/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.VolatileImage;
import java.util.concurrent.BrokenBarrierException;
import java.util.logging.Level;
import mochadoom.Loggers;
import v.renderers.BufferedRenderer32;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.renderers.SoftwareParallelVideoRenderer;
import v.tables.BlurryTable;
import v.tables.ColorTint;

class BufferedRenderer16
extends SoftwareParallelVideoRenderer<byte[], short[]> {
    protected final short[] raster;
    protected VolatileImage screen;
    protected final boolean compatible = BufferedRenderer16.checkConfigurationHicolor();
    protected final BlurryTable blurryTable;

    BufferedRenderer16(RendererFactory.WithWadLoader<byte[], short[]> rf) {
        super(rf, short[].class);
        if (this.compatible) {
            this.screen = GRAPHICS_CONF.createCompatibleVolatileImage(this.width, this.height);
            this.currentscreen = GRAPHICS_CONF.createCompatibleImage(this.width, this.height);
        } else {
            this.currentscreen = new BufferedImage(this.width, this.height, 9);
        }
        this.currentscreen.setAccelerationPriority(1.0f);
        this.raster = ((DataBufferUShort)((BufferedImage)this.currentscreen).getRaster().getDataBuffer()).getData();
        this.blurryTable = new BlurryTable((short[][])this.liteColorMaps);
        int len = this.raster.length;
        int chunk = len / PARALLELISM;
        for (int i = 0; i < PARALLELISM; ++i) {
            this.paletteThreads[i] = new ShortPaletteThread(i * chunk, (i + 1) * chunk);
        }
    }

    @Override
    public Image getScreenImage() {
        this.doWriteScreen();
        if (!this.compatible) {
            return this.currentscreen;
        }
        do {
            if (this.screen.validate(GRAPHICS_CONF) == 2) {
                this.screen.flush();
                this.screen = GRAPHICS_CONF.createCompatibleVolatileImage(this.width, this.height);
            }
            Graphics2D g = this.screen.createGraphics();
            g.drawImage(this.currentscreen, 0, 0, null);
            g.dispose();
        } while (this.screen.contentsLost());
        return this.screen;
    }

    @Override
    void doWriteScreen() {
        for (int i = 0; i < PARALLELISM; ++i) {
            this.executor.execute(this.paletteThreads[i]);
        }
        try {
            this.updateBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            Loggers.getLogger(BufferedRenderer32.class.getName()).log(Level.SEVERE, e, null);
        }
    }

    @Override
    public int getBaseColor(byte color) {
        return ((short[])this.palette)[color & 0xFF];
    }

    @Override
    public BlurryTable getBlurryTable() {
        return this.blurryTable;
    }

    private class ShortPaletteThread
    implements Runnable {
        private final short[] FG;
        private final int start;
        private final int stop;

        ShortPaletteThread(int start, int stop) {
            this.start = start;
            this.stop = stop;
            this.FG = (short[])BufferedRenderer16.this.screens.get((Object)DoomScreen.FG);
        }

        @Override
        public void run() {
            ColorTint t = (BufferedRenderer16.this.GRAYPAL_SET ? ColorTint.GREY_TINTS : ColorTint.NORMAL_TINTS).get(BufferedRenderer16.this.usepalette);
            byte[] LUT_R = t.LUT_r5[BufferedRenderer16.this.usegamma];
            byte[] LUT_G = t.LUT_g5[BufferedRenderer16.this.usegamma];
            byte[] LUT_B = t.LUT_b5[BufferedRenderer16.this.usegamma];
            int i = this.start;
            while (i < this.stop) {
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
                BufferedRenderer16.this.raster[i] = (short)((LUT_R[this.FG[i] >> 10 & 0x1F] & 0x1F) << 10 | (LUT_G[this.FG[i] >> 5 & 0x1F] & 0x1F) << 5 | LUT_B[this.FG[i++] & 0x1F] & 0x1F);
            }
            try {
                BufferedRenderer16.this.updateBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                Loggers.getLogger(BufferedRenderer32.class.getName()).log(Level.WARNING, e, null);
            }
        }
    }
}

