/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import doom.CommandVariable;
import doom.DoomMain;
import java.util.function.Function;
import m.Settings;
import mochadoom.Engine;
import rr.SceneRenderer;
import rr.UnifiedRenderer;
import rr.parallel.ParallelRenderer;
import rr.parallel.ParallelRenderer2;

public final class SceneRendererMode
extends Enum<SceneRendererMode> {
    public static final /* enum */ SceneRendererMode Serial;
    public static final /* enum */ SceneRendererMode Parallel;
    public static final /* enum */ SceneRendererMode Parallel2;
    private static final boolean cVarSerial;
    private static final boolean cVarParallel;
    private static final boolean cVarParallel2;
    private static final int[] threads;
    final SG<byte[], byte[]> indexedGen;
    final SG<byte[], short[]> hicolorGen;
    final SG<byte[], int[]> truecolorGen;
    private static final /* synthetic */ SceneRendererMode[] $VALUES;

    public static SceneRendererMode[] values() {
        return (SceneRendererMode[])$VALUES.clone();
    }

    public static SceneRendererMode valueOf(String name) {
        return Enum.valueOf(SceneRendererMode.class, name);
    }

    private SceneRendererMode(SG<byte[], byte[]> indexed, SG<byte[], short[]> hi, SG<byte[], int[]> truecolor) {
        this.indexedGen = indexed;
        this.hicolorGen = hi;
        this.truecolorGen = truecolor;
    }

    static int[] parseSwitchConfig(CommandVariable sw) {
        int walls = Engine.getCVM().get(sw, Integer.class, 0).orElse(1);
        int floors = Engine.getCVM().get(sw, Integer.class, 1).orElse(1);
        int masked = Engine.getCVM().get(sw, Integer.class, 2).orElse(2);
        return new int[]{walls, floors, masked};
    }

    static SceneRendererMode getMode() {
        if (cVarSerial) {
            return Serial;
        }
        if (cVarParallel) {
            return Parallel;
        }
        if (cVarParallel2) {
            return Parallel2;
        }
        return Engine.getConfig().getValue(Settings.scene_renderer_mode, SceneRendererMode.class);
    }

    private static SceneRenderer<byte[], byte[]> Parallel_8(DoomMain<byte[], byte[]> DOOM) {
        return new ParallelRenderer.Indexed(DOOM, threads[0], threads[1], threads[2]);
    }

    private static SceneRenderer<byte[], short[]> Parallel_16(DoomMain<byte[], short[]> DOOM) {
        return new ParallelRenderer.HiColor(DOOM, threads[0], threads[1], threads[2]);
    }

    private static SceneRenderer<byte[], int[]> Parallel_32(DoomMain<byte[], int[]> DOOM) {
        return new ParallelRenderer.TrueColor(DOOM, threads[0], threads[1], threads[2]);
    }

    private static SceneRenderer<byte[], byte[]> Parallel2_8(DoomMain<byte[], byte[]> DOOM) {
        return new ParallelRenderer2.Indexed(DOOM, threads[0], threads[1], threads[2]);
    }

    private static SceneRenderer<byte[], short[]> Parallel2_16(DoomMain<byte[], short[]> DOOM) {
        return new ParallelRenderer2.HiColor(DOOM, threads[0], threads[1], threads[2]);
    }

    private static SceneRenderer<byte[], int[]> Parallel2_32(DoomMain<byte[], int[]> DOOM) {
        return new ParallelRenderer2.TrueColor(DOOM, threads[0], threads[1], threads[2]);
    }

    static {
        int[] nArray;
        Serial = new SceneRendererMode(UnifiedRenderer.Indexed::new, UnifiedRenderer.HiColor::new, UnifiedRenderer.TrueColor::new);
        Parallel = new SceneRendererMode(SceneRendererMode::Parallel_8, SceneRendererMode::Parallel_16, SceneRendererMode::Parallel_32);
        Parallel2 = new SceneRendererMode(SceneRendererMode::Parallel2_8, SceneRendererMode::Parallel2_16, SceneRendererMode::Parallel2_32);
        $VALUES = new SceneRendererMode[]{Serial, Parallel, Parallel2};
        cVarSerial = Engine.getCVM().bool(CommandVariable.SERIALRENDERER);
        cVarParallel = Engine.getCVM().present(CommandVariable.PARALLELRENDERER);
        cVarParallel2 = Engine.getCVM().present(CommandVariable.PARALLELRENDERER2);
        if (cVarSerial) {
            nArray = null;
        } else if (cVarParallel) {
            nArray = SceneRendererMode.parseSwitchConfig(CommandVariable.PARALLELRENDERER);
        } else if (cVarParallel2) {
            nArray = SceneRendererMode.parseSwitchConfig(CommandVariable.PARALLELRENDERER2);
        } else {
            int[] nArray2 = new int[3];
            nArray2[0] = 2;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 2;
        }
        threads = nArray;
    }

    static interface SG<T, V>
    extends Function<DoomMain<T, V>, SceneRenderer<T, V>> {
    }
}

