/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import doom.CommandVariable;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import m.MenuMisc;
import m.Settings;
import mochadoom.Engine;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.renderers.SoftwareGraphicsSystem;

abstract class SoftwareParallelVideoRenderer<T, V>
extends SoftwareGraphicsSystem<T, V> {
    private static final int[] EMPTY_INT_PALETTED_BLOCK = new int[0];
    private static final short[] EMPTY_SHORT_PALETTED_BLOCK = new short[0];
    protected static final int PARALLELISM = Engine.getConfig().getValue(Settings.parallelism_realcolor_tint, Integer.class);
    protected static final GraphicsConfiguration GRAPHICS_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    protected final boolean GRAYPAL_SET = Engine.getCVM().bool(CommandVariable.GREYPAL);
    protected final HashMap<Integer, V> colcache = new HashMap();
    protected final Runnable[] paletteThreads = new Runnable[PARALLELISM];
    protected final Executor executor = Executors.newFixedThreadPool(PARALLELISM);
    protected final CyclicBarrier updateBarrier = new CyclicBarrier(PARALLELISM + 1);

    static boolean checkConfigurationHicolor() {
        ColorModel cm = GRAPHICS_CONF.getColorModel();
        int cps = cm.getNumComponents();
        return cps == 3 && cm.getComponentSize(0) == 5 && cm.getComponentSize(1) == 5 && cm.getComponentSize(2) == 5;
    }

    static boolean checkConfigurationTruecolor() {
        ColorModel cm = GRAPHICS_CONF.getColorModel();
        int cps = cm.getNumComponents();
        return cps == 3 && cm.getComponentSize(0) == 8 && cm.getComponentSize(1) == 8 && cm.getComponentSize(2) == 8;
    }

    SoftwareParallelVideoRenderer(RendererFactory.WithWadLoader<T, V> rf, Class<V> bufferType) {
        super(rf, bufferType);
    }

    abstract void doWriteScreen();

    @Override
    public boolean writeScreenShot(String name, DoomScreen screen) {
        Object screenBuffer = this.screens.get((Object)screen);
        if (screenBuffer.getClass() == short[].class) {
            MenuMisc.WritePNGfile(name, (short[])screenBuffer, this.width, this.height);
        } else {
            MenuMisc.WritePNGfile(name, (int[])screenBuffer, this.width, this.height);
        }
        return true;
    }

    @Override
    public V convertPalettedBlock(byte ... data) {
        Object[] objectArray;
        boolean isShort;
        boolean bl = isShort = this.bufferType == short[].class;
        if (data.length > 1) {
            if (isShort) {
                return (V)this.colcache.computeIfAbsent(Arrays.hashCode(data), h -> {
                    short[] stuff = new short[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        stuff[i] = (short)this.getBaseColor(data[i]);
                    }
                    return stuff;
                });
            }
            return (V)this.colcache.computeIfAbsent(Arrays.hashCode(data), h -> {
                int[] stuff = new int[data.length];
                for (int i = 0; i < data.length; ++i) {
                    stuff[i] = this.getBaseColor(data[i]);
                }
                return stuff;
            });
        }
        if (data.length == 0) {
            return (V)(isShort ? EMPTY_SHORT_PALETTED_BLOCK : (short[])EMPTY_INT_PALETTED_BLOCK);
        }
        if (isShort) {
            short[] sArray = new short[1];
            objectArray = sArray;
            sArray[0] = (short)this.getBaseColor(data[0]);
        } else {
            int[] nArray = new int[1];
            objectArray = nArray;
            nArray[0] = this.getBaseColor(data[0]);
        }
        return (V)objectArray;
    }
}

