/*
 * Decompiled with CFR 0.152.
 */
package v.scale;

import v.scale.VideoScale;

class VideoScaleInfo
implements VideoScale {
    protected float scale;
    protected int width;
    protected int height;
    protected int bestScaleX;
    protected int bestScaleY;
    protected int bestSafeScale;

    public VideoScaleInfo(float scale) {
        this.scale = scale;
        this.width = (int)(320.0f * scale);
        this.height = (int)((double)(scale * 320.0f) * 0.625);
        this.bestScaleX = (int)Math.floor((float)this.width / 320.0f);
        this.bestScaleY = (int)Math.floor((float)this.height / 200.0f);
        this.bestSafeScale = Math.min(this.bestScaleX, this.bestScaleY);
    }

    public VideoScaleInfo(float scale, float ratio) {
        this.scale = scale;
        this.width = (int)(320.0f * scale);
        this.height = (int)(scale * 320.0f * ratio);
        this.bestScaleX = (int)Math.floor((float)this.width / 320.0f);
        this.bestScaleY = (int)Math.floor((float)this.height / 200.0f);
        this.bestSafeScale = Math.min(this.bestScaleX, this.bestScaleY);
    }

    @Override
    public int getScreenWidth() {
        return this.width;
    }

    @Override
    public int getScreenHeight() {
        return this.height;
    }

    @Override
    public int getScalingX() {
        return this.bestScaleX;
    }

    @Override
    public int getScalingY() {
        return this.bestScaleY;
    }

    @Override
    public int getSafeScaling() {
        return this.bestSafeScale;
    }

    @Override
    public boolean changed() {
        return false;
    }

    @Override
    public float getScreenMul() {
        return this.scale;
    }
}

