/*
 * Decompiled with CFR 0.152.
 */
package v.scale;

import doom.CVarManager;
import doom.CommandVariable;
import v.scale.VideoScale;
import v.scale.VideoScaleInfo;

public class VisualSettings {
    public static final VideoScale vanilla = new VideoScaleInfo(1.0f);
    public static final VideoScale double_vanilla = new VideoScaleInfo(2.0f);
    public static final VideoScale triple_vanilla;
    public static final VideoScale default_scale;

    public static final VideoScale parse(CVarManager CVM) {
        int mulf;
        int multiply = CVM.get(CommandVariable.MULTIPLY, Integer.class, 0).orElse(-1);
        if (multiply > 0 && multiply <= 5) {
            return new VideoScaleInfo(multiply);
        }
        int width = CVM.get(CommandVariable.WIDTH, Integer.class, 0).orElse(-1);
        int height = CVM.get(CommandVariable.HEIGHT, Integer.class, 0).orElse(-1);
        if (height == -1 && width == -1) {
            return default_scale;
        }
        int mulx = Math.round((float)width / 320.0f);
        int muly = Math.round((float)height / 200.0f);
        if ((mulx > 0 || muly > 0) && (mulf = Math.max(mulx, muly)) >= 1 && mulf <= 5) {
            return new VideoScaleInfo(mulf);
        }
        return default_scale;
    }

    static {
        default_scale = triple_vanilla = new VideoScaleInfo(3.0f);
    }
}

