/*
 * Decompiled with CFR 0.152.
 */
package v.tables;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import v.tables.GammaTables;

public class ColorTint {
    public static final ColorTint NORMAL = new ColorTint(0, 0, 0, 0.0f);
    public static final ColorTint RED_11 = new ColorTint(255, 2, 3, 0.11f);
    public static final ColorTint RED_22 = new ColorTint(255, 0, 0, 0.22f);
    public static final ColorTint RED_33 = new ColorTint(255, 0, 0, 0.33f);
    public static final ColorTint RED_44 = new ColorTint(255, 0, 0, 0.44f);
    public static final ColorTint RED_55 = new ColorTint(255, 0, 0, 0.55f);
    public static final ColorTint RED_66 = new ColorTint(255, 0, 0, 0.66f);
    public static final ColorTint RED_77 = new ColorTint(255, 0, 0, 0.77f);
    public static final ColorTint RED_88 = new ColorTint(255, 0, 0, 0.88f);
    public static final ColorTint BERSERK_SLIGHT = new ColorTint(215, 185, 68, 0.12f);
    public static final ColorTint BERSERK_SOMEWHAT = new ColorTint(215, 185, 68, 0.25f);
    public static final ColorTint BERSERK_NOTICABLE = new ColorTint(215, 185, 68, 0.375f);
    public static final ColorTint BERSERK_HEAVY = new ColorTint(215, 185, 68, 0.5f);
    public static final ColorTint RADSUIT = new ColorTint(3, 253, 3, 0.125f);
    public static final ColorTint GREY_NORMAL = new ColorTint(NORMAL.mid(), NORMAL.mid5(), ColorTint.NORMAL.purepart);
    public static final ColorTint GREY_RED_11 = new ColorTint(RED_11.mid(), RED_11.mid5(), ColorTint.RED_11.purepart);
    public static final ColorTint GREY_RED_22 = new ColorTint(RED_22.mid(), RED_22.mid5(), ColorTint.RED_22.purepart);
    public static final ColorTint GREY_RED_33 = new ColorTint(RED_33.mid(), RED_33.mid5(), ColorTint.RED_33.purepart);
    public static final ColorTint GREY_RED_44 = new ColorTint(RED_44.mid(), RED_44.mid5(), ColorTint.RED_44.purepart);
    public static final ColorTint GREY_RED_55 = new ColorTint(RED_55.mid(), RED_55.mid5(), ColorTint.RED_55.purepart);
    public static final ColorTint GREY_RED_66 = new ColorTint(RED_66.mid(), RED_66.mid5(), ColorTint.RED_66.purepart);
    public static final ColorTint GREY_RED_77 = new ColorTint(RED_77.mid(), RED_77.mid5(), ColorTint.RED_77.purepart);
    public static final ColorTint GREY_RED_88 = new ColorTint(RED_88.mid(), RED_88.mid5(), ColorTint.RED_88.purepart);
    public static final ColorTint GREY_BERSERK_SLIGHT = new ColorTint(BERSERK_SLIGHT.mid(), BERSERK_SLIGHT.mid5(), ColorTint.BERSERK_SLIGHT.purepart);
    public static final ColorTint GREY_BERSERK_SOMEWHAT = new ColorTint(BERSERK_SOMEWHAT.mid(), BERSERK_SOMEWHAT.mid5(), ColorTint.BERSERK_SOMEWHAT.purepart);
    public static final ColorTint GREY_BERSERK_NOTICABLE = new ColorTint(BERSERK_NOTICABLE.mid(), BERSERK_NOTICABLE.mid5(), ColorTint.BERSERK_NOTICABLE.purepart);
    public static final ColorTint GREY_BERSERK_HEAVY = new ColorTint(BERSERK_HEAVY.mid(), BERSERK_HEAVY.mid5(), ColorTint.BERSERK_HEAVY.purepart);
    public static final ColorTint GREY_RADSUIT = new ColorTint(RADSUIT.mid(), RADSUIT.mid5(), ColorTint.RADSUIT.purepart);
    public static final List<ColorTint> NORMAL_TINTS = Collections.unmodifiableList(Arrays.asList(NORMAL, RED_11, RED_22, RED_33, RED_44, RED_55, RED_66, RED_77, RED_88, BERSERK_SLIGHT, BERSERK_SOMEWHAT, BERSERK_NOTICABLE, BERSERK_HEAVY, RADSUIT));
    public static final List<ColorTint> GREY_TINTS = Collections.unmodifiableList(Arrays.asList(GREY_NORMAL, GREY_RED_11, GREY_RED_22, GREY_RED_33, GREY_RED_44, GREY_RED_55, GREY_RED_66, GREY_RED_77, GREY_RED_88, GREY_BERSERK_SLIGHT, GREY_BERSERK_SOMEWHAT, GREY_BERSERK_NOTICABLE, GREY_BERSERK_HEAVY, GREY_RADSUIT));
    private final float r;
    private final float g;
    private final float b;
    private final float r5;
    private final float g5;
    private final float b5;
    private final float purepart;
    public final byte[][] LUT_r8 = new byte[5][256];
    public final byte[][] LUT_g8 = new byte[5][256];
    public final byte[][] LUT_b8 = new byte[5][256];
    public final byte[][] LUT_r5 = new byte[5][32];
    public final byte[][] LUT_g5 = new byte[5][32];
    public final byte[][] LUT_b5 = new byte[5][32];

    ColorTint(int r, int g, int b, float tint) {
        this((float)r * tint, (float)(r >> 3) * tint, (float)g * tint, (float)(g >> 3) * tint, (float)b * tint, (float)(b >> 3) * tint, 1.0f - tint);
    }

    ColorTint(float mid8, float mid5, float purepart) {
        this(mid8, mid5, mid8, mid5, mid8, mid5, purepart);
    }

    ColorTint(float r, float r5, float g, float g5, float b, float b5, float purepart) {
        this.r = r;
        this.r5 = r5;
        this.g = g;
        this.g5 = g5;
        this.b = b;
        this.b5 = b5;
        this.purepart = purepart;
        for (int j = 0; j < GammaTables.LUT.length; ++j) {
            for (int i = 0; i <= 255; ++i) {
                this.LUT_r8[j][i] = (byte)GammaTables.LUT[j][this.tintRed8(i)];
                this.LUT_g8[j][i] = (byte)GammaTables.LUT[j][this.tintGreen8(i)];
                this.LUT_b8[j][i] = (byte)GammaTables.LUT[j][this.tintBlue8(i)];
                if (i > 31) continue;
                this.LUT_r5[j][i] = (byte)(GammaTables.LUT[j][this.tintRed5(i) << 3] >> 3);
                this.LUT_g5[j][i] = (byte)(GammaTables.LUT[j][this.tintGreen5(i) << 3] >> 3);
                this.LUT_b5[j][i] = (byte)(GammaTables.LUT[j][this.tintBlue5(i) << 3] >> 3);
            }
        }
    }

    public float mid() {
        return (this.r + this.g + this.b) / 3.0f;
    }

    public float mid5() {
        return (this.r5 + this.g5 + this.b5) / 3.0f;
    }

    public final int tintGreen8(int green8) {
        return Math.min((int)((float)green8 * this.purepart + this.g), 255);
    }

    public final int tintGreen5(int green5) {
        return Math.min((int)((float)green5 * this.purepart + this.g5), 31);
    }

    public final int tintBlue8(int blue8) {
        return Math.min((int)((float)blue8 * this.purepart + this.b), 255);
    }

    public final int tintBlue5(int blue5) {
        return Math.min((int)((float)blue5 * this.purepart + this.b5), 31);
    }

    public final int tintRed8(int red8) {
        return Math.min((int)((float)red8 * this.purepart + this.r), 255);
    }

    public final int tintRed5(int red5) {
        return Math.min((int)((float)red5 * this.purepart + this.r5), 31);
    }
}

