/*
 * Decompiled with CFR 0.152.
 */
package v.tables;

import m.Settings;
import mochadoom.Engine;

public enum GreyscaleFilter {
    Lightness,
    Average,
    Luminance,
    Luminosity;

    private static GreyscaleFilter FILTER;

    public static int component(int r, int g, int b) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getComponent(r, g, b);
    }

    public static float component(float r, float g, float b) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getComponent(r, g, b);
    }

    public static int grey888(int rgb888) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getGrey888(rgb888);
    }

    public static int grey888(int r8, int g8, int b8) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getGrey888(r8, g8, b8);
    }

    public static short grey555(int r5, int g5, int b5) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getGrey555(r5, g5, b5);
    }

    public static short grey555(short rgb555) {
        if (FILTER == null) {
            GreyscaleFilter.readSetting();
        }
        return FILTER.getGrey555(rgb555);
    }

    private static void readSetting() {
        FILTER = Engine.getConfig().getValue(Settings.greyscale_filter, GreyscaleFilter.class);
    }

    public int getComponent(int r, int g, int b) {
        switch (this) {
            case Lightness: {
                return (Math.max(Math.max(r, g), b) + Math.min(Math.min(r, g), b)) / 2;
            }
            case Average: {
                return (r + g + b) / 3;
            }
            case Luminance: {
                return (int)(0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b);
            }
            case Luminosity: {
                return (int)(0.2126f * (float)r + 0.7152f * (float)g + 0.0722f * (float)b);
            }
        }
        return 0;
    }

    public float getComponent(float r, float g, float b) {
        switch (this) {
            case Lightness: {
                return (Math.max(Math.max(r, g), b) + Math.min(Math.min(r, g), b)) / 2.0f;
            }
            case Average: {
                return (r + g + b) / 3.0f;
            }
            case Luminance: {
                return 0.299f * r + 0.587f * g + 0.114f * b;
            }
            case Luminosity: {
                return 0.2126f * r + 0.7152f * g + 0.0722f * b;
            }
        }
        return 0.0f;
    }

    public int getGrey888(int r8, int g8, int b8) {
        int component = this.getComponent(r8, g8, b8) & 0xFF;
        return -16777216 + (component << 16) + (component << 8) + component;
    }

    public short getGrey555(int r5, int g5, int b5) {
        int component = this.getComponent(r5, g5, b5) & 0x1F;
        return (short)((component << 10) + (component << 5) + component);
    }

    public int getGrey888(int rgb888) {
        return this.getGrey888(rgb888 >> 16 & 0xFF, rgb888 >> 8 & 0xFF, rgb888 & 0xFF);
    }

    public short getGrey555(short rgb555) {
        return this.getGrey555(rgb555 >> 10 & 0x1F, rgb555 >> 5 & 0x1F, rgb555 & 0x1F);
    }
}

