/*
 * Decompiled with CFR 0.152.
 */
package v.tables;

import doom.DoomMain;
import doom.player_t;
import v.renderers.BppMode;

public class LightsAndColors<V> {
    private final LCData LC_DATA;
    public V[] colormaps;
    public V[] walllights;
    public V fixedcolormap;
    public byte[][] translationtables;
    public int extralight;
    public V[][] scalelight;
    public V[] scalelightfixed;
    public V[][] zlight;
    public V[] spritelights;

    public LightsAndColors(DoomMain<?, V> DM) {
        this.LC_DATA = new LCData(DM.bppMode);
    }

    public int lightBits() {
        return this.LC_DATA.bpp.lightBits;
    }

    public int lightBright() {
        return this.LC_DATA.LIGHTBRIGHT;
    }

    public int lightLevels() {
        return this.LC_DATA.LIGHTLEVELS;
    }

    public int lightScaleShift() {
        return this.LC_DATA.LIGHTSCALESHIFT;
    }

    public int lightSegShift() {
        return this.LC_DATA.LIGHTSEGSHIFT;
    }

    public int lightZShift() {
        return this.LC_DATA.LIGHTZSHIFT;
    }

    public int maxLightScale() {
        return this.LC_DATA.MAXLIGHTSCALE;
    }

    public int maxLightZ() {
        return this.LC_DATA.MAXLIGHTZ;
    }

    public int numColorMaps() {
        return this.LC_DATA.NUMCOLORMAPS;
    }

    public V getFixedColormap(player_t player) {
        if (this.LC_DATA.bpp.lightBits > 5) {
            return this.colormaps[player.fixedcolormap << this.LC_DATA.bpp.lightBits - 5];
        }
        return this.colormaps[player.fixedcolormap];
    }

    public final byte[] getTranslationTable(long mobjflags) {
        return this.translationtables[(int)((mobjflags & 0xC000000L) >> 26)];
    }

    private static class LCData {
        final BppMode bpp;
        final int LIGHTLEVELS;
        final int LIGHTSEGSHIFT;
        final int NUMCOLORMAPS;
        final int MAXLIGHTSCALE;
        final int LIGHTSCALESHIFT;
        final int MAXLIGHTZ;
        final int LIGHTBRIGHT;
        final int LIGHTZSHIFT;

        LCData(BppMode bpp) {
            this.bpp = bpp;
            this.LIGHTLEVELS = 1 << bpp.lightBits;
            this.MAXLIGHTZ = this.LIGHTLEVELS * 4;
            this.LIGHTBRIGHT = 2;
            this.LIGHTSEGSHIFT = 8 - bpp.lightBits;
            this.NUMCOLORMAPS = this.LIGHTLEVELS;
            this.MAXLIGHTSCALE = 3 * this.LIGHTLEVELS / 2;
            this.LIGHTSCALESHIFT = 17 - bpp.lightBits;
            this.LIGHTZSHIFT = 25 - bpp.lightBits;
        }
    }
}

