/*
 * Decompiled with CFR 0.152.
 */
package w;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import rr.patch_t;
import utils.GenericCopy;
import v.tables.Playpal;
import w.CacheableDoomObject;
import w.DoomBuffer;
import w.lumpinfo_t;
import w.wadfile_info_t;

public interface IWadLoader {
    public void Reload() throws Exception;

    public void InitMultipleFiles(String[] var1) throws Exception;

    public void InitFile(String var1) throws Exception;

    public int NumLumps();

    public lumpinfo_t GetLumpinfoForName(String var1);

    public int GetNumForName(String var1);

    public int GetNumForName(String var1, boolean var2);

    public String GetNameForNum(int var1);

    public int LumpLength(int var1);

    public <T> T CacheLumpNum(int var1, int var2, Class<T> var3);

    @Deprecated
    public void CacheLumpNumIntoArray(int var1, int var2, Object[] var3, Class<?> var4) throws IOException;

    public byte[] CacheLumpNameAsRawBytes(String var1, int var2);

    public byte[] CacheLumpNumAsRawBytes(int var1, int var2);

    public DoomBuffer CacheLumpName(String var1, int var2);

    public DoomBuffer CacheLumpNumAsDoomBuffer(int var1);

    public patch_t CachePatchName(String var1);

    public patch_t CachePatchName(String var1, int var2);

    public patch_t CachePatchNum(int var1);

    public <T extends CacheableDoomObject> T CacheLumpName(String var1, int var2, Class<T> var3);

    public boolean isLumpMarker(int var1);

    public String GetNameForLump(int var1);

    public int CheckNumForName(String var1);

    public int[] CheckNumsForName(String var1);

    public lumpinfo_t GetLumpInfo(int var1);

    public void CloseAllHandles();

    public void UnlockLumpNum(int var1);

    public void UnlockLumpNum(CacheableDoomObject var1);

    public <T extends CacheableDoomObject> T[] CacheLumpNumIntoArray(int var1, int var2, GenericCopy.ArraySupplier<T> var3, IntFunction<T[]> var4);

    public boolean verifyLumpName(int var1, String var2);

    public int GetWadfileIndex(wadfile_info_t var1);

    public int GetNumWadfiles();

    public void InjectLumpNum(int var1, CacheableDoomObject var2);

    public byte[] ReadLump(int var1);

    public void ReadLump(int var1, byte[] var2);

    public void ReadLump(int var1, byte[] var2, int var3);

    default public byte[] LoadPlaypal() {
        int pallump = this.GetNumForName("PLAYPAL");
        byte[] playpal = Playpal.properPlaypal(this.CacheLumpNumAsRawBytes(pallump, 1));
        int minLength = 768;
        if (playpal.length < 768) {
            throw new IllegalArgumentException(String.format("Invalid PLAYPAL: has %d entries instead of %d. Try -noplaypal mode", playpal.length, 768));
        }
        System.out.print("VI_Init: set palettes.\n");
        System.out.println("Palette: " + playpal.length / 3 + " colors");
        this.InjectLumpNum(pallump, new DoomBuffer(ByteBuffer.wrap(playpal)));
        return playpal;
    }

    default public byte[] tryLoadPlaypal() {
        byte[] ret = this.LoadPlaypal();
        if (null == ret) {
            ret = Playpal.greypal();
        }
        return ret;
    }

    default public byte[][] LoadColormap() {
        int lump = this.GetNumForName("COLORMAP");
        int length = this.LumpLength(lump) + 256;
        byte[][] colormap = new byte[length / 256][256];
        int minLength = 33;
        if (colormap.length < 33) {
            throw new IllegalArgumentException(String.format("Invalid COLORMAP: has %d entries, minimum is %d. Try -nocolormap mode", colormap.length, 33));
        }
        System.out.print("VI_Init: set colormaps.\n");
        System.out.println("Colormaps: " + colormap.length);
        byte[] tmp = new byte[length];
        this.ReadLump(lump, tmp);
        for (int i = 0; i < colormap.length; ++i) {
            System.arraycopy(tmp, i * 256, colormap[i], 0, 256);
        }
        return colormap;
    }

    public patch_t tryCachePatchName(String var1);

    public patch_t tryCachePatchName(String var1, int var2);
}

