/*
 * Decompiled with CFR 0.152.
 */
package w;

import i.DummySystem;
import i.IDoomSystem;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mochadoom.Loggers;
import rr.patch_t;
import utils.C2JUtils;
import utils.GenericCopy;
import w.CacheableDoomObject;
import w.CacheableDoomObjectContainer;
import w.DoomBuffer;
import w.DoomIO;
import w.IReadableDoomObject;
import w.IWadLoader;
import w.InputStreamSugar;
import w.filelump_t;
import w.li_namespace;
import w.lumpinfo_t;
import w.name8;
import w.wad_source_t;
import w.wadfile_info_t;
import w.wadinfo_t;

public class WadLoader
implements IWadLoader {
    protected IDoomSystem I;
    public lumpinfo_t[] lumpinfo;
    public int numlumps;
    private CacheableDoomObject[] lumpcache;
    private boolean[] preloaded;
    private List<wadfile_info_t> wadfiles;
    int reloadlump;
    String reloadname;
    HashMap<String, Integer> doomhash;
    private final ArrayList<Integer> list = new ArrayList();
    public static final int ns_global = 0;
    public static final int ns_flats = 1;
    public static final int ns_sprites = 2;
    HashMap<CacheableDoomObject, Integer> zone;

    public WadLoader(IDoomSystem I) {
        this();
        this.I = I;
    }

    public WadLoader() {
        this.lumpinfo = new lumpinfo_t[0];
        this.zone = new HashMap();
        this.wadfiles = new ArrayList<wadfile_info_t>();
        this.I = new DummySystem();
    }

    public String strupr(String s) {
        return s.toUpperCase();
    }

    public void strupr(char[] s) {
        for (int i = 0; i < s.length; ++i) {
            s[i] = Character.toUpperCase(s[i]);
        }
    }

    private void AddFile(String uri, ZipEntry entry, int type) throws Exception {
        String checkname;
        InputStream handle;
        wadinfo_t header = new wadinfo_t();
        IReadableDoomObject[] fileinfo = new filelump_t[1];
        filelump_t singleinfo = new filelump_t();
        if (uri.charAt(0) == '~') {
            this.reloadname = uri = uri.substring(1);
            this.reloadlump = this.numlumps;
        }
        try {
            handle = InputStreamSugar.createInputStreamFromURI(uri, entry, type);
        }
        catch (Exception e) {
            this.I.Error(" couldn't open resource %s \n", uri);
            return;
        }
        wadfile_info_t wadinfo = new wadfile_info_t();
        wadinfo.handle = handle;
        wadinfo.name = uri;
        wadinfo.entry = entry;
        wadinfo.type = type;
        int startlump = this.numlumps;
        String string = checkname = wadinfo.entry != null ? wadinfo.entry.getName() : uri;
        if (!C2JUtils.checkForExtension(checkname, "wad")) {
            fileinfo[0] = singleinfo;
            singleinfo.filepos = 0L;
            singleinfo.size = InputStreamSugar.getSizeEstimate(handle, wadinfo.entry);
            singleinfo.actualname = singleinfo.name = C2JUtils.removeExtension(uri).toUpperCase();
            if (C2JUtils.checkForExtension(uri, "lmp")) {
                wadinfo.src = wad_source_t.source_lmp;
            } else if (C2JUtils.checkForExtension(uri, "deh")) {
                wadinfo.src = wad_source_t.source_deh;
            } else if (C2JUtils.checkForExtension(uri, null)) {
                wadinfo.src = wad_source_t.source_deh;
            }
            ++this.numlumps;
        } else {
            DataInputStream dis = new DataInputStream(handle);
            header.read(dis);
            if (header.identification.compareTo("IWAD") != 0) {
                if (header.identification.compareTo("PWAD") != 0) {
                    this.I.Error("Wad file %s doesn't have IWAD or PWAD id\n", checkname);
                } else {
                    wadinfo.src = wad_source_t.source_pwad;
                }
            } else {
                wadinfo.src = wad_source_t.source_iwad;
            }
            long length = header.numlumps;
            fileinfo = (filelump_t[])GenericCopy.malloc(filelump_t::new, filelump_t[]::new, (int)length);
            dis.close();
            handle = InputStreamSugar.streamSeek(handle, header.infotableofs, wadinfo.maxsize, uri, entry, type);
            byte[] TOC = new byte[(int)(length * (long)filelump_t.sizeof())];
            for (int read = 0; read < TOC.length; read += handle.read(TOC, read, TOC.length - read)) {
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(TOC);
            dis = new DataInputStream(bais);
            DoomIO.readObjectArray(dis, fileinfo, (int)length);
            this.numlumps = (int)((long)this.numlumps + header.numlumps);
            wadinfo.maxsize = this.estimateWadSize(header, this.lumpinfo);
        }
        this.wadfiles.add(wadinfo);
        int oldsize = this.lumpinfo.length;
        lumpinfo_t[] newlumpinfo = (lumpinfo_t[])GenericCopy.malloc(lumpinfo_t::new, lumpinfo_t[]::new, this.numlumps);
        try {
            System.arraycopy(this.lumpinfo, 0, newlumpinfo, 0, oldsize);
        }
        catch (Exception e) {
            this.I.Error("Couldn't realloc lumpinfo");
        }
        this.lumpinfo = newlumpinfo;
        int lump_p = startlump;
        InputStream storehandle = this.reloadname != null ? null : handle;
        int fileinfo_p = 0;
        int i = startlump;
        while (i < this.numlumps) {
            this.lumpinfo[lump_p].handle = storehandle;
            this.lumpinfo[lump_p].position = ((filelump_t)fileinfo[fileinfo_p]).filepos;
            this.lumpinfo[lump_p].size = ((filelump_t)fileinfo[fileinfo_p]).size;
            this.lumpinfo[lump_p].name = ((filelump_t)fileinfo[fileinfo_p]).name.toUpperCase();
            this.lumpinfo[lump_p].hash = this.lumpinfo[lump_p].name.hashCode();
            this.lumpinfo[lump_p].intname = name8.getIntName(this.strupr(this.lumpinfo[lump_p].name));
            this.lumpinfo[lump_p].wadfile = wadinfo;
            ++i;
            ++lump_p;
            ++fileinfo_p;
        }
        if (this.reloadname != null) {
            handle.close();
        }
    }

    private long estimateWadSize(wadinfo_t header, lumpinfo_t[] lumpinfo) {
        long maxsize = header.infotableofs + header.numlumps * 16L;
        for (int i = 0; i < lumpinfo.length; ++i) {
            if (lumpinfo[i].position + lumpinfo[i].size <= maxsize) continue;
            maxsize = lumpinfo[i].position + lumpinfo[i].size;
        }
        return maxsize;
    }

    @Override
    public void Reload() throws Exception {
        wadinfo_t header = new wadinfo_t();
        DataInputStream handle = null;
        if (this.reloadname == null) {
            return;
        }
        try {
            handle = new DataInputStream(new BufferedInputStream(new FileInputStream(this.reloadname)));
        }
        catch (Exception e) {
            this.I.Error("W_Reload: couldn't open %s", this.reloadname);
        }
        header.read(handle);
        int lumpcount = (int)header.numlumps;
        header.infotableofs = header.infotableofs;
        int length = lumpcount;
        IReadableDoomObject[] fileinfo = new filelump_t[length];
        handle.reset();
        handle.skip(header.infotableofs);
        DoomIO.readObjectArrayWithReflection(handle, fileinfo, length);
        int lump_p = this.reloadlump;
        int fileinfo_p = 0;
        int i = this.reloadlump;
        while (i < this.reloadlump + lumpcount) {
            if (this.lumpcache[i] != null) {
                this.lumpcache[i] = null;
                this.preloaded[i] = false;
            }
            this.lumpinfo[lump_p].position = ((filelump_t)fileinfo[fileinfo_p]).filepos;
            this.lumpinfo[lump_p].size = ((filelump_t)fileinfo[fileinfo_p]).size;
            ++i;
            ++lump_p;
            ++fileinfo_p;
        }
    }

    @Override
    public void InitMultipleFiles(String[] filenames) throws Exception {
        this.numlumps = 0;
        this.lumpinfo = new lumpinfo_t[0];
        for (String s : filenames) {
            if (s == null) continue;
            if (C2JUtils.testReadAccess(s)) {
                int type = C2JUtils.guessResourceType(s);
                if (C2JUtils.flags(type, 4)) {
                    this.addZipFile(s, type);
                } else {
                    this.AddFile(s, null, type);
                }
                System.out.printf("\tadded %s (zipped: %s network: %s)\n", s, C2JUtils.flags(type, 4), C2JUtils.flags(type, 2));
                continue;
            }
            System.err.printf("Couldn't open resource %s\n", s);
        }
        if (this.numlumps == 0) {
            this.I.Error("W_InitFiles: no files found");
        }
        this.CoalesceMarkedResource("S_START", "S_END", li_namespace.ns_sprites);
        this.CoalesceMarkedResource("F_START", "F_END", li_namespace.ns_flats);
        int size = this.numlumps;
        this.lumpcache = new CacheableDoomObject[size];
        this.preloaded = new boolean[size];
        if (this.lumpcache == null) {
            this.I.Error("Couldn't allocate lumpcache");
        }
        this.InitLumpHash();
    }

    protected void addZipFile(String s, int type) throws IOException, Exception {
        BufferedInputStream is = new BufferedInputStream(InputStreamSugar.createInputStreamFromURI(s, null, type));
        ZipInputStream zip = new ZipInputStream(is);
        List<ZipEntry> zes = InputStreamSugar.getAllEntries(zip);
        zip.close();
        for (ZipEntry zz : zes) {
            if (zz.isDirectory()) continue;
            this.AddFile(s, zz, type);
        }
    }

    @Override
    public void InitFile(String filename) throws Exception {
        String[] names = new String[]{filename};
        this.InitMultipleFiles(names);
    }

    @Override
    public final int NumLumps() {
        return this.numlumps;
    }

    @Override
    public lumpinfo_t GetLumpinfoForName(String name) {
        name8 union = new name8(this.strupr(name));
        int v1 = union.x[0];
        int v2 = union.x[1];
        int lump_p = this.numlumps;
        while (lump_p-- != 0) {
            int a = name8.stringToInt(this.lumpinfo[lump_p].name, 0);
            int b = name8.stringToInt(this.lumpinfo[lump_p].name, 4);
            if (a != v1 || b != v2) continue;
            return this.lumpinfo[lump_p];
        }
        return null;
    }

    @Override
    public int GetNumForName(String name) {
        return this.GetNumForName(name, true);
    }

    @Override
    public int GetNumForName(String name, boolean fatal) {
        int i = this.CheckNumForName(name.toUpperCase());
        if (fatal && i == -1) {
            Exception e = new Exception();
            e.printStackTrace();
            System.err.println("Error: " + name + " not found");
            System.err.println("Hash: " + Long.toHexString(name8.getLongHash(name)));
            this.I.Error("W_GetNumForName: %s not found!", name);
        }
        return i;
    }

    @Override
    public String GetNameForNum(int lumpnum) {
        if (lumpnum >= 0 && lumpnum < this.numlumps) {
            return this.lumpinfo[lumpnum].name;
        }
        return null;
    }

    @Override
    public int LumpLength(int lump) {
        if (lump >= this.numlumps) {
            this.I.Error("W_LumpLength: %i >= numlumps", lump);
        }
        return (int)this.lumpinfo[lump].size;
    }

    @Override
    public final byte[] ReadLump(int lump) {
        lumpinfo_t l = this.lumpinfo[lump];
        byte[] buf = new byte[(int)l.size];
        this.ReadLump(lump, buf, 0);
        return buf;
    }

    @Override
    public final void ReadLump(int lump, byte[] buf) {
        this.ReadLump(lump, buf, 0);
    }

    @Override
    public final void ReadLump(int lump, byte[] buf, int offset) {
        int c = 0;
        InputStream handle = null;
        if (lump >= this.numlumps) {
            this.I.Error("W_ReadLump: %i >= numlumps", lump);
            return;
        }
        lumpinfo_t l = this.lumpinfo[lump];
        if (l.handle == null) {
            try {
                handle = InputStreamSugar.createInputStreamFromURI(this.reloadname, null, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.I.Error("W_ReadLump: couldn't open %s", this.reloadname);
            }
        } else {
            handle = l.handle;
        }
        try {
            handle = InputStreamSugar.streamSeek(handle, l.position, l.wadfile.maxsize, l.wadfile.name, l.wadfile.entry, l.wadfile.type);
            BufferedInputStream bis = new BufferedInputStream(handle, 8192);
            while ((long)c < l.size) {
                c += bis.read(buf, offset + c, (int)(l.size - (long)c));
            }
            if ((long)c < l.size) {
                System.err.printf("W_ReadLump: only read %d of %d on lump %d %d\n", c, l.size, lump, l.position);
            }
            if (l.handle == null) {
                handle.close();
            } else {
                l.handle = handle;
            }
            this.I.BeginRead();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.I.Error("W_ReadLump: could not read lump " + lump);
            e.printStackTrace();
            return;
        }
    }

    @Override
    public <T> T CacheLumpNum(int lump, int tag, Class<T> what) {
        block8: {
            if (lump >= this.numlumps) {
                this.I.Error("W_CacheLumpNum: %i >= numlumps", lump);
            }
            if (this.lumpcache[lump] == null || what == null) {
                ByteBuffer thebuffer = ByteBuffer.wrap(this.ReadLump(lump));
                if (what != null) {
                    try {
                        if (this.implementsInterface(what, CacheableDoomObject.class)) {
                            thebuffer.rewind();
                            this.lumpcache[lump] = (CacheableDoomObject)what.newInstance();
                            this.lumpcache[lump].unpack(thebuffer);
                            this.Track(this.lumpcache[lump], lump);
                            if (what == patch_t.class) {
                                ((patch_t)this.lumpcache[lump]).name = this.lumpinfo[lump].name;
                            }
                            break block8;
                        }
                        this.lumpcache[lump] = (CacheableDoomObject)((Object)thebuffer);
                        this.Track((CacheableDoomObject)((Object)thebuffer), lump);
                    }
                    catch (Exception e) {
                        System.err.println("Could not auto-instantiate lump " + lump + " of class " + what);
                        e.printStackTrace();
                    }
                } else {
                    DoomBuffer db = new DoomBuffer(thebuffer);
                    this.lumpcache[lump] = db;
                }
            }
        }
        return (T)this.lumpcache[lump];
    }

    @Override
    @Deprecated
    public void CacheLumpNumIntoArray(int lump, int tag, Object[] array, Class<?> what) throws IOException {
        if (lump >= this.numlumps) {
            this.I.Error("W_CacheLumpNum: %i >= numlumps", lump);
        }
        if (this.lumpcache[lump] == null) {
            ByteBuffer thebuffer = ByteBuffer.wrap(this.ReadLump(lump));
            this.lumpcache[lump] = new DoomBuffer(thebuffer);
            this.Track(this.lumpcache[lump], lump);
        }
        if (what != null && this.lumpcache[lump].getClass() == DoomBuffer.class) {
            try {
                ByteBuffer b = ((DoomBuffer)this.lumpcache[lump]).getBuffer();
                b.rewind();
                for (int i = 0; i < array.length; ++i) {
                    if (!this.implementsInterface(what, CacheableDoomObject.class)) continue;
                    ((CacheableDoomObject)array[i]).unpack(b);
                }
            }
            catch (Exception e) {
                System.err.println("Could not auto-unpack lump " + lump + " into an array of objects of class " + what);
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T extends CacheableDoomObject> T[] CacheLumpNumIntoArray(int lump, int num, GenericCopy.ArraySupplier<T> what, IntFunction<T[]> arrGen) {
        if (lump >= this.numlumps) {
            this.I.Error("CacheLumpNumIntoArray: %i >= numlumps", lump);
        }
        if (this.lumpcache[lump] == null && what != null) {
            ByteBuffer thebuffer = ByteBuffer.wrap(this.ReadLump(lump));
            CacheableDoomObject[] stuff = (CacheableDoomObject[])GenericCopy.malloc(what, arrGen, num);
            this.lumpcache[lump] = new CacheableDoomObjectContainer(stuff);
            try {
                thebuffer.rewind();
                this.lumpcache[lump].unpack(thebuffer);
            }
            catch (IOException e) {
                Loggers.getLogger(WadLoader.class.getName()).log(Level.WARNING, String.format("Could not auto-unpack lump %s into an array of objects of class %s", lump, what), e);
            }
            this.Track(this.lumpcache[lump], lump);
        }
        if (this.lumpcache[lump] == null) {
            return null;
        }
        CacheableDoomObjectContainer cont = (CacheableDoomObjectContainer)this.lumpcache[lump];
        return cont.getStuff();
    }

    public CacheableDoomObject CacheLumpNum(int lump) {
        return this.lumpcache[lump];
    }

    protected boolean implementsInterface(Class<?> what, Class<?> which) {
        Class<?>[] shit = what.getInterfaces();
        for (int i = 0; i < shit.length; ++i) {
            if (!shit[i].equals(which)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] CacheLumpNameAsRawBytes(String name, int tag) {
        return ((DoomBuffer)this.CacheLumpNum(this.GetNumForName(name), tag, null)).getBuffer().array();
    }

    @Override
    public byte[] CacheLumpNumAsRawBytes(int num, int tag) {
        return ((DoomBuffer)this.CacheLumpNum(num, tag, null)).getBuffer().array();
    }

    @Override
    public DoomBuffer CacheLumpName(String name, int tag) {
        return this.CacheLumpNum(this.GetNumForName(name), tag, DoomBuffer.class);
    }

    @Override
    public DoomBuffer CacheLumpNumAsDoomBuffer(int lump) {
        return this.CacheLumpNum(lump, 0, DoomBuffer.class);
    }

    @Override
    public patch_t CachePatchName(String name) {
        return this.CacheLumpNum(this.GetNumForName(name), 101, patch_t.class);
    }

    @Override
    public patch_t tryCachePatchName(String name) {
        int id = this.GetNumForName(name, false);
        if (-1 == id) {
            return null;
        }
        return this.CacheLumpNum(id, 101, patch_t.class);
    }

    @Override
    public patch_t CachePatchName(String name, int tag) {
        return this.CacheLumpNum(this.GetNumForName(name), tag, patch_t.class);
    }

    @Override
    public patch_t tryCachePatchName(String name, int tag) {
        int id = this.GetNumForName(name, false);
        if (-1 == id) {
            return null;
        }
        return this.CacheLumpNum(id, tag, patch_t.class);
    }

    @Override
    public patch_t CachePatchNum(int num) {
        return this.CacheLumpNum(num, 101, patch_t.class);
    }

    @Override
    public <T extends CacheableDoomObject> T CacheLumpName(String name, int tag, Class<T> what) {
        return (T)((CacheableDoomObject)this.CacheLumpNum(this.GetNumForName(name.toUpperCase()), tag, what));
    }

    @Override
    public boolean isLumpMarker(int lump) {
        return this.lumpinfo[lump].size == 0L;
    }

    @Override
    public String GetNameForLump(int lump) {
        return this.lumpinfo[lump].name;
    }

    protected void InitLumpHash() {
        this.doomhash = new HashMap(this.numlumps);
        for (int i = 0; i < this.numlumps; ++i) {
            this.doomhash.put(this.lumpinfo[i].name.toUpperCase(), new Integer(i));
        }
    }

    @Override
    public int CheckNumForName(String name) {
        Integer r = this.doomhash.get(name);
        if (r != null) {
            return r;
        }
        return -1;
    }

    @Override
    public int[] CheckNumsForName(String name) {
        this.list.clear();
        for (int i = this.numlumps - 1; i >= 0; --i) {
            if (name.compareToIgnoreCase(this.lumpinfo[i].name) != 0) continue;
            this.list.add(i);
        }
        int num = this.list.size();
        int[] result = new int[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.list.get(i);
        }
        return result;
    }

    @Override
    public lumpinfo_t GetLumpInfo(int i) {
        return this.lumpinfo[i];
    }

    @Override
    public void CloseAllHandles() {
        ArrayList<InputStream> d = new ArrayList<InputStream>();
        for (int i = 0; i < this.lumpinfo.length; ++i) {
            if (d.contains(this.lumpinfo[i].handle)) continue;
            d.add(this.lumpinfo[i].handle);
        }
        int count = 0;
        for (InputStream e : d) {
            try {
                e.close();
                ++count;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void finalize() {
        this.CloseAllHandles();
    }

    public int CoalesceMarkedResource(String start_marker, String end_marker, li_namespace namespace) {
        int result = 0;
        lumpinfo_t[] marked = new lumpinfo_t[this.numlumps];
        int num_marked = 0;
        int num_unmarked = 0;
        boolean is_marked = false;
        boolean mark_end = false;
        for (int i = 0; i < this.numlumps; ++i) {
            lumpinfo_t lump = this.lumpinfo[i];
            if (WadLoader.IsMarker(start_marker, lump.name)) {
                if (num_marked == 0) {
                    marked[num_marked] = new lumpinfo_t();
                    marked[num_marked].name = new String(start_marker);
                    marked[num_marked].size = 0L;
                    marked[num_marked].namespace = li_namespace.ns_global;
                    marked[num_marked].handle = lump.handle;
                    marked[num_marked].wadfile = lump.wadfile;
                    num_marked = 1;
                }
                is_marked = true;
                continue;
            }
            if (WadLoader.IsMarker(end_marker, lump.name)) {
                mark_end = true;
                is_marked = false;
                continue;
            }
            if (is_marked || lump.namespace == namespace) {
                if (namespace == li_namespace.ns_sprites && lump.size <= 8L) continue;
                marked[num_marked] = lump.clone();
                marked[num_marked++].namespace = namespace;
                ++result;
                continue;
            }
            this.lumpinfo[num_unmarked++] = lump.clone();
        }
        System.arraycopy(marked, 0, this.lumpinfo, num_unmarked, num_marked);
        this.numlumps = num_unmarked + num_marked;
        if (mark_end) {
            this.lumpinfo[this.numlumps].size = 0L;
            this.lumpinfo[this.numlumps].namespace = li_namespace.ns_global;
            ++this.numlumps;
            this.lumpinfo[this.numlumps].name = end_marker;
        }
        return result;
    }

    public static final boolean IsMarker(String marker, String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        boolean result = name.equalsIgnoreCase(marker) || marker.charAt(1) == '_' && name.charAt(0) == marker.charAt(0) && name.substring(1).equalsIgnoreCase(marker);
        return result;
    }

    @Override
    public void UnlockLumpNum(int lump) {
        this.lumpcache[lump] = null;
    }

    @Override
    public void InjectLumpNum(int lump, CacheableDoomObject obj) {
        this.lumpcache[lump] = obj;
    }

    public void Track(CacheableDoomObject lump, int index) {
        this.zone.put(lump, index);
    }

    @Override
    public void UnlockLumpNum(CacheableDoomObject lump) {
        Integer lumpno = this.zone.remove(lump);
        if (lumpno != null) {
            this.lumpcache[lumpno.intValue()] = null;
        }
    }

    @Override
    public boolean verifyLumpName(int lump, String lumpname) {
        if (lump < 0 || lump > this.numlumps - 1) {
            return false;
        }
        String name = this.GetNameForLump(lump);
        return name != null && lumpname.compareToIgnoreCase(name) == 0;
    }

    @Override
    public int GetWadfileIndex(wadfile_info_t wad1) {
        return this.wadfiles.indexOf(wad1);
    }

    @Override
    public int GetNumWadfiles() {
        return this.wadfiles.size();
    }
}

