/*
 * Decompiled with CFR 0.152.
 */
package automap;

import automap.IAutoMap;
import automap.fline_t;
import automap.islope_t;
import automap.mline_t;
import automap.mpoint_t;
import data.Tables;
import doom.DoomMain;
import doom.event_t;
import doom.evtype_t;
import doom.player_t;
import g.Signals;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import m.cheatseq_t;
import m.fixed_t;
import p.mobj_t;
import rr.patch_t;
import utils.GenericCopy;
import v.graphics.Plotter;
import v.renderers.DoomScreen;

public class Map<T, V>
implements IAutoMap<T, V> {
    final DoomMain<T, V> DOOM;
    static final Color BACKGROUND = Color.BLACK;
    static final Color YOURCOLORS = Color.WHITE;
    static final Color WALLCOLORS = Color.REDS;
    static final Color TELECOLORS = Color.DARK_REDS;
    static final Color TSWALLCOLORS = Color.GRAYS;
    static final Color FDWALLCOLORS = Color.BROWNS;
    static final Color CDWALLCOLORS = Color.YELLOWS;
    static final Color THINGCOLORS = Color.GREENS;
    static final Color SECRETWALLCOLORS = Color.REDS;
    static final Color GRIDCOLORS = Color.DARK_GREYS;
    static final Color MAPPOWERUPSHOWNCOLORS = Color.GRAYS;
    static final Color CROSSHAIRCOLORS = Color.GRAYS;
    static final EnumSet<Color> GENERATE_LITE_LEVELS_FOR = EnumSet.of(TELECOLORS, new Color[]{WALLCOLORS, FDWALLCOLORS, CDWALLCOLORS, TSWALLCOLORS, SECRETWALLCOLORS, MAPPOWERUPSHOWNCOLORS, THINGCOLORS});
    static final Color[] THEIR_COLORS = new Color[]{Color.GREENS, Color.GRAYS, Color.BROWNS, Color.REDS};
    public static final Signals.ScanCode AM_PANDOWNKEY = Signals.ScanCode.SC_DOWN;
    public static final Signals.ScanCode AM_PANUPKEY = Signals.ScanCode.SC_UP;
    public static final Signals.ScanCode AM_PANRIGHTKEY = Signals.ScanCode.SC_RIGHT;
    public static final Signals.ScanCode AM_PANLEFTKEY = Signals.ScanCode.SC_LEFT;
    public static final Signals.ScanCode AM_ZOOMINKEY = Signals.ScanCode.SC_EQUALS;
    public static final Signals.ScanCode AM_ZOOMOUTKEY = Signals.ScanCode.SC_MINUS;
    public static final Signals.ScanCode AM_STARTKEY = Signals.ScanCode.SC_TAB;
    public static final Signals.ScanCode AM_ENDKEY = Signals.ScanCode.SC_TAB;
    public static final Signals.ScanCode AM_GOBIGKEY = Signals.ScanCode.SC_0;
    public static final Signals.ScanCode AM_FOLLOWKEY = Signals.ScanCode.SC_F;
    public static final Signals.ScanCode AM_GRIDKEY = Signals.ScanCode.SC_G;
    public static final Signals.ScanCode AM_MARKKEY = Signals.ScanCode.SC_M;
    public static final Signals.ScanCode AM_CLEARMARKKEY = Signals.ScanCode.SC_C;
    public static final int AM_NUMMARKPOINTS = 10;
    public static final int INITSCALEMTOF = 13107;
    public static final int F_PANINC = 4;
    public static final int M_ZOOMIN = 66846;
    public static final int M_ZOOMOUT = 64250;
    final EnumMap<Color, V> fixedColorSources = new EnumMap(Color.class);
    final EnumMap<Color, V> litedColorSources = new EnumMap(Color.class);
    public static final short LINE_NEVERSEE = 128;
    private static final int MINIMUM_SCALE = 45875;
    private static final int MINIMUM_VIABLE_SCALE = 2048;
    protected mline_t[] player_arrow;
    protected int NUMPLYRLINES;
    protected mline_t[] cheat_player_arrow;
    protected int NUMCHEATPLYRLINES;
    protected mline_t[] triangle_guy;
    protected int NUMTRIANGLEGUYLINES;
    protected mline_t[] thintriangle_guy;
    protected int NUMTHINTRIANGLEGUYLINES;
    protected int overlay = 0;
    protected int cheating = 0;
    protected boolean grid = false;
    protected int leveljuststarted = 1;
    protected int finit_width;
    protected int finit_height;
    protected int f_x;
    protected int f_y;
    protected int f_w;
    protected int f_h;
    protected Rectangle f_rect;
    protected int lightlev;
    protected final Plotter<V> plotter;
    protected int amclock;
    protected mpoint_t m_paninc;
    protected int mtof_zoommul;
    protected int ftom_zoommul;
    protected int m_x;
    protected int m_y;
    protected int m_x2;
    protected int m_y2;
    protected int m_w;
    protected int m_h;
    protected int min_x;
    protected int min_y;
    protected int max_x;
    protected int max_y;
    protected int max_w;
    protected int max_h;
    protected int min_w;
    protected int min_h;
    protected int min_scale_mtof;
    protected int max_scale_mtof;
    protected int old_m_w;
    protected int old_m_h;
    protected int old_m_x;
    protected int old_m_y;
    protected mpoint_t f_oldloc;
    protected int scale_mtof = 13107;
    protected int scale_ftom;
    protected player_t plr;
    private final patch_t[] marknums = new patch_t[10];
    private final mpoint_t[] markpoints;
    private int markpointnum = 0;
    protected boolean followplayer = true;
    protected char[] cheat_amap_seq = new char[]{'\u00b2', '&', '&', '.', '\u00ff'};
    protected cheatseq_t cheat_amap = new cheatseq_t(this.cheat_amap_seq, 0);
    private final char[] cheat_strobe_seq = new char[]{'n', '\u00a6', '\u00ea', '.', 'j', '\u00f6', 'b', '\u00a6', '\u00ff'};
    private final cheatseq_t cheat_strobe = new cheatseq_t(this.cheat_strobe_seq, 0);
    private boolean stopped = true;
    protected int lastlevel = -1;
    protected int lastepisode = -1;
    protected boolean cheatstate = false;
    protected boolean bigstate = false;
    protected String buffer;
    private int tmpx;
    private int tmpy;
    protected static int LEFT = 1;
    protected static int RIGHT = 2;
    protected static int BOTTOM = 4;
    protected static int TOP = 8;
    protected int fuck = 0;
    protected int singlepixel = 0;
    private fline_t fl = new fline_t();
    private mline_t ml = new mline_t();
    protected mline_t l = new mline_t();
    private int rotx;
    private int roty;

    public Map(DoomMain<T, V> DOOM) {
        this.DOOM = DOOM;
        this.markpoints = (mpoint_t[])GenericCopy.malloc(mpoint_t::new, mpoint_t[]::new, 10);
        this.f_oldloc = new mpoint_t();
        this.m_paninc = new mpoint_t();
        this.plotter = DOOM.graphicSystem.createPlotter(DoomScreen.FG);
        this.plr = DOOM.players[DOOM.displayplayer];
        this.Repalette();
        this.finit_width = DOOM.vs.getScreenWidth();
        this.finit_height = DOOM.vs.getScreenHeight() - 32 * DOOM.vs.getSafeScaling();
    }

    @Override
    public final void Repalette() {
        GENERATE_LITE_LEVELS_FOR.stream().forEach(c -> {
            if (c.liteBlock != null) {
                this.litedColorSources.put((Color)((Object)c), this.DOOM.graphicSystem.convertPalettedBlock(c.liteBlock));
            }
        });
        Arrays.stream(Color.values()).forEach(c -> {
            Object converted = this.DOOM.graphicSystem.convertPalettedBlock(c.value);
            Object extended = Array.newInstance(converted.getClass().getComponentType(), 8);
            GenericCopy.memset(extended, 0, 8, converted, 0, 1);
            this.fixedColorSources.put((Color)((Object)c), extended);
        });
    }

    private int FTOM(int x) {
        return fixed_t.FixedMul(x << 16, this.scale_ftom);
    }

    private int MTOF(int x) {
        return fixed_t.FixedMul(x, this.scale_mtof) >> 16;
    }

    private int CXMTOF(int x) {
        return this.f_x + this.MTOF(x - this.m_x);
    }

    private int CYMTOF(int y) {
        return this.f_y + (this.f_h - this.MTOF(y - this.m_y));
    }

    protected void initVectorGraphics() {
        int R = 1198372;
        this.player_arrow = new mline_t[]{new mline_t(-R + R / 8, 0, R, 0), new mline_t(R, 0, R - R / 2, R / 4), new mline_t(R, 0, R - R / 2, -R / 4), new mline_t(-R + R / 8, 0, -R - R / 8, R / 4), new mline_t(-R + R / 8, 0, -R - R / 8, -R / 4), new mline_t(-R + 3 * R / 8, 0, -R + R / 8, R / 4), new mline_t(-R + 3 * R / 8, 0, -R + R / 8, -R / 4)};
        this.NUMPLYRLINES = this.player_arrow.length;
        this.cheat_player_arrow = new mline_t[]{new mline_t(-R + R / 8, 0, R, 0), new mline_t(R, 0, R - R / 2, R / 6), new mline_t(R, 0, R - R / 2, -R / 6), new mline_t(-R + R / 8, 0, -R - R / 8, R / 6), new mline_t(-R + R / 8, 0, -R - R / 8, -R / 6), new mline_t(-R + 3 * R / 8, 0, -R + R / 8, R / 6), new mline_t(-R + 3 * R / 8, 0, -R + R / 8, -R / 6), new mline_t(-R / 2, 0, -R / 2, -R / 6), new mline_t(-R / 2, -R / 6, -R / 2 + R / 6, -R / 6), new mline_t(-R / 2 + R / 6, -R / 6, -R / 2 + R / 6, R / 4), new mline_t(-R / 6, 0, -R / 6, -R / 6), new mline_t(-R / 6, -R / 6, 0, -R / 6), new mline_t(0, -R / 6, 0, R / 4), new mline_t(R / 6, R / 4, R / 6, -R / 7), new mline_t(R / 6, -R / 7, R / 6 + R / 32, -R / 7 - R / 32), new mline_t(R / 6 + R / 32, -R / 7 - R / 32, R / 6 + R / 10, -R / 7)};
        this.NUMCHEATPLYRLINES = this.cheat_player_arrow.length;
        R = 65536;
        this.triangle_guy = new mline_t[]{new mline_t(-0.867 * (double)R, -0.5 * (double)R, 0.867 * (double)R, -0.5 * (double)R), new mline_t(0.867 * (double)R, -0.5 * (double)R, 0.0, (double)R), new mline_t(0.0, (double)R, -0.867 * (double)R, -0.5 * (double)R)};
        this.NUMTRIANGLEGUYLINES = this.triangle_guy.length;
        this.thintriangle_guy = new mline_t[]{new mline_t(-0.5 * (double)R, -0.7 * (double)R, (double)R, 0.0), new mline_t((double)R, 0.0, -0.5 * (double)R, 0.7 * (double)R), new mline_t(-0.5 * (double)R, 0.7 * (double)R, -0.5 * (double)R, -0.7 * (double)R)};
        this.NUMTHINTRIANGLEGUYLINES = this.thintriangle_guy.length;
    }

    public final void getIslope(mline_t ml, islope_t is) {
        int dy = ml.ay - ml.by;
        int dx = ml.bx - ml.ax;
        is.islp = dy == 0 ? (dx < 0 ? -2147483647 : Integer.MAX_VALUE) : fixed_t.FixedDiv(dx, dy);
        is.slp = dx == 0 ? (dy < 0 ? -2147483647 : Integer.MAX_VALUE) : fixed_t.FixedDiv(dy, dx);
    }

    public final void activateNewScale() {
        this.m_x += this.m_w / 2;
        this.m_y += this.m_h / 2;
        this.m_w = this.FTOM(this.f_w);
        this.m_h = this.FTOM(this.f_h);
        this.m_x -= this.m_w / 2;
        this.m_y -= this.m_h / 2;
        this.m_x2 = this.m_x + this.m_w;
        this.m_y2 = this.m_y + this.m_h;
        this.plotter.setThickness(Math.min(this.MTOF(65536), this.DOOM.graphicSystem.getScalingX()), Math.min(this.MTOF(65536), this.DOOM.graphicSystem.getScalingY()));
    }

    public final void saveScaleAndLoc() {
        this.old_m_x = this.m_x;
        this.old_m_y = this.m_y;
        this.old_m_w = this.m_w;
        this.old_m_h = this.m_h;
    }

    private void restoreScaleAndLoc() {
        this.m_w = this.old_m_w;
        this.m_h = this.old_m_h;
        if (!this.followplayer) {
            this.m_x = this.old_m_x;
            this.m_y = this.old_m_y;
        } else {
            this.m_x = this.plr.mo.x - this.m_w / 2;
            this.m_y = this.plr.mo.y - this.m_h / 2;
        }
        this.m_x2 = this.m_x + this.m_w;
        this.m_y2 = this.m_y + this.m_h;
        this.scale_mtof = fixed_t.FixedDiv(this.f_w << 16, this.m_w);
        this.scale_ftom = fixed_t.FixedDiv(65536, this.scale_mtof);
        this.plotter.setThickness(Math.min(this.MTOF(65536), 8), Math.min(this.MTOF(65536), 8));
    }

    public final void addMark() {
        this.markpoints[this.markpointnum].x = this.m_x + this.m_w / 2;
        this.markpoints[this.markpointnum].y = this.m_y + this.m_h / 2;
        this.markpointnum = (this.markpointnum + 1) % 10;
    }

    public final void findMinMaxBoundaries() {
        int b;
        this.min_y = Integer.MAX_VALUE;
        this.min_x = Integer.MAX_VALUE;
        this.max_y = -2147483647;
        this.max_x = -2147483647;
        for (int i = 0; i < this.DOOM.levelLoader.numvertexes; ++i) {
            if (this.DOOM.levelLoader.vertexes[i].x < this.min_x) {
                this.min_x = this.DOOM.levelLoader.vertexes[i].x;
            } else if (this.DOOM.levelLoader.vertexes[i].x > this.max_x) {
                this.max_x = this.DOOM.levelLoader.vertexes[i].x;
            }
            if (this.DOOM.levelLoader.vertexes[i].y < this.min_y) {
                this.min_y = this.DOOM.levelLoader.vertexes[i].y;
                continue;
            }
            if (this.DOOM.levelLoader.vertexes[i].y <= this.max_y) continue;
            this.max_y = this.DOOM.levelLoader.vertexes[i].y;
        }
        this.max_w = this.max_x - this.min_x;
        this.max_h = this.max_y - this.min_y;
        this.min_w = 0x200000;
        this.min_h = 0x200000;
        int a = fixed_t.FixedDiv(this.f_w << 16, this.max_w);
        int n = this.min_scale_mtof = a < (b = fixed_t.FixedDiv(this.f_h << 16, this.max_h)) ? a : b;
        if (this.min_scale_mtof < 0) {
            this.min_scale_mtof = 2048;
        }
        this.max_scale_mtof = fixed_t.FixedDiv(this.f_h << 16, 0x200000);
    }

    public final void changeWindowLoc() {
        if (this.m_paninc.x != 0 || this.m_paninc.y != 0) {
            this.followplayer = false;
            this.f_oldloc.x = Integer.MAX_VALUE;
        }
        this.m_x += this.m_paninc.x;
        this.m_y += this.m_paninc.y;
        if (this.m_x + this.m_w / 2 > this.max_x) {
            this.m_x = this.max_x - this.m_w / 2;
        } else if (this.m_x + this.m_w / 2 < this.min_x) {
            this.m_x = this.min_x - this.m_w / 2;
        }
        if (this.m_y + this.m_h / 2 > this.max_y) {
            this.m_y = this.max_y - this.m_h / 2;
        } else if (this.m_y + this.m_h / 2 < this.min_y) {
            this.m_y = this.min_y - this.m_h / 2;
        }
        this.m_x2 = this.m_x + this.m_w;
        this.m_y2 = this.m_y + this.m_h;
    }

    public final void initVariables() {
        this.DOOM.automapactive = true;
        this.f_oldloc.x = Integer.MAX_VALUE;
        this.amclock = 0;
        this.lightlev = 0;
        this.m_paninc.y = 0;
        this.m_paninc.x = 0;
        this.ftom_zoommul = 65536;
        this.mtof_zoommul = 65536;
        this.m_w = this.FTOM(this.f_w);
        this.m_h = this.FTOM(this.f_h);
        int pnum = this.DOOM.consoleplayer;
        if (!this.DOOM.playeringame[pnum]) {
            for (pnum = 0; pnum < 4; ++pnum) {
                System.out.println(pnum);
                if (this.DOOM.playeringame[pnum]) break;
            }
        }
        this.plr = this.DOOM.players[pnum];
        this.m_x = this.plr.mo.x - this.m_w / 2;
        this.m_y = this.plr.mo.y - this.m_h / 2;
        this.changeWindowLoc();
        this.old_m_x = this.m_x;
        this.old_m_y = this.m_y;
        this.old_m_w = this.m_w;
        this.old_m_h = this.m_h;
        this.DOOM.statusBar.NotifyAMEnter();
    }

    public final void loadPics() {
        for (int i = 0; i < 10; ++i) {
            String namebuf = "AMMNUM" + i;
            this.marknums[i] = this.DOOM.wadLoader.CachePatchName(namebuf);
        }
    }

    public final void unloadPics() {
        for (int i = 0; i < 10; ++i) {
            this.DOOM.wadLoader.UnlockLumpNum(this.marknums[i]);
        }
    }

    public final void clearMarks() {
        for (int i = 0; i < 10; ++i) {
            this.markpoints[i].x = -1;
        }
        this.markpointnum = 0;
    }

    public final void LevelInit() {
        this.leveljuststarted = 0;
        this.f_y = 0;
        this.f_x = 0;
        this.f_w = this.finit_width;
        this.f_h = this.finit_height;
        this.f_rect = new Rectangle(0, 0, this.f_w, this.f_h);
        this.clearMarks();
        this.findMinMaxBoundaries();
        this.scale_mtof = fixed_t.FixedDiv(this.min_scale_mtof, 45875);
        if (this.scale_mtof > this.max_scale_mtof) {
            this.scale_mtof = this.min_scale_mtof;
        }
        this.scale_ftom = fixed_t.FixedDiv(65536, this.scale_mtof);
        this.plotter.setThickness(Math.min(this.MTOF(65536), this.DOOM.graphicSystem.getScalingX()), Math.min(this.MTOF(65536), this.DOOM.graphicSystem.getScalingY()));
    }

    @Override
    public final void Stop() {
        this.unloadPics();
        this.DOOM.automapactive = false;
        this.DOOM.statusBar.NotifyAMExit();
        this.stopped = true;
    }

    @Override
    public final void Start() {
        if (!this.stopped) {
            this.Stop();
        }
        this.stopped = false;
        if (this.lastlevel != this.DOOM.gamemap || this.lastepisode != this.DOOM.gameepisode) {
            this.LevelInit();
            this.lastlevel = this.DOOM.gamemap;
            this.lastepisode = this.DOOM.gameepisode;
        }
        this.initVectorGraphics();
        this.LevelInit();
        this.initVariables();
        this.loadPics();
    }

    public final void minOutWindowScale() {
        this.scale_mtof = this.min_scale_mtof;
        this.scale_ftom = fixed_t.FixedDiv(65536, this.scale_mtof);
        this.plotter.setThickness(this.DOOM.graphicSystem.getScalingX(), this.DOOM.graphicSystem.getScalingY());
        this.activateNewScale();
    }

    public final void maxOutWindowScale() {
        this.scale_mtof = this.max_scale_mtof;
        this.scale_ftom = fixed_t.FixedDiv(65536, this.scale_mtof);
        this.plotter.setThickness(0, 0);
        this.activateNewScale();
    }

    @Override
    public final boolean Responder(event_t ev) {
        boolean rc = false;
        if (!this.DOOM.automapactive) {
            if (ev.isKey(AM_STARTKEY, evtype_t.ev_keyup)) {
                this.Start();
                this.DOOM.viewactive = false;
                rc = true;
            }
        } else if (ev.isType(evtype_t.ev_keydown)) {
            rc = true;
            if (ev.isKey(AM_PANRIGHTKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.x = this.FTOM(4);
                } else {
                    rc = false;
                }
            } else if (ev.isKey(AM_PANLEFTKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.x = -this.FTOM(4);
                } else {
                    rc = false;
                }
            } else if (ev.isKey(AM_PANUPKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.y = this.FTOM(4);
                } else {
                    rc = false;
                }
            } else if (ev.isKey(AM_PANDOWNKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.y = -this.FTOM(4);
                } else {
                    rc = false;
                }
            } else if (ev.isKey(AM_ZOOMOUTKEY)) {
                this.mtof_zoommul = 64250;
                this.ftom_zoommul = 66846;
            } else if (ev.isKey(AM_ZOOMINKEY)) {
                this.mtof_zoommul = 66846;
                this.ftom_zoommul = 64250;
            } else if (ev.isKey(AM_GOBIGKEY)) {
                boolean bl = this.bigstate = !this.bigstate;
                if (this.bigstate) {
                    this.saveScaleAndLoc();
                    this.minOutWindowScale();
                } else {
                    this.restoreScaleAndLoc();
                }
            } else if (ev.isKey(AM_FOLLOWKEY)) {
                this.followplayer = !this.followplayer;
                this.f_oldloc.x = Integer.MAX_VALUE;
                this.plr.message = this.followplayer ? "Follow Mode ON" : "Follow Mode OFF";
            } else if (ev.isKey(AM_GRIDKEY)) {
                this.grid = !this.grid;
                this.plr.message = this.grid ? "Grid ON" : "Grid OFF";
            } else if (ev.isKey(AM_MARKKEY)) {
                this.plr.message = this.buffer = "Marked Spot " + this.markpointnum;
                this.addMark();
            } else if (ev.isKey(AM_CLEARMARKKEY)) {
                this.clearMarks();
                this.plr.message = "All Marks Cleared";
            } else {
                this.cheatstate = false;
                rc = false;
            }
            if (!this.DOOM.deathmatch) {
                if (ev.ifKeyAsciiChar(this.cheat_amap::CheckCheat)) {
                    rc = false;
                    this.cheating = (this.cheating + 1) % 3;
                }
            }
            if (ev.ifKeyAsciiChar(this.cheat_strobe::CheckCheat)) {
                this.DOOM.mapstrobe = !this.DOOM.mapstrobe;
            }
        } else if (ev.isType(evtype_t.ev_keyup)) {
            rc = false;
            if (ev.isKey(AM_PANRIGHTKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.x = 0;
                }
            } else if (ev.isKey(AM_PANLEFTKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.x = 0;
                }
            } else if (ev.isKey(AM_PANUPKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.y = 0;
                }
            } else if (ev.isKey(AM_PANDOWNKEY)) {
                if (!this.followplayer) {
                    this.m_paninc.y = 0;
                }
            } else if (ev.isKey(AM_ZOOMOUTKEY) || ev.isKey(AM_ZOOMINKEY)) {
                this.mtof_zoommul = 65536;
                this.ftom_zoommul = 65536;
            } else if (ev.isKey(AM_ENDKEY)) {
                this.bigstate = false;
                this.DOOM.viewactive = true;
                this.Stop();
            }
        }
        return rc;
    }

    private void changeWindowScale() {
        this.scale_mtof = fixed_t.FixedMul(this.scale_mtof, this.mtof_zoommul);
        this.scale_ftom = fixed_t.FixedDiv(65536, this.scale_mtof);
        if (this.scale_mtof < this.min_scale_mtof) {
            this.minOutWindowScale();
        } else if (this.scale_mtof > this.max_scale_mtof) {
            this.maxOutWindowScale();
        } else {
            this.activateNewScale();
        }
    }

    private void doFollowPlayer() {
        if (this.f_oldloc.x != this.plr.mo.x || this.f_oldloc.y != this.plr.mo.y) {
            this.m_x = this.FTOM(this.MTOF(this.plr.mo.x)) - this.m_w / 2;
            this.m_y = this.FTOM(this.MTOF(this.plr.mo.y)) - this.m_h / 2;
            this.m_x2 = this.m_x + this.m_w;
            this.m_y2 = this.m_y + this.m_h;
            this.f_oldloc.x = this.plr.mo.x;
            this.f_oldloc.y = this.plr.mo.y;
        }
    }

    private void updateLightLev() {
        if (this.amclock % 6 == 0) {
            int sourceLength = 8;
            Object intermeditate = this.DOOM.graphicSystem.convertPalettedBlock(0);
            this.litedColorSources.forEach((c, source) -> {
                GenericCopy.memcpy(source, 7, intermeditate, 0, 1);
                GenericCopy.memcpy(source, 0, source, 1, 7);
                GenericCopy.memcpy(intermeditate, 0, source, 0, 1);
            });
        }
    }

    @Override
    public final void Ticker() {
        if (!this.DOOM.automapactive || this.DOOM.menuactive) {
            return;
        }
        ++this.amclock;
        if (this.followplayer) {
            this.doFollowPlayer();
        }
        if (this.ftom_zoommul != 65536) {
            this.changeWindowScale();
        }
        if ((this.m_paninc.x | this.m_paninc.y) != 0) {
            this.changeWindowLoc();
        }
        if (this.DOOM.mapstrobe) {
            this.updateLightLev();
        }
    }

    private boolean clipMline(mline_t ml, fline_t fl) {
        int outcode1 = 0;
        int outcode2 = 0;
        if (ml.ay > this.m_y2) {
            outcode1 = TOP;
        } else if (ml.ay < this.m_y) {
            outcode1 = BOTTOM;
        }
        if (ml.by > this.m_y2) {
            outcode2 = TOP;
        } else if (ml.by < this.m_y) {
            outcode2 = BOTTOM;
        }
        if ((outcode1 & outcode2) != 0) {
            return false;
        }
        if (ml.ax < this.m_x) {
            outcode1 |= LEFT;
        } else if (ml.ax > this.m_x2) {
            outcode1 |= RIGHT;
        }
        if (ml.bx < this.m_x) {
            outcode2 |= LEFT;
        } else if (ml.bx > this.m_x2) {
            outcode2 |= RIGHT;
        }
        if ((outcode1 & outcode2) != 0) {
            return false;
        }
        fl.ax = this.CXMTOF(ml.ax);
        fl.ay = this.CYMTOF(ml.ay);
        fl.bx = this.CXMTOF(ml.bx);
        fl.by = this.CYMTOF(ml.by);
        outcode1 = this.DOOUTCODE(fl.ax, fl.ay);
        if ((outcode1 & (outcode2 = this.DOOUTCODE(fl.bx, fl.by))) != 0) {
            return false;
        }
        while ((outcode1 | outcode2) != 0) {
            int dx;
            int dy;
            int outside = outcode1 != 0 ? outcode1 : outcode2;
            if ((outside & TOP) != 0) {
                dy = fl.ay - fl.by;
                dx = fl.bx - fl.ax;
                this.tmpx = fl.ax + dx * fl.ay / dy;
                this.tmpy = 0;
            } else if ((outside & BOTTOM) != 0) {
                dy = fl.ay - fl.by;
                dx = fl.bx - fl.ax;
                this.tmpx = fl.ax + dx * (fl.ay - this.f_h) / dy;
                this.tmpy = this.f_h - 1;
            } else if ((outside & RIGHT) != 0) {
                dy = fl.by - fl.ay;
                dx = fl.bx - fl.ax;
                this.tmpy = fl.ay + dy * (this.f_w - 1 - fl.ax) / dx;
                this.tmpx = this.f_w - 1;
            } else if ((outside & LEFT) != 0) {
                dy = fl.by - fl.ay;
                dx = fl.bx - fl.ax;
                this.tmpy = fl.ay + dy * -fl.ax / dx;
                this.tmpx = 0;
            }
            if (outside == outcode1) {
                fl.ax = this.tmpx;
                fl.ay = this.tmpy;
                outcode1 = this.DOOUTCODE(fl.ax, fl.ay);
            } else {
                fl.bx = this.tmpx;
                fl.by = this.tmpy;
                outcode2 = this.DOOUTCODE(fl.bx, fl.by);
            }
            if ((outcode1 & outcode2) == 0) continue;
            return false;
        }
        return true;
    }

    private int DOOUTCODE(int mx, int my) {
        int oc = 0;
        if (my < 0) {
            oc |= TOP;
        } else if (my >= this.f_h) {
            oc |= BOTTOM;
        }
        if (mx < 0) {
            oc |= LEFT;
        } else if (mx >= this.f_w) {
            oc |= RIGHT;
        }
        return oc;
    }

    private void drawMline(mline_t ml, V colorSource) {
        if (this.clipMline(ml, this.fl)) {
            this.DOOM.graphicSystem.drawLine(this.plotter.setColorSource(colorSource, 0).setPosition(this.fl.ax, this.fl.ay), this.fl.bx, this.fl.by);
        }
    }

    private void drawGrid(V colorSource) {
        int start = this.m_x;
        if ((start - this.DOOM.levelLoader.bmaporgx) % 0x800000 != 0) {
            start += 0x800000 - (start - this.DOOM.levelLoader.bmaporgx) % 0x800000;
        }
        int end = this.m_x + this.m_w;
        this.ml.ay = this.m_y;
        this.ml.by = this.m_y + this.m_h;
        for (int x = start; x < end; x += 0x800000) {
            this.ml.ax = x;
            this.ml.bx = x;
            this.drawMline(this.ml, colorSource);
        }
        start = this.m_y;
        if ((start - this.DOOM.levelLoader.bmaporgy) % 0x800000 != 0) {
            start += 0x800000 - (start - this.DOOM.levelLoader.bmaporgy) % 0x800000;
        }
        end = this.m_y + this.m_h;
        this.ml.ax = this.m_x;
        this.ml.bx = this.m_x + this.m_w;
        for (int y = start; y < end; y += 0x800000) {
            this.ml.ay = y;
            this.ml.by = y;
            this.drawMline(this.ml, colorSource);
        }
    }

    private void drawWalls() {
        V teleColorSource = this.litedColorSources.get((Object)TELECOLORS);
        V wallColorSource = this.litedColorSources.get((Object)WALLCOLORS);
        V fdWallColorSource = this.litedColorSources.get((Object)FDWALLCOLORS);
        V cdWallColorSource = this.litedColorSources.get((Object)CDWALLCOLORS);
        V tsWallColorSource = this.litedColorSources.get((Object)TSWALLCOLORS);
        V secretWallColorSource = this.litedColorSources.get((Object)SECRETWALLCOLORS);
        for (int i = 0; i < this.DOOM.levelLoader.numlines; ++i) {
            this.l.ax = this.DOOM.levelLoader.lines[i].v1x;
            this.l.ay = this.DOOM.levelLoader.lines[i].v1y;
            this.l.bx = this.DOOM.levelLoader.lines[i].v2x;
            this.l.by = this.DOOM.levelLoader.lines[i].v2y;
            if ((this.cheating | this.DOOM.levelLoader.lines[i].flags & 0x100) != 0) {
                if ((this.DOOM.levelLoader.lines[i].flags & 0x80 & ~this.cheating) != 0) continue;
                if (this.DOOM.levelLoader.lines[i].backsector == null) {
                    this.drawMline(this.l, wallColorSource);
                    continue;
                }
                if (this.DOOM.levelLoader.lines[i].special == 39) {
                    this.drawMline(this.l, teleColorSource);
                    continue;
                }
                if ((this.DOOM.levelLoader.lines[i].flags & 0x20) != 0) {
                    if (this.cheating != 0) {
                        this.drawMline(this.l, secretWallColorSource);
                        continue;
                    }
                    this.drawMline(this.l, wallColorSource);
                    continue;
                }
                if (this.DOOM.levelLoader.lines[i].backsector.floorheight != this.DOOM.levelLoader.lines[i].frontsector.floorheight) {
                    this.drawMline(this.l, fdWallColorSource);
                    continue;
                }
                if (this.DOOM.levelLoader.lines[i].backsector.ceilingheight != this.DOOM.levelLoader.lines[i].frontsector.ceilingheight) {
                    this.drawMline(this.l, cdWallColorSource);
                    continue;
                }
                if (this.cheating == 0) continue;
                this.drawMline(this.l, tsWallColorSource);
                continue;
            }
            if (this.plr.powers[4] == 0 || (this.DOOM.levelLoader.lines[i].flags & 0x80) != 0) continue;
            this.drawMline(this.l, this.litedColorSources.get((Object)MAPPOWERUPSHOWNCOLORS));
        }
    }

    private void rotate(int x, int y, int a) {
        this.rotx = fixed_t.FixedMul(x, Tables.finecosine[a]) - fixed_t.FixedMul(y, Tables.finesine[a]);
        this.roty = fixed_t.FixedMul(x, Tables.finesine[a]) + fixed_t.FixedMul(y, Tables.finecosine[a]);
    }

    private void drawLineCharacter(mline_t[] lineguy, int lineguylines, int scale, int angle, V colorSource, int x, int y) {
        boolean rotate = angle != 0;
        mline_t l = new mline_t();
        for (int i = 0; i < lineguylines; ++i) {
            l.ax = lineguy[i].ax;
            l.ay = lineguy[i].ay;
            if (scale != 0) {
                l.ax = fixed_t.FixedMul(scale, l.ax);
                l.ay = fixed_t.FixedMul(scale, l.ay);
            }
            if (rotate) {
                this.rotate(l.ax, l.ay, angle);
                l.ax = this.rotx;
                l.ay = this.roty;
            }
            l.ax += x;
            l.ay += y;
            l.bx = lineguy[i].bx;
            l.by = lineguy[i].by;
            if (scale != 0) {
                l.bx = fixed_t.FixedMul(scale, l.bx);
                l.by = fixed_t.FixedMul(scale, l.by);
            }
            if (rotate) {
                this.rotate(l.bx, l.by, angle);
                l.bx = this.rotx;
                l.by = this.roty;
            }
            l.bx += x;
            l.by += y;
            this.drawMline(l, colorSource);
        }
    }

    public final void drawPlayers() {
        int their_color = -1;
        if (!this.DOOM.netgame) {
            if (this.cheating != 0) {
                this.drawLineCharacter(this.cheat_player_arrow, this.NUMCHEATPLYRLINES, 0, Tables.toBAMIndex(this.plr.mo.angle), this.fixedColorSources.get((Object)Color.WHITE), this.plr.mo.x, this.plr.mo.y);
            } else {
                this.drawLineCharacter(this.player_arrow, this.NUMPLYRLINES, 0, Tables.toBAMIndex(this.plr.mo.angle), this.fixedColorSources.get((Object)Color.WHITE), this.plr.mo.x, this.plr.mo.y);
            }
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ++their_color;
            player_t p = this.DOOM.players[i];
            if (this.DOOM.deathmatch && !this.DOOM.singledemo && p != this.plr || !this.DOOM.playeringame[i]) continue;
            V colorSource = p.powers[2] != 0 ? this.fixedColorSources.get((Object)Color.CLOSE_TO_BLACK) : this.fixedColorSources.get((Object)THEIR_COLORS[their_color]);
            this.drawLineCharacter(this.player_arrow, this.NUMPLYRLINES, 0, (int)p.mo.angle, colorSource, p.mo.x, p.mo.y);
        }
    }

    final void drawThings(Color colors, int colorrange) {
        V colorSource = this.litedColorSources.get((Object)colors);
        for (int i = 0; i < this.DOOM.levelLoader.numsectors; ++i) {
            mobj_t t = this.DOOM.levelLoader.sectors[i].thinglist;
            while (t != null) {
                this.drawLineCharacter(this.thintriangle_guy, this.NUMTHINTRIANGLEGUYLINES, 0x100000, Tables.toBAMIndex(t.angle), colorSource, t.x, t.y);
                t = (mobj_t)t.snext;
            }
        }
    }

    public final void drawMarks() {
        for (int i = 0; i < 10; ++i) {
            if (this.markpoints[i].x == -1) continue;
            short w = this.marknums[i].width;
            short h = this.marknums[i].height;
            int fx = this.CXMTOF(this.markpoints[i].x);
            int fy = this.CYMTOF(this.markpoints[i].y);
            if (fx < this.f_x || fx > this.f_w - w || fy < this.f_y || fy > this.f_h - h) continue;
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.marknums[i], this.DOOM.vs, fx, fy, 65536);
        }
    }

    private void drawCrosshair(V colorSource) {
    }

    @Override
    public final void Drawer() {
        if (!this.DOOM.automapactive) {
            return;
        }
        if (this.overlay < 1) {
            this.DOOM.graphicSystem.FillRect(DoomScreen.FG, this.f_rect, Map.BACKGROUND.value);
        }
        if (this.grid) {
            this.drawGrid(this.fixedColorSources.get((Object)GRIDCOLORS));
        }
        this.drawWalls();
        this.drawPlayers();
        if (this.cheating == 2) {
            this.drawThings(THINGCOLORS, 16);
        }
        this.drawCrosshair(this.fixedColorSources.get((Object)CROSSHAIRCOLORS));
        this.drawMarks();
    }

    static enum Color {
        CLOSE_TO_BLACK(1, -10),
        REDS(16, -80),
        BLUES(8, -56),
        GREENS(16, 112),
        GRAYS(16, 96),
        BROWNS(16, 64),
        YELLOWS(8, -96),
        BLACK(1, 0),
        WHITE(1, 4),
        GRAYS_DARKER_25(13, (byte)(Color.GRAYS.value + 4)),
        DARK_GREYS(8, (byte)(Color.GRAYS.value + Color.GRAYS.range / 2)),
        DARK_REDS(8, (byte)(Color.REDS.value + Color.REDS.range / 2));

        static final int NUM_LITES = 8;
        static final int[] LITE_LEVELS_FULL_RANGE;
        static final int[] LITE_LEVELS_HALF_RANGE;
        final byte[] liteBlock;
        final byte value;
        final int range;

        private Color(int range, byte value) {
            this.range = range;
            this.value = value;
            this.liteBlock = (byte[])(range >= 8 ? new byte[8] : null);
        }

        static {
            LITE_LEVELS_FULL_RANGE = new int[]{0, 4, 7, 10, 12, 14, 15, 15};
            LITE_LEVELS_HALF_RANGE = new int[]{0, 2, 3, 5, 6, 6, 7, 7};
            block4: for (Color c : Color.values()) {
                switch (c.range) {
                    case 16: {
                        int i;
                        for (i = 0; i < 8; ++i) {
                            c.liteBlock[i] = (byte)(c.value + LITE_LEVELS_FULL_RANGE[i]);
                        }
                        continue block4;
                    }
                    case 8: {
                        int i;
                        for (i = 0; i < LITE_LEVELS_HALF_RANGE.length; ++i) {
                            c.liteBlock[i] = (byte)(c.value + LITE_LEVELS_HALF_RANGE[i]);
                        }
                        continue block4;
                    }
                }
            }
        }
    }
}

