/*
 * Decompiled with CFR 0.152.
 */
package awt;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DisplayModePicker {
    protected GraphicsDevice device;
    protected DisplayMode default_mode;

    public DisplayModePicker(GraphicsDevice device) {
        this.device = device;
        this.default_mode = device.getDisplayMode();
    }

    public DisplayMode pickClosest(int width, int height) {
        DisplayMode[] modes = this.device.getDisplayModes();
        ArrayList<DisplayMode> picks = new ArrayList<DisplayMode>();
        WidthComparator wc = new WidthComparator();
        HeightComparator hc = new HeightComparator();
        for (DisplayMode dm : modes) {
            if (dm.getWidth() < width || dm.getHeight() < height) continue;
            picks.add(dm);
        }
        if (picks.size() > 0) {
            Collections.sort(picks, wc.thenComparing(hc));
        }
        return (DisplayMode)picks.get(0);
    }

    public int[] getCentering(int width, int height, DisplayMode dm) {
        int[] xy = new int[]{(dm.getWidth() - width) / 2, (dm.getHeight() - height) / 2};
        return xy;
    }

    class HeightComparator
    implements Comparator<DisplayMode> {
        HeightComparator() {
        }

        @Override
        public int compare(DisplayMode arg0, DisplayMode arg1) {
            if (arg0.getHeight() > arg1.getHeight()) {
                return 1;
            }
            if (arg0.getHeight() < arg1.getHeight()) {
                return -1;
            }
            return 0;
        }
    }

    class WidthComparator
    implements Comparator<DisplayMode> {
        WidthComparator() {
        }

        @Override
        public int compare(DisplayMode arg0, DisplayMode arg1) {
            if (arg0.getWidth() > arg1.getWidth()) {
                return 1;
            }
            if (arg0.getWidth() < arg1.getWidth()) {
                return -1;
            }
            return 0;
        }
    }
}

