/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.DoomFrame;
import awt.DoomWindow;
import awt.EventObserver;
import awt.FullscreenOptions;
import doom.event_t;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import m.Settings;
import mochadoom.Engine;
import mochadoom.Loggers;

public class DoomWindowController<E extends Component, H extends Enum<H>>
implements FullscreenOptions {
    private static final long ALL_EVENTS_MASK = -1L;
    final GraphicsDevice device;
    final FullscreenOptions.FullscreenFunction switcher;
    final int defaultWidth;
    final int defaultHeight;
    private final E component;
    private final EventObserver<H> observer;
    private DoomFrame<E> doomFrame;
    private final DimensionImpl dimension;
    private boolean isFullScreen;

    DoomWindowController(Class<H> handlerClass, GraphicsDevice device, Supplier<Image> imageSource, Consumer<? super event_t> doomEventConsumer, E component, int defaultWidth, int defaultHeight) {
        this.device = device;
        this.switcher = this.createFullSwitcher(device);
        this.component = component;
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        this.dimension = new DimensionImpl(defaultWidth, defaultHeight);
        this.doomFrame = new DoomFrame<E>(this.dimension, component, imageSource);
        this.observer = new EventObserver<H>(handlerClass, (Component)component, (Consumer<event_t>)doomEventConsumer);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.observer::observe, -1L);
        this.sizeInit();
        this.doomFrame.turnOn();
    }

    private void sizeInit() {
        try {
            if (!Engine.getConfig().equals(Settings.fullscreen, Boolean.TRUE) || !this.switchToFullScreen()) {
                this.updateSize();
            }
        }
        catch (Exception e) {
            Loggers.getLogger(DoomWindow.class.getName()).log(Level.SEVERE, String.format("Error creating DOOM AWT frame. Exiting. Reason: %s", e.getMessage()), e);
            throw e;
        }
    }

    public void updateFrame() {
        this.doomFrame.update();
    }

    public EventObserver<H> getObserver() {
        return this.observer;
    }

    public boolean switchFullscreen() {
        Loggers.getLogger(DoomFrame.class.getName()).log(Level.WARNING, "FULLSCREEN SWITHED");
        this.doomFrame.dispose();
        this.doomFrame = new DoomFrame<E>(this.dimension, this.component, this.doomFrame.imageSupplier);
        boolean ret = this.switchToFullScreen();
        this.doomFrame.turnOn();
        return ret;
    }

    public final boolean switchToFullScreen() {
        if (!this.isFullScreen) {
            this.isFullScreen = this.device.isFullScreenSupported();
            if (!this.isFullScreen) {
                return false;
            }
        } else {
            this.isFullScreen = false;
        }
        DisplayMode displayMode = this.switcher.get(this.defaultWidth, this.defaultHeight);
        this.doomFrame.setUndecorated(this.isFullScreen);
        this.device.setFullScreenWindow(this.isFullScreen ? this.doomFrame : null);
        if (this.device.isDisplayChangeSupported()) {
            this.device.setDisplayMode(displayMode);
        }
        ((Component)this.component).validate();
        this.dimension.setSize(displayMode);
        this.updateSize();
        return this.isFullScreen;
    }

    private void updateSize() {
        this.doomFrame.setPreferredSize(this.isFullscreen() ? this.dimension : null);
        ((Component)this.component).setPreferredSize(this.dimension);
        ((Component)this.component).setBounds(0, 0, this.defaultWidth - 1, this.defaultHeight - 1);
        ((Component)this.component).setBackground(Color.black);
        this.doomFrame.renewGraphics();
    }

    public boolean isFullscreen() {
        return this.isFullScreen;
    }

    private class DimensionImpl
    extends Dimension
    implements FullscreenOptions.Dimension {
        private static final long serialVersionUID = 4598094740125688728L;
        private int offsetX;
        private int offsetY;
        private int fitWidth;
        private int fitHeight;

        DimensionImpl(int width, int height) {
            this.width = DoomWindowController.this.defaultWidth;
            this.height = DoomWindowController.this.defaultHeight;
            this.offsetY = 0;
            this.offsetX = 0;
            this.fitWidth = width;
            this.fitHeight = height;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public int height() {
            return this.height;
        }

        @Override
        public int defWidth() {
            return DoomWindowController.this.defaultWidth;
        }

        @Override
        public int defHeight() {
            return DoomWindowController.this.defaultHeight;
        }

        @Override
        public int fitX() {
            return this.fitWidth;
        }

        @Override
        public int fitY() {
            return this.fitHeight;
        }

        @Override
        public int offsX() {
            return this.offsetX;
        }

        @Override
        public int offsY() {
            return this.offsetY;
        }

        private void setSize(DisplayMode mode) {
            if (DoomWindowController.this.isFullScreen) {
                this.width = mode.getWidth();
                this.height = mode.getHeight();
                this.offsetX = FullscreenOptions.Dimension.super.offsX();
                this.offsetY = FullscreenOptions.Dimension.super.offsY();
                this.fitWidth = FullscreenOptions.Dimension.super.fitX();
                this.fitHeight = FullscreenOptions.Dimension.super.fitY();
            } else {
                this.width = DoomWindowController.this.defaultWidth;
                this.height = DoomWindowController.this.defaultHeight;
                this.offsetY = 0;
                this.offsetX = 0;
                this.fitWidth = this.width;
                this.fitHeight = this.height;
            }
        }
    }
}

