/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.EventObserver;
import g.Signals;
import java.awt.AWTEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;

public interface EventBase<Handler extends Enum<Handler>>
extends IntSupplier {
    public static final Comparator<IntSupplier> EVENT_SORT = Comparator.comparingInt(IntSupplier::getAsInt);

    public static <H extends Enum<H>> H[] sortHandlers(H[] values) {
        Arrays.sort(values, EVENT_SORT);
        return values;
    }

    public static <H extends Enum<H>> Optional<H> findById(H[] values, int eventId) {
        int index = Arrays.binarySearch(values, () -> eventId, EVENT_SORT);
        if (index < 0) {
            return Optional.empty();
        }
        return Optional.of(values[index]);
    }

    @SafeVarargs
    public static <H extends Enum<H>> Relation<H>[] Relate(H src, H ... dests) {
        IntFunction<Relation[]> arrayer = Relation[]::new;
        return (Relation[])Arrays.stream(dests).map(dest -> new Relation<Enum>(src, (Enum)dest)).toArray(arrayer);
    }

    public Set<ActionMode> defaultEnabledActions();

    public Map<ActionMode, EventAction<Handler>> allActions();

    public Map<RelationType, Set<Handler>> cooperations();

    public Map<RelationType, Set<Handler>> adjustments();

    default public boolean hasActions(ActionMode ... modes) {
        Set<ActionMode> actions = this.defaultEnabledActions();
        if (actions.isEmpty()) {
            return false;
        }
        for (ActionMode m : modes) {
            if (actions.contains((Object)m)) continue;
            return false;
        }
        return true;
    }

    public static final class Relation<Handler extends Enum<Handler>> {
        public final Handler sourceHandler;
        public final Handler targetHandler;

        public Relation(Handler sourceHandler, Handler targetHandler) {
            this.sourceHandler = sourceHandler;
            this.targetHandler = targetHandler;
        }
    }

    public static final class ActionStateHolder<Handler extends Enum<Handler>> {
        private final Map<Handler, Set<ActionMode>> enabledActions;
        private final Map<Handler, Map<ActionMode, EventAction<Handler>>> actionsMap;
        private final Map<Handler, Map<RelationType, Set<Handler>>> cooperationMap;
        private final Map<Handler, Map<RelationType, Set<Handler>>> adjustmentMap;
        private final EventObserver<Handler> observer;
        private final EnumSet<Handler> emptyEnumSet;

        public boolean hasActionsEnabled(Handler h, ActionMode ... modes) {
            Set<ActionMode> actions = this.enabledActions.get(h);
            if (actions.isEmpty()) {
                return false;
            }
            for (ActionMode m : modes) {
                if (actions.contains((Object)m)) continue;
                return false;
            }
            return true;
        }

        public ActionStateHolder(Class<Handler> hClass, EventObserver<Handler> observer) {
            Enum[] values = (Enum[])hClass.getEnumConstants();
            this.enabledActions = this.populate(hClass, values, h -> {
                Set<ActionMode> set = ((EventBase)((Object)h)).defaultEnabledActions();
                return set.isEmpty() ? EnumSet.noneOf(ActionMode.class) : EnumSet.copyOf(set);
            });
            this.actionsMap = this.populate(hClass, values, h -> {
                Map map = ((EventBase)((Object)h)).allActions();
                return map.isEmpty() ? new EnumMap(ActionMode.class) : new EnumMap(map);
            });
            this.cooperationMap = this.populate(hClass, values, h -> this.deepCopyMap(((EventBase)((Object)h)).cooperations()));
            this.adjustmentMap = this.populate(hClass, values, h -> this.deepCopyMap(((EventBase)((Object)h)).adjustments()));
            this.observer = observer;
            this.emptyEnumSet = EnumSet.noneOf(hClass);
        }

        private Map<RelationType, Set<Handler>> deepCopyMap(Map<RelationType, Set<Handler>> map) {
            if (map.isEmpty()) {
                return new EnumMap<RelationType, Set<Handler>>(RelationType.class);
            }
            EnumMap<RelationType, Set<Handler>> copy = new EnumMap<RelationType, Set<Handler>>(map);
            copy.replaceAll((r, l) -> EnumSet.copyOf(l));
            return copy;
        }

        private <V> Map<Handler, V> populate(Class<Handler> hClass, Handler[] values, Function<? super Handler, ? extends V> mapper) {
            return Arrays.stream(values).collect(() -> new EnumMap(hClass), (m, h) -> m.put(h, mapper.apply((Object)h)), EnumMap::putAll);
        }

        public ActionStateHolder<Handler> run(Handler h, ActionMode mode, AWTEvent ev) {
            if (this.enabledActions.get(h).contains((Object)mode)) {
                Optional.ofNullable(this.actionsMap.get(h).get((Object)mode)).ifPresent(action -> action.act(this.observer, ev));
            }
            return this;
        }

        public Map<RelationType, Set<Handler>> cooperations(Handler h) {
            return this.cooperationMap.get(h);
        }

        public Map<RelationType, Set<Handler>> adjustments(Handler h) {
            return this.adjustmentMap.get(h);
        }

        public Set<Handler> cooperations(Handler h, RelationType type) {
            return this.cooperationMap.get(h).getOrDefault((Object)type, this.emptyEnumSet);
        }

        public Set<Handler> adjustments(Handler h, RelationType type) {
            return this.adjustmentMap.get(h).getOrDefault((Object)type, this.emptyEnumSet);
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> unmapCooperation(Handler h, RelationType type, Handler ... targets) {
            Set<Handler> set = this.cooperationMap.get(h).get((Object)type);
            if (set == null || set.isEmpty()) {
                return this;
            }
            if (targets.length == 0) {
                set.clear();
            } else {
                set.removeAll(Arrays.asList(targets));
            }
            return this;
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> mapCooperation(Handler h, RelationType mode, Handler ... targets) {
            this.cooperationMap.get(h).compute(mode, (m, set) -> {
                if (set == null) {
                    set = EnumSet.copyOf(this.emptyEnumSet);
                }
                set.addAll(Arrays.asList(targets));
                return set;
            });
            return this;
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> restoreCooperation(Handler h, RelationType mode, Handler ... targets) {
            Set orig = ((EventBase)h).adjustments().get((Object)mode);
            if (orig != null) {
                EnumSet a = EnumSet.copyOf(orig);
                Set<Handler> b = this.cooperationMap.get(h).get((Object)mode);
                a.retainAll(Arrays.asList(targets));
                b.addAll(a);
            } else {
                this.cooperationMap.get(h).remove((Object)mode);
            }
            return this;
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> unmapAdjustment(Handler h, RelationType type, Handler ... targets) {
            Set<Handler> set = this.adjustmentMap.get(h).get((Object)type);
            if (set == null || set.isEmpty()) {
                return this;
            }
            if (targets.length == 0) {
                set.clear();
            } else {
                set.removeAll(Arrays.asList(targets));
            }
            return this;
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> mapAdjustment(Handler h, RelationType mode, Handler ... targets) {
            this.adjustmentMap.get(h).compute(mode, (m, set) -> {
                if (set == null) {
                    set = EnumSet.copyOf(this.emptyEnumSet);
                }
                set.addAll(Arrays.asList(targets));
                return set;
            });
            return this;
        }

        @SafeVarargs
        public final ActionStateHolder<Handler> restoreAdjustment(Handler h, RelationType mode, Handler ... targets) {
            Set orig = ((EventBase)h).adjustments().get((Object)mode);
            if (orig != null) {
                EnumSet a = EnumSet.copyOf(orig);
                Set<Handler> b = this.adjustmentMap.get(h).get((Object)mode);
                a.retainAll(Arrays.asList(targets));
                b.addAll(a);
            } else {
                this.adjustmentMap.get(h).remove((Object)mode);
            }
            return this;
        }

        public ActionStateHolder<Handler> enableAction(Handler h, ActionMode mode) {
            this.enabledActions.get(h).add(mode);
            return this;
        }

        public ActionStateHolder<Handler> disableAction(Handler h, ActionMode mode) {
            this.enabledActions.get(h).remove((Object)mode);
            return this;
        }

        public ActionStateHolder<Handler> unmapAction(Handler h, ActionMode mode) {
            this.actionsMap.get(h).remove((Object)mode);
            return this;
        }

        public ActionStateHolder<Handler> mapAction(Handler h, ActionMode mode, EventAction<Handler> remap) {
            this.actionsMap.get(h).put(mode, remap);
            return this;
        }

        public ActionStateHolder<Handler> remapAction(Handler h, ActionMode mode, EventAction<Handler> remap) {
            this.actionsMap.get(h).replace(mode, remap);
            return this;
        }

        public ActionStateHolder<Handler> restoreAction(Handler h, ActionMode mode) {
            EventAction a = ((EventBase)h).allActions().get((Object)mode);
            if (a != null) {
                this.actionsMap.get(h).put(mode, a);
            } else {
                this.actionsMap.get(h).remove((Object)mode);
            }
            return this;
        }
    }

    public static final class KeyStateHolder<Handler extends Enum<Handler>> {
        private final Set<Signals.ScanCode> holdingSet;
        private final LinkedHashSet<KeyStateInterest<Handler>> keyInterests;
        private final IntFunction<KeyStateInterest<Handler>[]> generator = KeyStateInterest[]::new;

        public KeyStateHolder() {
            this.holdingSet = EnumSet.noneOf(Signals.ScanCode.class);
            this.keyInterests = new LinkedHashSet();
        }

        public void removeAllKeys() {
            this.holdingSet.clear();
        }

        public boolean contains(Signals.ScanCode sc) {
            return this.holdingSet.contains((Object)sc);
        }

        public void addInterest(KeyStateInterest<Handler> interest) {
            this.keyInterests.add(interest);
        }

        public void removeInterest(KeyStateInterest<Handler> interest) {
            this.keyInterests.remove(interest);
        }

        public boolean matchInterest(KeyStateInterest<Handler> check) {
            return this.holdingSet.containsAll(((KeyStateInterest)check).interestSet);
        }

        public boolean notifyKeyChange(EventObserver<Handler> observer, Signals.ScanCode code, boolean press) {
            if (press) {
                this.holdingSet.add(code);
                KeyStateInterest[] matched = (KeyStateInterest[])this.keyInterests.stream().filter(this::matchInterest).toArray(this.generator);
                boolean ret = false;
                block5: for (int i = 0; i < matched.length; ++i) {
                    switch (matched[i].satisfiedCallback.call(observer)) {
                        case SATISFIED_ATE: {
                            ret = true;
                        }
                        case GENEOROUS_PASS: {
                            this.keyInterests.remove(matched[i]);
                            continue block5;
                        }
                        case WANTS_MORE_ATE: {
                            ret = true;
                        }
                    }
                }
                return ret;
            }
            this.holdingSet.remove((Object)code);
            return false;
        }
    }

    public static final class KeyStateInterest<Handler extends Enum<Handler>> {
        private final Set<Signals.ScanCode> interestSet;
        private final KeyStateCallback<Handler> satisfiedCallback;

        public KeyStateInterest(KeyStateCallback<Handler> satisfiedCallback, Signals.ScanCode interestFirstKey, Signals.ScanCode ... interestKeyChain) {
            this.interestSet = EnumSet.of(interestFirstKey, interestKeyChain);
            this.satisfiedCallback = satisfiedCallback;
        }
    }

    public static interface KeyStateCallback<Handler extends Enum<Handler>> {
        public KeyStateSatisfaction call(EventObserver<Handler> var1);
    }

    @FunctionalInterface
    public static interface EventAction<Handler extends Enum<Handler>> {
        public void act(EventObserver<Handler> var1, AWTEvent var2);
    }

    @FunctionalInterface
    public static interface RelationMapper<Handler extends Enum<Handler>> {
        public void map(RelationType var1, Relation<Handler>[] var2);
    }

    @FunctionalInterface
    public static interface ActionMapper<Handler extends Enum<Handler>> {
        public void map(ActionMode var1, EventAction<Handler> var2);
    }

    public static enum RelationType {
        ENABLE(RelationAffection.ENABLES, ActionMode.PERFORM),
        ENABLE_DEPEND(RelationAffection.ENABLES, ActionMode.DEPEND),
        ENABLE_CAUSE(RelationAffection.ENABLES, ActionMode.CAUSE),
        ENABLE_REVERT(RelationAffection.ENABLES, ActionMode.REVERT),
        DISABLE(RelationAffection.DISABLES, ActionMode.PERFORM),
        DISABLE_DEPEND(RelationAffection.DISABLES, ActionMode.DEPEND),
        DISABLE_CAUSE(RelationAffection.DISABLES, ActionMode.CAUSE),
        DISABLE_REVERT(RelationAffection.DISABLES, ActionMode.REVERT),
        DEPEND(RelationAffection.COOPERATES, ActionMode.DEPEND),
        CAUSE(RelationAffection.COOPERATES, ActionMode.CAUSE),
        REVERT(RelationAffection.COOPERATES, ActionMode.REVERT);

        final RelationAffection affection;
        final ActionMode affectedMode;

        private RelationType(RelationAffection affection, ActionMode affectedMode) {
            this.affection = affection;
            this.affectedMode = affectedMode;
        }

        public String toString() {
            return String.format("%s on [%s]", new Object[]{this.affection, this.affectedMode});
        }
    }

    public static enum RelationAffection {
        ENABLES,
        DISABLES,
        COOPERATES;

    }

    public static enum ActionMode {
        PERFORM,
        DEPEND,
        CAUSE,
        REVERT;

    }

    public static enum KeyStateSatisfaction {
        SATISFIED_ATE,
        GENEOROUS_PASS,
        WANTS_MORE_ATE,
        WANTS_MORE_PASS;

    }
}

