/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.EventBase;
import awt.EventHandler;
import doom.event_t;
import doom.evtype_t;
import g.Signals;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mochadoom.Loggers;

public class EventObserver<Handler extends Enum<Handler>> {
    static final Optional<Robot> MOUSE_ROBOT = EventObserver.createRobot();
    private static final Logger LOGGER = Loggers.getLogger(EventObserver.class.getName());
    protected final event_t.mouseevent_t mouseEvent = new event_t.mouseevent_t(evtype_t.ev_mouse, 0, 0, 0);
    protected final EventBase.KeyStateHolder<Handler> keyStateHolder;
    protected final Component component;
    private final Consumer<? super event_t> doomEventConsumer;
    private final Handler[] eventSortedHandlers;
    private final EventBase.ActionStateHolder<Handler> actionStateHolder;
    private final Cursor initialCursor;
    private final Cursor hiddenCursor;

    private static Optional<Robot> createRobot() {
        try {
            return Optional.of(new Robot());
        }
        catch (AWTException e) {
            Loggers.getLogger(EventObserver.class.getName()).log(Level.SEVERE, "AWT Robot could not be created, mouse input focus will be loose!", e);
            return Optional.empty();
        }
    }

    private Cursor createHiddenCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension dim = tk.getBestCursorSize(2, 2);
        if (dim.width == 0 || dim.height == 0) {
            return this.initialCursor;
        }
        BufferedImage transparent = new BufferedImage(dim.width, dim.height, 2);
        return tk.createCustomCursor(transparent, new Point(1, 1), "HiddenCursor");
    }

    public EventObserver(Class<Handler> handlerClass, Component component, Consumer<? super event_t> doomEventConsumer) {
        this.actionStateHolder = new EventBase.ActionStateHolder<Handler>(handlerClass, this);
        this.eventSortedHandlers = EventBase.sortHandlers((Enum[])((Enum[])handlerClass.getEnumConstants()));
        this.doomEventConsumer = doomEventConsumer;
        this.component = component;
        this.initialCursor = component.getCursor();
        this.hiddenCursor = this.createHiddenCursor();
        this.keyStateHolder = new EventBase.KeyStateHolder();
    }

    public EventObserver<Handler> addInterest(EventBase.KeyStateInterest<Handler> interest) {
        this.keyStateHolder.addInterest(interest);
        return this;
    }

    public EventObserver<Handler> removeInterest(EventBase.KeyStateInterest<Handler> interest) {
        this.keyStateHolder.removeInterest(interest);
        return this;
    }

    public void observe(AWTEvent ev) {
        Enum handler;
        block5: {
            block4: {
                Optional maybe = EventBase.findById(this.eventSortedHandlers, (int)ev.getID());
                if (!maybe.isPresent()) break block4;
                handler = (Enum)maybe.get();
                if (this.actionStateHolder.hasActionsEnabled(handler, EventBase.ActionMode.PERFORM)) break block5;
            }
            return;
        }
        if (handler == EventHandler.WINDOW_ACTIVATE) {
            int n = 8;
        }
        Loggers.LogEvent(LOGGER, this.actionStateHolder, handler, ev);
        this.actionStateHolder.run(handler, EventBase.ActionMode.PERFORM, ev);
        this.actionStateHolder.adjustments(handler).forEach((relation, affected) -> {
            switch (relation.affection) {
                case ENABLES: {
                    affected.forEach(h -> this.actionStateHolder.enableAction((Enum)h, relation.affectedMode));
                    return;
                }
                case DISABLES: {
                    affected.forEach(h -> this.actionStateHolder.disableAction((Enum)h, relation.affectedMode));
                }
            }
        });
        this.actionStateHolder.cooperations(handler, EventBase.RelationType.CAUSE).forEach(h -> this.actionStateHolder.run((Enum)h, EventBase.ActionMode.CAUSE, ev));
        this.actionStateHolder.cooperations(handler, EventBase.RelationType.REVERT).forEach(h -> this.actionStateHolder.run((Enum)h, EventBase.ActionMode.REVERT, ev));
    }

    protected void feed(event_t ev) {
        if (!ev.ifKey(sc -> this.keyStateHolder.notifyKeyChange(this, (Signals.ScanCode)((Object)sc), ev.isType(evtype_t.ev_keydown)))) {
            this.doomEventConsumer.accept(ev);
        }
    }

    protected void restoreCursor(AWTEvent event) {
        this.component.setCursor(this.initialCursor);
    }

    protected void modifyCursor(AWTEvent event) {
        this.component.getInputContext().selectInputMethod(Locale.US);
        this.component.setCursor(this.hiddenCursor);
    }

    protected void centreCursor(AWTEvent event) {
        int centreX = this.component.getWidth() >> 1;
        int centreY = this.component.getHeight() >> 1;
        if (this.component.isShowing()) {
            MOUSE_ROBOT.ifPresent(rob -> this.mouseEvent.resetIn((Robot)rob, this.component.getLocationOnScreen(), centreX, centreY));
        }
        this.modifyCursor(event);
    }

    protected void cancelKeys(AWTEvent ev) {
        this.feed(event_t.CANCEL_KEYS);
        this.keyStateHolder.removeAllKeys();
    }

    protected void cancelMouse(AWTEvent ev) {
        this.feed(event_t.CANCEL_MOUSE);
    }

    protected void sendKeyUps(AWTEvent ev) {
        this.feed(Signals.getScanCode((KeyEvent)((KeyEvent)ev)).doomEventUp);
        this.discardInputEvent(ev);
    }

    protected void sendKeyDowns(AWTEvent ev) {
        this.feed(Signals.getScanCode((KeyEvent)((KeyEvent)ev)).doomEventDown);
        this.discardInputEvent(ev);
    }

    protected void discardInputEvent(AWTEvent ev) {
        try {
            ((InputEvent)ev).consume();
        }
        catch (ClassCastException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    protected final void enableAction(Handler h, EventBase.ActionMode mode) {
        this.actionStateHolder.enableAction(h, mode);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("ENABLE ACTION: %s [%s]", new Object[]{h, mode}));
        }
    }

    protected final void disableAction(Handler h, EventBase.ActionMode mode) {
        this.actionStateHolder.disableAction(h, mode);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("DISABLE ACTION: %s [%s]", new Object[]{h, mode}));
        }
    }

    @SafeVarargs
    protected final void mapRelation(Handler h, EventBase.RelationType type, Handler ... targets) {
        if (type.affection == EventBase.RelationAffection.COOPERATES) {
            this.actionStateHolder.mapCooperation((Enum)h, type, (Enum[])targets);
        } else {
            this.actionStateHolder.mapAdjustment((Enum)h, type, (Enum[])targets);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("RELATION MAPPING: %s -> [%s] {%s}", new Object[]{h, type, Arrays.toString(targets)}));
        }
    }

    @SafeVarargs
    protected final void unmapRelation(Handler h, EventBase.RelationType type, Handler ... targets) {
        if (type.affection == EventBase.RelationAffection.COOPERATES) {
            this.actionStateHolder.unmapCooperation((Enum)h, type, (Enum[])targets);
        } else {
            this.actionStateHolder.unmapAdjustment((Enum)h, type, (Enum[])targets);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("RELATION UNMAP: %s -> [%s] {%s}", new Object[]{h, type, Arrays.toString(targets)}));
        }
    }

    @SafeVarargs
    protected final void restoreRelation(Handler h, EventBase.RelationType type, Handler ... targets) {
        if (type.affection == EventBase.RelationAffection.COOPERATES) {
            this.actionStateHolder.restoreCooperation((Enum)h, type, (Enum[])targets);
        } else {
            this.actionStateHolder.restoreAdjustment((Enum)h, type, (Enum[])targets);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("RELATION RESTORE: %s -> [%s] {%s}", new Object[]{h, type, Arrays.toString(targets)}));
        }
    }

    protected void mapAction(Handler h, EventBase.ActionMode mode, EventBase.EventAction<Handler> remap) {
        this.actionStateHolder.mapAction(h, mode, remap);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("ACTION MAPPING (MAP): %s [%s]", new Object[]{h, mode}));
        }
    }

    protected void remapAction(Handler h, EventBase.ActionMode mode, EventBase.EventAction<Handler> remap) {
        this.actionStateHolder.remapAction(h, mode, remap);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("ACTION MAPPING (REMAP): %s [%s]", new Object[]{h, mode}));
        }
    }

    protected void unmapAction(Handler h, EventBase.ActionMode mode) {
        this.actionStateHolder.unmapAction(h, mode);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("UNMAP ACTION: %s [%s]", new Object[]{h, mode}));
        }
    }

    protected void restoreAction(Handler h, EventBase.ActionMode mode) {
        this.actionStateHolder.restoreAction(h, mode);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, () -> String.format("RESTORE ACTION: %s [%s]", new Object[]{h, mode}));
        }
    }
}

