/*
 * Decompiled with CFR 0.152.
 */
package awt;

import awt.DisplayModePicker;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import m.Settings;
import mochadoom.Engine;

public interface FullscreenOptions {
    public static final FullMode FULLMODE = Engine.getConfig().getValue(Settings.fullscreen_mode, FullMode.class);
    public static final StretchMode STRETCH = Engine.getConfig().getValue(Settings.fullscreen_stretch, StretchMode.class);
    public static final InterpolationMode INTERPOLATION = Engine.getConfig().getValue(Settings.fullscreen_interpolation, InterpolationMode.class);

    default public void options(Graphics2D graphics) {
        switch (INTERPOLATION) {
            case Nearest: {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                break;
            }
            case Bilinear: {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case Biqubic: {
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
        }
    }

    default public void draw(Graphics2D graphics, Image image, Dimension dim, ImageObserver observer) {
        graphics.drawImage(image, dim.offsX(), dim.offsY(), dim.fitX(), dim.fitY(), observer);
    }

    default public FullscreenFunction createFullSwitcher(GraphicsDevice device) {
        switch (FULLMODE) {
            case Best: {
                return new FullscreenSwitch(device, new DisplayModePicker(device));
            }
            case Native: {
                return (w, h) -> device.getDisplayMode();
            }
        }
        throw new Error("Enum reflection overuse?");
    }

    public static class FullscreenSwitch
    implements FullscreenFunction {
        private final GraphicsDevice dev;
        private final DisplayModePicker dmp;
        private DisplayMode oldDisplayMode;
        private DisplayMode displayMode;

        private FullscreenSwitch(GraphicsDevice dev, DisplayModePicker dmp) {
            this.dev = dev;
            this.dmp = dmp;
        }

        @Override
        public DisplayMode get(int width, int height) {
            if (this.oldDisplayMode == null) {
                this.oldDisplayMode = this.dev.getDisplayMode();
                this.displayMode = this.dmp.pickClosest(width, height);
            } else {
                this.displayMode = this.oldDisplayMode;
                this.oldDisplayMode = null;
            }
            return this.displayMode;
        }
    }

    @FunctionalInterface
    public static interface FullscreenFunction {
        public DisplayMode get(int var1, int var2);
    }

    public static interface Fitter {
        public int fit(int var1, int var2, int var3, int var4);
    }

    public static interface Dimension {
        public int width();

        public int height();

        public int defWidth();

        public int defHeight();

        default public int fitX() {
            return FullscreenOptions.STRETCH.widthFun.fit(this.width(), this.defWidth(), this.height(), this.defHeight());
        }

        default public int fitY() {
            return FullscreenOptions.STRETCH.heightFun.fit(this.width(), this.defWidth(), this.height(), this.defHeight());
        }

        default public int offsX() {
            return FullscreenOptions.STRETCH.offsXFun.fit(this.width(), this.defWidth(), this.height(), this.defHeight());
        }

        default public int offsY() {
            return FullscreenOptions.STRETCH.offsYFun.fit(this.width(), this.defWidth(), this.height(), this.defHeight());
        }
    }

    public static enum FullMode {
        Best,
        Native;

    }

    public static enum StretchMode {
        Centre((w, defW, h, defH) -> Math.min(defW, w), (w, defW, h, defH) -> Math.min(defH, h), (w, defW, h, defH) -> Math.max(0, (w - defW) / 2), (w, defW, h, defH) -> Math.max(0, (h - defH) / 2)),
        Stretch((w, defW, h, defH) -> w, (w, defW, h, defH) -> h, (w, defW, h, defH) -> 0, (w, defW, h, defH) -> 0),
        Fit((w, defW, h, defH) -> (int)((float)defW * StretchMode.minScale(w, defW, h, defH)), (w, defW, h, defH) -> (int)((float)defH * StretchMode.minScale(w, defW, h, defH)), (w, defW, h, defH) -> (w - (int)((float)defW * StretchMode.minScale(w, defW, h, defH))) / 2, (w, defW, h, defH) -> (h - (int)((float)defH * StretchMode.minScale(w, defW, h, defH))) / 2),
        Aspect_4_3((w, defW, h, defH) -> StretchMode.Fit.widthFun.fit(w, defW, h, (int)((float)defH * 1.2f)), (w, defW, h, defH) -> StretchMode.Fit.heightFun.fit(w, defW, h, (int)((float)defH * 1.2f)), (w, defW, h, defH) -> StretchMode.Fit.offsXFun.fit(w, defW, h, (int)((float)defH * 1.2f)), (w, defW, h, defH) -> StretchMode.Fit.offsYFun.fit(w, defW, h, (int)((float)defH * 1.2f)));

        final Fitter widthFun;
        final Fitter heightFun;
        final Fitter offsXFun;
        final Fitter offsYFun;

        private StretchMode(Fitter widthFun, Fitter heightFun, Fitter offsXFun, Fitter offsYFun) {
            this.widthFun = widthFun;
            this.heightFun = heightFun;
            this.offsXFun = offsXFun;
            this.offsYFun = offsYFun;
        }

        private static float minScale(int w, int defW, int h, int defH) {
            float scaleX = (float)w / (float)defW;
            float scaleY = (float)h / (float)defH;
            return Math.min(scaleX, scaleY);
        }
    }

    public static enum InterpolationMode {
        Nearest,
        Bilinear,
        Biqubic;

    }
}

