/*
 * Decompiled with CFR 0.152.
 */
package demo;

import defines.skill_t;
import demo.IDemoTicCmd;
import demo.IDoomDemo;
import demo.VanillaTiccmd;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import utils.GenericCopy;
import w.CacheableDoomObject;
import w.DoomBuffer;
import w.DoomIO;

public class VanillaDoomDemo
implements IDoomDemo,
CacheableDoomObject {
    public int version;
    public skill_t skill;
    public int episode;
    public int map;
    public boolean deathmatch;
    public boolean respawnparm;
    public boolean fastparm;
    public boolean nomonsters;
    public int consoleplayer;
    public boolean[] playeringame;
    protected int p_demo;
    VanillaTiccmd[] commands;
    List<IDemoTicCmd> demorecorder = new ArrayList<IDemoTicCmd>();

    @Override
    public void unpack(ByteBuffer b) {
        boolean vanilla;
        int lens = (b.limit() - 13) / 4;
        boolean bl = vanilla = b.limit() == 14 + 4 * lens;
        if (b.limit() < 14) {
            this.skill = null;
            return;
        }
        this.version = b.get();
        try {
            this.skill = skill_t.values()[b.get()];
        }
        catch (Exception e) {
            this.skill = null;
        }
        this.episode = b.get();
        this.map = b.get();
        this.deathmatch = b.get() != 0;
        this.respawnparm = b.get() != 0;
        this.fastparm = b.get() != 0;
        this.nomonsters = b.get() != 0;
        this.consoleplayer = b.get();
        this.playeringame = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = b.get() != 0;
        }
        this.commands = (VanillaTiccmd[])GenericCopy.malloc(VanillaTiccmd::new, VanillaTiccmd[]::new, lens);
        try {
            DoomBuffer.readObjectArray(b, this.commands, lens);
        }
        catch (IOException e) {
            this.skill = null;
        }
    }

    @Override
    public IDemoTicCmd getNextTic() {
        if (this.commands != null && this.p_demo < this.commands.length) {
            return this.commands[this.p_demo++];
        }
        return null;
    }

    @Override
    public void putTic(IDemoTicCmd tic) {
        this.demorecorder.add(tic);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public skill_t getSkill() {
        return this.skill;
    }

    @Override
    public void setSkill(skill_t skill) {
        this.skill = skill;
    }

    @Override
    public int getEpisode() {
        return this.episode;
    }

    @Override
    public void setEpisode(int episode) {
        this.episode = episode;
    }

    @Override
    public int getMap() {
        return this.map;
    }

    @Override
    public void setMap(int map) {
        this.map = map;
    }

    @Override
    public boolean isDeathmatch() {
        return this.deathmatch;
    }

    @Override
    public void setDeathmatch(boolean deathmatch) {
        this.deathmatch = deathmatch;
    }

    @Override
    public boolean isRespawnparm() {
        return this.respawnparm;
    }

    @Override
    public void setRespawnparm(boolean respawnparm) {
        this.respawnparm = respawnparm;
    }

    @Override
    public boolean isFastparm() {
        return this.fastparm;
    }

    @Override
    public void setFastparm(boolean fastparm) {
        this.fastparm = fastparm;
    }

    @Override
    public boolean isNomonsters() {
        return this.nomonsters;
    }

    @Override
    public void setNomonsters(boolean nomonsters) {
        this.nomonsters = nomonsters;
    }

    @Override
    public int getConsoleplayer() {
        return this.consoleplayer;
    }

    @Override
    public void setConsoleplayer(int consoleplayer) {
        this.consoleplayer = consoleplayer;
    }

    @Override
    public boolean[] getPlayeringame() {
        return this.playeringame;
    }

    @Override
    public void setPlayeringame(boolean[] playeringame) {
        this.playeringame = playeringame;
    }

    @Override
    public void write(DataOutputStream f) throws IOException {
        f.writeByte(this.version);
        f.writeByte(this.skill.ordinal());
        f.writeByte(this.episode);
        f.writeByte(this.map);
        f.writeBoolean(this.deathmatch);
        f.writeBoolean(this.respawnparm);
        f.writeBoolean(this.fastparm);
        f.writeBoolean(this.nomonsters);
        f.writeByte(this.consoleplayer);
        DoomIO.writeBoolean(f, this.playeringame, 4);
        for (IDemoTicCmd i : this.demorecorder) {
            i.write(f);
        }
        f.writeByte(128);
    }

    @Override
    public void resetDemo() {
        this.p_demo = 0;
    }
}

