/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.CommandVariable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import mochadoom.Loggers;
import utils.ResourceIO;

public class CVarManager {
    private final EnumMap<CommandVariable, Object[]> cVarMap = new EnumMap(CommandVariable.class);

    public CVarManager(List<String> commandList) {
        System.out.println(this.processAllArgs(commandList) + " command-line variables");
    }

    public boolean bool(CommandVariable cv) {
        return cv.getType() == CommandVariable.Type.SWITCH && this.cVarMap.containsKey((Object)cv);
    }

    public boolean present(CommandVariable cv) {
        return this.cVarMap.get((Object)cv) != null;
    }

    public boolean specified(CommandVariable cv) {
        return this.cVarMap.containsKey((Object)cv);
    }

    public <T> Optional<T> get(CommandVariable cv, Class<T> itemType, int position) {
        if (cv.arguments[position] == itemType) {
            if (!this.cVarMap.containsKey((Object)cv)) {
                return Optional.empty();
            }
            Object ret = this.cVarMap.get((Object)cv)[position];
            return Optional.ofNullable(ret);
        }
        throw new IllegalArgumentException("CVar argument at position " + position + " is not of class " + itemType.getName());
    }

    public <T> boolean with(CommandVariable cv, int position, Consumer<T> action) {
        try {
            Object[] mapped = this.cVarMap.get((Object)cv);
            if (mapped == null) {
                return false;
            }
            Object item = mapped[position];
            action.accept(item);
            return true;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public <T> boolean override(CommandVariable cv, T value, int position) {
        if (position < 0 || position >= cv.arguments.length) {
            return false;
        }
        if (!cv.arguments[position].isInstance(value)) {
            return false;
        }
        this.cVarMap.compute(cv, (key, array) -> {
            if (array == null) {
                array = new Object[cv.arguments.length];
            }
            array[position] = value;
            return array;
        });
        return true;
    }

    private void readResponseFile(String filename) {
        ResponseReader r = new ResponseReader();
        if (new ResourceIO(filename).readLines(r)) {
            System.out.println(String.format("Found response file %s, read %d command line variables", filename, r.cVarCount));
        } else {
            System.out.println(String.format("No such response file %s!", filename));
            System.exit(1);
        }
    }

    private int processAllArgs(List<String> commandList) {
        int cVarCount = 0;
        int position = 0;
        int limit = commandList.size();
        while (limit > position) {
            position = this.processCVar(commandList, position);
            ++position;
            ++cVarCount;
        }
        return cVarCount;
    }

    private int processCVar(List<String> commandList, int position) {
        String arg = commandList.get(position);
        if (!this.isCommandArgument(arg)) {
            return position;
        }
        char cVarPrefix = arg.charAt(0);
        String cVarName = arg.substring(1);
        if (cVarPrefix == '@') {
            this.readResponseFile(cVarName);
            return position;
        }
        try {
            CommandVariable cVar = CommandVariable.valueOf(cVarName.toUpperCase());
            if (cVar.prefix == cVarPrefix) {
                switch (cVar.getType()) {
                    case PARAMETER: {
                        this.cVarMap.put(cVar, null);
                    }
                    case VARARG: {
                        return this.processCVarSubArgs(commandList, position, cVar);
                    }
                }
                this.cVarMap.put(cVar, null);
                return position;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return position;
    }

    private int processCVarSubArgs(List<String> commandList, int position, CommandVariable cVar) {
        Object[] cVarMappings = new Object[cVar.arguments.length];
        for (int j = 0; j < cVar.arguments.length; ++j) {
            if (cVar.arguments[j].isArray()) {
                Object[] mapping;
                Class<?> elementClass = cVar.arguments[j].getComponentType();
                cVarMappings[j] = mapping = this.processVarArg(elementClass, commandList, position + 1);
                position += mapping.length;
                if (mapping.length != 0) continue;
                break;
            }
            cVarMappings[j] = this.processValue(cVar.arguments[j], commandList, position + 1);
            if (cVarMappings[j] == null) break;
            ++position;
        }
        this.cVarMap.put(cVar, cVarMappings);
        return position;
    }

    private Object processValue(Class<?> elementClass, List<String> commandList, int position) {
        String arg;
        if (position < commandList.size() && !this.isCommandArgument(arg = commandList.get(position))) {
            return this.formatArgValue(elementClass, arg);
        }
        return null;
    }

    private Object[] processVarArg(Class<?> elementClass, List<String> commandList, int position) {
        Object value;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((value = this.processValue(elementClass, commandList, position)) != null) {
            list.add(value);
            ++position;
        }
        return list.toArray((Object[])Array.newInstance(elementClass, list.size()));
    }

    private Object formatArgValue(Class<?> format, String arg) {
        if (format == Integer.class) {
            try {
                return Integer.parseInt(arg);
            }
            catch (NumberFormatException ex) {
                Loggers.getLogger(CommandVariable.class.getName()).log(Level.WARNING, null, ex);
                return null;
            }
        }
        if (format == String.class) {
            return arg;
        }
        try {
            return format.getDeclaredConstructor(String.class).newInstance(arg);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Loggers.getLogger(CommandVariable.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private boolean isCommandArgument(String arg) {
        if (arg.length() < 4) {
            return false;
        }
        switch (arg.charAt(0)) {
            case '+': 
            case '-': 
            case '@': {
                return true;
            }
        }
        return false;
    }

    private class ResponseReader
    implements Consumer<String> {
        int cVarCount = 0;

        private ResponseReader() {
        }

        @Override
        public void accept(String line) {
            this.cVarCount += CVarManager.this.processAllArgs(Arrays.asList(line.split(" ")));
        }
    }
}

