/*
 * Decompiled with CFR 0.152.
 */
package doom;

import automap.IAutoMap;
import automap.Map;
import data.Defines;
import data.Tables;
import data.info;
import data.mapthing_t;
import data.mobjtype_t;
import data.sounds;
import defines.DoomVersion;
import defines.GameMission_t;
import defines.GameMode;
import defines.Language_t;
import defines.gamestate_t;
import defines.skill_t;
import defines.statenum_t;
import demo.IDemoTicCmd;
import demo.VanillaDoomDemo;
import demo.VanillaTiccmd;
import doom.CVarManager;
import doom.CommandVariable;
import doom.DoomStatus;
import doom.IDoom;
import doom.IDoomGame;
import doom.IDoomGameNetworking;
import doom.doomcom_t;
import doom.doomdata_t;
import doom.event_t;
import doom.evtype_t;
import doom.gameaction_t;
import doom.player_t;
import doom.ticcmd_t;
import f.EndLevel;
import f.Finale;
import f.Wiper;
import g.Signals;
import hu.HU;
import i.DiskDrawer;
import i.DoomSystem;
import i.IDiskDrawer;
import i.IDoomSystem;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import m.DelegateRandom;
import m.IDoomMenu;
import m.Menu;
import m.MenuMisc;
import m.Settings;
import mochadoom.Engine;
import n.DoomSystemNetworking;
import n.DummyNetworkDriver;
import p.AbstractLevelLoader;
import p.ActionFunctions;
import p.BoomLevelLoader;
import p.mobj_t;
import rr.ISpriteManager;
import rr.SceneRenderer;
import rr.SpriteManager;
import rr.TextureManager;
import rr.ViewVars;
import rr.patch_t;
import rr.subsector_t;
import s.IDoomSound;
import s.IMusic;
import s.ISoundDriver;
import s.ISoundOrigin;
import savegame.VanillaDSG;
import savegame.VanillaDSGHeader;
import st.AbstractStatusBar;
import st.StatusBar;
import timing.ITicker;
import timing.MilliTicker;
import utils.C2JUtils;
import v.DoomGraphicSystem;
import v.renderers.BppMode;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.scale.VideoScale;
import v.scale.VisualSettings;
import w.IWadLoader;
import w.WadLoader;

public class DoomMain<T, V>
extends DoomStatus<T, V>
implements IDoomGameNetworking,
IDoomGame,
IDoom {
    public static final String RCSID = "$Id: DoomMain.java,v 1.109 2012/11/06 16:04:58 velktron Exp $";
    public final event_t[] events = new event_t[64];
    public int eventhead;
    public int eventtail;
    private boolean viewactivestate = false;
    private boolean menuactivestate = false;
    private boolean inhelpscreensstate = false;
    private boolean fullscreen = false;
    private gamestate_t oldgamestate = gamestate_t.GS_MINUS_ONE;
    private int borderdrawcount;
    protected ViewVars view;
    int demosequence;
    int pagetic;
    String pagename;
    StringBuffer title = new StringBuffer();
    protected ticcmd_t base = new ticcmd_t();
    protected boolean first = true;
    private final String turbomessage = "is turbo!";
    final int[][] pars = new int[][]{{0}, {0, 30, 75, 120, 90, 165, 180, 180, 30, 165}, {0, 90, 90, 90, 120, 90, 360, 240, 30, 170}, {0, 90, 45, 90, 150, 90, 90, 165, 30, 135}};
    final int[] cpars = new int[]{30, 90, 120, 120, 90, 150, 120, 120, 270, 90, 210, 150, 150, 150, 210, 150, 420, 150, 210, 150, 240, 150, 180, 150, 150, 300, 330, 420, 300, 180, 120, 30};
    boolean secretexit;
    String savename;
    skill_t d_skill;
    int d_episode;
    int d_map;
    String defdemoname;
    protected ITicker RealTime;
    public player_t[] players;
    public DelegateRandom random;
    public final CVarManager cVarManager;
    public final IWadLoader wadLoader;
    public final IDoomSound doomSound;
    public final ISoundDriver soundDriver;
    public final IMusic music;
    public final AbstractStatusBar statusBar;
    public final DoomGraphicSystem<T, V> graphicSystem;
    public final DoomSystemNetworking systemNetworking;
    public final IDoomGameNetworking gameNetworking;
    public final AbstractLevelLoader levelLoader;
    public final IDoomMenu menu;
    public final ActionFunctions actions;
    public final SceneRenderer<T, V> sceneRenderer;
    public final HU headsUp;
    public final IAutoMap<T, V> autoMap;
    public final Finale<T> finale;
    public final EndLevel<T, V> endLevel;
    public final Wiper wiper;
    public final TextureManager<T> textureManager;
    public final ISpriteManager spriteManager;
    public final ITicker ticker;
    public final IDiskDrawer diskDrawer;
    public final IDoomSystem doomSystem;
    public final BppMode bppMode;
    protected StringBuilder sb = new StringBuilder();
    int[] nettics = new int[8];
    boolean[] nodeingame = new boolean[8];
    boolean[] remoteresend = new boolean[8];
    int[] resendto = new int[8];
    int[] resendcount = new int[8];
    int[] nodeforplayer = new int[4];
    int maketic;
    int lastnettic;
    int skiptics;
    protected int ticdup;
    int maxsend;
    boolean reboundpacket = false;
    doomdata_t reboundstore = new doomdata_t();
    StringBuilder exitmsg = new StringBuilder(80);
    int gametime;
    boolean[] gotinfo = new boolean[8];
    int[] frametics = new int[4];
    int frameon;
    boolean[] frameskip = new boolean[4];
    int oldnettics;
    int oldentertics;
    public final VideoScale vs;

    @Override
    public void PostEvent(event_t ev) {
        if (ev == event_t.CANCEL_KEYS) {
            C2JUtils.memset(this.gamekeydown, false, this.gamekeydown.length);
            this.keysCleared = true;
            return;
        }
        this.events[this.eventhead] = ev;
        ++this.eventhead;
        this.eventhead &= 0x3F;
    }

    public void ProcessEvents() {
        if (this.isCommercial() && this.wadLoader.CheckNumForName("MAP01") < 0) {
            return;
        }
        while (this.eventtail != this.eventhead) {
            event_t ev = this.events[this.eventtail];
            ev.withMouse(event_t.mouseevent_t::processedNotify);
            if (!this.menu.Responder(ev)) {
                this.Responder(ev);
            }
            ++this.eventtail;
            this.eventtail &= 0x3F;
        }
    }

    public void Display() throws IOException {
        boolean wipe;
        if (this.nodrawers) {
            return;
        }
        boolean redrawsbar = false;
        if (this.sceneRenderer.getSetSizeNeeded()) {
            this.sceneRenderer.ExecuteSetViewSize();
            this.oldgamestate = gamestate_t.GS_MINUS_ONE;
            this.borderdrawcount = 3;
        }
        boolean bl = wipe = this.gamestate != this.wipegamestate;
        if (wipe) {
            this.wiper.StartScreen(0, 0, this.vs.getScreenWidth(), this.vs.getScreenHeight());
        }
        if (this.gamestate == gamestate_t.GS_LEVEL && C2JUtils.eval(this.gametic)) {
            this.headsUp.Erase();
        }
        switch (this.gamestate) {
            case GS_LEVEL: {
                if (!C2JUtils.eval(this.gametic)) break;
                if (this.automapactive) {
                    this.autoMap.Drawer();
                }
                if (wipe || !this.sceneRenderer.isFullHeight() && this.fullscreen || this.inhelpscreensstate && !this.inhelpscreens || this.diskDrawer.justDoneReading()) {
                    redrawsbar = true;
                }
                this.statusBar.Drawer(this.sceneRenderer.isFullHeight(), redrawsbar);
                this.fullscreen = this.sceneRenderer.isFullHeight();
                break;
            }
            case GS_INTERMISSION: {
                this.endLevel.Drawer();
                break;
            }
            case GS_FINALE: {
                this.finale.Drawer();
                break;
            }
            case GS_DEMOSCREEN: {
                this.PageDrawer();
                break;
            }
        }
        if (this.gamestate == gamestate_t.GS_LEVEL && !this.automapactive && C2JUtils.eval(this.gametic)) {
            if (this.flashing_hom) {
                this.graphicSystem.FillRect(DoomScreen.FG, new Rectangle(this.view.getViewWindowX(), this.view.getViewWindowY(), this.view.getScaledViewWidth(), this.view.getScaledViewHeight()), this.gametic % 256);
            }
            this.sceneRenderer.RenderPlayerView(this.players[this.displayplayer]);
        }
        if (this.gamestate == gamestate_t.GS_LEVEL && C2JUtils.eval(this.gametic)) {
            this.headsUp.Drawer();
        }
        if (this.gamestate != this.oldgamestate && this.gamestate != gamestate_t.GS_LEVEL) {
            this.graphicSystem.setPalette(0);
        }
        if (this.gamestate == gamestate_t.GS_LEVEL && this.oldgamestate != gamestate_t.GS_LEVEL) {
            this.viewactivestate = false;
            this.sceneRenderer.FillBackScreen();
        }
        if (this.gamestate == gamestate_t.GS_LEVEL && !this.automapactive && !this.sceneRenderer.isFullScreen()) {
            if (this.menuactive || this.menuactivestate || !this.viewactivestate) {
                this.borderdrawcount = 3;
            }
            if (C2JUtils.eval(this.borderdrawcount)) {
                this.sceneRenderer.DrawViewBorder();
                --this.borderdrawcount;
            }
        }
        this.menuactivestate = this.menuactive;
        this.viewactivestate = this.viewactive;
        this.inhelpscreensstate = this.inhelpscreens;
        this.oldgamestate = this.wipegamestate = this.gamestate;
        if (this.paused) {
            int y = this.automapactive ? 4 * this.graphicSystem.getScalingY() : this.view.getViewWindowY() + 4 * this.graphicSystem.getScalingY();
            patch_t pause = this.wadLoader.CachePatchName("M_PAUSE", 101);
            this.graphicSystem.DrawPatchCenteredScaled(DoomScreen.FG, pause, this.vs, y, 65536);
        }
        this.menu.Drawer();
        this.NetUpdate();
        this.diskDrawer.Drawer();
        if (!wipe) {
            Engine.updateFrame();
            return;
        }
        this.wiper.EndScreen(0, 0, this.vs.getScreenWidth(), this.vs.getScreenHeight());
        int wipestart = this.ticker.GetTime() - 1;
        while (true) {
            int nowtime;
            int tics;
            if ((tics = (nowtime = this.ticker.GetTime()) - wipestart) == 0) {
                continue;
            }
            wipestart = nowtime;
            Wiper.Wipe wipeType = this.CM.equals(Settings.scale_melt, Boolean.TRUE) ? Wiper.Wipe.ScaledMelt : Wiper.Wipe.Melt;
            boolean done = this.wiper.ScreenWipe(wipeType, 0, 0, this.vs.getScreenWidth(), this.vs.getScreenHeight(), tics);
            this.soundDriver.UpdateSound();
            this.soundDriver.SubmitSound();
            this.menu.Drawer();
            Engine.updateFrame();
            if (done) break;
        }
    }

    public void DoomLoop() throws IOException {
        if (this.demorecording) {
            this.BeginRecording();
        }
        if (this.cVarManager.bool(CommandVariable.DEBUGFILE)) {
            String filename = "debug" + this.consoleplayer + ".txt";
            System.out.println("debug output to: " + filename);
            try {
                this.debugfile = new OutputStreamWriter(new FileOutputStream(filename));
            }
            catch (FileNotFoundException e) {
                System.err.println("Couldn't open debugfile. Now, that sucks some putrid shit out of John Romero's asshole!");
                e.printStackTrace();
            }
        }
        this.view = this.sceneRenderer.getView();
        while (true) {
            if (this.singletics) {
                this.ProcessEvents();
                this.BuildTiccmd(this.netcmds[this.consoleplayer][this.maketic % 12]);
                if (this.advancedemo) {
                    this.DoAdvanceDemo();
                }
                this.menu.Ticker();
                this.Ticker();
                ++this.gametic;
                ++this.maketic;
            } else {
                this.gameNetworking.TryRunTics();
            }
            this.doomSound.UpdateSounds(this.players[this.consoleplayer].mo);
            this.Display();
            this.soundDriver.UpdateSound();
            this.soundDriver.SubmitSound();
        }
    }

    @Override
    public final void PageTicker() {
        if (--this.pagetic < 0) {
            this.AdvanceDemo();
        }
    }

    @Override
    public final void PageDrawer() {
        if (this.pagename != null) {
            this.graphicSystem.DrawPatchScaled(DoomScreen.FG, this.wadLoader.CachePatchName(this.pagename, 101), this.vs, 0, 0, 0x4000000);
        }
    }

    @Override
    public void AdvanceDemo() {
        this.advancedemo = true;
    }

    public void DoAdvanceDemo() {
        this.players[this.consoleplayer].playerstate = 0;
        this.advancedemo = false;
        this.usergame = false;
        this.paused = false;
        this.gameaction = gameaction_t.ga_nothing;
        this.demosequence = this.isRetail() ? (this.demosequence + 1) % 7 : (this.demosequence + 1) % 6;
        switch (this.demosequence) {
            case 0: {
                this.pagetic = this.isCommercial() ? 385 : 170;
                this.gamestate = gamestate_t.GS_DEMOSCREEN;
                if (this.wadLoader.CheckNumForName("TITLEPIC") != -1) {
                    this.pagename = "TITLEPIC";
                } else if (this.wadLoader.CheckNumForName("DMENUPIC") != -1) {
                    this.pagename = "DMENUPIC";
                }
                if (this.isCommercial()) {
                    this.doomSound.StartMusic(sounds.musicenum_t.mus_dm2ttl);
                    break;
                }
                this.doomSound.StartMusic(sounds.musicenum_t.mus_intro);
                break;
            }
            case 1: {
                this.DeferedPlayDemo("demo1");
                break;
            }
            case 2: {
                this.pagetic = 200;
                this.gamestate = gamestate_t.GS_DEMOSCREEN;
                this.pagename = "CREDIT";
                break;
            }
            case 3: {
                this.DeferedPlayDemo("demo2");
                break;
            }
            case 4: {
                this.gamestate = gamestate_t.GS_DEMOSCREEN;
                if (this.isCommercial()) {
                    this.pagetic = 385;
                    this.pagename = "TITLEPIC";
                    this.doomSound.StartMusic(sounds.musicenum_t.mus_dm2ttl);
                    break;
                }
                this.pagetic = 200;
                if (this.isRetail()) {
                    this.pagename = "CREDIT";
                    break;
                }
                this.pagename = "HELP1";
                break;
            }
            case 5: {
                this.DeferedPlayDemo("demo3");
                break;
            }
            case 6: {
                this.DeferedPlayDemo("demo4");
            }
        }
    }

    @Override
    public void StartTitle() {
        this.gameaction = gameaction_t.ga_nothing;
        this.demosequence = -1;
        this.AdvanceDemo();
    }

    private void AddFile(String file) {
        int numwadfiles = 0;
        while (C2JUtils.eval(this.wadfiles[numwadfiles])) {
            ++numwadfiles;
        }
        this.wadfiles[numwadfiles] = file;
    }

    public final String IdentifyVersion() {
        String doomwaddir;
        this.language = Language_t.english;
        if (this.cVarManager.present(CommandVariable.IWAD)) {
            System.out.println("-iwad specified. Will be used with priority\n");
            String test = C2JUtils.unquoteIfQuoted(this.cVarManager.get(CommandVariable.IWAD, String.class, 0).get(), '\"');
            String separator = System.getProperty("file.separator");
            String iwad = test.substring(1 + test.lastIndexOf(separator));
            doomwaddir = test.substring(0, 1 + test.lastIndexOf(separator));
            GameMode attempt = DoomVersion.tryOnlyOne(iwad, doomwaddir);
            if (attempt != null) {
                this.AddFile(doomwaddir + iwad);
                this.setGameMode(attempt);
                return doomwaddir + iwad;
            }
        } else {
            doomwaddir = System.getenv("DOOMWADDIR");
            if (doomwaddir != null) {
                System.out.println("DOOMWADDIR found. Will be used with priority\n");
            }
            if (!C2JUtils.eval(doomwaddir)) {
                doomwaddir = ".";
            }
        }
        for (GameMode mode : GameMode.values()) {
            if (mode == GameMode.indetermined || !this.cVarManager.bool(mode.devVar)) continue;
            return this.devParmOn(mode);
        }
        String wadFullPath = DoomVersion.tryAllWads(this, doomwaddir);
        if (wadFullPath == null) {
            System.out.println("Game mode indeterminate.\n");
            this.setGameMode(GameMode.indetermined);
        } else {
            this.AddFile(wadFullPath);
        }
        return wadFullPath;
    }

    private String devParmOn(GameMode mode) {
        this.setGameMode(mode);
        this.devparm = true;
        this.AddFile("devdata" + (Object)((Object)mode.version));
        this.AddFile("devmaps" + mode.devDir + "/texture1.lmp");
        if (mode.hasTexture2()) {
            this.AddFile("devmaps" + mode.devDir + "/texture2.lmp");
        }
        this.AddFile("devmaps" + mode.devDir + "/pnames.lmp");
        return "devdata" + (Object)((Object)mode.version);
    }

    protected final void CheckForPWADSInShareware() {
        if (this.modifiedgame) {
            String[] name = new String[]{"e2m1", "e2m2", "e2m3", "e2m4", "e2m5", "e2m6", "e2m7", "e2m8", "e2m9", "e3m1", "e3m3", "e3m3", "e3m4", "e3m5", "e3m6", "e3m7", "e3m8", "e3m9", "dphoof", "bfgga0", "heada1", "cybra1", "spida1d1"};
            if (this.isShareware()) {
                System.out.println("\nYou cannot -file with the shareware version. Register!");
            }
            if (this.isRegistered()) {
                for (int i = 0; i < 23; ++i) {
                    if (this.wadLoader.CheckNumForName(name[i].toUpperCase()) >= 0) continue;
                    this.doomSystem.Error("\nThis is not the registered version: " + name[i]);
                }
            }
        }
    }

    protected final void CheckForUltimateDoom(WadLoader W) {
        if (this.isRegistered()) {
            String[] lumps = new String[]{"e4m1", "e4m2", "e4m3", "e4m4", "e4m5", "e4m6", "e4m7", "e4m8", "e4m9"};
            if (!this.CheckForLumps(lumps, W)) {
                return;
            }
            this.setGameMode(GameMode.retail);
        }
    }

    protected boolean CheckForLumps(String[] name, WadLoader W) {
        for (String name1 : name) {
            if (W.CheckNumForName(name1.toUpperCase()) >= 0) continue;
            return false;
        }
        return true;
    }

    protected final void GenerateTitle() {
        switch (this.getGameMode()) {
            case retail: {
                this.title.append("                         ");
                this.title.append("The Ultimate DOOM Startup v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case shareware: {
                this.title.append("                            ");
                this.title.append("DOOM Shareware Startup v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case registered: {
                this.title.append("                            ");
                this.title.append("DOOM Registered Startup v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case commercial: {
                this.title.append("                            ");
                this.title.append("DOOM 2: Hell on Earth v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case pack_plut: {
                this.title.append("                            ");
                this.title.append("DOOM 2: Plutonia Experiment v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case pack_tnt: {
                this.title.append("                            ");
                this.title.append("DOOM 2: TNT - Evilution v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case pack_xbla: {
                this.title.append("                            ");
                this.title.append("DOOM 2: No Rest for the Living v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case freedm: {
                this.title.append("                            ");
                this.title.append("FreeDM                     v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case freedoom1: {
                this.title.append("                            ");
                this.title.append("FreeDoom: Phase 1          v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            case freedoom2: {
                this.title.append("                            ");
                this.title.append("FreeDoom: Phase 2          v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
                break;
            }
            default: {
                this.title.append("                            ");
                this.title.append("Public DOOM - v");
                this.title.append(1);
                this.title.append(".");
                this.title.append(9);
                this.title.append("                           ");
            }
        }
    }

    private void BuildTiccmd(ticcmd_t cmd) {
        boolean bstrafe;
        int lspeed;
        int tspeed;
        this.base.copyTo(cmd);
        cmd.consistancy = this.consistancy[this.consoleplayer][this.maketic % 12];
        boolean strafe = this.gamekeydown[this.key_strafe] || this.mousebuttons(this.mousebstrafe) || this.joybuttons(this.joybstrafe);
        int speed = this.gamekeydown[this.key_speed] ^ this.alwaysrun || this.joybuttons(this.joybspeed) ? 1 : 0;
        int look = 0;
        int side = 0;
        int forward = 0;
        this.turnheld = this.joyxmove < 0 || this.joyxmove > 0 || this.gamekeydown[this.key_right] || this.gamekeydown[this.key_left] ? (this.turnheld += this.ticdup) : 0;
        int n = tspeed = this.turnheld < 6 ? 2 : speed;
        this.lookheld = this.gamekeydown[this.key_lookdown] || this.gamekeydown[this.key_lookup] ? (this.lookheld += this.ticdup) : 0;
        int n2 = lspeed = this.lookheld < 6 ? 1 : 2;
        if (strafe) {
            if (this.gamekeydown[this.key_right]) {
                side += this.sidemove[speed];
            }
            if (this.gamekeydown[this.key_left]) {
                side -= this.sidemove[speed];
            }
            if (this.joyxmove > 0) {
                side += this.sidemove[speed];
            } else if (this.joyxmove < 0) {
                side -= this.sidemove[speed];
            }
        } else {
            if (this.gamekeydown[this.key_right]) {
                cmd.angleturn = (short)(cmd.angleturn - this.angleturn[tspeed]);
            }
            if (this.gamekeydown[this.key_left]) {
                cmd.angleturn = (short)(cmd.angleturn + this.angleturn[tspeed]);
            }
            if (this.joyxmove > 0) {
                cmd.angleturn = (short)(cmd.angleturn - this.angleturn[tspeed]);
            } else if (this.joyxmove < 0) {
                cmd.angleturn = (short)(cmd.angleturn + this.angleturn[tspeed]);
            }
        }
        if (this.gamekeydown[this.key_up]) {
            forward += this.forwardmove[speed];
        }
        if (this.gamekeydown[this.key_down]) {
            forward -= this.forwardmove[speed];
        }
        if (this.joyymove < 0) {
            forward += this.forwardmove[speed];
        } else if (this.joyymove > 0) {
            forward -= this.forwardmove[speed];
        }
        if (this.gamekeydown[this.key_straferight]) {
            side += this.sidemove[speed];
        }
        if (this.gamekeydown[this.key_strafeleft]) {
            side -= this.sidemove[speed];
        }
        if (this.gamekeydown[this.key_lookup]) {
            System.err.print("Look up\n");
            look = lspeed;
        }
        if (this.gamekeydown[this.key_lookdown]) {
            System.err.print("Look down\n");
            look = -lspeed;
        }
        if (this.gamekeydown[this.key_lookcenter]) {
            System.err.print("Center look\n");
            look = -8;
        }
        cmd.chatchar = this.headsUp.dequeueChatChar();
        if (this.gamekeydown[this.key_fire] || this.mousebuttons(this.mousebfire) || this.joybuttons(this.joybfire)) {
            cmd.buttons = (char)(cmd.buttons | '\u0001');
        }
        if (this.gamekeydown[this.key_use] || this.joybuttons(this.joybuse)) {
            cmd.buttons = (char)(cmd.buttons | 2);
            this.dclicks = 0;
        }
        for (int i = 0; i < Defines.NUMWEAPONS - 1; ++i) {
            if (!this.gamekeydown[this.key_numbers[i]]) continue;
            cmd.buttons = (char)(cmd.buttons | 4);
            cmd.buttons = (char)(cmd.buttons | i << 3);
            break;
        }
        if (this.mousebuttons(this.mousebforward)) {
            forward += this.forwardmove[speed];
        }
        if (this.mousebuttons(this.mousebforward) != C2JUtils.eval(this.dclickstate) && this.dclicktime > 1) {
            int n3 = this.dclickstate = this.mousebuttons(this.mousebforward) ? 1 : 0;
            if (this.dclickstate != 0) {
                ++this.dclicks;
            }
            if (this.dclicks == 2) {
                cmd.buttons = (char)(cmd.buttons | 2);
                this.dclicks = 0;
            } else {
                this.dclicktime = 0;
            }
        } else {
            this.dclicktime += this.ticdup;
            if (this.dclicktime > 20) {
                this.dclicks = 0;
                this.dclickstate = 0;
            }
        }
        boolean bl = bstrafe = this.mousebuttons(this.mousebstrafe) || this.joybuttons(this.joybstrafe);
        if (bstrafe != C2JUtils.eval(this.dclickstate2) && this.dclicktime2 > 1) {
            int n4 = this.dclickstate2 = bstrafe ? 1 : 0;
            if (this.dclickstate2 != 0) {
                ++this.dclicks2;
            }
            if (this.dclicks2 == 2) {
                cmd.buttons = (char)(cmd.buttons | 2);
                this.dclicks2 = 0;
            } else {
                this.dclicktime2 = 0;
            }
        } else {
            this.dclicktime2 += this.ticdup;
            if (this.dclicktime2 > 20) {
                this.dclicks2 = 0;
                this.dclickstate2 = 0;
            }
        }
        if (!this.novert) {
            forward += this.mousey;
        }
        if (strafe) {
            side += this.mousex * 2;
        } else {
            cmd.angleturn = (short)(cmd.angleturn - this.mousex * 8);
        }
        this.mousey = 0;
        this.mousex = 0;
        if (forward > this.MAXPLMOVE()) {
            forward = this.MAXPLMOVE();
        } else if (forward < -this.MAXPLMOVE()) {
            forward = -this.MAXPLMOVE();
        }
        if (side > this.MAXPLMOVE()) {
            side = this.MAXPLMOVE();
        } else if (side < -this.MAXPLMOVE()) {
            side = -this.MAXPLMOVE();
        }
        cmd.forwardmove = (byte)(cmd.forwardmove + forward);
        cmd.sidemove = (byte)(cmd.sidemove + side);
        if (this.players[this.consoleplayer].playerstate == 0) {
            if (look < 0) {
                look += 16;
            }
            cmd.lookfly = (char)look;
        }
        if (this.sendpause) {
            this.sendpause = false;
            cmd.buttons = (char)129;
        }
        if (this.sendsave) {
            this.sendsave = false;
            cmd.buttons = (char)(0x82 | this.savegameslot << 2);
        }
    }

    public boolean DoLoadLevel() {
        if (Engine.getConfig().equals(Settings.fix_sky_change, Boolean.TRUE) && (this.isCommercial() || this.gamemission == GameMission_t.pack_tnt || this.gamemission == GameMission_t.pack_plut)) {
            this.textureManager.setSkyFlatNum(this.textureManager.FlatNumForName("F_SKY1"));
            this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY3"));
            if (this.gamemap < 12) {
                this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY1"));
            } else if (this.gamemap < 21) {
                this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY2"));
            }
        }
        this.levelstarttic = this.gametic;
        if (this.wipegamestate == gamestate_t.GS_LEVEL) {
            this.wipegamestate = gamestate_t.GS_MINUS_ONE;
        }
        this.gamestate = gamestate_t.GS_LEVEL;
        for (int i = 0; i < 4; ++i) {
            if (this.playeringame[i] && this.players[i].playerstate == 1) {
                this.players[i].playerstate = 2;
            }
            C2JUtils.memset(this.players[i].frags, 0, this.players[i].frags.length);
        }
        try {
            this.levelLoader.SetupLevel(this.gameepisode, this.gamemap, 0, this.gameskill);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.displayplayer = this.consoleplayer;
        this.starttime = this.ticker.GetTime();
        this.gameaction = gameaction_t.ga_nothing;
        C2JUtils.memset(this.gamekeydown, false, this.gamekeydown.length);
        this.keysCleared = true;
        this.joyymove = 0;
        this.joyxmove = 0;
        this.mousey = 0;
        this.mousex = 0;
        this.paused = false;
        this.sendsave = false;
        this.sendpause = false;
        C2JUtils.memset(this.mousearray, false, this.mousearray.length);
        C2JUtils.memset(this.joyarray, false, this.joyarray.length);
        this.statusBar.Start();
        this.headsUp.Start();
        if (this.timingdemo && this.first) {
            this.starttime = this.RealTime.GetTime();
            this.first = false;
        }
        this.sceneRenderer.resetLimits();
        return true;
    }

    public boolean Responder(event_t ev) {
        if (this.gamestate == gamestate_t.GS_LEVEL && ev.isKey(Signals.ScanCode.SC_F12, evtype_t.ev_keydown) && (this.singledemo || !this.deathmatch)) {
            do {
                ++this.displayplayer;
                if (this.displayplayer != 4) continue;
                this.displayplayer = 0;
            } while (!this.playeringame[this.displayplayer] && this.displayplayer != this.consoleplayer);
            return true;
        }
        if (this.gameaction == gameaction_t.ga_nothing && !this.singledemo && (this.demoplayback || this.gamestate == gamestate_t.GS_DEMOSCREEN)) {
            if (ev.isType(evtype_t.ev_keydown) || ev.ifMouse(evtype_t.ev_mouse, event_t::hasData) || ev.ifJoy(evtype_t.ev_joystick, event_t::hasData)) {
                this.menu.StartControlPanel();
                return true;
            }
            return false;
        }
        if (this.gamestate == gamestate_t.GS_LEVEL) {
            if (this.devparm && ev.isKey(Signals.ScanCode.SC_SEMICOLON, evtype_t.ev_keydown)) {
                this.DeathMatchSpawnPlayer(0);
                return true;
            }
            if (this.headsUp.Responder(ev)) {
                return true;
            }
            if (this.statusBar.Responder(ev)) {
                return true;
            }
            if (this.autoMap.Responder(ev)) {
                return true;
            }
        }
        if (this.gamestate == gamestate_t.GS_FINALE && this.finale.Responder(ev)) {
            return true;
        }
        switch (ev.type()) {
            case ev_keydown: {
                if (ev.isKey(Signals.ScanCode.SC_PAUSE)) {
                    this.sendpause = true;
                    return true;
                }
                ev.withKey(sc -> {
                    this.gamekeydown[sc.ordinal()] = true;
                    if (this.vanillaKeyBehavior) {
                        switch (sc) {
                            case SC_LSHIFT: 
                            case SC_RSHIFT: {
                                this.gamekeydown[Signals.ScanCode.SC_LSHIFT.ordinal()] = true;
                                this.gamekeydown[Signals.ScanCode.SC_RSHIFT.ordinal()] = true;
                                break;
                            }
                            case SC_LCTRL: 
                            case SC_RCTRL: {
                                this.gamekeydown[Signals.ScanCode.SC_LCTRL.ordinal()] = true;
                                this.gamekeydown[Signals.ScanCode.SC_RCTRL.ordinal()] = true;
                                break;
                            }
                            case SC_LALT: 
                            case SC_RALT: {
                                this.gamekeydown[Signals.ScanCode.SC_LALT.ordinal()] = true;
                                this.gamekeydown[Signals.ScanCode.SC_RALT.ordinal()] = true;
                                break;
                            }
                        }
                    }
                });
                return true;
            }
            case ev_keyup: {
                if (ev.isKey(Signals.ScanCode.SC_CAPSLK)) {
                    this.alwaysrun = !this.alwaysrun;
                    this.players[this.consoleplayer].message = String.format("Always run: %s", this.alwaysrun);
                }
                ev.withKey(sc -> {
                    this.gamekeydown[sc.ordinal()] = false;
                    if (this.vanillaKeyBehavior) {
                        switch (sc) {
                            case SC_LSHIFT: 
                            case SC_RSHIFT: {
                                this.gamekeydown[Signals.ScanCode.SC_LSHIFT.ordinal()] = false;
                                this.gamekeydown[Signals.ScanCode.SC_RSHIFT.ordinal()] = false;
                                break;
                            }
                            case SC_LCTRL: 
                            case SC_RCTRL: {
                                this.gamekeydown[Signals.ScanCode.SC_LCTRL.ordinal()] = false;
                                this.gamekeydown[Signals.ScanCode.SC_RCTRL.ordinal()] = false;
                                break;
                            }
                            case SC_LALT: 
                            case SC_RALT: {
                                this.gamekeydown[Signals.ScanCode.SC_LALT.ordinal()] = false;
                                this.gamekeydown[Signals.ScanCode.SC_RALT.ordinal()] = false;
                                break;
                            }
                        }
                    }
                });
                return false;
            }
            case ev_mouse: {
                if (this.use_mouse) {
                    this.mousebuttons(0, ev.isMouse(1));
                    this.mousebuttons(1, ev.isMouse(2));
                    this.mousebuttons(2, ev.isMouse(4));
                    ev.withMouse(mouseEvent -> {
                        this.mousex = mouseEvent.x * (this.mouseSensitivity + 5) / 10;
                        this.mousey = mouseEvent.y * (this.mouseSensitivity + 5) / 10;
                    });
                }
                return true;
            }
            case ev_joystick: {
                if (this.use_joystick) {
                    this.joybuttons(0, ev.isJoy(1));
                    this.joybuttons(1, ev.isJoy(2));
                    this.joybuttons(2, ev.isJoy(4));
                    this.joybuttons(3, ev.isJoy(8));
                    ev.withJoy(joyEvent -> {
                        this.joyxmove = joyEvent.x;
                        this.joyymove = joyEvent.y;
                    });
                }
                return true;
            }
        }
        return false;
    }

    public void Ticker() {
        int i;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (!this.playeringame[i2] || this.players[i2].playerstate != 2) continue;
            this.DoReborn(i2);
        }
        block23: while (this.gameaction != gameaction_t.ga_nothing) {
            switch (this.gameaction) {
                case ga_loadlevel: {
                    this.DoLoadLevel();
                    continue block23;
                }
                case ga_newgame: {
                    this.DoNewGame();
                    continue block23;
                }
                case ga_loadgame: {
                    this.DoLoadGame();
                    continue block23;
                }
                case ga_savegame: {
                    this.DoSaveGame();
                    continue block23;
                }
                case ga_playdemo: {
                    this.DoPlayDemo();
                    continue block23;
                }
                case ga_completed: {
                    this.DoCompleted();
                    continue block23;
                }
                case ga_victory: {
                    this.finale.StartFinale();
                    continue block23;
                }
                case ga_worlddone: {
                    this.DoWorldDone();
                    continue block23;
                }
                case ga_screenshot: {
                    this.ScreenShot();
                    this.gameaction = gameaction_t.ga_nothing;
                    continue block23;
                }
                case ga_nothing: {
                    continue block23;
                }
            }
        }
        int buf = this.gametic / this.ticdup % 12;
        for (i = 0; i < 4; ++i) {
            if (!this.playeringame[i]) continue;
            ticcmd_t cmd = this.players[i].cmd;
            this.netcmds[i][buf].copyTo(cmd);
            if (this.demoplayback) {
                this.ReadDemoTiccmd(cmd);
            }
            if (this.demorecording) {
                this.WriteDemoTiccmd(cmd);
            }
            if (cmd.forwardmove > 50 && (this.gametic & 0x1F) == 0 && (this.gametic >> 5 & 3) == i) {
                this.players[this.consoleplayer].message = HU.player_names[i] + "is turbo!";
            }
            if (!this.netgame || this.netdemo || this.gametic % this.ticdup != 0) continue;
            if (this.gametic > 12 && this.consistancy[i][buf] != cmd.consistancy) {
                this.doomSystem.Error("consistency failure (%d should be %d)", cmd.consistancy, this.consistancy[i][buf]);
            }
            this.consistancy[i][buf] = this.players[i].mo != null ? (short)this.players[i].mo.x : (short)this.random.getIndex();
        }
        block25: for (i = 0; i < 4; ++i) {
            if (!this.playeringame[i] || (this.players[i].cmd.buttons & 0x80) == 0) continue;
            switch (this.players[i].cmd.buttons & 3) {
                case 1: {
                    boolean bl = this.paused = !this.paused;
                    if (this.paused) {
                        this.doomSound.PauseSound();
                        continue block25;
                    }
                    this.doomSound.ResumeSound();
                    continue block25;
                }
                case 2: {
                    if (this.savedescription == null) {
                        this.savedescription = "NET GAME";
                    }
                    this.savegameslot = (this.players[i].cmd.buttons & 0x1C) >> 2;
                    this.gameaction = gameaction_t.ga_savegame;
                }
            }
        }
        switch (this.gamestate) {
            case GS_LEVEL: {
                this.actions.Ticker();
                this.statusBar.Ticker();
                this.autoMap.Ticker();
                this.headsUp.Ticker();
                break;
            }
            case GS_INTERMISSION: {
                this.endLevel.Ticker();
                break;
            }
            case GS_FINALE: {
                this.finale.Ticker();
                break;
            }
            case GS_DEMOSCREEN: {
                this.PageTicker();
                break;
            }
        }
    }

    protected void InitPlayer(int player) {
        this.players[player].PlayerReborn();
    }

    private boolean CheckSpot(int playernum, mapthing_t mthing) {
        if (this.players[playernum].mo == null) {
            for (int i = 0; i < playernum; ++i) {
                if (this.players[i].mo.x != mthing.x << 16 || this.players[i].mo.y != mthing.y << 16) continue;
                return false;
            }
            return true;
        }
        int x = mthing.x << 16;
        int y = mthing.y << 16;
        if (!this.actions.CheckPosition(this.players[playernum].mo, x, y)) {
            return false;
        }
        if (this.bodyqueslot >= 32) {
            this.actions.RemoveMobj(this.bodyque[this.bodyqueslot % 32]);
        }
        this.bodyque[this.bodyqueslot % 32] = this.players[playernum].mo;
        ++this.bodyqueslot;
        subsector_t ss = this.levelLoader.PointInSubsector(x, y);
        int angle = (int)(0x20000000L * (long)(mthing.angle / 45) >>> 19);
        mobj_t mo = this.actions.SpawnMobj(x + 20 * Tables.finecosine[angle], y + 20 * Tables.finesine[angle], ss.sector.floorheight, mobjtype_t.MT_TFOG);
        if (this.players[this.consoleplayer].viewz != 1) {
            this.doomSound.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_telept);
        }
        return true;
    }

    @Override
    public void DeathMatchSpawnPlayer(int playernum) {
        int selections = this.deathmatch_p;
        if (selections < 4) {
            this.doomSystem.Error("Only %d deathmatch spots, 4 required", selections);
        }
        for (int j = 0; j < 20; ++j) {
            int i = this.random.P_Random() % selections;
            if (!this.CheckSpot(playernum, this.deathmatchstarts[i])) continue;
            this.deathmatchstarts[i].type = (short)(playernum + 1);
            this.actions.SpawnPlayer(this.deathmatchstarts[i]);
            return;
        }
        this.actions.SpawnPlayer(this.playerstarts[playernum]);
    }

    public void DoReborn(int playernum) {
        if (!this.netgame) {
            this.gameaction = gameaction_t.ga_loadlevel;
        } else {
            this.players[playernum].mo.player = null;
            if (this.deathmatch) {
                this.DeathMatchSpawnPlayer(playernum);
                return;
            }
            if (this.CheckSpot(playernum, this.playerstarts[playernum])) {
                this.actions.SpawnPlayer(this.playerstarts[playernum]);
                return;
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.CheckSpot(playernum, this.playerstarts[i])) continue;
                this.playerstarts[i].type = (short)(playernum + 1);
                this.actions.SpawnPlayer(this.playerstarts[i]);
                this.playerstarts[i].type = (short)(i + 1);
                return;
            }
            this.actions.SpawnPlayer(this.playerstarts[playernum]);
        }
    }

    @Override
    public final void ExitLevel() {
        this.secretexit = false;
        this.gameaction = gameaction_t.ga_completed;
    }

    public void SecretExitLevel() {
        this.secretexit = !this.isCommercial() || this.wadLoader.CheckNumForName("MAP31") >= 0;
        this.gameaction = gameaction_t.ga_completed;
    }

    protected void DoCompleted() {
        int i;
        this.gameaction = gameaction_t.ga_nothing;
        for (i = 0; i < 4; ++i) {
            if (!this.playeringame[i]) continue;
            this.players[i].PlayerFinishLevel();
        }
        if (this.automapactive) {
            this.autoMap.Stop();
        }
        if (!this.isCommercial()) {
            switch (this.gamemap) {
                case 8: {
                    this.gameaction = gameaction_t.ga_victory;
                    return;
                }
                case 9: {
                    for (i = 0; i < 4; ++i) {
                        this.players[i].didsecret = true;
                    }
                    break;
                }
            }
        }
        this.wminfo.didsecret = this.players[this.consoleplayer].didsecret;
        this.wminfo.epsd = this.gameepisode - 1;
        this.wminfo.last = this.gamemap - 1;
        if (this.isCommercial()) {
            if (this.secretexit) {
                switch (this.gamemap) {
                    case 2: {
                        this.wminfo.next = 32;
                        break;
                    }
                    case 15: {
                        this.wminfo.next = 30;
                        break;
                    }
                    case 31: {
                        this.wminfo.next = 31;
                        break;
                    }
                }
            } else {
                switch (this.gamemap) {
                    case 31: 
                    case 32: {
                        this.wminfo.next = 15;
                        break;
                    }
                    case 33: {
                        this.wminfo.next = 2;
                        break;
                    }
                    default: {
                        this.wminfo.next = this.gamemap;
                        break;
                    }
                }
            }
        } else if (this.secretexit) {
            this.wminfo.next = 8;
        } else if (this.gamemap == 9) {
            switch (this.gameepisode) {
                case 1: {
                    this.wminfo.next = 3;
                    break;
                }
                case 2: {
                    this.wminfo.next = 5;
                    break;
                }
                case 3: {
                    this.wminfo.next = 6;
                    break;
                }
                case 4: {
                    this.wminfo.next = 2;
                    break;
                }
            }
        } else {
            this.wminfo.next = this.gamemap;
        }
        this.wminfo.maxkills = this.totalkills;
        this.wminfo.maxitems = this.totalitems;
        this.wminfo.maxsecret = this.totalsecret;
        this.wminfo.maxfrags = 0;
        this.wminfo.partime = this.isCommercial() ? 35 * this.cpars[this.gamemap - 1] : (this.gameepisode >= this.pars.length ? 0 : 35 * this.pars[this.gameepisode][this.gamemap]);
        this.wminfo.pnum = this.consoleplayer;
        for (i = 0; i < 4; ++i) {
            this.wminfo.plyr[i].in = this.playeringame[i];
            this.wminfo.plyr[i].skills = this.players[i].killcount;
            this.wminfo.plyr[i].sitems = this.players[i].itemcount;
            this.wminfo.plyr[i].ssecret = this.players[i].secretcount;
            this.wminfo.plyr[i].stime = this.leveltime;
            C2JUtils.memcpy(this.wminfo.plyr[i].frags, this.players[i].frags, this.wminfo.plyr[i].frags.length);
        }
        this.gamestate = gamestate_t.GS_INTERMISSION;
        this.viewactive = false;
        this.automapactive = false;
        if (this.statcopy != null) {
            C2JUtils.memcpy(this.statcopy, this.wminfo, 1);
        }
        this.endLevel.Start(this.wminfo);
    }

    @Override
    public void WorldDone() {
        this.gameaction = gameaction_t.ga_worlddone;
        if (this.secretexit) {
            this.players[this.consoleplayer].didsecret = true;
        }
        if (this.isCommercial()) {
            switch (this.gamemap) {
                case 15: 
                case 31: {
                    if (!this.secretexit) break;
                }
                case 6: 
                case 11: 
                case 20: 
                case 30: {
                    this.finale.StartFinale();
                }
            }
        }
    }

    public void DoWorldDone() {
        this.gamestate = gamestate_t.GS_LEVEL;
        this.gamemap = this.wminfo.next + 1;
        this.DoLoadLevel();
        this.gameaction = gameaction_t.ga_nothing;
        this.viewactive = true;
    }

    @Override
    public void LoadGame(String name) {
        this.savename = name;
        this.gameaction = gameaction_t.ga_loadgame;
    }

    protected void DoLoadGame() {
        try {
            StringBuffer vcheck = new StringBuffer();
            VanillaDSGHeader header = new VanillaDSGHeader();
            VanillaDSG dsg = new VanillaDSG(this);
            this.gameaction = gameaction_t.ga_nothing;
            DataInputStream f = new DataInputStream(new BufferedInputStream(new FileInputStream(this.savename)));
            header.read(f);
            f.close();
            vcheck.append("version ");
            vcheck.append(109);
            if (vcheck.toString().compareTo(header.getVersion()) != 0) {
                f.close();
                return;
            }
            f = new DataInputStream(new BufferedInputStream(new FileInputStream(this.savename)));
            this.gameskill = header.getGameskill();
            this.gameepisode = header.getGameepisode();
            this.gamemap = header.getGamemap();
            System.arraycopy(header.getPlayeringame(), 0, this.playeringame, 0, 4);
            this.InitNew(this.gameskill, this.gameepisode, this.gamemap);
            if (this.gameaction == gameaction_t.ga_failure) {
                f.close();
                return;
            }
            this.gameaction = gameaction_t.ga_nothing;
            this.leveltime = header.getLeveltime();
            boolean ok = dsg.doLoad(f);
            f.close();
            if (!ok) {
                this.doomSystem.Error("Bad savegame");
            }
            if (this.sceneRenderer.getSetSizeNeeded()) {
                this.sceneRenderer.ExecuteSetViewSize();
            }
            this.sceneRenderer.FillBackScreen();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void SaveGame(int slot, String description) {
        this.savegameslot = slot;
        this.savedescription = description;
        this.sendsave = true;
    }

    protected void DoSaveGame() {
        try {
            StringBuffer build = new StringBuffer();
            VanillaDSGHeader header = new VanillaDSGHeader();
            VanillaDSG dsg = new VanillaDSG(this);
            if (this.cVarManager.bool(CommandVariable.CDROM)) {
                build.append("c:\\doomdata\\");
            }
            build.append(String.format("%s%d.dsg", "doomsav", this.savegameslot));
            String name = build.toString();
            String description = this.savedescription;
            header.setName(description);
            header.setVersion(String.format("version %d", 109));
            header.setGameskill(this.gameskill);
            header.setGameepisode(this.gameepisode);
            header.setGamemap(this.gamemap);
            header.setPlayeringame(this.playeringame);
            header.setLeveltime(this.leveltime);
            dsg.setHeader(header);
            try (DataOutputStream f = new DataOutputStream(new FileOutputStream(name));){
                boolean bl = dsg.doSave(f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.gameaction = gameaction_t.ga_nothing;
        this.savedescription = "";
        this.players[this.consoleplayer].message = "game saved.";
        this.sceneRenderer.FillBackScreen();
    }

    @Override
    public void DeferedInitNew(skill_t skill, int episode, int map) {
        this.d_skill = skill;
        this.d_episode = episode;
        this.d_map = map;
        this.gameaction = gameaction_t.ga_newgame;
    }

    public void DoNewGame() {
        this.demoplayback = false;
        this.netdemo = false;
        this.netgame = false;
        this.deathmatch = false;
        this.playeringame[3] = false;
        this.playeringame[2] = false;
        this.playeringame[1] = false;
        this.respawnparm = false;
        this.fastparm = false;
        this.nomonsters = false;
        this.consoleplayer = 0;
        this.InitNew(this.d_skill, this.d_episode, this.d_map);
        this.gameaction = gameaction_t.ga_nothing;
    }

    public void InitNew(skill_t skill, int episode, int map) {
        this.InitNew(skill, episode, map, false);
    }

    private void InitNew(skill_t skill, int episode, int map, boolean noSwitchRandom) {
        int i;
        if (this.paused) {
            this.paused = false;
            this.doomSound.ResumeSound();
        }
        if (skill.ordinal() > skill_t.sk_nightmare.ordinal()) {
            skill = skill_t.sk_nightmare;
        }
        if (episode < 1) {
            episode = 1;
        }
        if (this.isRetail()) {
            if (episode > 4) {
                episode = 4;
            }
        } else if (this.isShareware()) {
            if (episode > 1) {
                episode = 1;
            }
        } else if (episode > 3) {
            episode = 3;
        }
        if (map < 1) {
            map = 1;
        }
        if (map > 9 && !this.isCommercial()) {
            map = 9;
        }
        if (!noSwitchRandom) {
            if (this.cVarManager.bool(CommandVariable.JAVARANDOM)) {
                this.random.requireRandom(237);
            } else {
                this.random.requireRandom(109);
            }
        }
        this.random.ClearRandom();
        boolean bl = this.respawnmonsters = skill == skill_t.sk_nightmare || this.respawnparm;
        if (this.fastparm || skill == skill_t.sk_nightmare && this.gameskill != skill_t.sk_nightmare) {
            for (i = statenum_t.S_SARG_RUN1.ordinal(); i <= statenum_t.S_SARG_PAIN2.ordinal(); ++i) {
                info.states[i].tics >>= 1;
            }
            info.mobjinfo[mobjtype_t.MT_BRUISERSHOT.ordinal()].speed = 0x140000;
            info.mobjinfo[mobjtype_t.MT_HEADSHOT.ordinal()].speed = 0x140000;
            info.mobjinfo[mobjtype_t.MT_TROOPSHOT.ordinal()].speed = 0x140000;
        } else if (skill != skill_t.sk_nightmare && this.gameskill == skill_t.sk_nightmare) {
            for (i = statenum_t.S_SARG_RUN1.ordinal(); i <= statenum_t.S_SARG_PAIN2.ordinal(); ++i) {
                info.states[i].tics <<= 1;
            }
            info.mobjinfo[mobjtype_t.MT_BRUISERSHOT.ordinal()].speed = 983040;
            info.mobjinfo[mobjtype_t.MT_HEADSHOT.ordinal()].speed = 655360;
            info.mobjinfo[mobjtype_t.MT_TROOPSHOT.ordinal()].speed = 655360;
        }
        for (i = 0; i < 4; ++i) {
            this.players[i].playerstate = 2;
        }
        this.usergame = true;
        this.paused = false;
        this.demoplayback = false;
        this.automapactive = false;
        this.viewactive = true;
        this.gameepisode = episode;
        this.gamemap = map;
        this.gameskill = skill;
        this.viewactive = true;
        if (this.isCommercial()) {
            this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY3"));
            if (this.gamemap < 12) {
                this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY1"));
            } else if (this.gamemap < 21) {
                this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY2"));
            }
        } else {
            switch (episode) {
                case 1: {
                    this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY1"));
                    break;
                }
                case 2: {
                    this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY2"));
                    break;
                }
                case 3: {
                    this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY3"));
                    break;
                }
                case 4: {
                    this.textureManager.setSkyTexture(this.textureManager.TextureNumForName("SKY4"));
                    break;
                }
            }
        }
        if (!this.DoLoadLevel()) {
            this.levelLoadFailure();
        }
    }

    protected void levelLoadFailure() {
        boolean endgame = this.doomSystem.GenerateAlert("Level loading failure", "<html><center>Level loading failed!<br>Press OK to end this game without exiting, or cancel to quit Doom.</center></html>");
        if (endgame) {
            this.gameaction = gameaction_t.ga_failure;
            this.gamestate = gamestate_t.GS_DEMOSCREEN;
            this.menu.ClearMenus();
            this.StartTitle();
        } else {
            this.doomSystem.Quit();
        }
    }

    public void ReadDemoTiccmd(ticcmd_t cmd) {
        IDemoTicCmd democmd = this.demobuffer.getNextTic();
        if (democmd == null) {
            this.CheckDemoStatus();
            this.demobuffer.resetDemo();
            return;
        }
        democmd.decode(cmd);
    }

    public void WriteDemoTiccmd(ticcmd_t cmd) {
        if (this.gamekeydown[this.key_recordstop]) {
            this.CheckDemoStatus();
        }
        VanillaTiccmd reccmd = new VanillaTiccmd();
        reccmd.encode(cmd);
        this.demobuffer.putTic(reccmd);
        reccmd.decode(cmd);
    }

    public void RecordDemo(String name) {
        StringBuffer buf = new StringBuffer();
        this.usergame = false;
        buf.append(name);
        buf.append(".lmp");
        this.demoname = buf.toString();
        this.demobuffer = new VanillaDoomDemo();
        this.demorecording = true;
    }

    public void BeginRecording() {
        this.demobuffer.setVersion(this.cVarManager.bool(CommandVariable.JAVARANDOM) ? 237 : 109);
        this.demobuffer.setSkill(this.gameskill);
        this.demobuffer.setEpisode(this.gameepisode);
        this.demobuffer.setMap(this.gamemap);
        this.demobuffer.setDeathmatch(this.deathmatch);
        this.demobuffer.setRespawnparm(this.respawnparm);
        this.demobuffer.setFastparm(this.fastparm);
        this.demobuffer.setNomonsters(this.nomonsters);
        this.demobuffer.setConsoleplayer(this.consoleplayer);
        this.demobuffer.setPlayeringame(this.playeringame);
    }

    public void DeferedPlayDemo(String name) {
        this.defdemoname = name;
        this.gameaction = gameaction_t.ga_playdemo;
    }

    public void DoPlayDemo() {
        int version;
        boolean fail;
        this.gameaction = gameaction_t.ga_nothing;
        try {
            this.demobuffer = this.wadLoader.CacheLumpName(this.defdemoname.toUpperCase(), 1, VanillaDoomDemo.class);
        }
        catch (Exception e) {
            boolean bl = true;
        }
        boolean bl = fail = this.demobuffer.getSkill() == null;
        if (fail || ((version = this.demobuffer.getVersion() & 0xFF) & 0xFFFFFF7F) != 109) {
            System.err.println("Demo is from a different game version!\n");
            System.err.println("Version code read: " + this.demobuffer.getVersion());
            this.gameaction = gameaction_t.ga_nothing;
            return;
        }
        this.random.requireRandom(version);
        skill_t skill = this.demobuffer.getSkill();
        int episode = this.demobuffer.getEpisode();
        int map = this.demobuffer.getMap();
        this.deathmatch = this.demobuffer.isDeathmatch();
        this.respawnparm = this.demobuffer.isRespawnparm();
        this.fastparm = this.demobuffer.isFastparm();
        this.nomonsters = this.demobuffer.isNomonsters();
        this.consoleplayer = this.demobuffer.getConsoleplayer();
        this.demobuffer.resetDemo();
        boolean[] pigs = this.demobuffer.getPlayeringame();
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = pigs[i];
        }
        if (this.playeringame[1]) {
            this.netgame = true;
            this.netdemo = true;
        }
        this.precache = false;
        this.InitNew(skill, episode, map, true);
        this.precache = true;
        this.usergame = false;
        this.demoplayback = true;
    }

    public void TimeDemo(String name) {
        this.nodrawers = this.cVarManager.bool(CommandVariable.NODRAW);
        this.noblit = this.cVarManager.bool(CommandVariable.NOBLIT);
        this.timingdemo = true;
        this.singletics = true;
        this.defdemoname = name;
        this.gameaction = gameaction_t.ga_playdemo;
    }

    @Override
    public boolean CheckDemoStatus() {
        if (this.timingdemo) {
            int endtime = this.RealTime.GetTime();
            long realtics = endtime - this.starttime;
            this.commit();
            this.CM.SaveDefaults();
            this.doomSystem.Error("timed %d gametics in %d realtics = %f frames per second", this.gametic, realtics, (double)this.gametic * 35.0 / (double)realtics);
        }
        if (this.demoplayback) {
            if (this.singledemo) {
                this.doomSystem.Quit();
            }
            this.demoplayback = false;
            this.netdemo = false;
            this.netgame = false;
            this.deathmatch = false;
            this.playeringame[3] = false;
            this.playeringame[2] = false;
            this.playeringame[1] = false;
            this.respawnparm = false;
            this.fastparm = false;
            this.nomonsters = false;
            this.consoleplayer = 0;
            this.AdvanceDemo();
            return true;
        }
        if (this.demorecording) {
            MenuMisc.WriteFile(this.demoname, this.demobuffer);
            this.demorecording = false;
            this.doomSystem.Error("Demo %s recorded", this.demoname);
        }
        return false;
    }

    public DoomMain() throws IOException {
        this.players = new player_t[4];
        Arrays.setAll(this.players, i -> new player_t(this));
        this.cVarManager = Engine.getCVM();
        Arrays.fill(this.events, event_t.EMPTY_EVENT);
        this.doomSystem = new DoomSystem(this);
        this.bppMode = BppMode.chooseBppMode(this.cVarManager);
        this.RealTime = new MilliTicker();
        this.gameNetworking = this;
        this.ticker = ITicker.createTicker(this.cVarManager);
        this.systemNetworking = new DummyNetworkDriver(this);
        this.random = new DelegateRandom();
        System.out.print(String.format("M_Random: Using %s.\n", this.random.getClass().getSimpleName()));
        this.wadLoader = new WadLoader(this.doomSystem);
        this.vs = VisualSettings.parse(this.cVarManager);
        this.spriteManager = new SpriteManager(this);
        this.headsUp = new HU(this);
        this.menu = new Menu(this);
        this.levelLoader = new BoomLevelLoader(this);
        this.sceneRenderer = this.bppMode.sceneRenderer(this);
        this.actions = new ActionFunctions(this);
        this.statusBar = new StatusBar(this);
        this.textureManager = this.sceneRenderer.getTextureManager();
        this.endLevel = new EndLevel(this);
        this.finale = this.selectFinale();
        this.readCVars();
        System.out.print("W_Init: Init WADfiles.\n");
        try {
            this.wadLoader.InitMultipleFiles(this.wadfiles);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.graphicSystem = RendererFactory.newBuilder().setVideoScale(this.vs).setBppMode(this.bppMode).setWadLoader(this.wadLoader).build();
        System.out.print("V_Init: allocate screens.\n");
        this.diskDrawer = new DiskDrawer(this, "STDISK");
        System.out.print("AM_Init: Init Automap colors - \n");
        this.autoMap = new Map(this);
        this.wiper = this.graphicSystem.createWiper(this.random);
        this.update();
        this.CheckForPWADSInShareware();
        this.printGameInfo();
        System.out.print("Tables.InitTables: Init trigonometric LUTs.\n");
        Tables.InitTables();
        System.out.print("M_Init: Init miscellaneous info.\n");
        this.menu.Init();
        System.out.print("R_Init: Init DOOM refresh daemon - ");
        this.sceneRenderer.Init();
        System.out.print("\nP_Init: Init Playloop state.\n");
        this.actions.Init();
        System.out.print("I_Init: Setting up machine state.\n");
        this.doomSystem.Init();
        System.out.print("D_CheckNetGame: Checking network game status.\n");
        this.CheckNetGame();
        System.out.print("S_Init: Setting up sound.\n");
        this.music = IMusic.chooseModule(this.cVarManager);
        this.soundDriver = ISoundDriver.chooseModule(this, this.cVarManager);
        this.doomSound = IDoomSound.chooseSoundIsPresent(this, this.cVarManager, this.soundDriver);
        this.music.InitMusic();
        this.doomSound.Init(this.snd_SfxVolume * 8, this.snd_MusicVolume * 8);
        System.out.print("HU_Init: Setting up heads up display.\n");
        this.headsUp.Init();
        System.out.print("ST_Init: Init status bar.\n");
        this.statusBar.Init();
        if (this.statcopy != null) {
            System.out.print("External statistics registered.\n");
        }
        this.diskDrawer.Init();
    }

    @Override
    public final void update() {
        super.update();
        this.graphicSystem.setUsegamma(this.CM.getValue(Settings.usegamma, Integer.class));
        this.menu.setShowMessages(this.CM.equals(Settings.show_messages, 1));
        this.menu.setScreenBlocks(this.CM.getValue(Settings.screenblocks, Integer.class));
        for (int i = 0; i <= 9; ++i) {
            String chatmacro = String.format("chatmacro%d", i);
            this.headsUp.setChatMacro(i, this.CM.getValue(Settings.valueOf(chatmacro), String.class));
        }
    }

    @Override
    public final void commit() {
        super.commit();
        this.CM.update(Settings.usegamma, this.graphicSystem.getUsegamma());
        this.CM.update(Settings.show_messages, this.menu.getShowMessages());
        this.CM.update(Settings.screenblocks, this.menu.getScreenBlocks());
        for (int i = 0; i <= 9; ++i) {
            this.CM.update(Settings.valueOf(String.format("chatmacro%d", i)), this.headsUp.chat_macros[i]);
        }
    }

    public void setupLoop() throws IOException {
        this.cVarManager.with(CommandVariable.STATCOPY, 0, s -> {
            this.statcopy = s;
            System.out.print("External statistics registered.\n");
        });
        this.cVarManager.with(CommandVariable.RECORD, 0, s -> {
            this.RecordDemo((String)s);
            this.autostart = true;
        });
        if (this.singletics) {
            this.TimeDemo(this.loaddemo);
            this.autostart = true;
        } else if (this.fastdemo || this.normaldemo) {
            this.singledemo = true;
            if (this.fastdemo) {
                this.timingdemo = true;
            }
            this.InitNew(this.startskill, this.startepisode, this.startmap);
            this.gamestate = gamestate_t.GS_DEMOSCREEN;
            this.DeferedPlayDemo(this.loaddemo);
        } else if (this.gameaction != gameaction_t.ga_loadgame) {
            if (this.autostart || this.netgame) {
                this.InitNew(this.startskill, this.startepisode, this.startmap);
            } else {
                this.StartTitle();
            }
        }
        this.DoomLoop();
    }

    private void printGameInfo() {
        if (this.modifiedgame && !this.doomSystem.GenerateAlert("Modified game alert", "<html><center>===========================================================================<br>ATTENTION:  This version of DOOM has been modified.  If you would like to<br>get a copy of the original game, call 1-800-IDGAMES or see the readme file.<br>        You will not receive technical support for modified games.<br>                      press OK to continue<br>===========================================================================<br></center></html>")) {
            this.wadLoader.CloseAllHandles();
            System.exit(-2);
        }
        switch (this.getGameMode()) {
            case shareware: 
            case indetermined: {
                System.out.print("===========================================================================\n");
                System.out.print("                                Shareware!\n");
                System.out.print("===========================================================================\n");
                break;
            }
            case retail: 
            case registered: 
            case commercial: 
            case pack_plut: 
            case pack_tnt: 
            case pack_xbla: {
                System.out.print("===========================================================================\n");
                System.out.print("                 Commercial product - do not distribute!\n");
                System.out.print("         Please report software piracy to the SPA: 1-800-388-PIR8\n");
                System.out.print("===========================================================================\n");
                break;
            }
            case freedm: 
            case freedoom1: 
            case freedoom2: {
                System.out.print("===========================================================================\n");
                System.out.print("       Copyright \u00a9 2001-2017 Contributors to the Freedoom project.\n");
                System.out.print("                            All rights reserved.\n");
                System.out.print("     See: https://github.com/freedoom/freedoom/blob/master/COPYING.adoc\n");
                System.out.print("===========================================================================\n");
                break;
            }
        }
    }

    private void readCVars() {
        StringBuffer file = new StringBuffer();
        String iwadfilename = this.IdentifyVersion();
        this.nomonsters = this.cVarManager.bool(CommandVariable.NOMONSTERS);
        this.respawnparm = this.cVarManager.bool(CommandVariable.RESPAWN);
        this.fastparm = this.cVarManager.bool(CommandVariable.FAST);
        this.devparm = this.cVarManager.bool(CommandVariable.DEVPARM);
        this.altdeath = this.cVarManager.bool(CommandVariable.ALTDEATH);
        if (!this.altdeath) {
            this.deathmatch = this.cVarManager.bool(CommandVariable.DEATHMATCH);
        }
        WadLoader tmpwad = new WadLoader();
        try {
            tmpwad.InitFile(iwadfilename);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.CheckForUltimateDoom(tmpwad);
        this.GenerateTitle();
        if (this.cVarManager.bool(CommandVariable.MILLIS)) {
            System.out.println("ITicker: Using millisecond accuracy timer.");
        } else if (this.cVarManager.bool(CommandVariable.FASTTIC)) {
            System.out.println("ITicker: Using fastest possible timer.");
        } else {
            System.out.println("ITicker: Using nanosecond accuracy timer.");
        }
        System.out.println(this.title.toString());
        if (this.devparm) {
            System.out.println("Development mode ON.\n");
        }
        if (this.cVarManager.bool(CommandVariable.CDROM)) {
            System.out.println("CD-ROM Version: default.cfg from c:\\doomdata\n");
        }
        if (this.cVarManager.specified(CommandVariable.TURBO)) {
            int scale = 200;
            if (this.cVarManager.present(CommandVariable.TURBO)) {
                scale = this.cVarManager.get(CommandVariable.TURBO, Integer.class, 0).get();
            }
            if (scale < 10) {
                scale = 10;
            }
            if (scale > 400) {
                scale = 400;
            }
            System.out.println("turbo scale: " + scale);
            this.forwardmove[0] = this.forwardmove[0] * scale / 100;
            this.forwardmove[1] = this.forwardmove[1] * scale / 100;
            this.sidemove[0] = this.sidemove[0] * scale / 100;
            this.sidemove[1] = this.sidemove[1] * scale / 100;
        }
        if (this.cVarManager.present(CommandVariable.WART)) {
            int ep2 = this.cVarManager.get(CommandVariable.WART, Integer.class, 0).get();
            int map = this.cVarManager.get(CommandVariable.WART, Integer.class, 1).get();
            this.cVarManager.override(CommandVariable.WARP, new CommandVariable.WarpFormat(ep2 * 10 + map), 0);
            GameMode gamemode = this.getGameMode();
            switch (gamemode) {
                case retail: 
                case shareware: 
                case registered: 
                case freedoom1: {
                    file.append("~");
                    file.append("devmaps");
                    file.append(String.format("E%dM%d.wad", ep2, map));
                    file.append(String.format("Warping to Episode %s, Map %s.\n", ep2, map));
                    break;
                }
                default: {
                    if (ep2 < 10) {
                        file.append("~");
                        file.append("devmaps");
                        file.append(String.format("cdata/map0%d.wad", ep2));
                        break;
                    }
                    file.append("~");
                    file.append("devmaps");
                    file.append(String.format("cdata/map%d.wad", ep2));
                }
            }
            this.AddFile(file.toString());
        }
        if (this.cVarManager.present(CommandVariable.FILE)) {
            this.modifiedgame = true;
            this.cVarManager.with(CommandVariable.FILE, 0, a -> Arrays.stream(a).map(s -> C2JUtils.unquoteIfQuoted(s, '\"')).forEach(this::AddFile));
        }
        if (this.cVarManager.present(CommandVariable.PLAYDEMO)) {
            this.normaldemo = true;
            this.loaddemo = this.cVarManager.get(CommandVariable.PLAYDEMO, String.class, 0).get();
        } else if (this.cVarManager.present(CommandVariable.FASTDEMO)) {
            System.out.println("Fastdemo mode. Boundless clock!");
            this.fastdemo = true;
            this.loaddemo = this.cVarManager.get(CommandVariable.FASTDEMO, String.class, 0).get();
        } else if (this.cVarManager.present(CommandVariable.TIMEDEMO)) {
            this.singletics = true;
            this.loaddemo = this.cVarManager.get(CommandVariable.TIMEDEMO, String.class, 0).get();
        }
        if (this.loaddemo != null) {
            this.loaddemo = C2JUtils.unquoteIfQuoted(this.loaddemo, '\"');
            this.AddFile(this.loaddemo + ".lmp");
            System.out.printf("Playing demo %s.lmp.\n", this.loaddemo);
            this.autostart = true;
        }
        this.loaddemo = C2JUtils.extractFileBase(this.loaddemo, 0, true);
        this.startskill = skill_t.sk_medium;
        this.startepisode = 1;
        this.startmap = 1;
        if (this.cVarManager.present(CommandVariable.NOVERT)) {
            this.novert = this.cVarManager.get(CommandVariable.NOVERT, CommandVariable.ForbidFormat.class, 0).filter(CommandVariable.ForbidFormat.FORBID::equals).isPresent();
            if (!this.novert) {
                System.out.println("-novert ENABLED (default)");
            } else {
                System.out.println("-novert DISABLED. Hope you know what you're doing...");
            }
        }
        this.cVarManager.with(CommandVariable.SKILL, 0, s -> {
            this.startskill = skill_t.values()[s - 1];
            this.autostart = true;
        });
        this.cVarManager.with(CommandVariable.EPISODE, 0, ep -> {
            this.startepisode = ep;
            this.startmap = 1;
            this.autostart = true;
        });
        if (this.cVarManager.present(CommandVariable.TIMER) && this.deathmatch) {
            int time = this.cVarManager.get(CommandVariable.TIMER, Integer.class, 0).get();
            System.out.print("Levels will end after " + time + " minute");
            if (time > 1) {
                System.out.print("s");
            }
            System.out.print(".\n");
        }
        if (this.cVarManager.bool(CommandVariable.AVG) && this.deathmatch) {
            System.out.print("Austin Virtual Gaming: Levels will end after 20 minutes\n");
        }
        this.cVarManager.with(CommandVariable.WARP, 0, w -> {
            CommandVariable.WarpMetric metric = w.getMetric(this.isCommercial());
            this.startepisode = metric.getEpisode();
            this.startmap = metric.getMap();
            this.autostart = true;
        });
        this.cVarManager.with(CommandVariable.MAP, 0, m -> {
            CommandVariable.WarpMetric metric = m.getMetric(this.isCommercial());
            this.startepisode = metric.getEpisode();
            this.startmap = metric.getMap();
            this.autostart = true;
        });
        this.cVarManager.with(CommandVariable.LOADGAME, 0, c -> {
            file.delete(0, file.length());
            if (this.cVarManager.bool(CommandVariable.CDROM)) {
                file.append("c:\\doomdata\\");
            }
            file.append(String.format("%s%d.dsg", "doomsav", c));
            this.LoadGame(file.toString());
        });
    }

    @Override
    public int getTicdup() {
        return this.ticdup;
    }

    @Override
    public void setTicdup(int ticdup) {
        this.ticdup = ticdup;
    }

    int NetbufferSize() {
        return 8 * (this.netbuffer.numtics + 1);
    }

    protected long NetbufferChecksum() {
        int l = (this.NetbufferSize() - 4) / 4;
        long c = 19088743L;
        for (int i = 0; i < l; ++i) {
            c += 0L;
        }
        return c & 0xFFFFFFFL;
    }

    protected int ExpandTics(int low) {
        int delta = low - (this.maketic & 0xFF);
        if (delta >= -64 && delta <= 64) {
            return (this.maketic & 0xFFFFFF00) + low;
        }
        if (delta > 64) {
            return (this.maketic & 0xFFFFFF00) - 256 + low;
        }
        if (delta < -64) {
            return (this.maketic & 0xFFFFFF00) + 256 + low;
        }
        this.doomSystem.Error("ExpandTics: strange value %d at maketic %d", low, this.maketic);
        return 0;
    }

    void HSendPacket(int node, int flags) {
        this.netbuffer.checksum = (int)(this.NetbufferChecksum() | (long)flags);
        if (node == 0) {
            this.reboundstore.copyFrom(this.netbuffer);
            this.reboundpacket = true;
            return;
        }
        if (this.demoplayback) {
            return;
        }
        if (!this.netgame) {
            this.doomSystem.Error("Tried to transmit to another node");
        }
        this.doomcom.command = 1;
        this.doomcom.remotenode = (short)node;
        this.doomcom.datalength = (short)this.NetbufferSize();
        if (this.debugfile != null) {
            int realretrans = C2JUtils.flags(this.netbuffer.checksum, 0x40000000) ? this.ExpandTics(this.netbuffer.retransmitfrom) : -1;
            this.logger(this.debugfile, "send (" + this.ExpandTics(this.netbuffer.starttic) + ", " + this.netbuffer.numtics + ", R " + realretrans + "[" + this.doomcom.datalength + "]");
            for (int i = 0; i < this.doomcom.datalength; ++i) {
                this.logger(this.debugfile, this.netbuffer.toString() + "\n");
            }
        }
        this.systemNetworking.NetCmd();
    }

    private boolean HGetPacket() {
        this.sb.setLength(0);
        if (this.reboundpacket) {
            this.netbuffer.copyFrom(this.reboundstore);
            this.doomcom.remotenode = 0;
            this.reboundpacket = false;
            return true;
        }
        if (!this.netgame) {
            return false;
        }
        if (this.demoplayback) {
            return false;
        }
        this.doomcom.command = (short)2;
        this.systemNetworking.NetCmd();
        if (this.doomcom.remotenode == -1) {
            return false;
        }
        if (this.doomcom.datalength != this.NetbufferSize()) {
            if (C2JUtils.eval(this.debugfile)) {
                this.logger(this.debugfile, "bad packet length " + this.doomcom.datalength + "\n");
            }
            return false;
        }
        if (this.NetbufferChecksum() != (long)(this.netbuffer.checksum & 0xFFFFFFF)) {
            if (C2JUtils.eval(this.debugfile)) {
                this.logger(this.debugfile, "bad packet checksum\n");
            }
            return false;
        }
        if (C2JUtils.eval(this.debugfile)) {
            if (C2JUtils.flags(this.netbuffer.checksum, 0x20000000)) {
                this.logger(this.debugfile, "setup packet\n");
            } else {
                int realretrans = C2JUtils.flags(this.netbuffer.checksum, 0x40000000) ? this.ExpandTics(this.netbuffer.retransmitfrom) : -1;
                this.sb.append("get ");
                this.sb.append(this.doomcom.remotenode);
                this.sb.append(" = (");
                this.sb.append(this.ExpandTics(this.netbuffer.starttic));
                this.sb.append(" + ");
                this.sb.append(this.netbuffer.numtics);
                this.sb.append(", R ");
                this.sb.append(realretrans);
                this.sb.append(")[");
                this.sb.append(this.doomcom.datalength);
                this.sb.append("]");
                this.logger(this.debugfile, this.sb.toString());
                this.netbuffer.pack();
                try {
                    for (int i = 0; i < this.doomcom.datalength; ++i) {
                        this.debugfile.write(Integer.toHexString(this.netbuffer.cached()[i]));
                        this.debugfile.write(10);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public void GetPackets() {
        while (this.HGetPacket()) {
            if (C2JUtils.flags(this.netbuffer.checksum, 0x20000000)) continue;
            int netconsole = this.netbuffer.player & ~PL_DRONE;
            short netnode = this.doomcom.remotenode;
            int realstart = this.ExpandTics(this.netbuffer.starttic);
            int realend = realstart + this.netbuffer.numtics;
            if (C2JUtils.flags(this.netbuffer.checksum, Integer.MIN_VALUE)) {
                if (!this.nodeingame[netnode]) continue;
                this.nodeingame[netnode] = false;
                this.playeringame[netconsole] = false;
                this.exitmsg.insert(0, "Player 1 left the game");
                this.exitmsg.setCharAt(7, (char)(this.exitmsg.charAt(7) + netconsole));
                this.players[this.consoleplayer].message = this.exitmsg.toString();
                if (!this.demorecording) continue;
                this.CheckDemoStatus();
                continue;
            }
            if (C2JUtils.flags(this.netbuffer.checksum, 0x10000000)) {
                this.doomSystem.Error("Killed by network driver");
            }
            this.nodeforplayer[netconsole] = netnode;
            if (this.resendcount[netnode] <= 0 && C2JUtils.flags(this.netbuffer.checksum, 0x40000000)) {
                this.resendto[netnode] = this.ExpandTics(this.netbuffer.retransmitfrom);
                if (C2JUtils.eval(this.debugfile)) {
                    this.sb.setLength(0);
                    this.sb.append("retransmit from ");
                    this.sb.append(this.resendto[netnode]);
                    this.sb.append('\n');
                    this.logger(this.debugfile, this.sb.toString());
                    this.resendcount[netnode] = RESENDCOUNT;
                }
            } else {
                short s = netnode;
                this.resendcount[s] = this.resendcount[s] - 1;
            }
            if (realend == this.nettics[netnode]) continue;
            if (realend < this.nettics[netnode]) {
                if (!C2JUtils.eval(this.debugfile)) continue;
                this.sb.setLength(0);
                this.sb.append("out of order packet (");
                this.sb.append(realstart);
                this.sb.append(" + ");
                this.sb.append(this.netbuffer.numtics);
                this.sb.append(")\n");
                this.logger(this.debugfile, this.sb.toString());
                continue;
            }
            if (realstart > this.nettics[netnode]) {
                if (C2JUtils.eval(this.debugfile)) {
                    this.sb.setLength(0);
                    this.sb.append("missed tics from ");
                    this.sb.append(netnode);
                    this.sb.append(" (");
                    this.sb.append(realstart);
                    this.sb.append(" - ");
                    this.sb.append(this.nettics[netnode]);
                    this.sb.append(")\n");
                    this.logger(this.debugfile, this.sb.toString());
                }
                this.remoteresend[netnode] = true;
                continue;
            }
            this.remoteresend[netnode] = false;
            int start = this.nettics[netnode] - realstart;
            ticcmd_t src = this.netbuffer.cmds[start];
            while (this.nettics[netnode] < realend) {
                ticcmd_t dest = this.netcmds[netconsole][this.nettics[netnode] % 12];
                short s = netnode;
                this.nettics[s] = this.nettics[s] + 1;
                src.copyTo(dest);
                if (++start >= this.netbuffer.cmds.length) continue;
                src = this.netbuffer.cmds[start];
            }
        }
    }

    protected void logger(OutputStreamWriter debugfile, String string) {
        try {
            debugfile.write(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void NetUpdate() {
        int nowtime = this.ticker.GetTime() / this.ticdup;
        int newtics = nowtime - this.gametime;
        this.gametime = nowtime;
        if (newtics <= 0) {
            this.GetPackets();
        } else {
            int i;
            if (this.skiptics <= newtics) {
                newtics -= this.skiptics;
                this.skiptics = 0;
            } else {
                this.skiptics -= newtics;
                newtics = 0;
            }
            this.netbuffer.player = (byte)this.consoleplayer;
            int gameticdiv = this.gametic / this.ticdup;
            for (i = 0; i < newtics; ++i) {
                this.ProcessEvents();
                if (this.maketic - gameticdiv >= 5) break;
                this.BuildTiccmd(this.localcmds[this.maketic % 12]);
                ++this.maketic;
            }
            if (this.singletics) {
                return;
            }
            for (i = 0; i < this.doomcom.numnodes; ++i) {
                if (!this.nodeingame[i]) continue;
                int realstart = this.resendto[i];
                this.netbuffer.starttic = (byte)realstart;
                this.netbuffer.numtics = (byte)(this.maketic - realstart);
                if (this.netbuffer.numtics > 12) {
                    this.doomSystem.Error("NetUpdate: netbuffer.numtics > BACKUPTICS");
                }
                this.resendto[i] = this.maketic - this.doomcom.extratics;
                for (int j = 0; j < this.netbuffer.numtics; ++j) {
                    this.localcmds[(realstart + j) % 12].copyTo(this.netbuffer.cmds[j]);
                }
                if (this.remoteresend[i]) {
                    this.netbuffer.retransmitfrom = (byte)this.nettics[i];
                    this.HSendPacket(i, 0x40000000);
                    continue;
                }
                this.netbuffer.retransmitfrom = 0;
                this.HSendPacket(i, 0);
            }
            this.GetPackets();
        }
    }

    private void CheckAbort() {
        int stoptic = this.ticker.GetTime() + 2;
        while (this.ticker.GetTime() < stoptic) {
        }
        while (this.eventtail != this.eventhead) {
            event_t ev = this.events[this.eventtail];
            if (ev.isKey(Signals.ScanCode.SC_ESCAPE, evtype_t.ev_keydown)) {
                this.doomSystem.Error("Network game synchronization aborted.");
            }
            ++this.eventtail;
            this.eventtail &= 0x3F;
        }
    }

    public void ArbitrateNetStart() throws IOException {
        int i;
        this.autostart = true;
        C2JUtils.memset(this.gotinfo, false, this.gotinfo.length);
        if (this.doomcom.consoleplayer != 0) {
            System.out.println("listening for network start info...\n");
            do {
                this.CheckAbort();
            } while (!this.HGetPacket() || !C2JUtils.flags(this.netbuffer.checksum, 0x20000000));
            if (this.netbuffer.player != 109) {
                this.doomSystem.Error("Different DOOM versions cannot play a net game!");
            }
            this.startskill = skill_t.values()[this.netbuffer.retransmitfrom & 0xF];
            if ((this.netbuffer.retransmitfrom & 0xC0) >> 6 == 1) {
                this.deathmatch = true;
            } else if ((this.netbuffer.retransmitfrom & 0xC0) >> 6 == 2) {
                this.altdeath = true;
            }
            this.nomonsters = (this.netbuffer.retransmitfrom & 0x20) > 0;
            this.respawnparm = (this.netbuffer.retransmitfrom & 0x10) > 0;
            this.startmap = this.netbuffer.starttic & 0x3F;
            this.startepisode = this.netbuffer.starttic >> 6;
            return;
        }
        System.out.println("sending network start info...\n");
        do {
            this.CheckAbort();
            for (i = 0; i < this.doomcom.numnodes; ++i) {
                this.netbuffer.retransmitfrom = (byte)this.startskill.ordinal();
                if (this.deathmatch) {
                    this.netbuffer.retransmitfrom = (byte)(this.netbuffer.retransmitfrom | 0x40);
                } else if (this.altdeath) {
                    this.netbuffer.retransmitfrom = (byte)(this.netbuffer.retransmitfrom | 0x80);
                }
                if (this.nomonsters) {
                    this.netbuffer.retransmitfrom = (byte)(this.netbuffer.retransmitfrom | 0x20);
                }
                if (this.respawnparm) {
                    this.netbuffer.retransmitfrom = (byte)(this.netbuffer.retransmitfrom | 0x10);
                }
                this.netbuffer.starttic = (byte)(this.startepisode * 64 + this.startmap);
                this.netbuffer.player = (byte)109;
                this.netbuffer.numtics = 0;
                this.HSendPacket(i, 0x20000000);
            }
            for (i = 10; i > 0 && this.HGetPacket(); --i) {
                if ((this.netbuffer.player & 0x7F) >= 8) continue;
                this.gotinfo[this.netbuffer.player & 0x7F] = true;
            }
            for (i = 1; i < this.doomcom.numnodes && this.gotinfo[i]; ++i) {
            }
        } while (i < this.doomcom.numnodes);
    }

    private void CheckNetGame() throws IOException {
        int i;
        for (i = 0; i < 8; ++i) {
            this.nodeingame[i] = false;
            this.nettics[i] = 0;
            this.remoteresend[i] = false;
            this.resendto[i] = 0;
        }
        this.systemNetworking.InitNetwork();
        if (this.doomcom.id != 305419896) {
            this.doomSystem.Error("Doomcom buffer invalid!");
        }
        this.netbuffer = this.doomcom.data;
        short s = this.doomcom.consoleplayer;
        this.displayplayer = s;
        this.consoleplayer = s;
        if (this.netgame) {
            this.ArbitrateNetStart();
        }
        System.out.printf("startskill %s  deathmatch: %s  startmap: %d  startepisode: %d\n", this.startskill.toString(), Boolean.toString(this.deathmatch), this.startmap, this.startepisode);
        this.ticdup = this.doomcom.ticdup;
        this.maxsend = 12 / (2 * this.ticdup) - 1;
        if (this.maxsend < 1) {
            this.maxsend = 1;
        }
        for (i = 0; i < this.doomcom.numplayers; ++i) {
            this.playeringame[i] = true;
        }
        for (i = 0; i < this.doomcom.numnodes; ++i) {
            this.nodeingame[i] = true;
        }
        System.out.printf("player %d of %d (%d nodes)\n", this.consoleplayer + 1, this.doomcom.numplayers, this.doomcom.numnodes);
    }

    @Override
    public void QuitNetGame() throws IOException {
        if (C2JUtils.eval(this.debugfile)) {
            try {
                this.debugfile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!this.netgame || !this.usergame || this.consoleplayer == -1 || this.demoplayback) {
            return;
        }
        this.netbuffer.player = (byte)this.consoleplayer;
        this.netbuffer.numtics = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 1; j < this.doomcom.numnodes; ++j) {
                if (!this.nodeingame[j]) continue;
                this.HSendPacket(j, Integer.MIN_VALUE);
            }
            this.doomSystem.WaitVBL(1);
        }
    }

    @Override
    public void TryRunTics() throws IOException {
        int i;
        int entertic = this.ticker.GetTime() / this.ticdup;
        int realtics = entertic - this.oldentertics;
        this.oldentertics = entertic;
        this.NetUpdate();
        int lowtic = Integer.MAX_VALUE;
        int numplaying = 0;
        for (i = 0; i < this.doomcom.numnodes; ++i) {
            if (!this.nodeingame[i]) continue;
            ++numplaying;
            if (this.nettics[i] >= lowtic) continue;
            lowtic = this.nettics[i];
        }
        int availabletics = lowtic - this.gametic / this.ticdup;
        int counts = realtics < availabletics - 1 ? realtics + 1 : (realtics < availabletics ? realtics : availabletics);
        if (counts < 1) {
            counts = 1;
        }
        ++this.frameon;
        if (C2JUtils.eval(this.debugfile)) {
            this.sb.setLength(0);
            this.sb.append("=======real: ");
            this.sb.append(realtics);
            this.sb.append("  avail: ");
            this.sb.append(availabletics);
            this.sb.append("  game: ");
            this.sb.append(counts);
            this.sb.append("\n");
            this.debugfile.write(this.sb.toString());
        }
        if (!this.demoplayback) {
            for (i = 0; i < 4 && !this.playeringame[i]; ++i) {
            }
            if (this.consoleplayer != i) {
                if (this.nettics[0] <= this.nettics[this.nodeforplayer[i]]) {
                    --this.gametime;
                    System.out.print("-");
                }
                this.frameskip[this.frameon & 3] = this.oldnettics > this.nettics[this.nodeforplayer[i]];
                this.oldnettics = this.nettics[0];
                if (this.frameskip[0] && this.frameskip[1] && this.frameskip[2] && this.frameskip[3]) {
                    this.skiptics = 1;
                    System.out.print("+");
                }
            }
        }
        while (lowtic < this.gametic / this.ticdup + counts) {
            int time;
            this.NetUpdate();
            lowtic = Integer.MAX_VALUE;
            for (i = 0; i < this.doomcom.numnodes; ++i) {
                if (!this.nodeingame[i] || this.nettics[i] >= lowtic) continue;
                lowtic = this.nettics[i];
            }
            if (lowtic < this.gametic / this.ticdup) {
                this.doomSystem.Error("TryRunTics: lowtic < gametic");
            }
            if ((time = this.ticker.GetTime()) / this.ticdup - entertic < 20) continue;
            this.menu.Ticker();
            return;
        }
        while (counts-- > 0) {
            for (i = 0; i < this.ticdup; ++i) {
                if (this.gametic / this.ticdup > lowtic) {
                    this.doomSystem.Error("gametic>lowtic");
                }
                if (this.advancedemo) {
                    this.DoAdvanceDemo();
                }
                this.menu.Ticker();
                this.Ticker();
                ++this.gametic;
                if (i == this.ticdup - 1) continue;
                int buf = this.gametic / this.ticdup % 12;
                for (int j = 0; j < 4; ++j) {
                    ticcmd_t cmd = this.netcmds[j][buf];
                    cmd.chatchar = '\u0000';
                    if (!C2JUtils.flags(cmd.buttons, 128)) continue;
                    cmd.buttons = '\u0000';
                }
            }
            this.NetUpdate();
        }
    }

    @Override
    public doomcom_t getDoomCom() {
        return this.doomcom;
    }

    @Override
    public void setDoomCom(doomcom_t doomcom) {
        this.doomcom = doomcom;
    }

    @Override
    public void setGameAction(gameaction_t action) {
        this.gameaction = action;
    }

    @Override
    public gameaction_t getGameAction() {
        return this.gameaction;
    }

    public boolean shouldPollLockingKeys() {
        if (this.keysCleared) {
            this.keysCleared = false;
            return true;
        }
        return false;
    }

    private String findFileNameToSave() {
        int i;
        String format = "DOOM%d%d%d%d.png";
        String lbmname = null;
        int[] digit = new int[4];
        for (i = 0; i <= 9999; ++i) {
            digit[0] = i / 1000 % 10;
            digit[1] = i / 100 % 10;
            digit[2] = i / 10 % 10;
            digit[3] = i % 10;
            lbmname = String.format(format, digit[0], digit[1], digit[2], digit[3]);
            if (!C2JUtils.testReadAccess(lbmname)) break;
        }
        if (i == 10000) {
            this.doomSystem.Error("M_ScreenShot: Couldn't create a PNG");
        }
        return lbmname;
    }

    @Override
    protected final Finale<T> selectFinale() {
        return new Finale(this);
    }

    @Override
    public void ScreenShot() {
        String lbmname = this.findFileNameToSave();
        if (this.graphicSystem.writeScreenShot(lbmname, DoomScreen.FG)) {
            this.players[this.consoleplayer].message = "screen shot";
        }
    }
}

