/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.IDatagramSerializable;
import doom.ticcmd_t;
import java.nio.ByteBuffer;
import utils.GenericCopy;
import w.DoomBuffer;

public class doomdata_t
implements IDatagramSerializable {
    public static final int DOOMDATALEN = 104;
    public int checksum;
    public byte retransmitfrom;
    public byte starttic;
    public byte player;
    public byte numtics;
    public ticcmd_t[] cmds;
    private byte[] buffer;
    private ByteBuffer bbuf;
    StringBuilder sb = new StringBuilder();

    public doomdata_t() {
        this.cmds = (ticcmd_t[])GenericCopy.malloc(ticcmd_t::new, ticcmd_t[]::new, 12);
        this.buffer = new byte[104];
        this.bbuf = ByteBuffer.wrap(this.buffer);
    }

    @Override
    public byte[] pack() {
        this.bbuf.rewind();
        this.bbuf.putInt(this.checksum);
        this.bbuf.put(this.retransmitfrom);
        this.bbuf.put(this.starttic);
        this.bbuf.put(this.player);
        this.bbuf.put(this.numtics);
        for (int i = 0; i < this.cmds.length; ++i) {
            this.bbuf.put(this.cmds[i].pack());
        }
        return this.bbuf.array();
    }

    @Override
    public void pack(byte[] buf, int offset) {
        byte[] tmp = this.pack();
        System.arraycopy(tmp, 0, buf, offset, tmp.length);
    }

    @Override
    public void unpack(byte[] buf) {
        this.unpack(buf, 0);
    }

    @Override
    public void unpack(byte[] buf, int offset) {
        this.checksum = DoomBuffer.getBEInt(buf);
        offset = 4;
        this.retransmitfrom = buf[offset++];
        this.starttic = buf[offset++];
        this.player = buf[offset++];
        this.numtics = buf[offset++];
        for (int i = 0; i < this.cmds.length; ++i) {
            this.cmds[i].unpack(buf, offset);
            offset += 8;
        }
    }

    public void selfUnpack() {
        this.unpack(this.buffer);
    }

    public void copyFrom(doomdata_t source) {
        this.checksum = source.checksum;
        this.numtics = source.numtics;
        this.player = source.player;
        this.retransmitfrom = source.retransmitfrom;
        this.starttic = source.starttic;
    }

    @Override
    public byte[] cached() {
        return this.buffer;
    }

    public String toString() {
        this.sb.setLength(0);
        this.sb.append("doomdata_t ");
        this.sb.append(this.retransmitfrom);
        this.sb.append(" starttic ");
        this.sb.append(this.starttic);
        this.sb.append(" player ");
        this.sb.append(this.player);
        this.sb.append(" numtics ");
        this.sb.append(this.numtics);
        return this.sb.toString();
    }
}

