/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.evtype_t;
import g.Signals;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import utils.C2JUtils;

@FunctionalInterface
public interface event_t {
    public static final int MOUSE_LEFT = 1;
    public static final int MOUSE_RIGHT = 2;
    public static final int MOUSE_MID = 4;
    public static final int JOY_1 = 1;
    public static final int JOY_2 = 2;
    public static final int JOY_3 = 4;
    public static final int JOY_4 = 8;
    public static final event_t EMPTY_EVENT = () -> evtype_t.ev_null;
    public static final event_t CANCEL_KEYS = () -> evtype_t.ev_clear;
    public static final event_t CANCEL_MOUSE = new mouseevent_t(evtype_t.ev_mouse, 0, 0, 0);

    default public boolean hasData() {
        return false;
    }

    default public boolean isKey() {
        return false;
    }

    default public boolean isKey(Signals.ScanCode sc) {
        return false;
    }

    default public <T> T mapByKey(Function<? super Signals.ScanCode, ? extends T> scMapper) {
        return scMapper.apply(null);
    }

    default public boolean withKey(Consumer<? super Signals.ScanCode> scConsumer) {
        return false;
    }

    default public boolean ifKey(Predicate<? super Signals.ScanCode> scCondition) {
        return false;
    }

    default public boolean withKeyChar(IntConsumer scCharConsumer) {
        return false;
    }

    default public boolean ifKeyChar(IntPredicate scCharCondition) {
        return false;
    }

    default public boolean withKeyAsciiChar(IntConsumer scAsciiCharConsumer) {
        return false;
    }

    default public boolean ifKeyAsciiChar(IntPredicate scCharCondition) {
        return false;
    }

    default public <T> boolean withKey(Consumer<? super T> scConsumer, Function<? super Signals.ScanCode, ? extends T> extractor) {
        return false;
    }

    default public <T> boolean ifKey(Predicate<? super T> scCondition, Function<? super Signals.ScanCode, ? extends T> extractor) {
        return false;
    }

    default public Signals.ScanCode getSC() {
        return Signals.ScanCode.SC_NULL;
    }

    default public boolean isMouse() {
        return false;
    }

    default public boolean isMouse(int button) {
        return false;
    }

    default public <T> T mapByMouse(Function<? super mouseevent_t, ? extends T> mouseMapper) {
        return mouseMapper.apply(null);
    }

    default public boolean withMouse(Consumer<? super mouseevent_t> mouseConsumer) {
        return false;
    }

    default public boolean ifMouse(Predicate<? super mouseevent_t> mouseCondition) {
        return false;
    }

    default public <T> boolean withMouse(Consumer<? super T> mouseConsumer, Function<? super mouseevent_t, ? extends T> extractor) {
        return false;
    }

    default public <T> boolean ifMouse(Predicate<? super T> mouseCondition, Function<? super mouseevent_t, ? extends T> extractor) {
        return false;
    }

    default public boolean isJoy() {
        return false;
    }

    default public boolean isJoy(int button) {
        return false;
    }

    default public <T> T mapByJoy(Function<? super joyevent_t, ? extends T> joyMapper) {
        return joyMapper.apply(null);
    }

    default public boolean withJoy(Consumer<? super joyevent_t> joyConsumer) {
        return false;
    }

    default public boolean ifJoy(Predicate<? super joyevent_t> joyCondition) {
        return false;
    }

    default public <T> boolean withJoy(Consumer<? super T> joyConsumer, Function<? super joyevent_t, ? extends T> extractor) {
        return false;
    }

    default public <T> boolean ifJoy(Predicate<? super T> joyCondition, Function<? super joyevent_t, ? extends T> extractor) {
        return false;
    }

    public evtype_t type();

    default public boolean isType(evtype_t type) {
        return this.type() == type;
    }

    default public boolean isKey(Signals.ScanCode sc, evtype_t type) {
        return this.type() == type && this.isKey(sc);
    }

    default public boolean ifKey(evtype_t type, Predicate<? super Signals.ScanCode> scCondition) {
        if (this.type() == type) {
            return this.ifKey(scCondition);
        }
        return false;
    }

    default public boolean withKey(evtype_t type, Consumer<? super Signals.ScanCode> scConsumer) {
        if (this.type() == type) {
            return this.withKey(scConsumer);
        }
        return false;
    }

    default public boolean withKey(Signals.ScanCode sc, evtype_t type, Runnable runnable) {
        if (this.type() == type) {
            return this.withKey(sc, runnable);
        }
        return false;
    }

    default public boolean withKey(Signals.ScanCode sc, Runnable runnable) {
        if (this.isKey(sc)) {
            runnable.run();
            return true;
        }
        return false;
    }

    default public boolean isMouse(int button, evtype_t type) {
        return this.type() == type && this.isMouse(button);
    }

    default public boolean ifMouse(evtype_t type, Predicate<? super mouseevent_t> mouseCondition) {
        if (this.type() == type) {
            return this.ifMouse(mouseCondition);
        }
        return false;
    }

    default public boolean withMouse(evtype_t type, Consumer<? super mouseevent_t> mouseConsumer) {
        if (this.type() == type) {
            return this.withMouse(mouseConsumer);
        }
        return false;
    }

    default public boolean withMouse(int button, evtype_t type, Runnable runnable) {
        if (this.type() == type) {
            return this.withMouse(button, runnable);
        }
        return false;
    }

    default public boolean withMouse(int button, Runnable runnable) {
        if (this.isMouse(button)) {
            runnable.run();
            return true;
        }
        return false;
    }

    default public boolean isJoy(int button, evtype_t type) {
        return this.type() == type && this.isJoy(button);
    }

    default public boolean ifJoy(evtype_t type, Predicate<? super joyevent_t> joyCondition) {
        if (this.type() == type) {
            return this.ifJoy(joyCondition);
        }
        return false;
    }

    default public boolean withJoy(evtype_t type, Consumer<? super joyevent_t> joyConsumer) {
        if (this.type() == type) {
            return this.withJoy(joyConsumer);
        }
        return false;
    }

    default public boolean withJoy(int button, evtype_t type, Runnable runnable) {
        if (this.type() == type) {
            return this.withJoy(button, runnable);
        }
        return false;
    }

    default public boolean withJoy(int button, Runnable runnable) {
        if (this.isJoy(button)) {
            runnable.run();
            return true;
        }
        return false;
    }

    public static int mouseBits(int button) {
        switch (button) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    public static final class joyevent_t
    implements event_t {
        public evtype_t type;
        public int buttons;
        public int x;
        public int y;

        public joyevent_t(evtype_t type, int buttons, int x, int y) {
            this.type = type;
            this.buttons = buttons;
            this.x = x;
            this.y = y;
        }

        @Override
        public boolean hasData() {
            return this.buttons != 0;
        }

        @Override
        public evtype_t type() {
            return this.type;
        }

        @Override
        public boolean isJoy() {
            return true;
        }

        @Override
        public boolean isJoy(int button) {
            return C2JUtils.flags(this.buttons, button);
        }

        @Override
        public boolean ifJoy(Predicate<? super joyevent_t> joyCondition) {
            return joyCondition.test(this);
        }

        @Override
        public boolean withJoy(Consumer<? super joyevent_t> joyConsumer) {
            joyConsumer.accept(this);
            return true;
        }

        @Override
        public <T> boolean ifJoy(Predicate<? super T> joyCondition, Function<? super joyevent_t, ? extends T> extractor) {
            return joyCondition.test(extractor.apply(this));
        }

        @Override
        public <T> boolean withJoy(Consumer<? super T> joyConsumer, Function<? super joyevent_t, ? extends T> extractor) {
            joyConsumer.accept(extractor.apply(this));
            return true;
        }

        @Override
        public <T> T mapByJoy(Function<? super joyevent_t, ? extends T> mouseMapper) {
            return mouseMapper.apply(this);
        }
    }

    public static final class mouseevent_t
    implements event_t {
        public volatile evtype_t type;
        public volatile boolean robotMove;
        public volatile boolean processed = true;
        public volatile int buttons;
        public volatile int x;
        public volatile int y;

        public mouseevent_t(evtype_t type, int buttons, int x, int y) {
            this.type = type;
            this.buttons = buttons;
            this.x = x;
            this.y = y;
        }

        @Override
        public boolean hasData() {
            return this.buttons != 0;
        }

        public void buttonOn(MouseEvent ev) {
            this.buttons |= event_t.mouseBits(ev.getButton());
        }

        public void buttonOff(MouseEvent ev) {
            this.buttons ^= event_t.mouseBits(ev.getButton());
        }

        public void processedNotify() {
            this.processed = true;
        }

        public void resetNotify() {
            this.processed = false;
        }

        public void moveIn(MouseEvent ev, int centreX, int centreY, boolean drag) {
            int mouseX = ev.getX();
            int mouseY = ev.getY();
            if (mouseX == centreX && mouseY == centreY) {
                return;
            }
            if (!drag) {
                this.buttons = 0;
            }
            if (this.processed) {
                this.x = mouseX - centreX << 2;
                this.y = centreY - mouseY << 2;
            } else {
                this.x += mouseX - centreX << 2;
                this.y += centreY - mouseY << 2;
            }
        }

        public void moveIn(MouseEvent ev, Robot robot, Point windowOffset, int centreX, int centreY, boolean drag) {
            this.moveIn(ev, centreX, centreY, drag);
            this.resetIn(robot, windowOffset, centreX, centreY);
        }

        public void resetIn(Robot robot, Point windowOffset, int centreX, int centreY) {
            this.robotMove = true;
            robot.mouseMove(windowOffset.x + centreX, windowOffset.y + centreY);
        }

        @Override
        public evtype_t type() {
            return this.type;
        }

        @Override
        public boolean isMouse() {
            return true;
        }

        @Override
        public boolean isMouse(int button) {
            return C2JUtils.flags(this.buttons, button);
        }

        @Override
        public boolean ifMouse(Predicate<? super mouseevent_t> mouseCondition) {
            return mouseCondition.test(this);
        }

        @Override
        public boolean withMouse(Consumer<? super mouseevent_t> mouseConsumer) {
            mouseConsumer.accept(this);
            return true;
        }

        @Override
        public <T> boolean ifMouse(Predicate<? super T> mouseCondition, Function<? super mouseevent_t, ? extends T> extractor) {
            return mouseCondition.test(extractor.apply(this));
        }

        @Override
        public <T> boolean withMouse(Consumer<? super T> mouseConsumer, Function<? super mouseevent_t, ? extends T> extractor) {
            mouseConsumer.accept(extractor.apply(this));
            return true;
        }

        @Override
        public <T> T mapByMouse(Function<? super mouseevent_t, ? extends T> mouseMapper) {
            return mouseMapper.apply(this);
        }
    }

    public static final class keyevent_t
    implements event_t {
        public evtype_t type;
        public Signals.ScanCode sc;

        public keyevent_t(evtype_t type, Signals.ScanCode sc) {
            this.type = type;
            this.sc = sc;
        }

        @Override
        public boolean hasData() {
            return this.sc != Signals.ScanCode.SC_NULL;
        }

        @Override
        public evtype_t type() {
            return this.type;
        }

        @Override
        public boolean isKey() {
            return true;
        }

        @Override
        public boolean isKey(Signals.ScanCode sc) {
            return this.sc == sc;
        }

        @Override
        public boolean ifKey(Predicate<? super Signals.ScanCode> scCondition) {
            return scCondition.test(this.sc);
        }

        @Override
        public boolean withKey(Consumer<? super Signals.ScanCode> scConsumer) {
            scConsumer.accept(this.sc);
            return true;
        }

        @Override
        public boolean ifKeyChar(IntPredicate scCharCondition) {
            return scCharCondition.test(this.sc.c);
        }

        @Override
        public boolean withKeyChar(IntConsumer scCharConsumer) {
            scCharConsumer.accept(this.sc.c);
            return true;
        }

        @Override
        public boolean ifKeyAsciiChar(IntPredicate scAsciiCharCondition) {
            return this.sc.c > '\u00ff' ? false : this.ifKeyChar(scAsciiCharCondition);
        }

        @Override
        public boolean withKeyAsciiChar(IntConsumer scAsciiCharConsumer) {
            return this.sc.c > '\u00ff' ? false : this.withKeyChar(scAsciiCharConsumer);
        }

        @Override
        public <T> boolean ifKey(Predicate<? super T> scCondition, Function<? super Signals.ScanCode, ? extends T> extractor) {
            return scCondition.test(extractor.apply(this.sc));
        }

        @Override
        public <T> boolean withKey(Consumer<? super T> scConsumer, Function<? super Signals.ScanCode, ? extends T> extractor) {
            scConsumer.accept(extractor.apply(this.sc));
            return true;
        }

        @Override
        public <T> T mapByKey(Function<? super Signals.ScanCode, ? extends T> scMapper) {
            return scMapper.apply(this.sc);
        }

        @Override
        public Signals.ScanCode getSC() {
            return this.sc;
        }
    }
}

