/*
 * Decompiled with CFR 0.152.
 */
package doom;

import data.Defines;
import data.Tables;
import data.info;
import data.sounds;
import data.state_t;
import defines.ammotype_t;
import defines.card_t;
import defines.skill_t;
import defines.statenum_t;
import doom.DoomMain;
import doom.DoomStatus;
import doom.items;
import doom.ticcmd_t;
import doom.weapontype_t;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import m.fixed_t;
import p.ActiveStates;
import p.mobj_t;
import p.pspdef_t;
import rr.sector_t;
import s.ISoundOrigin;
import utils.C2JUtils;
import utils.GenericCopy;
import w.DoomBuffer;
import w.DoomIO;
import w.IPackableDoomObject;
import w.IReadableDoomObject;

public class player_t
implements Cloneable,
IReadableDoomObject,
IPackableDoomObject {
    private final DoomMain<?, ?> DOOM;
    public static final int CF_NOCLIP = 1;
    public static final int CF_GODMODE = 2;
    public static final int CF_NOMOMENTUM = 4;
    public mobj_t mo;
    public int playerstate;
    public ticcmd_t cmd;
    public int viewz;
    public int viewheight;
    public int deltaviewheight;
    public int bob;
    public int flyheight;
    public int lookdir;
    public boolean centering;
    public int[] health = new int[1];
    public int[] armorpoints = new int[1];
    public int armortype;
    public int[] powers;
    public boolean[] cards;
    public boolean backpack;
    public int[] frags;
    public weapontype_t readyweapon;
    public weapontype_t pendingweapon;
    public boolean[] weaponowned;
    public int[] ammo;
    public int[] maxammo;
    public boolean attackdown;
    public boolean usedown;
    public int cheats;
    public int refire;
    public int killcount;
    public int itemcount;
    public int secretcount;
    public String message;
    public int damagecount;
    public int bonuscount;
    public mobj_t attacker;
    public int extralight;
    public int fixedcolormap;
    public int colormap;
    public pspdef_t[] psprites;
    public boolean didsecret;
    private static int MAXBOB = 0x100000;
    protected static final int PLAYERTHRUST = 2048;
    public static final int[] clipammo = new int[]{10, 4, 20, 1};
    public static final int BONUSADD = 6;
    private static final long ANG5 = 0x38E38E3L;
    private int id = -1;
    private boolean onground;
    public static int ps_weapon = 0;
    public static int ps_flash = 1;
    public static int NUMPSPRITES = 2;
    public static int LOWERSPEED = 393216;
    public static int RAISESPEED = 393216;
    public static int WEAPONBOTTOM = 0x800000;
    public static int WEAPONTOP = 0x200000;
    private static int BFGCELLS = 40;
    int swingx;
    int swingy;
    private static StringBuilder sb = new StringBuilder();
    public int p_mobj;

    public player_t(DoomMain DOOM) {
        this.DOOM = DOOM;
        this.powers = new int[6];
        this.frags = new int[4];
        this.ammo = new int[Defines.NUMAMMO];
        this.maxammo = new int[Defines.NUMAMMO];
        this.cards = new boolean[card_t.NUMCARDS.ordinal()];
        this.weaponowned = new boolean[Defines.NUMWEAPONS];
        this.psprites = (pspdef_t[])GenericCopy.malloc(pspdef_t::new, pspdef_t[]::new, NUMPSPRITES);
        this.mo = mobj_t.createOn(DOOM);
        this.mo.player = this;
        this.readyweapon = weapontype_t.wp_fist;
        this.cmd = new ticcmd_t();
    }

    public void reset() {
        C2JUtils.memset(this.ammo, 0, this.ammo.length);
        C2JUtils.memset(this.armorpoints, 0, this.armorpoints.length);
        C2JUtils.memset(this.cards, false, this.cards.length);
        C2JUtils.memset(this.frags, 0, this.frags.length);
        C2JUtils.memset(this.health, 0, this.health.length);
        C2JUtils.memset(this.maxammo, 0, this.maxammo.length);
        C2JUtils.memset(this.powers, 0, this.powers.length);
        C2JUtils.memset(this.weaponowned, false, this.weaponowned.length);
        this.cheats = 0;
        this.armortype = 0;
        this.attackdown = false;
        this.attacker = null;
        this.backpack = false;
        this.bob = 0;
    }

    public player_t clone() throws CloneNotSupportedException {
        return (player_t)super.clone();
    }

    public void Thrust(long angle, int move) {
        this.mo.momx += fixed_t.FixedMul(move, Tables.finecosine(angle));
        this.mo.momy += fixed_t.FixedMul(move, Tables.finesine(angle));
    }

    public void MovePlayer() {
        int look;
        ticcmd_t cmd = this.cmd;
        this.mo.angle += (long)(cmd.angleturn << 16);
        this.mo.angle &= 0xFFFFFFFFL;
        boolean bl = this.onground = this.mo.z <= this.mo.floorz;
        if (cmd.forwardmove != 0 && this.onground) {
            this.Thrust(this.mo.angle, cmd.forwardmove * 2048);
        }
        if (cmd.sidemove != 0 && this.onground) {
            this.Thrust(this.mo.angle - 0x40000000L & 0xFFFFFFFFL, cmd.sidemove * 2048);
        }
        if ((cmd.forwardmove != 0 || cmd.sidemove != 0) && this.mo.mobj_state == info.states[statenum_t.S_PLAY.ordinal()]) {
            this.mo.SetMobjState(statenum_t.S_PLAY_RUN1);
        }
        if ((look = cmd.lookfly & 0xF) > 7) {
            look -= 16;
        }
        if (look != 0) {
            if (look == -8) {
                this.centering = true;
            } else {
                this.lookdir += 5 * look;
                if (this.lookdir > 90 || this.lookdir < -110) {
                    this.lookdir -= 5 * look;
                }
            }
        }
        if (this.centering) {
            if (this.lookdir > 0) {
                this.lookdir -= 8;
            } else if (this.lookdir < 0) {
                this.lookdir += 8;
            }
            if (Math.abs(this.lookdir) < 8) {
                this.lookdir = 0;
                this.centering = false;
            }
        }
    }

    public boolean GiveAmmo(ammotype_t amm, int num) {
        int ammo = amm.ordinal();
        if (ammo == ammotype_t.am_noammo.ordinal()) {
            return false;
        }
        if (ammo < 0 || ammo > Defines.NUMAMMO) {
            this.DOOM.doomSystem.Error("P_GiveAmmo: bad type %i", ammo);
        }
        if (this.ammo[ammo] == this.maxammo[ammo]) {
            return false;
        }
        num = num != 0 ? (num *= clipammo[ammo]) : clipammo[ammo] / 2;
        if (this.DOOM.gameskill == skill_t.sk_baby || this.DOOM.gameskill == skill_t.sk_nightmare) {
            num <<= 1;
        }
        int oldammo = this.ammo[ammo];
        int n = ammo;
        this.ammo[n] = this.ammo[n] + num;
        if (this.ammo[ammo] > this.maxammo[ammo]) {
            this.ammo[ammo] = this.maxammo[ammo];
        }
        if (oldammo != 0) {
            return true;
        }
        switch (ammotype_t.values()[ammo]) {
            case am_clip: {
                if (this.readyweapon != weapontype_t.wp_fist) break;
                if (this.weaponowned[weapontype_t.wp_chaingun.ordinal()]) {
                    this.pendingweapon = weapontype_t.wp_chaingun;
                    break;
                }
                this.pendingweapon = weapontype_t.wp_pistol;
                break;
            }
            case am_shell: {
                if (this.readyweapon != weapontype_t.wp_fist && this.readyweapon != weapontype_t.wp_pistol || !this.weaponowned[weapontype_t.wp_shotgun.ordinal()]) break;
                this.pendingweapon = weapontype_t.wp_shotgun;
                break;
            }
            case am_cell: {
                if (this.readyweapon != weapontype_t.wp_fist && this.readyweapon != weapontype_t.wp_pistol || !this.weaponowned[weapontype_t.wp_plasma.ordinal()]) break;
                this.pendingweapon = weapontype_t.wp_plasma;
                break;
            }
            case am_misl: {
                if (this.readyweapon != weapontype_t.wp_fist || !this.weaponowned[weapontype_t.wp_missile.ordinal()]) break;
                this.pendingweapon = weapontype_t.wp_missile;
            }
        }
        return true;
    }

    public boolean GiveWeapon(weapontype_t weapn, boolean dropped) {
        boolean gaveweapon;
        int weapon = weapn.ordinal();
        if (this.DOOM.netgame && !this.DOOM.deathmatch && !dropped) {
            if (this.weaponowned[weapon]) {
                return false;
            }
            this.bonuscount += 6;
            this.weaponowned[weapon] = true;
            if (this.DOOM.deathmatch) {
                this.GiveAmmo(items.weaponinfo[weapon].ammo, 5);
            } else {
                this.GiveAmmo(items.weaponinfo[weapon].ammo, 2);
            }
            this.pendingweapon = weapn;
            if (this == this.DOOM.players[this.DOOM.consoleplayer]) {
                this.DOOM.doomSound.StartSound(null, sounds.sfxenum_t.sfx_wpnup);
            }
            return false;
        }
        boolean gaveammo = items.weaponinfo[weapon].ammo != ammotype_t.am_noammo ? (dropped ? this.GiveAmmo(items.weaponinfo[weapon].ammo, 1) : this.GiveAmmo(items.weaponinfo[weapon].ammo, 2)) : false;
        if (this.weaponowned[weapon]) {
            gaveweapon = false;
        } else {
            gaveweapon = true;
            this.weaponowned[weapon] = true;
            this.pendingweapon = weapn;
        }
        return gaveweapon || gaveammo;
    }

    public boolean GiveBody(int num) {
        if (this.health[0] >= 100) {
            return false;
        }
        this.health[0] = this.health[0] + num;
        if (this.health[0] > 100) {
            this.health[0] = 100;
        }
        this.mo.health = this.health[0];
        return true;
    }

    public boolean GiveArmor(int armortype) {
        int hits = armortype * 100;
        if (this.armorpoints[0] >= hits) {
            return false;
        }
        this.armortype = armortype;
        this.armorpoints[0] = hits;
        return true;
    }

    public void GiveCard(card_t crd) {
        int card = crd.ordinal();
        if (this.cards[card]) {
            return;
        }
        this.bonuscount = 6;
        this.cards[card] = true;
    }

    public boolean GivePower(int power) {
        if (power == 0) {
            this.powers[power] = 1050;
            return true;
        }
        if (power == 2) {
            this.powers[power] = 2100;
            this.mo.flags |= 0x40000L;
            return true;
        }
        if (power == 5) {
            this.powers[power] = 4200;
            return true;
        }
        if (power == 3) {
            this.powers[power] = 2100;
            return true;
        }
        if (power == 1) {
            this.GiveBody(100);
            this.powers[power] = 1;
            return true;
        }
        if (this.powers[power] != 0) {
            return false;
        }
        this.powers[power] = 1;
        return true;
    }

    public final void PlayerFinishLevel() {
        C2JUtils.memset(this.powers, 0, this.powers.length);
        C2JUtils.memset(this.cards, false, this.cards.length);
        this.mo.flags &= 0xFFFFFFFFFFFBFFFFL;
        this.extralight = 0;
        this.fixedcolormap = 0;
        this.damagecount = 0;
        this.bonuscount = 0;
        this.lookdir = 0;
    }

    protected void PlayerInSpecialSector() {
        sector_t sector = this.mo.subsector.sector;
        if (this.mo.z != sector.floorheight) {
            return;
        }
        switch (sector.special) {
            case 5: {
                if (this.powers[3] != 0 || C2JUtils.flags(this.DOOM.leveltime, 31)) break;
                this.DOOM.actions.DamageMobj(this.mo, null, null, 10);
                break;
            }
            case 7: {
                if (this.powers[3] != 0 || C2JUtils.flags(this.DOOM.leveltime, 31)) break;
                this.DOOM.actions.DamageMobj(this.mo, null, null, 5);
                break;
            }
            case 4: 
            case 16: {
                if (C2JUtils.eval(this.powers[3]) && this.DOOM.random.P_Random() >= 5 || C2JUtils.flags(this.DOOM.leveltime, 31)) break;
                this.DOOM.actions.DamageMobj(this.mo, null, null, 20);
                break;
            }
            case 9: {
                ++this.secretcount;
                sector.special = 0;
                break;
            }
            case 11: {
                this.cheats &= 0xFFFFFFFD;
                if (!C2JUtils.flags(this.DOOM.leveltime, 31)) {
                    this.DOOM.actions.DamageMobj(this.mo, null, null, 20);
                }
                if (this.health[0] > 10) break;
                this.DOOM.ExitLevel();
                break;
            }
            default: {
                this.DOOM.doomSystem.Error("P_PlayerInSpecialSector: unknown special %d", sector.special);
            }
        }
    }

    public void CalcHeight() {
        this.bob = fixed_t.FixedMul(this.mo.momx, this.mo.momx) + fixed_t.FixedMul(this.mo.momy, this.mo.momy);
        this.bob >>= 2;
        if (this.bob > MAXBOB) {
            this.bob = MAXBOB;
        }
        if (C2JUtils.flags(this.cheats, 4) || !this.onground) {
            this.viewz = this.mo.z + 0x290000;
            if (this.viewz > this.mo.ceilingz - 262144) {
                this.viewz = this.mo.ceilingz - 262144;
            }
            this.viewz = this.mo.z + this.viewheight;
            return;
        }
        int angle = 409 * this.DOOM.leveltime & 0x1FFF;
        int bob = fixed_t.FixedMul(this.bob / 2, Tables.finesine[angle]);
        if (this.playerstate == 0) {
            this.viewheight += this.deltaviewheight;
            if (this.viewheight > 0x290000) {
                this.viewheight = 0x290000;
                this.deltaviewheight = 0;
            }
            if (this.viewheight < 1343488) {
                this.viewheight = 1343488;
                if (this.deltaviewheight <= 0) {
                    this.deltaviewheight = 1;
                }
            }
            if (this.deltaviewheight != 0) {
                this.deltaviewheight += 16384;
                if (this.deltaviewheight == 0) {
                    this.deltaviewheight = 1;
                }
            }
        }
        this.viewz = this.mo.z + this.viewheight + bob;
        if (this.viewz > this.mo.ceilingz - 262144) {
            this.viewz = this.mo.ceilingz - 262144;
        }
    }

    public void DeathThink() {
        this.MovePsprites();
        if (this.viewheight > 393216) {
            this.viewheight -= 65536;
        }
        if (this.viewheight < 393216) {
            this.viewheight = 393216;
        }
        this.deltaviewheight = 0;
        this.onground = this.mo.z <= this.mo.floorz;
        this.CalcHeight();
        if (this.attacker != null && this.attacker != this.mo) {
            long angle = this.DOOM.sceneRenderer.PointToAngle2(this.mo.x, this.mo.y, this.attacker.x, this.attacker.y);
            long delta = Tables.addAngles(angle, -this.mo.angle);
            if (delta < 0x38E38E3L || delta > -59652323L) {
                this.mo.angle = angle;
                if (this.damagecount != 0) {
                    --this.damagecount;
                }
            } else {
                this.mo.angle = delta < 0x80000000L ? (this.mo.angle += 0x38E38E3L) : (this.mo.angle -= 0x38E38E3L);
            }
        } else if (this.damagecount != 0) {
            --this.damagecount;
        }
        if (C2JUtils.flags(this.cmd.buttons, 2)) {
            this.playerstate = 2;
        }
    }

    public void MovePsprites() {
        state_t state = null;
        for (int i = 0; i < NUMPSPRITES; ++i) {
            pspdef_t psp = this.psprites[i];
            state = psp.state;
            if (state == null || psp.tics == -1) continue;
            --psp.tics;
            if (C2JUtils.eval(psp.tics)) continue;
            this.SetPsprite(i, psp.state.nextstate);
        }
        this.psprites[player_t.ps_flash].sx = this.psprites[player_t.ps_weapon].sx;
        this.psprites[player_t.ps_flash].sy = this.psprites[player_t.ps_weapon].sy;
    }

    public void SetPsprite(int position, statenum_t newstate) {
        pspdef_t psp = this.psprites[position];
        do {
            state_t state;
            if (!C2JUtils.eval((Object)newstate)) {
                psp.state = null;
                break;
            }
            psp.state = state = info.states[newstate.ordinal()];
            psp.tics = state.tics;
            if (C2JUtils.eval(state.misc1)) {
                psp.sx = state.misc1 << 16;
                psp.sy = state.misc2 << 16;
            }
            if (state.action.isParamType(ActiveStates.PlayerSpriteConsumer.class)) {
                state.action.fun(ActiveStates.PlayerSpriteConsumer.class).accept(this.DOOM.actions, this, psp);
                if (!C2JUtils.eval(psp.state)) break;
            }
            newstate = psp.state.nextstate;
        } while (!C2JUtils.eval(psp.tics));
    }

    public int identify() {
        int i;
        if (this.id >= 0) {
            return this.id;
        }
        for (i = 0; i < this.DOOM.players.length && this != this.DOOM.players[i]; ++i) {
        }
        this.id = i;
        return this.id;
    }

    public void CalcSwing(player_t player) {
        int swing = this.bob;
        int angle = 117 * this.DOOM.leveltime & 0x1FFF;
        this.swingx = fixed_t.FixedMul(swing, Tables.finesine[angle]);
        angle = 117 * this.DOOM.leveltime + 4096 & 0x1FFF;
        this.swingy = -fixed_t.FixedMul(this.swingx, Tables.finesine[angle]);
    }

    public void BringUpWeapon() {
        if (this.pendingweapon == weapontype_t.wp_nochange) {
            this.pendingweapon = this.readyweapon;
        }
        if (this.pendingweapon == weapontype_t.wp_chainsaw) {
            this.DOOM.doomSound.StartSound((ISoundOrigin)this.mo, sounds.sfxenum_t.sfx_sawup);
        }
        statenum_t newstate = items.weaponinfo[this.pendingweapon.ordinal()].upstate;
        this.pendingweapon = weapontype_t.wp_nochange;
        this.psprites[player_t.ps_weapon].sy = WEAPONBOTTOM;
        this.SetPsprite(ps_weapon, newstate);
    }

    public boolean CheckAmmo() {
        ammotype_t ammo = items.weaponinfo[this.readyweapon.ordinal()].ammo;
        int count = this.readyweapon == weapontype_t.wp_bfg ? BFGCELLS : (this.readyweapon == weapontype_t.wp_supershotgun ? 2 : 1);
        if (ammo == ammotype_t.am_noammo || this.ammo[ammo.ordinal()] >= count) {
            return true;
        }
        do {
            this.pendingweapon = this.weaponowned[weapontype_t.wp_plasma.ordinal()] && this.ammo[ammotype_t.am_cell.ordinal()] != 0 && !this.DOOM.isShareware() ? weapontype_t.wp_plasma : (this.weaponowned[weapontype_t.wp_supershotgun.ordinal()] && this.ammo[ammotype_t.am_shell.ordinal()] > 2 && this.DOOM.isCommercial() ? weapontype_t.wp_supershotgun : (this.weaponowned[weapontype_t.wp_chaingun.ordinal()] && this.ammo[ammotype_t.am_clip.ordinal()] != 0 ? weapontype_t.wp_chaingun : (this.weaponowned[weapontype_t.wp_shotgun.ordinal()] && this.ammo[ammotype_t.am_shell.ordinal()] != 0 ? weapontype_t.wp_shotgun : (this.ammo[ammotype_t.am_clip.ordinal()] != 0 ? weapontype_t.wp_pistol : (this.weaponowned[weapontype_t.wp_chainsaw.ordinal()] ? weapontype_t.wp_chainsaw : (this.weaponowned[weapontype_t.wp_missile.ordinal()] && this.ammo[ammotype_t.am_misl.ordinal()] != 0 ? weapontype_t.wp_missile : (this.weaponowned[weapontype_t.wp_bfg.ordinal()] && this.ammo[ammotype_t.am_cell.ordinal()] > 40 && !this.DOOM.isShareware() ? weapontype_t.wp_bfg : weapontype_t.wp_fist)))))));
        } while (this.pendingweapon == weapontype_t.wp_nochange);
        this.SetPsprite(ps_weapon, items.weaponinfo[this.readyweapon.ordinal()].downstate);
        return false;
    }

    public void DropWeapon() {
        this.SetPsprite(ps_weapon, items.weaponinfo[this.readyweapon.ordinal()].downstate);
    }

    public void SetupPsprites() {
        for (int i = 0; i < NUMPSPRITES; ++i) {
            this.psprites[i].state = null;
        }
        this.pendingweapon = this.readyweapon;
        this.BringUpWeapon();
    }

    public void PlayerThink(player_t player) {
        player.mo.flags = C2JUtils.flags(player.cheats, 1) ? (player.mo.flags |= 0x1000L) : (player.mo.flags &= 0xFFFFFFFFFFFFEFFFL);
        ticcmd_t cmd = player.cmd;
        if (C2JUtils.flags(player.mo.flags, 128L)) {
            cmd.angleturn = 0;
            cmd.forwardmove = (byte)100;
            cmd.sidemove = 0;
            player.mo.flags &= 0xFFFFFFFFFFFFFF7FL;
        }
        if (player.playerstate == 1) {
            player.DeathThink();
            return;
        }
        if (C2JUtils.eval(player.mo.reactiontime)) {
            --player.mo.reactiontime;
        } else {
            player.MovePlayer();
        }
        player.CalcHeight();
        if (C2JUtils.eval(player.mo.subsector.sector.special)) {
            player.PlayerInSpecialSector();
        }
        if (C2JUtils.flags(cmd.buttons, 128)) {
            cmd.buttons = '\u0000';
        }
        if (C2JUtils.flags(cmd.buttons, 4)) {
            weapontype_t newweapon = weapontype_t.values()[(cmd.buttons & 0x38) >> 3];
            if (newweapon == weapontype_t.wp_fist && player.weaponowned[weapontype_t.wp_chainsaw.ordinal()] && (player.readyweapon != weapontype_t.wp_chainsaw || !C2JUtils.eval(player.powers[1]))) {
                newweapon = weapontype_t.wp_chainsaw;
            }
            if (this.DOOM.isCommercial() && newweapon == weapontype_t.wp_shotgun && player.weaponowned[weapontype_t.wp_supershotgun.ordinal()] && player.readyweapon != weapontype_t.wp_supershotgun) {
                newweapon = weapontype_t.wp_supershotgun;
            }
            if (player.weaponowned[newweapon.ordinal()] && newweapon != player.readyweapon && (newweapon != weapontype_t.wp_plasma && newweapon != weapontype_t.wp_bfg || !this.DOOM.isShareware())) {
                player.pendingweapon = newweapon;
            }
        }
        if (C2JUtils.flags(cmd.buttons, 2)) {
            if (!player.usedown) {
                this.DOOM.actions.UseLines(player);
                player.usedown = true;
            }
        } else {
            player.usedown = false;
        }
        player.MovePsprites();
        if (C2JUtils.eval(player.powers[1])) {
            player.powers[1] = player.powers[1] + 1;
        }
        if (C2JUtils.eval(player.powers[0])) {
            player.powers[0] = player.powers[0] - 1;
        }
        if (C2JUtils.eval(player.powers[2]) && !C2JUtils.eval(player.powers[2] = player.powers[2] - 1)) {
            player.mo.flags &= 0xFFFFFFFFFFFBFFFFL;
        }
        if (C2JUtils.eval(player.powers[5])) {
            player.powers[5] = player.powers[5] - 1;
        }
        if (C2JUtils.eval(player.powers[3])) {
            player.powers[3] = player.powers[3] - 1;
        }
        if (C2JUtils.eval(player.damagecount)) {
            --player.damagecount;
        }
        if (C2JUtils.eval(player.bonuscount)) {
            --player.bonuscount;
        }
        player.fixedcolormap = C2JUtils.eval(player.powers[0]) ? (player.powers[0] > 128 || C2JUtils.flags(player.powers[0], 8) ? 32 : 0) : (C2JUtils.eval(player.powers[5]) ? (player.powers[5] > 128 || C2JUtils.flags(player.powers[5], 8) ? 1 : 0) : 0);
    }

    public void PlayerReborn() {
        int[] localFrags = new int[4];
        C2JUtils.memcpy(localFrags, this.frags, localFrags.length);
        int localKillCount = this.killcount;
        int localItemCount = this.itemcount;
        int localSecretCount = this.secretcount;
        this.reset();
        C2JUtils.memcpy(this.frags, localFrags, this.frags.length);
        this.killcount = localKillCount;
        this.itemcount = localItemCount;
        this.secretcount = localSecretCount;
        this.attackdown = true;
        this.usedown = true;
        this.playerstate = 0;
        this.health[0] = 100;
        this.readyweapon = this.pendingweapon = weapontype_t.wp_pistol;
        this.weaponowned[weapontype_t.wp_fist.ordinal()] = true;
        this.weaponowned[weapontype_t.wp_pistol.ordinal()] = true;
        this.ammo[ammotype_t.am_clip.ordinal()] = 50;
        this.lookdir = 0;
        System.arraycopy(DoomStatus.maxammo, 0, this.maxammo, 0, Defines.NUMAMMO);
    }

    public void PlayerThink() {
        this.PlayerThink(this);
    }

    public String toString() {
        sb.setLength(0);
        sb.append("player");
        sb.append(" momx ");
        sb.append(this.mo.momx);
        sb.append(" momy ");
        sb.append(this.mo.momy);
        sb.append(" x ");
        sb.append(this.mo.x);
        sb.append(" y ");
        sb.append(this.mo.y);
        return sb.toString();
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        this.p_mobj = DoomIO.readLEInt(f);
        this.playerstate = DoomIO.readLEInt(f);
        this.cmd.read(f);
        this.viewz = DoomIO.readLEInt(f);
        this.viewheight = DoomIO.readLEInt(f);
        this.deltaviewheight = DoomIO.readLEInt(f);
        this.bob = DoomIO.readLEInt(f);
        this.health[0] = DoomIO.readLEInt(f);
        this.armorpoints[0] = DoomIO.readLEInt(f);
        this.armortype = DoomIO.readLEInt(f);
        DoomIO.readIntArray(f, this.powers, ByteOrder.LITTLE_ENDIAN);
        DoomIO.readBooleanIntArray(f, this.cards);
        this.backpack = DoomIO.readIntBoolean(f);
        DoomIO.readIntArray(f, this.frags, ByteOrder.LITTLE_ENDIAN);
        this.readyweapon = weapontype_t.values()[DoomIO.readLEInt(f)];
        this.pendingweapon = weapontype_t.values()[DoomIO.readLEInt(f)];
        DoomIO.readBooleanIntArray(f, this.weaponowned);
        DoomIO.readIntArray(f, this.ammo, ByteOrder.LITTLE_ENDIAN);
        DoomIO.readIntArray(f, this.maxammo, ByteOrder.LITTLE_ENDIAN);
        this.attackdown = DoomIO.readIntBoolean(f);
        this.usedown = DoomIO.readIntBoolean(f);
        this.cheats = DoomIO.readLEInt(f);
        this.refire = DoomIO.readLEInt(f);
        this.killcount = DoomIO.readLEInt(f);
        this.itemcount = DoomIO.readLEInt(f);
        this.secretcount = DoomIO.readLEInt(f);
        f.skipBytes(4);
        this.damagecount = DoomIO.readLEInt(f);
        this.bonuscount = DoomIO.readLEInt(f);
        f.skipBytes(4);
        this.extralight = DoomIO.readLEInt(f);
        this.fixedcolormap = DoomIO.readLEInt(f);
        this.colormap = DoomIO.readLEInt(f);
        for (pspdef_t p : this.psprites) {
            p.read(f);
        }
        this.didsecret = DoomIO.readIntBoolean(f);
    }

    public void write(DataOutputStream f) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(280);
        this.pack(b);
        f.write(b.array());
    }

    @Override
    public void pack(ByteBuffer buf) throws IOException {
        ByteOrder bo = ByteOrder.LITTLE_ENDIAN;
        buf.order(bo);
        buf.putInt(C2JUtils.pointer(this.mo));
        buf.putInt(this.playerstate);
        this.cmd.pack(buf);
        buf.putInt(this.viewz);
        buf.putInt(this.viewheight);
        buf.putInt(this.deltaviewheight);
        buf.putInt(this.bob);
        buf.putInt(this.health[0]);
        buf.putInt(this.armorpoints[0]);
        buf.putInt(this.armortype);
        DoomBuffer.putIntArray(buf, this.powers, this.powers.length, bo);
        DoomBuffer.putBooleanIntArray(buf, this.cards, this.cards.length, bo);
        DoomBuffer.putBooleanInt(buf, this.backpack, bo);
        DoomBuffer.putIntArray(buf, this.frags, this.frags.length, bo);
        buf.putInt(this.readyweapon.ordinal());
        buf.putInt(this.pendingweapon.ordinal());
        DoomBuffer.putBooleanIntArray(buf, this.weaponowned, this.weaponowned.length, bo);
        DoomBuffer.putIntArray(buf, this.ammo, this.ammo.length, bo);
        DoomBuffer.putIntArray(buf, this.maxammo, this.maxammo.length, bo);
        DoomBuffer.putBooleanInt(buf, this.attackdown, bo);
        DoomBuffer.putBooleanInt(buf, this.usedown, bo);
        buf.putInt(this.cheats);
        buf.putInt(this.refire);
        buf.putInt(this.killcount);
        buf.putInt(this.itemcount);
        buf.putInt(this.secretcount);
        buf.putInt(0);
        buf.putInt(this.damagecount);
        buf.putInt(this.bonuscount);
        buf.putInt(C2JUtils.pointer(this.attacker));
        buf.putInt(this.extralight);
        buf.putInt(this.fixedcolormap);
        buf.putInt(this.colormap);
        for (pspdef_t p : this.psprites) {
            p.pack(buf);
        }
        buf.putInt(this.didsecret ? 1 : 0);
    }
}

