/*
 * Decompiled with CFR 0.152.
 */
package doom;

import doom.IDatagramSerializable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import w.CacheableDoomObject;
import w.IReadableDoomObject;

public class ticcmd_t
implements IDatagramSerializable,
IReadableDoomObject,
CacheableDoomObject {
    public static final int TICCMDLEN = 8;
    public byte forwardmove;
    public byte sidemove;
    public short angleturn;
    public short consistancy;
    public char chatchar;
    public char buttons;
    public char lookfly;
    private byte[] buffer = new byte[8];
    private static StringBuilder sb = new StringBuilder();
    private static ByteBuffer iobuffer = ByteBuffer.allocate(8);

    public int getChecksum(ticcmd_t cmd) {
        int sum = 0;
        sum += this.forwardmove;
        sum += this.sidemove;
        sum += this.angleturn;
        sum += this.consistancy;
        sum += this.chatchar;
        return sum += this.buttons;
    }

    public void copyTo(ticcmd_t dest) {
        dest.forwardmove = this.forwardmove;
        dest.sidemove = this.sidemove;
        dest.angleturn = this.angleturn;
        dest.consistancy = this.consistancy;
        dest.chatchar = this.chatchar;
        dest.buttons = this.buttons;
        dest.lookfly = this.lookfly;
    }

    public String toString() {
        sb.setLength(0);
        sb.append(" forwardmove ");
        sb.append(Integer.toHexString(this.forwardmove));
        sb.append(" sidemove ");
        sb.append(Integer.toHexString(this.sidemove));
        sb.append(" angleturn ");
        sb.append(Integer.toHexString(this.angleturn));
        sb.append(" consistancy ");
        sb.append(Integer.toHexString(this.consistancy));
        sb.append(" chatchar ");
        sb.append(this.chatchar);
        sb.append(" buttons ");
        sb.append(Integer.toHexString(this.buttons));
        return sb.toString();
    }

    @Override
    public byte[] pack() {
        this.buffer[0] = this.forwardmove;
        this.buffer[1] = this.sidemove;
        this.buffer[2] = (byte)(this.angleturn >>> 8);
        this.buffer[3] = (byte)(this.angleturn & 0xFF);
        this.buffer[4] = (byte)(this.consistancy >>> 8);
        this.buffer[5] = (byte)(this.consistancy & 0xFF);
        this.buffer[6] = (byte)(this.chatchar & 0xFF);
        this.buffer[7] = (byte)(this.buttons & 0xFF);
        return this.buffer;
    }

    @Override
    public void pack(byte[] buf, int offset) {
        buf[0 + offset] = this.forwardmove;
        buf[1 + offset] = this.sidemove;
        buf[2 + offset] = (byte)(this.angleturn >>> 8);
        buf[3 + offset] = (byte)(this.angleturn & 0xFF);
        buf[4 + offset] = (byte)(this.consistancy >>> 8);
        buf[5 + offset] = (byte)(this.consistancy & 0xFF);
        buf[6 + offset] = (byte)(this.chatchar & 0xFF);
        buf[7 + offset] = (byte)(this.buttons & 0xFF);
    }

    @Override
    public void unpack(byte[] buf) {
        this.unpack(buf, 0);
    }

    @Override
    public void unpack(byte[] buf, int offset) {
        this.forwardmove = buf[0 + offset];
        this.sidemove = buf[1 + offset];
        this.angleturn = (short)(buf[2 + offset] << 8 | buf[3 + offset]);
        this.consistancy = (short)(buf[4 + offset] << 8 | buf[5 + offset]);
        this.chatchar = (char)(0xFF & buf[6 + offset]);
        this.buttons = (char)(0xFF & buf[7 + offset]);
    }

    @Override
    public byte[] cached() {
        return this.buffer;
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        iobuffer.position(0);
        iobuffer.order(ByteOrder.LITTLE_ENDIAN);
        f.read(iobuffer.array());
        this.unpack(iobuffer);
    }

    @Override
    public void unpack(ByteBuffer f) throws IOException {
        f.order(ByteOrder.LITTLE_ENDIAN);
        this.forwardmove = f.get();
        this.sidemove = f.get();
        this.angleturn = f.getShort();
        this.consistancy = f.getShort();
        this.chatchar = (char)f.get();
        this.buttons = (char)f.get();
    }

    public void pack(ByteBuffer f) throws IOException {
        f.order(ByteOrder.LITTLE_ENDIAN);
        f.put(this.forwardmove);
        f.put(this.sidemove);
        f.putShort(this.angleturn);
        f.putShort(this.consistancy);
        f.put((byte)this.chatchar);
        f.put((byte)this.buttons);
    }
}

