/*
 * Decompiled with CFR 0.152.
 */
package g;

import doom.event_t;
import doom.evtype_t;
import java.awt.event.KeyEvent;

public class Signals {
    private static final byte[] map = new byte[65535];
    private static final byte[] siblings = new byte[254];

    public static ScanCode getScanCode(KeyEvent e) {
        ScanCode ret = ScanCode.v[map[e.getKeyCode()] & 0xFF];
        if (ret.location == e.getKeyLocation()) {
            return ret;
        }
        ScanCode sib = ScanCode.v[siblings[ret.ordinal()] & 0xFF];
        if (sib.location == e.getKeyLocation()) {
            return sib;
        }
        return ScanCode.SC_NULL;
    }

    private Signals() {
    }

    public static enum ScanCode {
        SC_NULL,
        SC_ESCAPE(27, new int[0]),
        SC_1(49, new int[0]),
        SC_2(50, new int[0]),
        SC_3(51, new int[0]),
        SC_4(52, new int[0]),
        SC_5(53, new int[0]),
        SC_6(54, new int[0]),
        SC_7(55, new int[0]),
        SC_8(56, new int[0]),
        SC_9(57, new int[0]),
        SC_0(48, new int[0]),
        SC_MINUS(45, new int[0]),
        SC_EQUALS(61, new int[0]),
        SC_BACKSPACE(8, new int[0]),
        SC_TAB(9, new int[0]),
        SC_Q(81, new int[0]),
        SC_W(87, new int[0]),
        SC_E(69, new int[0]),
        SC_R(82, new int[0]),
        SC_T(84, new int[0]),
        SC_Y(89, new int[0]),
        SC_U(85, new int[0]),
        SC_I(73, new int[0]),
        SC_O(79, new int[0]),
        SC_P(80, new int[0]),
        SC_LBRACE(91, new int[0]),
        SC_RBRACE(93, new int[0]),
        SC_ENTER(10, new int[0]),
        SC_LCTRL(17, 2, 128),
        SC_A(65, new int[0]),
        SC_S(83, new int[0]),
        SC_D(68, new int[0]),
        SC_F(70, new int[0]),
        SC_G(71, new int[0]),
        SC_H(72, new int[0]),
        SC_J(74, new int[0]),
        SC_K(75, new int[0]),
        SC_L(76, new int[0]),
        SC_SEMICOLON(59, new int[0]),
        SC_QUOTE(222, new int[0]),
        SC_TILDE(192, new int[0]),
        SC_LSHIFT(16, 2, 64),
        SC_BACKSLASH(92, new int[0]),
        SC_Z(90, new int[0]),
        SC_X(88, new int[0]),
        SC_C(67, new int[0]),
        SC_V(86, new int[0]),
        SC_B(66, new int[0]),
        SC_N(78, new int[0]),
        SC_M(77, new int[0]),
        SC_COMMA(44, new int[0]),
        SC_PERIOD(46, new int[0]),
        SC_SLASH(47, new int[0]),
        SC_RSHIFT(16, 3, 64),
        SC_NPMULTIPLY(106, 4),
        SC_LALT(18, 2, 512),
        SC_SPACE(32, new int[0]),
        SC_CAPSLK(20, new int[0]),
        SC_F1(112, new int[0]),
        SC_F2(113, new int[0]),
        SC_F3(114, new int[0]),
        SC_F4(115, new int[0]),
        SC_F5(116, new int[0]),
        SC_F6(117, new int[0]),
        SC_F7(118, new int[0]),
        SC_F8(119, new int[0]),
        SC_F9(120, new int[0]),
        SC_F10(121, new int[0]),
        SC_NUMLK(144, new int[0]),
        SC_SCROLLLK(145, new int[0]),
        SC_NUMKEY7(103, 4),
        SC_NUMKEY8(104, 4),
        SC_NUMKEY9(105, 4),
        SC_NPMINUS(45, 4),
        SC_NUMKEY4(100, 4),
        SC_NUMKEY5(101, 4),
        SC_NUMKEY6(102, 4),
        SC_NPPLUS(521, 4),
        SC_NUMKEY1(97, 4),
        SC_NUMKEY2(98, 4),
        SC_NUMKEY3(99, 4),
        SC_NUMKEY0(96, 4),
        SC_NPDOT(46, 4),
        SC_54,
        SC_55,
        SC_56,
        SC_F11(122, new int[0]),
        SC_F12(123, new int[0]),
        SC_ROMAN(245, new int[0]),
        SC_KATAKANA(241, new int[0]),
        SC_HIRAGANA(242, new int[0]),
        SC_5C,
        SC_5D,
        SC_5E,
        SC_5F,
        SC_NPENTER(10, 4),
        SC_RCTRL(17, 3, 128),
        SC_NPSLASH(47, 4),
        SC_PRTSCRN(154, new int[0]),
        SC_RALT(18, 3, 512),
        SC_64,
        SC_HOME(36, new int[0]),
        SC_UP(38, new int[0]),
        SC_PGUP(33, new int[0]),
        SC_LEFT(37, new int[0]),
        SC_RIGHT(39, new int[0]),
        SC_END(35, new int[0]),
        SC_DOWN(40, new int[0]),
        SC_PGDOWN(34, new int[0]),
        SC_INSERT(155, new int[0]),
        SC_DELETE(127, new int[0]),
        SC_MACRO(132, new int[0]),
        SC_71,
        SC_72,
        SC_73,
        SC_74,
        SC_NPEQUALS(61, 4),
        SC_76,
        SC_PAUSE(19, new int[0]),
        SC_78,
        SC_NPCOMMA(44, 4),
        SC_7A,
        SC_7B,
        SC_7C,
        SC_LWIN(524, 2, 256),
        SC_RWIN(524, 3, 256),
        SC_COMPOSE(65312, new int[0]),
        SC_STOP(65480, new int[0]),
        SC_AGAIN(65481, new int[0]),
        SC_PROPS(65482, new int[0]),
        SC_UNDO(65483, new int[0]),
        SC_84,
        SC_COPY(65485, new int[0]),
        SC_86,
        SC_PASTE(65487, new int[0]),
        SC_FIND(65488, new int[0]),
        SC_CUT(65489, new int[0]),
        SC_HELP(156, new int[0]),
        SC_MENU(525, new int[0]),
        SC_LMETA(157, 2, 256),
        SC_RMETA(157, 3, 256);

        public final char c;
        public final event_t doomEventUp;
        public final event_t doomEventDown;
        private final int location;
        private final char virtualKey;
        private static final ScanCode[] v;

        private ScanCode() {
            this.doomEventUp = this.doomEventDown = event_t.EMPTY_EVENT;
            this.virtualKey = '\u0000';
            this.c = '\u0000';
            this.location = '\u0000';
        }

        private ScanCode(int virtualKey, int ... properties) {
            this.location = properties.length > 0 ? properties[0] : 1;
            this.virtualKey = (char)virtualKey;
            this.doomEventUp = new event_t.keyevent_t(evtype_t.ev_keyup, this);
            this.doomEventDown = new event_t.keyevent_t(evtype_t.ev_keydown, this);
            this.c = Character.toLowerCase(this.virtualKey);
            if (map[virtualKey] != 0) {
                siblings[this.ordinal()] = map[virtualKey];
            }
            map[virtualKey] = (byte)this.ordinal();
        }

        static {
            v = ScanCode.values();
        }
    }

    @FunctionalInterface
    public static interface SignalListener {
        public void sendEvent(ScanCode var1, int var2);
    }
}

