/*
 * Decompiled with CFR 0.152.
 */
package m;

import utils.C2JUtils;

public class DoomSetting
implements Comparable<DoomSetting> {
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int DOUBLE = 4;
    public static final int INTEGER = 8;
    public static final int STRING = 16;
    private String name;
    private int typeflag;
    private int int_val;
    private long long_val;
    private char char_val;
    private double double_val;
    private boolean boolean_val;
    private String string_val;
    private boolean persist;
    public static DoomSetting NULL_SETTING = new DoomSetting("NULL", "", false);

    public DoomSetting(String name, String value, boolean persist) {
        this.name = name;
        this.typeflag = 16;
        this.updateValue(value);
        this.persist = persist;
    }

    public String getName() {
        return this.name;
    }

    public int getInteger() {
        return this.int_val;
    }

    public long getLong() {
        return this.long_val;
    }

    public char getChar() {
        return (char)this.int_val;
    }

    public String getString() {
        return this.string_val;
    }

    public double getDouble() {
        return this.double_val;
    }

    public boolean getBoolean() {
        return this.boolean_val;
    }

    public boolean getPersist() {
        return this.persist;
    }

    public int getTypeFlag() {
        return this.typeflag;
    }

    public void updateValue(String value) {
        boolean quoted = false;
        if (value.length() > 2) {
            quoted = C2JUtils.isQuoted(value, '\"');
            if (quoted) {
                value = C2JUtils.unquote(value, '\"');
            } else {
                quoted = C2JUtils.isQuoted(value, '\'');
                if (quoted) {
                    value = C2JUtils.unquote(value, '\'');
                }
            }
        }
        this.string_val = value;
        if (quoted && value.length() == 1 && value.charAt(0) >= '\u0000' && value.charAt(0) < '\u00ff') {
            this.char_val = Character.toLowerCase(value.charAt(0));
            this.int_val = this.char_val;
            this.long_val = this.char_val;
            this.double_val = this.char_val;
            this.typeflag |= 2;
            return;
        }
        try {
            this.int_val = Integer.parseInt(value);
            this.typeflag |= 8;
        }
        catch (NumberFormatException e) {
            this.int_val = -1;
        }
        try {
            this.long_val = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            try {
                this.long_val = Long.decode(value);
                this.typeflag |= 8;
            }
            catch (NumberFormatException h) {
                this.long_val = -1L;
            }
        }
        try {
            this.double_val = Double.parseDouble(value);
            this.typeflag |= 4;
        }
        catch (NumberFormatException e) {
            this.double_val = Double.NaN;
        }
        this.int_val = (int)this.long_val;
        this.char_val = (char)this.int_val;
        boolean bl = this.boolean_val = this.int_val == 1;
        if (Boolean.parseBoolean(value) || value.compareToIgnoreCase("false") == 0) {
            this.boolean_val = this.int_val == 1 || Boolean.parseBoolean(value);
            this.typeflag |= 1;
        }
    }

    public boolean isIntegerNumeric() {
        try {
            this.long_val = Long.parseLong(this.string_val);
        }
        catch (NumberFormatException e) {
            try {
                Long.decode(this.string_val);
            }
            catch (NumberFormatException h) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(DoomSetting o) {
        return this.name.compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return this.string_val;
    }

    static {
        DoomSetting.NULL_SETTING.typeflag = 31;
        DoomSetting.NULL_SETTING.string_val = "";
        DoomSetting.NULL_SETTING.char_val = '\u0000';
        DoomSetting.NULL_SETTING.double_val = 0.0;
        DoomSetting.NULL_SETTING.boolean_val = false;
        DoomSetting.NULL_SETTING.int_val = 0;
        DoomSetting.NULL_SETTING.long_val = 0L;
    }
}

