/*
 * Decompiled with CFR 0.152.
 */
package m;

import i.DoomSystem;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.ImageIO;
import m.pcx_t;
import w.IWritableDoomObject;

public abstract class MenuMisc {
    public static final String rcsid = "$Id: MenuMisc.java,v 1.29 2012/09/24 17:16:22 velktron Exp $";

    public static boolean WriteFile(String name, byte[] source, int length) {
        try {
            FileOutputStream handle = new FileOutputStream(name);
            ((OutputStream)handle).write(source, 0, length);
            ((OutputStream)handle).close();
        }
        catch (Exception e) {
            DoomSystem.MiscError("Couldn't write file %s (%s)", name, e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean WriteFile(String name, IWritableDoomObject source) {
        try {
            DataOutputStream handle = new DataOutputStream(new FileOutputStream(name));
            source.write(handle);
            handle.close();
        }
        catch (Exception e) {
            DoomSystem.MiscError("Couldn't write file %s (%s)", name, e.getMessage());
            return false;
        }
        return true;
    }

    public static ByteBuffer ReadFile(String name) {
        ByteBuffer buf;
        try {
            BufferedInputStream handle = new BufferedInputStream(new FileInputStream(name));
            int length = handle.available();
            buf = ByteBuffer.allocate(length);
            handle.read(buf.array());
            handle.close();
        }
        catch (Exception e) {
            DoomSystem.MiscError("Couldn't read file %s (%s)", name, e.getMessage());
            return null;
        }
        return buf;
    }

    public static int ReadFile(String name, byte[] buffer) {
        int count;
        byte[] buf;
        int length;
        try {
            BufferedInputStream handle = new BufferedInputStream(new FileInputStream(name));
            length = handle.available();
            buf = new byte[length];
            count = handle.read(buf);
            handle.close();
            if (count < length) {
                throw new Exception("Read only " + count + " bytes out of " + length);
            }
        }
        catch (Exception e) {
            DoomSystem.MiscError("Couldn't read file %s (%s)", name, e.getMessage());
            return -1;
        }
        System.arraycopy(buf, 0, buffer, 0, Math.min(count, buffer.length));
        return length;
    }

    public static void WritePCXfile(String filename, byte[] data, int width, int height, byte[] palette) {
        int i;
        pcx_t pcx = new pcx_t();
        byte[] pack = new byte[width * height * 2];
        pcx.manufacturer = (byte)10;
        pcx.version = (byte)5;
        pcx.encoding = 1;
        pcx.bits_per_pixel = (byte)8;
        pcx.xmin = '\u0000';
        pcx.ymin = '\u0000';
        pcx.xmax = (char)(width - 1);
        pcx.ymax = (char)(height - 1);
        pcx.hres = (char)width;
        pcx.vres = (char)height;
        pcx.color_planes = 1;
        pcx.bytes_per_line = (char)width;
        pcx.palette_type = (char)2;
        int p_pack = 0;
        for (i = 0; i < width * height; ++i) {
            if ((data[i] & 0xC0) != 192) {
                pack[p_pack++] = data[i];
                continue;
            }
            pack[p_pack++] = -63;
            pack[p_pack++] = data[i];
        }
        pack[p_pack++] = 12;
        for (i = 0; i < 768; ++i) {
            pack[p_pack++] = palette[i];
        }
        int length = p_pack;
        pcx.data = Arrays.copyOf(pack, length);
        DataOutputStream f = null;
        try {
            f = new DataOutputStream(new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            pcx.write(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract boolean getShowMessages();

    public abstract void setShowMessages(boolean var1);

    public static void WritePNGfile(String imagename, short[] linear, int width, int height) {
        BufferedImage buf = new BufferedImage(width, height, 9);
        DataBufferUShort sh = (DataBufferUShort)buf.getRaster().getDataBuffer();
        short[] shd = sh.getData();
        System.arraycopy(linear, 0, shd, 0, Math.min(linear.length, shd.length));
        try {
            ImageIO.write((RenderedImage)buf, "PNG", new File(imagename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void WritePNGfile(String imagename, int[] linear, int width, int height) {
        BufferedImage buf = new BufferedImage(width, height, 2);
        DataBufferInt sh = (DataBufferInt)buf.getRaster().getDataBuffer();
        int[] shd = sh.getData();
        System.arraycopy(linear, 0, shd, 0, Math.min(linear.length, shd.length));
        try {
            ImageIO.write((RenderedImage)buf, "PNG", new File(imagename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void WritePNGfile(String imagename, byte[] linear, int width, int height, IndexColorModel icm) {
        BufferedImage buf = new BufferedImage(width, height, 13, icm);
        DataBufferByte sh = (DataBufferByte)buf.getRaster().getDataBuffer();
        byte[] shd = sh.getData();
        System.arraycopy(linear, 0, shd, 0, Math.min(linear.length, shd.length));
        try {
            ImageIO.write((RenderedImage)buf, "PNG", new File(imagename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

