/*
 * Decompiled with CFR 0.152.
 */
package mochadoom;

import awt.DoomWindow;
import awt.EventBase;
import java.awt.AWTEvent;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import p.ActiveStates;
import v.graphics.Patches;

public class Loggers {
    private static final Level DEFAULT_LEVEL = Level.WARNING;
    private static final Map<Level, Logger> PARENT_LOGGERS_MAP = Stream.of(Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING).collect(Collectors.toMap(l -> l, Loggers::newLoggerHandlingLevel));
    private static final Logger DEFAULT_LOGGER = PARENT_LOGGERS_MAP.get(DEFAULT_LEVEL);
    private static final HashMap<String, Logger> INDIVIDUAL_CLASS_LOGGERS = new HashMap();
    private static EventBase<?> lastHandler;

    public static Logger getLogger(String className) {
        Logger ret = Logger.getLogger(className);
        ret.setParent(INDIVIDUAL_CLASS_LOGGERS.getOrDefault(className, DEFAULT_LOGGER));
        return ret;
    }

    public static <EventHandler extends Enum<EventHandler>> void LogEvent(Logger logger, EventBase.ActionStateHolder<EventHandler> actionStateHolder, EventHandler handler, AWTEvent event) {
        if (!logger.isLoggable(Level.ALL) && lastHandler == handler) {
            return;
        }
        lastHandler = (EventBase)((Object)handler);
        IntFunction<EventBase[]> arrayGenerator = EventBase[]::new;
        EventBase[] depends = (EventBase[])actionStateHolder.cooperations(handler, EventBase.RelationType.DEPEND).stream().filter(hdl -> actionStateHolder.hasActionsEnabled(hdl, EventBase.ActionMode.DEPEND)).toArray(arrayGenerator);
        Map adjusts = actionStateHolder.adjustments(handler);
        EventBase[] causes = (EventBase[])actionStateHolder.cooperations(handler, EventBase.RelationType.CAUSE).stream().filter(hdl -> actionStateHolder.hasActionsEnabled(hdl, EventBase.ActionMode.DEPEND)).toArray(arrayGenerator);
        EventBase[] reverts = (EventBase[])actionStateHolder.cooperations(handler, EventBase.RelationType.REVERT).stream().filter(hdl -> actionStateHolder.hasActionsEnabled(hdl, EventBase.ActionMode.DEPEND)).toArray(arrayGenerator);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, () -> String.format("\n\nENCOUNTERED EVENT: %s [%s] \n%s: %s \n%s \n%s: %s \n%s: %s \nOn event: %s", new Object[]{handler, EventBase.ActionMode.PERFORM, EventBase.RelationType.DEPEND, Arrays.toString(depends), adjusts.entrySet().stream().collect(StringBuilder::new, (sb, e) -> sb.append(e.getKey()).append(' ').append(e.getValue()).append('\n'), StringBuilder::append), EventBase.RelationType.CAUSE, Arrays.toString(causes), EventBase.RelationType.REVERT, Arrays.toString(reverts), event}));
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, () -> String.format("\n\nENCOUNTERED EVENT: %s [%s] \n%s: %s \n%s \n%s: %s \n%s: %s \n", new Object[]{handler, EventBase.ActionMode.PERFORM, EventBase.RelationType.DEPEND, Arrays.toString(depends), adjusts.entrySet().stream().collect(StringBuilder::new, (sb, e) -> sb.append(e.getKey()).append(' ').append(e.getValue()).append('\n'), StringBuilder::append), EventBase.RelationType.CAUSE, Arrays.toString(causes), EventBase.RelationType.REVERT, Arrays.toString(reverts)}));
        } else {
            logger.log(Level.FINE, () -> String.format("\nENCOUNTERED EVENT: %s [%s]", new Object[]{handler, EventBase.ActionMode.PERFORM}));
        }
    }

    private Loggers() {
    }

    private static Logger newLoggerHandlingLevel(Level l) {
        OutHandler h = new OutHandler();
        h.setLevel(l);
        Logger ret = Logger.getAnonymousLogger();
        ret.setUseParentHandlers(false);
        ret.setLevel(l);
        ret.addHandler(h);
        return ret;
    }

    static {
        INDIVIDUAL_CLASS_LOGGERS.put(ActiveStates.class.getName(), PARENT_LOGGERS_MAP.get(Level.FINER));
        INDIVIDUAL_CLASS_LOGGERS.put(DoomWindow.class.getName(), PARENT_LOGGERS_MAP.get(Level.FINE));
        INDIVIDUAL_CLASS_LOGGERS.put(Patches.class.getName(), PARENT_LOGGERS_MAP.get(Level.INFO));
        lastHandler = null;
    }

    private static final class OutHandler
    extends ConsoleHandler {
        private OutHandler() {
        }

        @Override
        protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
            super.setOutputStream(System.out);
        }
    }
}

