/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.sounds;
import doom.thinker_t;
import p.Actions.ActionsMoveEvents;
import p.Actions.ActionsUseEvents;
import p.ActiveStates;
import p.ceiling_e;
import p.ceiling_t;
import p.result_e;
import rr.line_t;
import rr.sector_t;
import s.ISoundOrigin;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsCeilings
extends ActionsMoveEvents,
ActionsUseEvents {
    public static final TraitFactory.ContextKey<Ceilings> KEY_CEILINGS = ACTION_KEY_CHAIN.newKey(ActionsCeilings.class, Ceilings::new);

    @Override
    public void RemoveThinker(thinker_t var1);

    public result_e MovePlane(sector_t var1, int var2, int var3, boolean var4, int var5, int var6);

    public int FindSectorFromLineTag(line_t var1, int var2);

    default public void ClearCeilingsBeforeLoading() {
        this.contextRequire(ActionsCeilings.KEY_CEILINGS).activeceilings = new ceiling_t[30];
    }

    default public void MoveCeiling(ceiling_t ceiling) {
        block0 : switch (ceiling.direction) {
            case 0: {
                break;
            }
            case 1: {
                result_e res = this.MovePlane(ceiling.sector, ceiling.speed, ceiling.topheight, false, 1, ceiling.direction);
                if (!C2JUtils.eval(this.LevelTime() & 7)) {
                    switch (ceiling.type) {
                        case silentCrushAndRaise: {
                            break;
                        }
                        default: {
                            this.StartSound((ISoundOrigin)ceiling.sector.soundorg, sounds.sfxenum_t.sfx_stnmov);
                        }
                    }
                }
                if (res != result_e.pastdest) break;
                switch (ceiling.type) {
                    case raiseToHighest: {
                        this.RemoveActiveCeiling(ceiling);
                        break;
                    }
                    case silentCrushAndRaise: {
                        this.StartSound((ISoundOrigin)ceiling.sector.soundorg, sounds.sfxenum_t.sfx_pstop);
                    }
                    case fastCrushAndRaise: 
                    case crushAndRaise: {
                        ceiling.direction = -1;
                    }
                }
                break;
            }
            case -1: {
                result_e res = this.MovePlane(ceiling.sector, ceiling.speed, ceiling.bottomheight, ceiling.crush, 1, ceiling.direction);
                if (!C2JUtils.eval(this.LevelTime() & 7)) {
                    switch (ceiling.type) {
                        case silentCrushAndRaise: {
                            break;
                        }
                        default: {
                            this.StartSound((ISoundOrigin)ceiling.sector.soundorg, sounds.sfxenum_t.sfx_stnmov);
                        }
                    }
                }
                if (res == result_e.pastdest) {
                    switch (ceiling.type) {
                        case silentCrushAndRaise: {
                            this.StartSound((ISoundOrigin)ceiling.sector.soundorg, sounds.sfxenum_t.sfx_pstop);
                        }
                        case crushAndRaise: {
                            ceiling.speed = 65536;
                        }
                        case fastCrushAndRaise: {
                            ceiling.direction = 1;
                            break block0;
                        }
                        case lowerAndCrush: 
                        case lowerToFloor: {
                            this.RemoveActiveCeiling(ceiling);
                            break block0;
                        }
                    }
                    break;
                }
                if (res != result_e.crushed) break;
                switch (ceiling.type) {
                    case silentCrushAndRaise: 
                    case crushAndRaise: 
                    case lowerAndCrush: {
                        ceiling.speed = 8192;
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    default public boolean DoCeiling(line_t line, ceiling_e type) {
        int secnum = -1;
        boolean rtn = false;
        switch (type) {
            case silentCrushAndRaise: 
            case fastCrushAndRaise: 
            case crushAndRaise: {
                this.ActivateInStasisCeiling(line);
            }
        }
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t sec = this.levelLoader().sectors[secnum];
            if (sec.specialdata != null) continue;
            rtn = true;
            ceiling_t ceiling = new ceiling_t();
            sec.specialdata = ceiling;
            ceiling.thinkerFunction = ActiveStates.T_MoveCeiling;
            this.AddThinker(ceiling);
            ceiling.sector = sec;
            ceiling.crush = false;
            switch (type) {
                case fastCrushAndRaise: {
                    ceiling.crush = true;
                    ceiling.topheight = sec.ceilingheight;
                    ceiling.bottomheight = sec.floorheight + 524288;
                    ceiling.direction = -1;
                    ceiling.speed = 131072;
                    break;
                }
                case silentCrushAndRaise: 
                case crushAndRaise: {
                    ceiling.crush = true;
                    ceiling.topheight = sec.ceilingheight;
                }
                case lowerAndCrush: 
                case lowerToFloor: {
                    ceiling.bottomheight = sec.floorheight;
                    if (type != ceiling_e.lowerToFloor) {
                        ceiling.bottomheight += 524288;
                    }
                    ceiling.direction = -1;
                    ceiling.speed = 65536;
                    break;
                }
                case raiseToHighest: {
                    ceiling.topheight = sec.FindHighestCeilingSurrounding();
                    ceiling.direction = 1;
                    ceiling.speed = 65536;
                }
            }
            ceiling.tag = sec.tag;
            ceiling.type = type;
            this.AddActiveCeiling(ceiling);
        }
        return rtn;
    }

    default public void AddActiveCeiling(ceiling_t c) {
        ceiling_t[] activeCeilings = this.getActiveCeilings();
        for (int i = 0; i < activeCeilings.length; ++i) {
            if (activeCeilings[i] != null) continue;
            activeCeilings[i] = c;
            return;
        }
        this.setActiveceilings(C2JUtils.resize(c, activeCeilings, 2 * activeCeilings.length));
    }

    default public void RemoveActiveCeiling(ceiling_t c) {
        ceiling_t[] activeCeilings = this.getActiveCeilings();
        for (int i = 0; i < activeCeilings.length; ++i) {
            if (activeCeilings[i] != c) continue;
            activeCeilings[i].sector.specialdata = null;
            this.RemoveThinker(activeCeilings[i]);
            activeCeilings[i] = null;
            break;
        }
    }

    default public void ActivateInStasisCeiling(line_t line) {
        ceiling_t[] activeCeilings = this.getActiveCeilings();
        for (int i = 0; i < activeCeilings.length; ++i) {
            if (activeCeilings[i] == null || activeCeilings[i].tag != line.tag || activeCeilings[i].direction != 0) continue;
            activeCeilings[i].direction = activeCeilings[i].olddirection;
            activeCeilings[i].thinkerFunction = ActiveStates.T_MoveCeiling;
        }
    }

    @Override
    default public int CeilingCrushStop(line_t line) {
        int rtn = 0;
        ceiling_t[] activeCeilings = this.getActiveCeilings();
        for (int i = 0; i < activeCeilings.length; ++i) {
            if (activeCeilings[i] == null || activeCeilings[i].tag != line.tag || activeCeilings[i].direction == 0) continue;
            activeCeilings[i].olddirection = activeCeilings[i].direction;
            activeCeilings[i].thinkerFunction = null;
            activeCeilings[i].direction = 0;
            rtn = 1;
        }
        return rtn;
    }

    default public void setActiveceilings(ceiling_t[] activeceilings) {
        this.contextRequire(ActionsCeilings.KEY_CEILINGS).activeceilings = activeceilings;
    }

    default public ceiling_t[] getActiveCeilings() {
        return this.contextRequire(ActionsCeilings.KEY_CEILINGS).activeceilings;
    }

    default public int getMaxCeilings() {
        return this.contextRequire(ActionsCeilings.KEY_CEILINGS).activeceilings.length;
    }

    public static final class Ceilings {
        ceiling_t[] activeceilings = new ceiling_t[30];
    }
}

