/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.mobjtype_t;
import defines.statenum_t;
import doom.items;
import doom.player_t;
import p.Actions.ActionTrait;
import p.Actions.ActionsSight;
import p.Actions.ActionsSpawns;
import p.MapUtils;
import p.mobj_t;
import rr.SceneRenderer;
import rr.line_t;
import rr.sector_t;
import rr.side_t;
import utils.TraitFactory;

public interface ActionsEnemies
extends ActionsSight,
ActionsSpawns {
    public static final TraitFactory.ContextKey<Enemies> KEY_ENEMIES = ACTION_KEY_CHAIN.newKey(ActionsEnemies.class, Enemies::new);

    default public boolean CheckMeleeRange(mobj_t actor) {
        if (actor.target == null) {
            return false;
        }
        mobj_t pl = actor.target;
        int dist = MapUtils.AproxDistance(pl.x - actor.x, pl.y - actor.y);
        if (dist >= Defines.MELEERANGE - 0x140000 + pl.info.radius) {
            return false;
        }
        return this.CheckSight(actor, actor.target);
    }

    default public boolean CheckMissileRange(mobj_t actor) {
        if (!this.CheckSight(actor, actor.target)) {
            return false;
        }
        if ((actor.flags & 0x40L) != 0L) {
            actor.flags &= 0xFFFFFFFFFFFFFFBFL;
            return true;
        }
        if (actor.reactiontime != 0) {
            return false;
        }
        int dist = MapUtils.AproxDistance(actor.x - actor.target.x, actor.y - actor.target.y) - 0x400000;
        if (actor.info.meleestate == statenum_t.S_NULL) {
            dist -= 0x800000;
        }
        if (actor.type == mobjtype_t.MT_VILE && (dist >>= 16) > 896) {
            return false;
        }
        if (actor.type == mobjtype_t.MT_UNDEAD) {
            if (dist < 196) {
                return false;
            }
            dist >>= 1;
        }
        if (actor.type == mobjtype_t.MT_CYBORG || actor.type == mobjtype_t.MT_SPIDER || actor.type == mobjtype_t.MT_SKULL) {
            dist >>= 1;
        }
        if (dist > 200) {
            dist = 200;
        }
        if (actor.type == mobjtype_t.MT_CYBORG && dist > 160) {
            dist = 160;
        }
        return this.P_Random() >= dist;
    }

    default public void RecursiveSound(sector_t sec, int soundblocks) {
        SceneRenderer<?, ?> sr = this.sceneRenderer();
        Enemies en = this.contextRequire(KEY_ENEMIES);
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if (sec.validcount == sr.getValidCount() && sec.soundtraversed <= soundblocks + 1) {
            return;
        }
        sec.validcount = sr.getValidCount();
        sec.soundtraversed = soundblocks + 1;
        sec.soundtarget = en.soundtarget;
        side_t[] sides = this.levelLoader().sides;
        for (int i = 0; i < sec.linecount; ++i) {
            line_t check = sec.lines[i];
            if ((check.flags & 4) == 0) continue;
            this.LineOpening(check);
            if (mov.openrange <= 0) continue;
            sector_t other = sides[check.sidenum[0]].sector == sec ? sides[check.sidenum[1]].sector : sides[check.sidenum[0]].sector;
            if ((check.flags & 0x40) != 0) {
                if (soundblocks != 0) continue;
                this.RecursiveSound(other, 1);
                continue;
            }
            this.RecursiveSound(other, soundblocks);
        }
    }

    default public void NoiseAlert(mobj_t target, mobj_t emmiter) {
        Enemies en = this.contextRequire(KEY_ENEMIES);
        en.soundtarget = target;
        this.sceneRenderer().increaseValidCount(1);
        this.RecursiveSound(emmiter.subsector.sector, 0);
    }

    default public void FireWeapon(player_t player) {
        if (!player.CheckAmmo()) {
            return;
        }
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK1);
        statenum_t newstate = items.weaponinfo[player.readyweapon.ordinal()].atkstate;
        player.SetPsprite(player_t.ps_weapon, newstate);
        this.NoiseAlert(player.mo, player.mo);
    }

    default public boolean LookForPlayers(mobj_t actor, boolean allaround) {
        SceneRenderer<?, ?> sr = this.sceneRenderer();
        int c = 0;
        int stop = actor.lastlook - 1 & 3;
        while (true) {
            if (this.PlayerInGame(actor.lastlook)) {
                int dist;
                long an;
                if (c++ == 2 || actor.lastlook == stop) {
                    return false;
                }
                player_t player = this.getPlayer(actor.lastlook);
                if (player.health[0] > 0 && this.CheckSight(actor, player.mo) && (allaround || (an = sr.PointToAngle2(actor.x, actor.y, player.mo.x, player.mo.y) - actor.angle & 0xFFFFFFFFL) <= 0x40000000L || an >= 0xC0000000L || (dist = MapUtils.AproxDistance(player.mo.x - actor.x, player.mo.y - actor.y)) <= Defines.MELEERANGE)) {
                    actor.target = player.mo;
                    return true;
                }
            }
            actor.lastlook = actor.lastlook + 1 & 3;
        }
    }

    public static class Enemies {
        mobj_t soundtarget;
        line_t[] spechitp = new line_t[8];
        int numspechit;
    }
}

