/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import p.AbstractLevelLoader;
import p.Actions.ActionsMoveEvents;
import p.Actions.ActionsUseEvents;
import p.ActiveStates;
import p.strobe_t;
import rr.SectorAction;
import rr.line_t;
import rr.sector_t;
import w.DoomIO;

public interface ActionsLights
extends ActionsMoveEvents,
ActionsUseEvents {
    public int FindSectorFromLineTag(line_t var1, int var2);

    default public int FindMinSurroundingLight(sector_t sector, int max) {
        int min = max;
        for (int i = 0; i < sector.linecount; ++i) {
            line_t line = sector.lines[i];
            sector_t check = line.getNextSector(sector);
            if (check == null || check.lightlevel >= min) continue;
            min = check.lightlevel;
        }
        return min;
    }

    default public void SpawnLightFlash(sector_t sector) {
        sector.special = 0;
        lightflash_t flash = new lightflash_t();
        this.AddThinker(flash);
        flash.thinkerFunction = ActiveStates.T_LightFlash;
        flash.sector = sector;
        flash.maxlight = sector.lightlevel;
        flash.minlight = this.FindMinSurroundingLight(sector, sector.lightlevel);
        flash.maxtime = 64;
        flash.mintime = 7;
        flash.count = (this.P_Random() & flash.maxtime) + 1;
    }

    default public void SpawnStrobeFlash(sector_t sector, int fastOrSlow, int inSync) {
        strobe_t flash = new strobe_t();
        this.AddThinker(flash);
        flash.sector = sector;
        flash.darktime = fastOrSlow;
        flash.brighttime = 5;
        flash.thinkerFunction = ActiveStates.T_StrobeFlash;
        flash.maxlight = sector.lightlevel;
        flash.minlight = this.FindMinSurroundingLight(sector, sector.lightlevel);
        if (flash.minlight == flash.maxlight) {
            flash.minlight = 0;
        }
        sector.special = 0;
        flash.count = inSync == 0 ? (this.P_Random() & 7) + 1 : 1;
    }

    default public void SpawnGlowingLight(sector_t sector) {
        glow_t g = new glow_t();
        this.AddThinker(g);
        g.sector = sector;
        g.minlight = this.FindMinSurroundingLight(sector, sector.lightlevel);
        g.maxlight = sector.lightlevel;
        g.thinkerFunction = ActiveStates.T_Glow;
        g.direction = -1;
        sector.special = 0;
    }

    @Override
    default public void StartLightStrobing(line_t line) {
        AbstractLevelLoader ll = this.levelLoader();
        int secnum = -1;
        while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t sec = ll.sectors[secnum];
            if (sec.specialdata != null) continue;
            this.SpawnStrobeFlash(sec, 35, 0);
        }
    }

    default public void SpawnFireFlicker(sector_t sector) {
        sector.special = 0;
        fireflicker_t flick = new fireflicker_t();
        this.AddThinker(flick);
        flick.thinkerFunction = ActiveStates.T_FireFlicker;
        flick.sector = sector;
        flick.maxlight = sector.lightlevel;
        flick.minlight = this.FindMinSurroundingLight(sector, sector.lightlevel) + 16;
        flick.count = 4;
    }

    @Override
    default public void TurnTagLightsOff(line_t line) {
        AbstractLevelLoader ll = this.levelLoader();
        for (int j = 0; j < ll.numsectors; ++j) {
            sector_t sector = ll.sectors[j];
            if (sector.tag != line.tag) continue;
            short min = sector.lightlevel;
            for (int i = 0; i < sector.linecount; ++i) {
                line_t templine = sector.lines[i];
                sector_t tsec = templine.getNextSector(sector);
                if (tsec == null || tsec.lightlevel >= min) continue;
                min = tsec.lightlevel;
            }
            sector.lightlevel = min;
        }
    }

    @Override
    default public void LightTurnOn(line_t line, int bright) {
        AbstractLevelLoader ll = this.levelLoader();
        for (int i = 0; i < ll.numsectors; ++i) {
            sector_t sector = ll.sectors[i];
            if (sector.tag != line.tag) continue;
            if (bright == 0) {
                for (int j = 0; j < sector.linecount; ++j) {
                    line_t templine = sector.lines[j];
                    sector_t temp = templine.getNextSector(sector);
                    if (temp == null || temp.lightlevel <= bright) continue;
                    bright = temp.lightlevel;
                }
            }
            sector.lightlevel = (short)bright;
        }
    }

    public static class glow_t
    extends SectorAction {
        public int minlight;
        public int maxlight;
        public int direction;

        @Override
        public void read(DataInputStream f) throws IOException {
            super.read(f);
            this.sectorid = DoomIO.readLEInt(f);
            this.minlight = DoomIO.readLEInt(f);
            this.maxlight = DoomIO.readLEInt(f);
            this.direction = DoomIO.readLEInt(f);
        }

        @Override
        public void pack(ByteBuffer b) throws IOException {
            super.pack(b);
            b.putInt(this.sectorid);
            b.putInt(this.minlight);
            b.putInt(this.maxlight);
            b.putInt(this.direction);
        }
    }

    public static class lightflash_t
    extends SectorAction {
        public int count;
        public int maxlight;
        public int minlight;
        public int maxtime;
        public int mintime;

        @Override
        public void read(DataInputStream f) throws IOException {
            super.read(f);
            this.sectorid = DoomIO.readLEInt(f);
            this.count = DoomIO.readLEInt(f);
            this.maxlight = DoomIO.readLEInt(f);
            this.minlight = DoomIO.readLEInt(f);
            this.maxtime = DoomIO.readLEInt(f);
            this.mintime = DoomIO.readLEInt(f);
        }

        @Override
        public void pack(ByteBuffer b) throws IOException {
            super.pack(b);
            b.putInt(this.sectorid);
            b.putInt(this.count);
            b.putInt(this.maxlight);
            b.putInt(this.minlight);
            b.putInt(this.maxtime);
            b.putInt(this.mintime);
        }
    }

    public static class fireflicker_t
    extends SectorAction {
        public int count;
        public int maxlight;
        public int minlight;
    }
}

