/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Tables;
import data.info;
import data.mobjtype_t;
import m.fixed_t;
import p.Actions.ActionsMobj;
import p.Actions.ActionsSectors;
import p.MapUtils;
import p.mobj_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsMissiles
extends ActionsMobj {
    public int AimLineAttack(mobj_t var1, long var2, int var4);

    default public void CheckMissileSpawn(mobj_t th) {
        th.mobj_tics -= (long)(this.P_Random() & 3);
        if (th.mobj_tics < 1L) {
            th.mobj_tics = 1L;
        }
        th.x += th.momx >> 1;
        th.y += th.momy >> 1;
        th.z += th.momz >> 1;
        if (!this.TryMove(th, th.x, th.y)) {
            this.ExplodeMissile(th);
        }
    }

    default public mobj_t SpawnMissile(mobj_t source, mobj_t dest, mobjtype_t type) {
        mobj_t th = this.SpawnMobj(source.x, source.y, source.z + 0x200000, type);
        if (th.info.seesound != null) {
            this.StartSound((ISoundOrigin)th, th.info.seesound);
        }
        th.target = source;
        long an = this.sceneRenderer().PointToAngle2(source.x, source.y, dest.x, dest.y) & 0xFFFFFFFFL;
        if (C2JUtils.eval(dest.flags & 0x40000L)) {
            an += (long)(this.P_Random() - this.P_Random() << 20);
        }
        th.angle = an & 0xFFFFFFFFL;
        th.momx = fixed_t.FixedMul(th.info.speed, Tables.finecosine(an));
        th.momy = fixed_t.FixedMul(th.info.speed, Tables.finesine(an));
        int dist = MapUtils.AproxDistance(dest.x - source.x, dest.y - source.y);
        if ((dist /= th.info.speed) < 1) {
            dist = 1;
        }
        th.momz = (dest.z - source.z) / dist;
        this.CheckMissileSpawn(th);
        return th;
    }

    default public void SpawnPlayerMissile(mobj_t source, mobjtype_t type) {
        ActionsSectors.Spawn targ = (ActionsSectors.Spawn)this.contextRequire(KEY_SPAWN);
        long an = source.angle;
        int slope = this.AimLineAttack(source, an, 0x4000000);
        if (targ.linetarget == null) {
            an += 0x4000000L;
            slope = this.AimLineAttack(source, an &= 0xFFFFFFFFL, 0x4000000);
            if (targ.linetarget == null) {
                an -= 0x8000000L;
                slope = this.AimLineAttack(source, an &= 0xFFFFFFFFL, 0x4000000);
            }
            if (targ.linetarget == null) {
                an = source.angle & 0xFFFFFFFFL;
                slope = (source.player.lookdir << 16) / 173;
            }
        }
        int x = source.x;
        int y = source.y;
        int z = source.z + 0x200000 + slope;
        mobj_t th = this.SpawnMobj(x, y, z, type);
        if (th.info.seesound != null) {
            this.StartSound((ISoundOrigin)th, th.info.seesound);
        }
        th.target = source;
        th.angle = an;
        th.momx = fixed_t.FixedMul(th.info.speed, Tables.finecosine(an));
        th.momy = fixed_t.FixedMul(th.info.speed, Tables.finesine(an));
        th.momz = fixed_t.FixedMul(th.info.speed, slope);
        this.CheckMissileSpawn(th);
    }

    @Override
    default public void ExplodeMissile(mobj_t mo) {
        mo.momz = 0;
        mo.momy = 0;
        mo.momx = 0;
        mo.SetMobjState(info.mobjinfo[mo.type.ordinal()].deathstate);
        mo.mobj_tics -= (long)(this.P_Random() & 3);
        if (mo.mobj_tics < 1L) {
            mo.mobj_tics = 1L;
        }
        mo.flags &= 0xFFFFFFFFFFFEFFFFL;
        if (mo.info.deathsound != null) {
            this.StartSound((ISoundOrigin)mo, mo.info.deathsound);
        }
    }
}

