/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.Tables;
import data.info;
import data.mobjtype_t;
import defines.skill_t;
import defines.statenum_t;
import doom.player_t;
import doom.weapontype_t;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.Actions.ActionsMovement;
import p.Actions.ActionsSectors;
import p.Actions.ActionsTeleportation;
import p.Actions.ActionsThings;
import p.mobj_t;
import utils.C2JUtils;

public interface ActionsMobj
extends ActionsThings,
ActionsMovement,
ActionsTeleportation {
    @Override
    default public void DamageMobj(mobj_t target, mobj_t inflictor, mobj_t source, int damage) {
        player_t player;
        if (!C2JUtils.eval(target.flags & 4L)) {
            return;
        }
        if (target.health <= 0) {
            return;
        }
        if (C2JUtils.eval(target.flags & 0x1000000L)) {
            target.momz = 0;
            target.momy = 0;
            target.momx = 0;
        }
        if ((player = target.player) != null && this.getGameSkill() == skill_t.sk_baby) {
            damage >>= 1;
        }
        if (!(inflictor == null || C2JUtils.eval(target.flags & 0x1000L) || source != null && source.player != null && source.player.readyweapon == weapontype_t.wp_chainsaw)) {
            long ang = this.sceneRenderer().PointToAngle2(inflictor.x, inflictor.y, target.x, target.y) & 0xFFFFFFFFL;
            int thrust = damage * 8192 * 100 / target.info.mass;
            if (damage < 40 && damage > target.health && target.z - inflictor.z > 0x400000 && C2JUtils.eval(this.P_Random() & 1)) {
                ang += 0x80000000L;
                thrust *= 4;
            }
            target.momx += fixed_t.FixedMul(thrust, Tables.finecosine(ang));
            target.momy += fixed_t.FixedMul(thrust, Tables.finesine(ang));
        }
        if (player != null) {
            int temp;
            if (target.subsector.sector.special == 11 && damage >= target.health) {
                damage = target.health - 1;
            }
            if (damage < 1000 && C2JUtils.eval(player.cheats & 2) || player.powers[0] != 0) {
                return;
            }
            if (player.armortype != 0) {
                int saved = player.armortype == 1 ? damage / 3 : damage / 2;
                if (player.armorpoints[0] <= saved) {
                    saved = player.armorpoints[0];
                    player.armortype = 0;
                }
                player.armorpoints[0] = player.armorpoints[0] - saved;
                damage -= saved;
            }
            player.health[0] = player.health[0] - damage;
            if (player.health[0] < 0) {
                player.health[0] = 0;
            }
            player.attacker = source;
            player.damagecount += damage;
            if (player.damagecount > 100) {
                player.damagecount = 100;
            }
            int n = temp = damage < 100 ? damage : 100;
            if (player == this.getPlayer(this.ConsolePlayerNumber())) {
                this.doomSystem().Tactile(40, 10, 40 + temp * 2);
            }
        }
        target.health -= damage;
        if (target.health <= 0) {
            this.KillMobj(source, target);
            return;
        }
        if (this.P_Random() < target.info.painchance && !C2JUtils.eval(target.flags & 0x1000000L)) {
            target.flags |= 0x40L;
            target.SetMobjState(target.info.painstate);
        }
        target.reactiontime = 0;
        if ((target.threshold == 0 || target.type == mobjtype_t.MT_VILE) && source != null && source != target && source.type != mobjtype_t.MT_VILE) {
            target.target = source;
            target.threshold = Defines.BASETHRESHOLD;
            if (target.mobj_state == info.states[target.info.spawnstate.ordinal()] && target.info.seestate != statenum_t.S_NULL) {
                target.SetMobjState(target.info.seestate);
            }
        }
    }

    default public void KillMobj(mobj_t source, mobj_t target) {
        mobjtype_t item;
        target.target = source;
        target.flags &= 0xFFFFFFFFFEFFBFFBL;
        if (target.type != mobjtype_t.MT_SKULL) {
            target.flags &= 0xFFFFFFFFFFFFFDFFL;
        }
        target.flags |= 0x100400L;
        target.height >>= 2;
        if (source != null && source.player != null) {
            if ((target.flags & 0x400000L) != 0L) {
                ++source.player.killcount;
            }
            if (target.player != null) {
                int n = target.player.identify();
                source.player.frags[n] = source.player.frags[n] + 1;
            }
        } else if (!this.IsNetGame() && (target.flags & 0x400000L) != 0L) {
            ++this.getPlayer((int)0).killcount;
        }
        if (target.player != null) {
            if (source == null) {
                int n = target.player.identify();
                target.player.frags[n] = target.player.frags[n] + 1;
            }
            target.flags &= 0xFFFFFFFFFFFFFFFDL;
            target.player.playerstate = 1;
            target.player.DropWeapon();
            if (target.player == this.getPlayer(this.ConsolePlayerNumber()) && this.IsAutoMapActive()) {
                this.autoMap().Stop();
            }
        }
        if (target.health < -target.info.spawnhealth && target.info.xdeathstate != statenum_t.S_NULL) {
            target.SetMobjState(target.info.xdeathstate);
        } else {
            target.SetMobjState(target.info.deathstate);
        }
        target.mobj_tics -= (long)(this.P_Random() & 3);
        if (target.mobj_tics < 1L) {
            target.mobj_tics = 1L;
        }
        switch (target.type) {
            case MT_WOLFSS: 
            case MT_POSSESSED: {
                item = mobjtype_t.MT_CLIP;
                break;
            }
            case MT_SHOTGUY: {
                item = mobjtype_t.MT_SHOTGUN;
                break;
            }
            case MT_CHAINGUY: {
                item = mobjtype_t.MT_CHAINGUN;
                break;
            }
            default: {
                return;
            }
        }
        mobj_t mo = this.SpawnMobj(target.x, target.y, Defines.ONFLOORZ, item);
        mo.flags |= 0x20000L;
    }

    @Override
    default public void RemoveMobj(mobj_t mobj) {
        if (C2JUtils.eval(mobj.flags & 1L) && !C2JUtils.eval(mobj.flags & 0x20000L) && mobj.type != mobjtype_t.MT_INV && mobj.type != mobjtype_t.MT_INS) {
            ActionsSectors.RespawnQueue resp = (ActionsSectors.RespawnQueue)this.contextRequire(KEY_RESP_QUEUE);
            resp.itemrespawnque[resp.iquehead] = mobj.spawnpoint;
            resp.itemrespawntime[resp.iquehead] = this.LevelTime();
            resp.iquehead = resp.iquehead + 1 & Defines.ITEMQUESIZE - 1;
            if (resp.iquehead == resp.iquetail) {
                resp.iquetail = resp.iquetail + 1 & Defines.ITEMQUESIZE - 1;
            }
        }
        this.UnsetThingPosition(mobj);
        this.StopSound(mobj);
        this.RemoveThinker(mobj);
    }

    @Override
    default public void UnsetThingPosition(mobj_t thing) {
        AbstractLevelLoader ll = this.levelLoader();
        if (!C2JUtils.eval(thing.flags & 8L)) {
            if (thing.snext != null) {
                ((mobj_t)thing.snext).sprev = thing.sprev;
            }
            if (thing.sprev != null) {
                ((mobj_t)thing.sprev).snext = thing.snext;
            } else {
                thing.subsector.sector.thinglist = (mobj_t)thing.snext;
            }
        }
        if (!C2JUtils.eval(thing.flags & 0x10L)) {
            if (thing.bnext != null) {
                ((mobj_t)thing.bnext).bprev = thing.bprev;
            }
            if (thing.bprev != null) {
                ((mobj_t)thing.bprev).bnext = thing.bnext;
            } else {
                int blockx = ll.getSafeBlockX(thing.x - ll.bmaporgx);
                int blocky = ll.getSafeBlockY(thing.y - ll.bmaporgy);
                if (blockx >= 0 && blockx < ll.bmapwidth && blocky >= 0 && blocky < ll.bmapheight) {
                    ll.blocklinks[blocky * ll.bmapwidth + blockx] = (mobj_t)thing.bnext;
                }
            }
        }
    }
}

