/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.Tables;
import defines.slopetype_t;
import defines.statenum_t;
import doom.player_t;
import m.fixed_t;
import p.Actions.ActionTrait;
import p.Actions.ActionsPathTraverse;
import p.ChaseDirections;
import p.MapUtils;
import p.intercept_t;
import p.mobj_t;
import rr.SceneRenderer;
import rr.line_t;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsMovement
extends ActionsPathTraverse {
    public static final TraitFactory.ContextKey<DirType> KEY_DIRTYPE = ACTION_KEY_CHAIN.newKey(ActionsMovement.class, DirType::new);
    public static final int STOPSPEED = 4096;
    public static final int FRICTION = 59392;
    public static final int FUDGE = 2048;

    public void UnsetThingPosition(mobj_t var1);

    public void ExplodeMissile(mobj_t var1);

    default public boolean Move(mobj_t actor) {
        int tryy;
        int tryx;
        boolean try_ok;
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        ActionTrait.Spechits sp = (ActionTrait.Spechits)this.contextRequire(KEY_SPECHITS);
        if (actor.movedir == 8) {
            return false;
        }
        if (actor.movedir >= 8) {
            this.doomSystem().Error("Weird actor.movedir!");
        }
        if (!(try_ok = this.TryMove(actor, tryx = actor.x + actor.info.speed * ChaseDirections.xspeed[actor.movedir], tryy = actor.y + actor.info.speed * ChaseDirections.yspeed[actor.movedir]))) {
            if (C2JUtils.eval(actor.flags & 0x4000L) && mov.floatok) {
                actor.z = actor.z < mov.tmfloorz ? (actor.z += 262144) : (actor.z -= 262144);
                actor.flags |= 0x200000L;
                return true;
            }
            if (sp.numspechit == 0) {
                return false;
            }
            actor.movedir = 8;
            boolean good = false;
            while (sp.numspechit-- > 0) {
                line_t ld = sp.spechit[sp.numspechit];
                if (!this.UseSpecialLine(actor, ld, false)) continue;
                good = true;
            }
            return good;
        }
        actor.flags &= 0xFFFFFFFFFFDFFFFFL;
        if (!C2JUtils.eval(actor.flags & 0x4000L)) {
            actor.z = actor.floorz;
        }
        return true;
    }

    default public boolean TryMove(mobj_t thing, int x, int y) {
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        ActionTrait.Spechits sp = (ActionTrait.Spechits)this.contextRequire(KEY_SPECHITS);
        mov.floatok = false;
        if (!this.CheckPosition(thing, x, y)) {
            return false;
        }
        if (!C2JUtils.eval(thing.flags & 0x1000L)) {
            if (mov.tmceilingz - mov.tmfloorz < thing.height) {
                return false;
            }
            mov.floatok = true;
            if (!C2JUtils.eval(thing.flags & 0x8000L) && mov.tmceilingz - thing.z < thing.height) {
                return false;
            }
            if (!C2JUtils.eval(thing.flags & 0x8000L) && mov.tmfloorz - thing.z > 0x180000) {
                return false;
            }
            if (!C2JUtils.eval(thing.flags & 0x4400L) && mov.tmfloorz - mov.tmdropoffz > 0x180000) {
                return false;
            }
        }
        this.UnsetThingPosition(thing);
        int oldx = thing.x;
        int oldy = thing.y;
        thing.floorz = mov.tmfloorz;
        thing.ceilingz = mov.tmceilingz;
        thing.x = x;
        thing.y = y;
        this.levelLoader().SetThingPosition(thing);
        if (!C2JUtils.eval(thing.flags & 0x9000L)) {
            while (sp.numspechit-- > 0) {
                boolean oldside;
                line_t ld = sp.spechit[sp.numspechit];
                boolean side = ld.PointOnLineSide(thing.x, thing.y);
                if (side == (oldside = ld.PointOnLineSide(oldx, oldy)) || ld.special == 0) continue;
                this.CrossSpecialLine(ld, oldside ? 1 : 0, thing);
            }
        }
        return true;
    }

    default public void NewChaseDir(mobj_t actor) {
        int tdir;
        DirType dirtype = this.contextRequire(KEY_DIRTYPE);
        if (actor.target == null) {
            this.doomSystem().Error("P_NewChaseDir: called with no target");
        }
        int olddir = actor.movedir;
        int turnaround = ChaseDirections.opposite[olddir];
        int deltax = actor.target.x - actor.x;
        int deltay = actor.target.y - actor.y;
        dirtype.d1 = deltax > 655360 ? 0 : (deltax < -655360 ? 4 : 8);
        dirtype.d2 = deltay < -655360 ? 6 : (deltay > 655360 ? 2 : 8);
        if (dirtype.d1 != 8 && dirtype.d2 != 8) {
            actor.movedir = ChaseDirections.diags[(C2JUtils.eval(deltay < 0) << 1) + C2JUtils.eval(deltax > 0)];
            if (actor.movedir != turnaround && this.TryWalk(actor)) {
                return;
            }
        }
        if (this.P_Random() > 200 || Math.abs(deltay) > Math.abs(deltax)) {
            tdir = dirtype.d1;
            dirtype.d1 = dirtype.d2;
            dirtype.d2 = tdir;
        }
        if (dirtype.d1 == turnaround) {
            dirtype.d1 = 8;
        }
        if (dirtype.d2 == turnaround) {
            dirtype.d2 = 8;
        }
        if (dirtype.d1 != 8) {
            actor.movedir = dirtype.d1;
            if (this.TryWalk(actor)) {
                return;
            }
        }
        if (dirtype.d2 != 8) {
            actor.movedir = dirtype.d2;
            if (this.TryWalk(actor)) {
                return;
            }
        }
        if (olddir != 8) {
            actor.movedir = olddir;
            if (this.TryWalk(actor)) {
                return;
            }
        }
        if (C2JUtils.eval(this.P_Random() & 1)) {
            for (tdir = 0; tdir <= 7; ++tdir) {
                if (tdir == turnaround) continue;
                actor.movedir = tdir;
                if (!this.TryWalk(actor)) continue;
                return;
            }
        } else {
            for (tdir = 7; tdir != -1; --tdir) {
                if (tdir == turnaround) continue;
                actor.movedir = tdir;
                if (!this.TryWalk(actor)) continue;
                return;
            }
        }
        if (turnaround != 8) {
            actor.movedir = turnaround;
            if (this.TryWalk(actor)) {
                return;
            }
        }
        actor.movedir = 8;
    }

    default public boolean TryWalk(mobj_t actor) {
        if (!this.Move(actor)) {
            return false;
        }
        actor.movecount = this.P_Random() & 0xF;
        return true;
    }

    default public void HitSlideLine(line_t ld) {
        long moveangle;
        long deltaangle;
        SceneRenderer<?, ?> sr = this.sceneRenderer();
        ActionTrait.SlideMove slideMove = (ActionTrait.SlideMove)this.contextRequire(KEY_SLIDEMOVE);
        if (ld.slopetype == slopetype_t.ST_HORIZONTAL) {
            slideMove.tmymove = 0;
            return;
        }
        if (ld.slopetype == slopetype_t.ST_VERTICAL) {
            slideMove.tmxmove = 0;
            return;
        }
        boolean side = ld.PointOnLineSide(slideMove.slidemo.x, slideMove.slidemo.y);
        long lineangle = sr.PointToAngle2(0, 0, ld.dx, ld.dy);
        if (side) {
            lineangle += 0x80000000L;
        }
        if ((deltaangle = (moveangle = sr.PointToAngle2(0, 0, slideMove.tmxmove, slideMove.tmymove)) - lineangle & 0xFFFFFFFFL) > 0x80000000L) {
            deltaangle += 0x80000000L;
        }
        int movelen = MapUtils.AproxDistance(slideMove.tmxmove, slideMove.tmymove);
        int newlen = fixed_t.FixedMul(movelen, Tables.finecosine(deltaangle));
        slideMove.tmxmove = fixed_t.FixedMul(newlen, Tables.finecosine(lineangle));
        slideMove.tmymove = fixed_t.FixedMul(newlen, Tables.finesine(lineangle));
    }

    default public void SlideMove(mobj_t mo) {
        ActionTrait.SlideMove slideMove = (ActionTrait.SlideMove)this.contextRequire(KEY_SLIDEMOVE);
        slideMove.slidemo = mo;
        int hitcount = 0;
        do {
            int newy;
            int newx;
            int traily;
            int leady;
            int trailx;
            int leadx;
            if (++hitcount == 3) {
                this.stairstep(mo);
                return;
            }
            if (mo.momx > 0) {
                leadx = mo.x + mo.radius;
                trailx = mo.x - mo.radius;
            } else {
                leadx = mo.x - mo.radius;
                trailx = mo.x + mo.radius;
            }
            if (mo.momy > 0) {
                leady = mo.y + mo.radius;
                traily = mo.y - mo.radius;
            } else {
                leady = mo.y - mo.radius;
                traily = mo.y + mo.radius;
            }
            slideMove.bestslidefrac = 65537;
            this.PathTraverse(leadx, leady, leadx + mo.momx, leady + mo.momy, Defines.PT_ADDLINES, this::SlideTraverse);
            this.PathTraverse(trailx, leady, trailx + mo.momx, leady + mo.momy, Defines.PT_ADDLINES, this::SlideTraverse);
            this.PathTraverse(leadx, traily, leadx + mo.momx, traily + mo.momy, Defines.PT_ADDLINES, this::SlideTraverse);
            if (slideMove.bestslidefrac == 65537) {
                this.stairstep(mo);
                return;
            }
            slideMove.bestslidefrac -= 2048;
            if (slideMove.bestslidefrac > 0 && !this.TryMove(mo, mo.x + (newx = fixed_t.FixedMul(mo.momx, slideMove.bestslidefrac)), mo.y + (newy = fixed_t.FixedMul(mo.momy, slideMove.bestslidefrac)))) {
                this.stairstep(mo);
                return;
            }
            slideMove.bestslidefrac = 65536 - (slideMove.bestslidefrac + 2048);
            if (slideMove.bestslidefrac > 65536) {
                slideMove.bestslidefrac = 65536;
            }
            if (slideMove.bestslidefrac <= 0) {
                return;
            }
            slideMove.tmxmove = fixed_t.FixedMul(mo.momx, slideMove.bestslidefrac);
            slideMove.tmymove = fixed_t.FixedMul(mo.momy, slideMove.bestslidefrac);
            this.HitSlideLine(slideMove.bestslideline);
            mo.momx = slideMove.tmxmove;
            mo.momy = slideMove.tmymove;
        } while (!this.TryMove(mo, mo.x + slideMove.tmxmove, mo.y + slideMove.tmymove));
    }

    default public void stairstep(mobj_t mo) {
        if (!this.TryMove(mo, mo.x, mo.y + mo.momy)) {
            this.TryMove(mo, mo.x + mo.momx, mo.y);
        }
    }

    default public void XYMovement(mobj_t mo) {
        ActionTrait.Movement mv = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if (mo.momx == 0 && mo.momy == 0) {
            if ((mo.flags & 0x1000000L) != 0L) {
                mo.flags &= 0xFFFFFFFFFEFFFFFFL;
                mo.momz = 0;
                mo.momy = 0;
                mo.momx = 0;
                mo.SetMobjState(mo.info.spawnstate);
            }
            return;
        }
        player_t player = mo.player;
        if (mo.momx > 0x1E0000) {
            mo.momx = 0x1E0000;
        } else if (mo.momx < -1966080) {
            mo.momx = -1966080;
        }
        if (mo.momy > 0x1E0000) {
            mo.momy = 0x1E0000;
        } else if (mo.momy < -1966080) {
            mo.momy = -1966080;
        }
        int xmove = mo.momx;
        int ymove = mo.momy;
        do {
            int ptryy;
            int ptryx;
            if (xmove > 983040 || ymove > 983040) {
                ptryx = mo.x + xmove / 2;
                ptryy = mo.y + ymove / 2;
                xmove >>= 1;
                ymove >>= 1;
            } else {
                ptryx = mo.x + xmove;
                ptryy = mo.y + ymove;
                ymove = 0;
                xmove = 0;
            }
            if (this.TryMove(mo, ptryx, ptryy)) continue;
            if (mo.player != null) {
                this.SlideMove(mo);
                continue;
            }
            if (C2JUtils.eval(mo.flags & 0x10000L)) {
                if (mv.ceilingline != null && mv.ceilingline.backsector != null && mv.ceilingline.backsector.ceilingpic == this.DOOM().textureManager.getSkyFlatNum()) {
                    this.RemoveMobj(mo);
                    return;
                }
                this.ExplodeMissile(mo);
                continue;
            }
            mo.momy = 0;
            mo.momx = 0;
        } while ((xmove | ymove) != 0);
        if (player != null && C2JUtils.eval(player.cheats & 4)) {
            mo.momy = 0;
            mo.momx = 0;
            return;
        }
        if (C2JUtils.eval(mo.flags & 0x1010000L)) {
            return;
        }
        if (mo.z > mo.floorz) {
            return;
        }
        if (C2JUtils.eval(mo.flags & 0x100000L) && (mo.momx > 16384 || mo.momx < -16384 || mo.momy > 16384 || mo.momy < -16384) && mo.floorz != mo.subsector.sector.floorheight) {
            return;
        }
        if (mo.momx > -4096 && mo.momx < 4096 && mo.momy > -4096 && mo.momy < 4096 && (player == null || player.cmd.forwardmove == 0 && player.cmd.sidemove == 0)) {
            if (player != null && player.mo.mobj_state.id - statenum_t.S_PLAY_RUN1.ordinal() < 4) {
                player.mo.SetMobjState(statenum_t.S_PLAY);
            }
            mo.momx = 0;
            mo.momy = 0;
        } else {
            mo.momx = fixed_t.FixedMul(mo.momx, 59392);
            mo.momy = fixed_t.FixedMul(mo.momy, 59392);
        }
    }

    default public boolean SlideTraverse(intercept_t in) {
        ActionTrait.SlideMove slideMove = (ActionTrait.SlideMove)this.contextRequire(KEY_SLIDEMOVE);
        ActionTrait.Movement ma = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        if (!in.isaline) {
            this.doomSystem().Error("PTR_SlideTraverse: not a line?");
        }
        line_t li = (line_t)in.d();
        if (!C2JUtils.eval(li.flags & 4)) {
            if (li.PointOnLineSide(slideMove.slidemo.x, slideMove.slidemo.y)) {
                return true;
            }
            return this.isblocking(in, li);
        }
        this.LineOpening(li);
        if (ma.openrange < slideMove.slidemo.height || ma.opentop - slideMove.slidemo.z < slideMove.slidemo.height || ma.openbottom - slideMove.slidemo.z > 0x180000) {
            if (in.frac < slideMove.bestslidefrac) {
                slideMove.secondslidefrac = slideMove.bestslidefrac;
                slideMove.secondslideline = slideMove.bestslideline;
                slideMove.bestslidefrac = in.frac;
                slideMove.bestslideline = li;
            }
            return false;
        }
        return true;
    }

    public static final class DirType {
        int d1;
        int d2;
    }
}

