/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.mapthing_t;
import data.mobjtype_t;
import defines.statenum_t;
import java.util.logging.Logger;
import mochadoom.Loggers;
import p.AbstractLevelLoader;
import p.Actions.ActionsCeilings;
import p.Actions.ActionsDoors;
import p.Actions.ActionsFloors;
import p.Actions.ActionsLights;
import p.Actions.ActionsSlideDoors;
import p.ActiveStates;
import p.divline_t;
import p.floor_e;
import p.floormove_t;
import p.mobj_t;
import p.result_e;
import rr.line_t;
import rr.sector_t;
import rr.side_t;
import utils.C2JUtils;
import utils.TraitFactory;

public interface ActionsSectors
extends ActionsLights,
ActionsFloors,
ActionsDoors,
ActionsCeilings,
ActionsSlideDoors {
    public static final TraitFactory.ContextKey<RespawnQueue> KEY_RESP_QUEUE = ACTION_KEY_CHAIN.newKey(ActionsSectors.class, RespawnQueue::new);
    public static final TraitFactory.ContextKey<Spawn> KEY_SPAWN = ACTION_KEY_CHAIN.newKey(ActionsSectors.class, Spawn::new);
    public static final TraitFactory.ContextKey<Crushes> KEY_CRUSHES = ACTION_KEY_CHAIN.newKey(ActionsSectors.class, Crushes::new);

    public void RemoveMobj(mobj_t var1);

    public void DamageMobj(mobj_t var1, mobj_t var2, mobj_t var3, int var4);

    public mobj_t SpawnMobj(int var1, int var2, int var3, mobjtype_t var4);

    default public boolean ChangeSector(sector_t sector, boolean crunch) {
        Crushes cr = this.contextRequire(KEY_CRUSHES);
        cr.nofit = false;
        cr.crushchange = crunch;
        for (int x = sector.blockbox[2]; x <= sector.blockbox[3]; ++x) {
            for (int y = sector.blockbox[1]; y <= sector.blockbox[0]; ++y) {
                this.BlockThingsIterator(x, y, this::ChangeSector);
            }
        }
        return cr.nofit;
    }

    default public boolean ChangeSector(mobj_t thing) {
        Crushes cr = this.contextRequire(KEY_CRUSHES);
        if (this.ThingHeightClip(thing)) {
            return true;
        }
        if (thing.health <= 0) {
            thing.SetMobjState(statenum_t.S_GIBS);
            thing.flags &= 0xFFFFFFFFFFFFFFFDL;
            thing.height = 0;
            thing.radius = 0;
            return true;
        }
        if (C2JUtils.eval(thing.flags & 0x20000L)) {
            this.RemoveMobj(thing);
            return true;
        }
        if (!C2JUtils.eval(thing.flags & 4L)) {
            return true;
        }
        cr.nofit = true;
        if (cr.crushchange && !C2JUtils.eval(this.LevelTime() & 3)) {
            this.DamageMobj(thing, null, null, 10);
            mobj_t mo = this.SpawnMobj(thing.x, thing.y, thing.z + thing.height / 2, mobjtype_t.MT_BLOOD);
            mo.momx = this.P_Random() - this.P_Random() << 12;
            mo.momy = this.P_Random() - this.P_Random() << 12;
        }
        return true;
    }

    @Override
    default public result_e MovePlane(sector_t sector, int speed, int dest, boolean crush, int floorOrCeiling, int direction) {
        block23: {
            switch (floorOrCeiling) {
                case 0: {
                    switch (direction) {
                        case -1: {
                            if (sector.floorheight - speed < dest) {
                                int lastpos = sector.floorheight;
                                sector.floorheight = dest;
                                boolean flag = this.ChangeSector(sector, crush);
                                if (flag) {
                                    sector.floorheight = lastpos;
                                    this.ChangeSector(sector, crush);
                                }
                                return result_e.pastdest;
                            }
                            int lastpos = sector.floorheight;
                            sector.floorheight -= speed;
                            boolean flag = this.ChangeSector(sector, crush);
                            if (!flag) break;
                            sector.floorheight = lastpos;
                            this.ChangeSector(sector, crush);
                            return result_e.crushed;
                        }
                        case 1: {
                            if (sector.floorheight + speed > dest) {
                                int lastpos = sector.floorheight;
                                sector.floorheight = dest;
                                boolean flag = this.ChangeSector(sector, crush);
                                if (flag) {
                                    sector.floorheight = lastpos;
                                    this.ChangeSector(sector, crush);
                                }
                                return result_e.pastdest;
                            }
                            int lastpos = sector.floorheight;
                            sector.floorheight += speed;
                            boolean flag = this.ChangeSector(sector, crush);
                            if (!flag) break;
                            if (crush) {
                                return result_e.crushed;
                            }
                            sector.floorheight = lastpos;
                            this.ChangeSector(sector, crush);
                            return result_e.crushed;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (direction) {
                        case -1: {
                            if (sector.ceilingheight - speed < dest) {
                                int lastpos = sector.ceilingheight;
                                sector.ceilingheight = dest;
                                boolean flag = this.ChangeSector(sector, crush);
                                if (flag) {
                                    sector.ceilingheight = lastpos;
                                    this.ChangeSector(sector, crush);
                                }
                                return result_e.pastdest;
                            }
                            int lastpos = sector.ceilingheight;
                            sector.ceilingheight -= speed;
                            boolean flag = this.ChangeSector(sector, crush);
                            if (flag) {
                                if (crush) {
                                    return result_e.crushed;
                                }
                                sector.ceilingheight = lastpos;
                                this.ChangeSector(sector, crush);
                                return result_e.crushed;
                            }
                            break block23;
                        }
                        case 1: {
                            if (sector.ceilingheight + speed > dest) {
                                int lastpos = sector.ceilingheight;
                                sector.ceilingheight = dest;
                                boolean flag = this.ChangeSector(sector, crush);
                                if (flag) {
                                    sector.ceilingheight = lastpos;
                                    this.ChangeSector(sector, crush);
                                }
                                return result_e.pastdest;
                            }
                            int lastpos = sector.ceilingheight;
                            sector.ceilingheight += speed;
                            boolean bl = this.ChangeSector(sector, crush);
                        }
                    }
                }
            }
        }
        return result_e.ok;
    }

    @Override
    default public boolean DoDonut(line_t line) {
        int secnum = -1;
        boolean rtn = false;
        block0: while ((secnum = this.FindSectorFromLineTag(line, secnum)) >= 0) {
            sector_t s1 = this.levelLoader().sectors[secnum];
            if (s1.specialdata != null) continue;
            rtn = true;
            sector_t s2 = s1.lines[0].getNextSector(s1);
            for (int i = 0; i < s2.linecount; ++i) {
                if (!C2JUtils.eval(s2.lines[i].flags & 4) || s2.lines[i].backsector == s1) continue;
                sector_t s3 = s2.lines[i].backsector;
                floormove_t floor = new floormove_t();
                s2.specialdata = floor;
                floor.thinkerFunction = ActiveStates.T_MoveFloor;
                this.AddThinker(floor);
                floor.type = floor_e.donutRaise;
                floor.crush = false;
                floor.direction = 1;
                floor.sector = s2;
                floor.speed = 32768;
                floor.texture = s3.floorpic;
                floor.newspecial = 0;
                floor.floordestheight = s3.floorheight;
                floor = new floormove_t();
                s1.specialdata = floor;
                floor.thinkerFunction = ActiveStates.T_MoveFloor;
                this.AddThinker(floor);
                floor.type = floor_e.lowerFloor;
                floor.crush = false;
                floor.direction = -1;
                floor.sector = s1;
                floor.speed = 32768;
                floor.floordestheight = s3.floorheight;
                continue block0;
            }
        }
        return rtn;
    }

    @Override
    default public int FindSectorFromLineTag(line_t line, int start) {
        AbstractLevelLoader ll = this.levelLoader();
        for (int i = start + 1; i < ll.numsectors; ++i) {
            if (ll.sectors[i].tag != line.tag) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public side_t getSide(int currentSector, int line, int side) {
        AbstractLevelLoader ll = this.levelLoader();
        return ll.sides[ll.sectors[currentSector].lines[line].sidenum[side]];
    }

    @Override
    default public sector_t getSector(int currentSector, int line, int side) {
        AbstractLevelLoader ll = this.levelLoader();
        return ll.sides[ll.sectors[currentSector].lines[line].sidenum[side]].sector;
    }

    @Override
    default public boolean twoSided(int sector, int line) {
        return C2JUtils.eval(this.levelLoader().sectors[sector].lines[line].flags & 4);
    }

    default public void ClearRespawnQueue() {
        RespawnQueue rq = this.contextRequire(KEY_RESP_QUEUE);
        rq.iquetail = 0;
        rq.iquehead = 0;
    }

    public static final class Spawn {
        static final Logger LOGGER = Loggers.getLogger(ActionsSectors.class.getName());
        public mobj_t linetarget;
        public int attackrange;
        public mobj_t shootthing;
        public int shootz;
        public int la_damage;
        public int aimslope;
        public divline_t trace = new divline_t();
        public int topslope;
        public int bottomslope;
        public int bulletslope;

        boolean isMeleeRange() {
            return this.attackrange == Defines.MELEERANGE;
        }
    }

    public static final class RespawnQueue {
        mapthing_t[] itemrespawnque = new mapthing_t[Defines.ITEMQUESIZE];
        int[] itemrespawntime = new int[Defines.ITEMQUESIZE];
        int iquehead;
        int iquetail;
    }

    public static final class Crushes {
        boolean crushchange;
        boolean nofit;
    }
}

