/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.Limits;
import data.info;
import data.mapthing_t;
import data.mobjinfo_t;
import data.mobjtype_t;
import data.sounds;
import data.state_t;
import defines.skill_t;
import defines.statenum_t;
import doom.DoomMain;
import doom.player_t;
import java.util.logging.Level;
import p.Actions.ActionsSectors;
import p.ActiveStates;
import p.mobj_t;
import rr.subsector_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsSpawns
extends ActionsSectors {
    default public void NightmareRespawn(mobj_t mobj) {
        int x = mobj.spawnpoint.x << 16;
        int y = mobj.spawnpoint.y << 16;
        if (!this.CheckPosition(mobj, x, y)) {
            return;
        }
        mobj_t mo = this.SpawnMobj(mobj.x, mobj.y, mobj.subsector.sector.floorheight, mobjtype_t.MT_TFOG);
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_telept);
        subsector_t ss = this.levelLoader().PointInSubsector(x, y);
        mo = this.SpawnMobj(x, y, ss.sector.floorheight, mobjtype_t.MT_TFOG);
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_telept);
        mapthing_t mthing = mobj.spawnpoint;
        int z = C2JUtils.eval(mobj.info.flags & 0x100L) ? Defines.ONCEILINGZ : Defines.ONFLOORZ;
        mo = this.SpawnMobj(x, y, z, mobj.type);
        mo.spawnpoint = mobj.spawnpoint;
        mo.angle = 0x20000000L * (long)(mthing.angle / 45);
        if (C2JUtils.eval(mthing.options & Defines.MTF_AMBUSH)) {
            mo.flags |= 0x20L;
        }
        mo.reactiontime = 18;
        this.RemoveMobj(mobj);
    }

    @Override
    default public mobj_t SpawnMobj(int x, int y, int z, mobjtype_t type) {
        state_t st;
        mobj_t mobj = this.createMobj();
        mobjinfo_t info2 = info.mobjinfo[type.ordinal()];
        mobj.type = type;
        mobj.info = info2;
        mobj.x = x;
        mobj.y = y;
        mobj.radius = info2.radius;
        mobj.height = info2.height;
        mobj.flags = info2.flags;
        mobj.health = info2.spawnhealth;
        if (this.getGameSkill() != skill_t.sk_nightmare) {
            mobj.reactiontime = info2.reactiontime;
        }
        mobj.lastlook = this.P_Random() % 4;
        mobj.mobj_state = st = info.states[info2.spawnstate.ordinal()];
        mobj.mobj_tics = st.tics;
        mobj.mobj_sprite = st.sprite;
        mobj.mobj_frame = st.frame;
        this.SetThingPosition(mobj);
        mobj.floorz = mobj.subsector.sector.floorheight;
        mobj.ceilingz = mobj.subsector.sector.ceilingheight;
        mobj.z = z == Defines.ONFLOORZ ? mobj.floorz : (z == Defines.ONCEILINGZ ? mobj.ceilingz - mobj.info.height : z);
        mobj.thinkerFunction = ActiveStates.P_MobjThinker;
        this.AddThinker(mobj);
        return mobj;
    }

    default public void SpawnPlayer(mapthing_t mthing) {
        if (!this.PlayerInGame(mthing.type - 1)) {
            return;
        }
        player_t p = this.getPlayer(mthing.type - 1);
        if (p.playerstate == 2) {
            p.PlayerReborn();
        }
        int x = mthing.x << 16;
        int y = mthing.y << 16;
        int z = Defines.ONFLOORZ;
        mobj_t mobj = this.SpawnMobj(x, y, z, mobjtype_t.MT_PLAYER);
        if (mthing.type > 1) {
            mobj.flags |= (long)(mthing.type - 1 << 26);
        }
        mobj.angle = 0x20000000L * (long)(mthing.angle / 45);
        mobj.player = p;
        mobj.health = p.health[0];
        p.mo = mobj;
        p.playerstate = 0;
        p.refire = 0;
        p.message = null;
        p.damagecount = 0;
        p.bonuscount = 0;
        p.extralight = 0;
        p.fixedcolormap = 0;
        p.viewheight = 0x290000;
        p.SetupPsprites();
        if (this.IsDeathMatch()) {
            for (int i = 0; i < Defines.NUMCARDS; ++i) {
                p.cards[i] = true;
            }
        }
        if (mthing.type - 1 == this.ConsolePlayerNumber()) {
            this.statusBar().Start();
            this.headsUp().Start();
        }
    }

    default public mobj_t SpawnMapThing(mapthing_t mthing) {
        int i;
        int bit;
        DoomMain<?, ?> D = this.DOOM();
        if (mthing.type == 11) {
            if (D.deathmatch_p < 10) {
                D.deathmatchstarts[D.deathmatch_p] = new mapthing_t(mthing);
                ++D.deathmatch_p;
            }
            return null;
        }
        if (mthing.type <= 0) {
            return null;
        }
        if (mthing.type <= 4 && mthing.type > 0) {
            D.playerstarts[mthing.type - 1] = new mapthing_t(mthing);
            if (!this.IsDeathMatch()) {
                this.SpawnPlayer(mthing);
            }
            return null;
        }
        if (!this.IsNetGame() && C2JUtils.eval(mthing.options & 0x10)) {
            return null;
        }
        switch (this.getGameSkill()) {
            case sk_baby: {
                bit = 1;
                break;
            }
            case sk_nightmare: {
                bit = 4;
                break;
            }
            default: {
                bit = 1 << this.getGameSkill().ordinal() - 1;
            }
        }
        if (!C2JUtils.eval(mthing.options & bit)) {
            return null;
        }
        for (i = 0; i < Limits.NUMMOBJTYPES && mthing.type != info.mobjinfo[i].doomednum; ++i) {
        }
        if (i == Limits.NUMMOBJTYPES) {
            ActionsSectors.Spawn.LOGGER.log(Level.WARNING, String.format("P_SpawnMapThing: Unknown type %d at (%d, %d)", mthing.type, mthing.x, mthing.y));
            return null;
        }
        if (this.IsDeathMatch() && C2JUtils.eval(info.mobjinfo[i].flags & 0x2000000L)) {
            return null;
        }
        if (D.nomonsters && (i == mobjtype_t.MT_SKULL.ordinal() || C2JUtils.eval(info.mobjinfo[i].flags & 0x400000L))) {
            return null;
        }
        int x = mthing.x << 16;
        int y = mthing.y << 16;
        int z = C2JUtils.eval(info.mobjinfo[i].flags & 0x100L) ? Defines.ONCEILINGZ : Defines.ONFLOORZ;
        mobj_t mobj = this.SpawnMobj(x, y, z, mobjtype_t.values()[i]);
        mobj.spawnpoint.copyFrom(mthing);
        if (mobj.mobj_tics > 0L) {
            mobj.mobj_tics = 1L + (long)this.P_Random() % mobj.mobj_tics;
        }
        if (C2JUtils.eval(mobj.flags & 0x400000L)) {
            ++D.totalkills;
        }
        if (C2JUtils.eval(mobj.flags & 0x800000L)) {
            ++D.totalitems;
        }
        mobj.angle = 0x20000000L * (long)(mthing.angle / 45);
        if (C2JUtils.eval(mthing.options & Defines.MTF_AMBUSH)) {
            mobj.flags |= 0x20L;
        }
        return mobj;
    }

    default public void SpawnBlood(int x, int y, int z, int damage) {
        mobj_t th = this.SpawnMobj(x, y, z += this.P_Random() - this.P_Random() << 10, mobjtype_t.MT_BLOOD);
        th.momz = 131072;
        th.mobj_tics -= (long)(this.P_Random() & 3);
        if (th.mobj_tics < 1L) {
            th.mobj_tics = 1L;
        }
        if (damage <= 12 && damage >= 9) {
            th.SetMobjState(statenum_t.S_BLOOD2);
        } else if (damage < 9) {
            th.SetMobjState(statenum_t.S_BLOOD3);
        }
    }

    default public void SpawnPuff(int x, int y, int z) {
        mobj_t th = this.SpawnMobj(x, y, z += this.P_Random() - this.P_Random() << 10, mobjtype_t.MT_PUFF);
        th.momz = 65536;
        th.mobj_tics -= (long)(this.P_Random() & 3);
        if (th.mobj_tics < 1L) {
            th.mobj_tics = 1L;
        }
        if (this.contextTest(KEY_SPAWN, ActionsSectors.Spawn::isMeleeRange)) {
            th.SetMobjState(statenum_t.S_PUFF3);
        }
    }
}

