/*
 * Decompiled with CFR 0.152.
 */
package p.Actions;

import data.Defines;
import data.Tables;
import data.sounds;
import doom.player_t;
import java.util.function.Predicate;
import p.Actions.ActionTrait;
import p.ceiling_e;
import p.floor_e;
import p.intercept_t;
import p.mobj_t;
import p.plattype_e;
import p.stair_e;
import p.vldoor_e;
import rr.line_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface ActionsUseEvents
extends ActionTrait {
    public void VerticalDoor(line_t var1, mobj_t var2);

    public void LightTurnOn(line_t var1, int var2);

    public boolean BuildStairs(line_t var1, stair_e var2);

    public boolean DoDonut(line_t var1);

    public boolean DoFloor(line_t var1, floor_e var2);

    public boolean DoDoor(line_t var1, vldoor_e var2);

    public boolean DoPlat(line_t var1, plattype_e var2, int var3);

    public boolean DoCeiling(line_t var1, ceiling_e var2);

    public boolean DoLockedDoor(line_t var1, vldoor_e var2, mobj_t var3);

    public boolean PathTraverse(int var1, int var2, int var3, int var4, int var5, Predicate<intercept_t> var6);

    default public boolean UseSpecialLine(mobj_t thing, line_t line, boolean side) {
        if (side) {
            switch (line.special) {
                case 124: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (thing.player == null) {
            if (C2JUtils.eval(line.flags & 0x20)) {
                return false;
            }
            switch (line.special) {
                case 1: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        switch (line.special) {
            case 1: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 117: 
            case 118: {
                this.VerticalDoor(line, thing);
                break;
            }
            case 124: {
                break;
            }
            case 7: {
                if (!this.BuildStairs(line, stair_e.build8)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 9: {
                if (!this.DoDonut(line)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 11: {
                this.getSwitches().ChangeSwitchTexture(line, false);
                this.DOOM().ExitLevel();
                break;
            }
            case 14: {
                if (!this.DoPlat(line, plattype_e.raiseAndChange, 32)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 15: {
                if (!this.DoPlat(line, plattype_e.raiseAndChange, 24)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 18: {
                if (!this.DoFloor(line, floor_e.raiseFloorToNearest)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 20: {
                if (!this.DoPlat(line, plattype_e.raiseToNearestAndChange, 0)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 21: {
                if (!this.DoPlat(line, plattype_e.downWaitUpStay, 0)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 23: {
                if (!this.DoFloor(line, floor_e.lowerFloorToLowest)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 29: {
                if (!this.DoDoor(line, vldoor_e.normal)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 41: {
                if (!this.DoCeiling(line, ceiling_e.lowerToFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 71: {
                if (!this.DoFloor(line, floor_e.turboLower)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 49: {
                if (!this.DoCeiling(line, ceiling_e.crushAndRaise)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 50: {
                if (!this.DoDoor(line, vldoor_e.close)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 51: {
                this.getSwitches().ChangeSwitchTexture(line, false);
                this.DOOM().SecretExitLevel();
                break;
            }
            case 55: {
                if (!this.DoFloor(line, floor_e.raiseFloorCrush)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 101: {
                if (!this.DoFloor(line, floor_e.raiseFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 102: {
                if (!this.DoFloor(line, floor_e.lowerFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 103: {
                if (!this.DoDoor(line, vldoor_e.open)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 111: {
                if (!this.DoDoor(line, vldoor_e.blazeRaise)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 112: {
                if (!this.DoDoor(line, vldoor_e.blazeOpen)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 113: {
                if (!this.DoDoor(line, vldoor_e.blazeClose)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 122: {
                if (!this.DoPlat(line, plattype_e.blazeDWUS, 0)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 127: {
                if (!this.BuildStairs(line, stair_e.turbo16)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 131: {
                if (!this.DoFloor(line, floor_e.raiseFloorTurbo)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 133: 
            case 135: 
            case 137: {
                if (!this.DoLockedDoor(line, vldoor_e.blazeOpen, thing)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 140: {
                if (!this.DoFloor(line, floor_e.raiseFloor512)) break;
                this.getSwitches().ChangeSwitchTexture(line, false);
                break;
            }
            case 42: {
                if (!this.DoDoor(line, vldoor_e.close)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 43: {
                if (!this.DoCeiling(line, ceiling_e.lowerToFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 45: {
                if (!this.DoFloor(line, floor_e.lowerFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 60: {
                if (!this.DoFloor(line, floor_e.lowerFloorToLowest)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 61: {
                if (!this.DoDoor(line, vldoor_e.open)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 62: {
                if (!this.DoPlat(line, plattype_e.downWaitUpStay, 1)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 63: {
                if (!this.DoDoor(line, vldoor_e.normal)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 64: {
                if (!this.DoFloor(line, floor_e.raiseFloor)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 66: {
                if (!this.DoPlat(line, plattype_e.raiseAndChange, 24)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 67: {
                if (!this.DoPlat(line, plattype_e.raiseAndChange, 32)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 65: {
                if (!this.DoFloor(line, floor_e.raiseFloorCrush)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 68: {
                if (!this.DoPlat(line, plattype_e.raiseToNearestAndChange, 0)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 69: {
                if (!this.DoFloor(line, floor_e.raiseFloorToNearest)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 70: {
                if (!this.DoFloor(line, floor_e.turboLower)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 114: {
                if (!this.DoDoor(line, vldoor_e.blazeRaise)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 115: {
                if (!this.DoDoor(line, vldoor_e.blazeOpen)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 116: {
                if (!this.DoDoor(line, vldoor_e.blazeClose)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 123: {
                if (!this.DoPlat(line, plattype_e.blazeDWUS, 0)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 132: {
                if (!this.DoFloor(line, floor_e.raiseFloorTurbo)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 99: 
            case 134: 
            case 136: {
                if (!this.DoLockedDoor(line, vldoor_e.blazeOpen, thing)) break;
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 138: {
                this.LightTurnOn(line, 255);
                this.getSwitches().ChangeSwitchTexture(line, true);
                break;
            }
            case 139: {
                this.LightTurnOn(line, 35);
                this.getSwitches().ChangeSwitchTexture(line, true);
            }
        }
        return true;
    }

    default public void UseLines(player_t player) {
        ActionTrait.Spechits sp = (ActionTrait.Spechits)this.contextRequire(KEY_SPECHITS);
        sp.usething = player.mo;
        int angle = Tables.toBAMIndex(player.mo.angle);
        int x1 = player.mo.x;
        int y1 = player.mo.y;
        int x2 = x1 + (Defines.USERANGE >> 16) * Tables.finecosine[angle];
        int y2 = y1 + (Defines.USERANGE >> 16) * Tables.finesine[angle];
        this.PathTraverse(x1, y1, x2, y2, Defines.PT_ADDLINES, this::UseTraverse);
    }

    default public boolean UseTraverse(intercept_t in) {
        ActionTrait.Movement mov = (ActionTrait.Movement)this.contextRequire(KEY_MOVEMENT);
        ActionTrait.Spechits sp = (ActionTrait.Spechits)this.contextRequire(KEY_SPECHITS);
        line_t line = (line_t)in.d();
        if (line.special == 0) {
            this.LineOpening(line);
            if (mov.openrange <= 0) {
                this.StartSound((ISoundOrigin)sp.usething, sounds.sfxenum_t.sfx_noway);
                return false;
            }
            return true;
        }
        boolean side = false;
        if (line.PointOnLineSide(sp.usething.x, sp.usething.y)) {
            side = true;
        }
        this.UseSpecialLine(sp.usething, line, side);
        return false;
    }
}

