/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates;

import data.mobjtype_t;
import data.sounds;
import defines.skill_t;
import defines.statenum_t;
import p.Actions.ActiveStates.Monsters;
import p.Actions.ActiveStates.Sounds;
import p.ActiveStates;
import p.mobj_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface Ai
extends Monsters,
Sounds {
    default public void A_Look(mobj_t actor) {
        boolean seeyou = false;
        actor.threshold = 0;
        mobj_t targ = actor.subsector.sector.soundtarget;
        if (targ != null && C2JUtils.eval(targ.flags & 4L)) {
            actor.target = targ;
            seeyou = C2JUtils.eval(actor.flags & 0x20L) ? this.getEnemies().CheckSight(actor, actor.target) : true;
        }
        if (!seeyou && !this.getEnemies().LookForPlayers(actor, false)) {
            return;
        }
        if (actor.info.seesound != null && actor.info.seesound != sounds.sfxenum_t.sfx_None) {
            int sound;
            switch (actor.info.seesound) {
                case sfx_posit1: 
                case sfx_posit2: 
                case sfx_posit3: {
                    sound = sounds.sfxenum_t.sfx_posit1.ordinal() + this.P_Random() % 3;
                    break;
                }
                case sfx_bgsit1: 
                case sfx_bgsit2: {
                    sound = sounds.sfxenum_t.sfx_bgsit1.ordinal() + this.P_Random() % 2;
                    break;
                }
                default: {
                    sound = actor.info.seesound.ordinal();
                }
            }
            if (actor.type == mobjtype_t.MT_SPIDER || actor.type == mobjtype_t.MT_CYBORG) {
                this.StartSound(null, sound);
            } else {
                this.StartSound((ISoundOrigin)actor, sound);
            }
        }
        actor.SetMobjState(actor.info.seestate);
    }

    @Override
    default public void A_Chase(mobj_t actor) {
        boolean nomissile = false;
        if (actor.reactiontime != 0) {
            --actor.reactiontime;
        }
        if (actor.threshold != 0) {
            actor.threshold = actor.target == null || actor.target.health <= 0 ? 0 : --actor.threshold;
        }
        if (actor.movedir < 8) {
            actor.angle &= 0xFFFFFFFFE0000000L;
            actor.angle &= 0xFFFFFFFFL;
            int delta = (int)(actor.angle - (long)(actor.movedir << 29));
            if (delta > 0) {
                actor.angle -= 0x20000000L;
            } else if (delta < 0) {
                actor.angle += 0x20000000L;
            }
            actor.angle &= 0xFFFFFFFFL;
        }
        if (actor.target == null || !C2JUtils.eval(actor.target.flags & 4L)) {
            if (this.getEnemies().LookForPlayers(actor, true)) {
                return;
            }
            actor.SetMobjState(actor.info.spawnstate);
            return;
        }
        if (C2JUtils.eval(actor.flags & 0x80L)) {
            actor.flags &= 0xFFFFFFFFFFFFFF7FL;
            if (this.getGameSkill() != skill_t.sk_nightmare && !this.IsFastParm()) {
                this.getAttacks().NewChaseDir(actor);
            }
            return;
        }
        if (actor.info.meleestate != statenum_t.S_NULL && this.getEnemies().CheckMeleeRange(actor)) {
            if (actor.info.attacksound != null) {
                this.StartSound((ISoundOrigin)actor, actor.info.attacksound);
            }
            actor.SetMobjState(actor.info.meleestate);
            return;
        }
        if (actor.info.missilestate != statenum_t.S_NULL) {
            if (this.getGameSkill().ordinal() < skill_t.sk_nightmare.ordinal() && !this.IsFastParm() && actor.movecount != 0) {
                nomissile = true;
            } else if (!this.getEnemies().CheckMissileRange(actor)) {
                nomissile = true;
            }
            if (!nomissile) {
                actor.SetMobjState(actor.info.missilestate);
                actor.flags |= 0x80L;
                return;
            }
        }
        if (this.IsNetGame() && actor.threshold == 0 && !this.getEnemies().CheckSight(actor, actor.target) && this.getEnemies().LookForPlayers(actor, true)) {
            return;
        }
        if (--actor.movecount < 0 || !this.getAttacks().Move(actor)) {
            this.getAttacks().NewChaseDir(actor);
        }
        if (actor.info.activesound != null && this.P_Random() < 3) {
            this.StartSound((ISoundOrigin)actor, actor.info.activesound);
        }
    }

    @Override
    default public void A_Fall(mobj_t actor) {
        actor.flags &= 0xFFFFFFFFFFFFFFFDL;
    }

    default public void P_MobjThinker(mobj_t mobj) {
        if (mobj.momx != 0 || mobj.momy != 0 || C2JUtils.eval(mobj.flags & 0x1000000L)) {
            this.getAttacks().XYMovement(mobj);
            if (mobj.thinkerFunction == ActiveStates.NOP) {
                return;
            }
        }
        if (mobj.z != mobj.floorz || mobj.momz != 0) {
            mobj.ZMovement();
            if (mobj.thinkerFunction == ActiveStates.NOP) {
                return;
            }
        }
        if (mobj.mobj_tics != -1L) {
            --mobj.mobj_tics;
            if (!C2JUtils.eval(mobj.mobj_tics) && !mobj.SetMobjState(mobj.mobj_state.nextstate)) {
                // empty if block
            }
        } else {
            if (!C2JUtils.eval(mobj.flags & 0x400000L)) {
                return;
            }
            if (!this.DOOM().respawnmonsters) {
                return;
            }
            ++mobj.movecount;
            if (mobj.movecount < 420) {
                return;
            }
            if (C2JUtils.eval(this.LevelTime() & 0x1F)) {
                return;
            }
            if (this.P_Random() > 4) {
                return;
            }
            this.getEnemies().NightmareRespawn(mobj);
        }
    }

    @Override
    default public void A_FaceTarget(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        actor.flags &= 0xFFFFFFFFFFFFFFDFL;
        actor.angle = this.sceneRenderer().PointToAngle2(actor.x, actor.y, actor.target.x, actor.target.y) & 0xFFFFFFFFL;
        if (C2JUtils.eval(actor.target.flags & 0x40000L)) {
            actor.angle += (long)(this.P_Random() - this.P_Random() << 21);
        }
        actor.angle &= 0xFFFFFFFFL;
    }
}

