/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates;

import data.Defines;
import data.mobjtype_t;
import data.sounds;
import defines.statenum_t;
import doom.items;
import doom.player_t;
import p.Actions.ActionsSectors;
import p.Actions.ActiveStates.Monsters;
import p.mobj_t;
import p.pspdef_t;
import s.ISoundOrigin;
import utils.C2JUtils;

public interface Attacks
extends Monsters {
    public static final int BFGCELLS = 40;

    default public void A_FirePistol(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_pistol);
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK2);
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 1;
        player.SetPsprite(player_t.ps_flash, items.weaponinfo[player.readyweapon.ordinal()].flashstate);
        this.getAttacks().P_BulletSlope(player.mo);
        this.getAttacks().P_GunShot(player.mo, !C2JUtils.eval(player.refire));
    }

    default public void A_FireShotgun(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_shotgn);
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK2);
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 1;
        player.SetPsprite(player_t.ps_flash, items.weaponinfo[player.readyweapon.ordinal()].flashstate);
        this.getAttacks().P_BulletSlope(player.mo);
        for (int i = 0; i < 7; ++i) {
            this.getAttacks().P_GunShot(player.mo, false);
        }
    }

    default public void A_FireShotgun2(player_t player, pspdef_t psp) {
        ActionsSectors.Spawn sp = this.getEnemies().contextRequire(ActionsSectors.KEY_SPAWN);
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_dshtgn);
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK2);
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 2;
        player.SetPsprite(player_t.ps_flash, items.weaponinfo[player.readyweapon.ordinal()].flashstate);
        this.getAttacks().P_BulletSlope(player.mo);
        for (int i = 0; i < 20; ++i) {
            int damage = 5 * (this.P_Random() % 3 + 1);
            long angle = player.mo.angle;
            this.getAttacks().LineAttack(player.mo, angle += (long)(this.P_Random() - this.P_Random() << 19), Defines.MISSILERANGE, sp.bulletslope + (this.P_Random() - this.P_Random() << 5), damage);
        }
    }

    default public void A_Punch(player_t player, pspdef_t psp) {
        ActionsSectors.Spawn sp = this.contextRequire(ActionsSectors.KEY_SPAWN);
        int damage = this.P_Random() % 10 + 1 << 1;
        if (C2JUtils.eval(player.powers[1])) {
            damage *= 10;
        }
        long angle = player.mo.angle;
        int slope = this.getAttacks().AimLineAttack(player.mo, angle += (long)(this.P_Random() - this.P_Random() << 18), Defines.MELEERANGE);
        this.getAttacks().LineAttack(player.mo, angle, Defines.MELEERANGE, slope, damage);
        if (C2JUtils.eval(sp.linetarget)) {
            this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_punch);
            player.mo.angle = this.sceneRenderer().PointToAngle2(player.mo.x, player.mo.y, sp.linetarget.x, sp.linetarget.y) & 0xFFFFFFFFL;
        }
    }

    default public void A_Saw(player_t player, pspdef_t psp) {
        ActionsSectors.Spawn sp = this.contextRequire(ActionsSectors.KEY_SPAWN);
        int damage = 2 * (this.P_Random() % 10 + 1);
        long angle = player.mo.angle;
        angle += (long)(this.P_Random() - this.P_Random() << 18);
        int slope = this.getAttacks().AimLineAttack(player.mo, angle &= 0xFFFFFFFFL, Defines.MELEERANGE + 1);
        this.getAttacks().LineAttack(player.mo, angle, Defines.MELEERANGE + 1, slope, damage);
        if (!C2JUtils.eval(sp.linetarget)) {
            this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_sawful);
            return;
        }
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_sawhit);
        angle = this.sceneRenderer().PointToAngle2(player.mo.x, player.mo.y, sp.linetarget.x, sp.linetarget.y) & 0xFFFFFFFFL;
        long dangle = angle - player.mo.angle;
        player.mo.angle = (dangle &= 0xFFFFFFFFL) > 0x80000000L ? ((long)((int)dangle) < -53687091L ? angle + 0x30C30C3L : (player.mo.angle -= 0x3333333L)) : (dangle > 0x3333333L ? angle - 0x30C30C3L : (player.mo.angle += 0x3333333L));
        player.mo.angle &= 0xFFFFFFFFL;
        player.mo.flags |= 0x80L;
    }

    default public void A_FireMissile(player_t player, pspdef_t psp) {
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 1;
        this.getAttacks().SpawnPlayerMissile(player.mo, mobjtype_t.MT_ROCKET);
    }

    default public void A_FireBFG(player_t player, pspdef_t psp) {
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 40;
        this.getAttacks().SpawnPlayerMissile(player.mo, mobjtype_t.MT_BFG);
    }

    default public void A_FireCGun(player_t player, pspdef_t psp) {
        int readyweap = player.readyweapon.ordinal();
        int flashstate = items.weaponinfo[readyweap].flashstate.ordinal();
        int current_state = psp.state.id;
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_pistol);
        if (!C2JUtils.eval(player.ammo[items.weaponinfo[readyweap].ammo.ordinal()])) {
            return;
        }
        player.mo.SetMobjState(statenum_t.S_PLAY_ATK2);
        int n = items.weaponinfo[readyweap].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 1;
        player.SetPsprite(player_t.ps_flash, statenum_t.values()[flashstate + current_state - statenum_t.S_CHAIN1.ordinal()]);
        this.getAttacks().P_BulletSlope(player.mo);
        this.getAttacks().P_GunShot(player.mo, !C2JUtils.eval(player.refire));
    }

    default public void A_FirePlasma(player_t player, pspdef_t psp) {
        int n = items.weaponinfo[player.readyweapon.ordinal()].ammo.ordinal();
        player.ammo[n] = player.ammo[n] - 1;
        player.SetPsprite(player_t.ps_flash, items.weaponinfo[player.readyweapon.ordinal()].flashstate);
        this.getAttacks().SpawnPlayerMissile(player.mo, mobjtype_t.MT_PLASMA);
    }

    default public void A_XScream(mobj_t actor) {
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_slop);
    }

    default public void A_Pain(mobj_t actor) {
        if (actor.info.painsound != null) {
            this.StartSound((ISoundOrigin)actor, actor.info.painsound);
        }
    }

    default public void A_Explode(mobj_t thingy) {
        this.getAttacks().RadiusAttack(thingy, thingy.target, 128);
    }

    default public void A_BFGSpray(mobj_t mo) {
        ActionsSectors.Spawn sp = this.contextRequire(ActionsSectors.KEY_SPAWN);
        for (int i = 0; i < 40; ++i) {
            long an = mo.angle - 0x20000000L + 0x1999999L * (long)i & 0xFFFFFFFFL;
            this.getAttacks().AimLineAttack(mo.target, an, 0x4000000);
            if (!C2JUtils.eval(sp.linetarget)) continue;
            this.getEnemies().SpawnMobj(sp.linetarget.x, sp.linetarget.y, sp.linetarget.z + (sp.linetarget.height >> 2), mobjtype_t.MT_EXTRABFG);
            int damage = 0;
            for (int j = 0; j < 15; ++j) {
                damage += (this.P_Random() & 7) + 1;
            }
            this.getEnemies().DamageMobj(sp.linetarget, mo.target, mo.target, damage);
        }
    }
}

