/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates.MonsterStates;

import data.Tables;
import data.mobjinfo_t;
import data.mobjtype_t;
import data.sounds;
import defines.statenum_t;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.Actions.ActionTrait;
import p.Actions.ActionsAttacks;
import p.ChaseDirections;
import p.mobj_t;
import s.ISoundOrigin;

public interface Viles
extends ActionTrait {
    public void A_FaceTarget(mobj_t var1);

    public void A_Chase(mobj_t var1);

    default public void A_VileChase(mobj_t actor) {
        AbstractLevelLoader ll = this.levelLoader();
        ActionsAttacks actionsAttacks = this.getAttacks();
        ActionsAttacks.Attacks att = actionsAttacks.contextRequire(ActionsAttacks.KEY_ATTACKS);
        if (actor.movedir != 8) {
            att.vileTryX = actor.x + actor.info.speed * ChaseDirections.xspeed[actor.movedir];
            att.vileTryY = actor.y + actor.info.speed * ChaseDirections.yspeed[actor.movedir];
            int xl = ll.getSafeBlockX(att.vileTryX - ll.bmaporgx - 0x400000);
            int xh = ll.getSafeBlockX(att.vileTryX - ll.bmaporgx + 0x400000);
            int yl = ll.getSafeBlockY(att.vileTryY - ll.bmaporgy - 0x400000);
            int yh = ll.getSafeBlockY(att.vileTryY - ll.bmaporgy + 0x400000);
            att.vileObj = actor;
            for (int bx = xl; bx <= xh; ++bx) {
                for (int by = yl; by <= yh; ++by) {
                    if (this.BlockThingsIterator(bx, by, actionsAttacks::VileCheck)) continue;
                    mobj_t temp = actor.target;
                    actor.target = att.vileCorpseHit;
                    this.A_FaceTarget(actor);
                    actor.target = temp;
                    actor.SetMobjState(statenum_t.S_VILE_HEAL1);
                    this.StartSound((ISoundOrigin)att.vileCorpseHit, sounds.sfxenum_t.sfx_slop);
                    mobjinfo_t info2 = att.vileCorpseHit.info;
                    att.vileCorpseHit.SetMobjState(info2.raisestate);
                    att.vileCorpseHit.height <<= 2;
                    att.vileCorpseHit.flags = info2.flags;
                    att.vileCorpseHit.health = info2.spawnhealth;
                    att.vileCorpseHit.target = null;
                    return;
                }
            }
        }
        this.A_Chase(actor);
    }

    default public void A_VileStart(mobj_t actor) {
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_vilatk);
    }

    default public void A_StartFire(mobj_t actor) {
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_flamst);
        this.A_Fire(actor);
    }

    default public void A_FireCrackle(mobj_t actor) {
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_flame);
        this.A_Fire(actor);
    }

    default public void A_Fire(mobj_t actor) {
        mobj_t dest = actor.tracer;
        if (dest == null) {
            return;
        }
        if (!this.getEnemies().CheckSight(actor.target, dest)) {
            return;
        }
        this.getAttacks().UnsetThingPosition(actor);
        actor.x = dest.x + fixed_t.FixedMul(0x180000, Tables.finecosine(dest.angle));
        actor.y = dest.y + fixed_t.FixedMul(0x180000, Tables.finesine(dest.angle));
        actor.z = dest.z;
        this.SetThingPosition(actor);
    }

    default public void A_VileTarget(mobj_t actor) {
        mobj_t fog;
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        actor.tracer = fog = this.getEnemies().SpawnMobj(actor.target.x, actor.target.y, actor.target.z, mobjtype_t.MT_FIRE);
        fog.target = actor;
        fog.tracer = actor.target;
        this.A_Fire(fog);
    }

    default public void A_VileAttack(mobj_t actor) {
        if (actor.target == null) {
            return;
        }
        this.A_FaceTarget(actor);
        if (!this.getEnemies().CheckSight(actor, actor.target)) {
            return;
        }
        this.StartSound((ISoundOrigin)actor, sounds.sfxenum_t.sfx_barexp);
        this.getAttacks().DamageMobj(actor.target, actor, actor, 20);
        actor.target.momz = 65536000 / actor.target.info.mass;
        mobj_t fire = actor.tracer;
        if (fire == null) {
            return;
        }
        fire.x = actor.target.x - fixed_t.FixedMul(0x180000, Tables.finecosine(actor.angle));
        fire.y = actor.target.y - fixed_t.FixedMul(0x180000, Tables.finesine(actor.angle));
        this.getAttacks().RadiusAttack(fire, actor, 70);
    }
}

