/*
 * Decompiled with CFR 0.152.
 */
package p.Actions.ActiveStates;

import data.mobjtype_t;
import data.sounds;
import doom.player_t;
import p.Actions.ActionTrait;
import p.mobj_t;
import p.pspdef_t;
import s.ISoundOrigin;

public interface Sounds
extends ActionTrait {
    public void A_Chase(mobj_t var1);

    public void A_ReFire(player_t var1, pspdef_t var2);

    public void A_SpawnFly(mobj_t var1);

    default public void A_Scream(mobj_t actor) {
        int sound;
        switch (actor.info.deathsound) {
            case sfx_None: {
                return;
            }
            case sfx_podth1: 
            case sfx_podth2: 
            case sfx_podth3: {
                sound = sounds.sfxenum_t.sfx_podth1.ordinal() + this.P_Random() % 3;
                break;
            }
            case sfx_bgdth1: 
            case sfx_bgdth2: {
                sound = sounds.sfxenum_t.sfx_bgdth1.ordinal() + this.P_Random() % 2;
                break;
            }
            default: {
                sound = actor.info.deathsound.ordinal();
            }
        }
        if (actor.type == mobjtype_t.MT_SPIDER || actor.type == mobjtype_t.MT_CYBORG) {
            this.StartSound(null, sound);
        } else {
            this.StartSound((ISoundOrigin)actor, sound);
        }
    }

    default public void A_Hoof(mobj_t mo) {
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_hoof);
        this.A_Chase(mo);
    }

    default public void A_BFGsound(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_bfg);
    }

    default public void A_OpenShotgun2(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_dbopn);
    }

    default public void A_LoadShotgun2(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_dbload);
    }

    default public void A_CloseShotgun2(player_t player, pspdef_t psp) {
        this.StartSound((ISoundOrigin)player.mo, sounds.sfxenum_t.sfx_dbcls);
        this.A_ReFire(player, psp);
    }

    default public void A_BrainPain(mobj_t mo) {
        this.StartSound(null, sounds.sfxenum_t.sfx_bospn);
    }

    default public void A_Metal(mobj_t mo) {
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_metal);
        this.A_Chase(mo);
    }

    default public void A_BabyMetal(mobj_t mo) {
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_bspwlk);
        this.A_Chase(mo);
    }

    default public void A_SpawnSound(mobj_t mo) {
        this.StartSound((ISoundOrigin)mo, sounds.sfxenum_t.sfx_boscub);
        this.A_SpawnFly(mo);
    }

    default public void A_PlayerScream(mobj_t actor) {
        sounds.sfxenum_t sound = sounds.sfxenum_t.sfx_pldeth;
        if (this.DOOM().isCommercial() && actor.health < -50) {
            sound = sounds.sfxenum_t.sfx_pdiehi;
        }
        this.StartSound((ISoundOrigin)actor, sound);
    }
}

