/*
 * Decompiled with CFR 0.152.
 */
package p;

import data.maplinedef_t;
import data.mapnode_t;
import data.mapsector_t;
import data.mapseg_t;
import data.mapsidedef_t;
import data.mapsubsector_t;
import data.mapthing_t;
import data.mapvertex_t;
import defines.skill_t;
import defines.slopetype_t;
import doom.CommandVariable;
import doom.DoomMain;
import java.io.IOException;
import java.nio.ByteOrder;
import m.BBox;
import m.fixed_t;
import p.AbstractLevelLoader;
import p.mobj_t;
import rr.line_t;
import rr.node_t;
import rr.sector_t;
import rr.seg_t;
import rr.side_t;
import rr.subsector_t;
import rr.vertex_t;
import s.degenmobj_t;
import utils.C2JUtils;
import utils.GenericCopy;
import w.DoomBuffer;

public class LevelLoader
extends AbstractLevelLoader {
    public static final String rcsid = "$Id: LevelLoader.java,v 1.44 2012/09/24 17:16:23 velktron Exp $";
    sector_t dummy_sector = new sector_t();

    public LevelLoader(DoomMain<?, ?> DM) {
        super(DM);
        this.deathmatchstarts = new mapthing_t[10];
    }

    public void LoadVertexes(int lump) throws IOException {
        this.numvertexes = this.DOOM.wadLoader.LumpLength(lump) / mapvertex_t.sizeOf();
        this.vertexes = (vertex_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numvertexes, vertex_t::new, vertex_t[]::new);
    }

    public void LoadSegs(int lump) throws IOException {
        this.numsegs = this.DOOM.wadLoader.LumpLength(lump) / mapseg_t.sizeOf();
        this.segs = (seg_t[])GenericCopy.malloc(seg_t::new, seg_t[]::new, this.numsegs);
        mapseg_t[] data = (mapseg_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsegs, mapseg_t::new, mapseg_t[]::new);
        for (int i = 0; i < this.numsegs; ++i) {
            line_t ldef;
            seg_t li = this.segs[i];
            mapseg_t ml = data[i];
            li.v1 = this.vertexes[ml.v1];
            li.v2 = this.vertexes[ml.v2];
            li.assignVertexValues();
            li.angle = (long)(ml.angle << 16) & 0xFFFFFFFFL;
            li.offset = ml.offset << 16;
            char linedef = ml.linedef;
            li.linedef = ldef = this.lines[linedef];
            char side = ml.side;
            li.sidedef = this.sides[ldef.sidenum[side]];
            li.frontsector = this.sides[ldef.sidenum[side]].sector;
            if (C2JUtils.flags(ldef.flags, 4)) {
                if (ldef.sidenum[side ^ '\u0001'] == '\uffff') continue;
                li.backsector = this.sides[ldef.sidenum[side ^ '\u0001']].sector;
                continue;
            }
            li.backsector = null;
        }
    }

    public void LoadSubsectors(int lump) throws IOException {
        this.numsubsectors = this.DOOM.wadLoader.LumpLength(lump) / mapsubsector_t.sizeOf();
        this.subsectors = (subsector_t[])GenericCopy.malloc(subsector_t::new, subsector_t[]::new, this.numsubsectors);
        mapsubsector_t[] data = (mapsubsector_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsubsectors, mapsubsector_t::new, mapsubsector_t[]::new);
        for (int i = 0; i < this.numsubsectors; ++i) {
            mapsubsector_t ms = data[i];
            subsector_t ss = this.subsectors[i];
            ss.numlines = ms.numsegs;
            ss.firstline = ms.firstseg;
        }
    }

    public void LoadSectors(int lump) throws IOException {
        this.numsectors = this.DOOM.wadLoader.LumpLength(lump) / mapsector_t.sizeOf();
        this.sectors = (sector_t[])GenericCopy.malloc(sector_t::new, sector_t[]::new, this.numsectors);
        mapsector_t[] data = (mapsector_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsectors, mapsector_t::new, mapsector_t[]::new);
        int i = 0;
        while (i < this.numsectors) {
            mapsector_t ms = data[i];
            sector_t ss = this.sectors[i];
            ss.floorheight = ms.floorheight << 16;
            ss.ceilingheight = ms.ceilingheight << 16;
            ss.floorpic = (short)this.DOOM.textureManager.FlatNumForName(ms.floorpic);
            ss.ceilingpic = (short)this.DOOM.textureManager.FlatNumForName(ms.ceilingpic);
            ss.lightlevel = ms.lightlevel;
            ss.special = ms.special;
            ss.tag = ms.tag;
            ss.thinglist = null;
            ss.id = i++;
            ss.TL = this.DOOM.actions;
            ss.RND = this.DOOM.random;
        }
    }

    public void LoadNodes(int lump) throws IOException {
        this.numnodes = this.DOOM.wadLoader.LumpLength(lump) / mapnode_t.sizeOf();
        this.nodes = (node_t[])GenericCopy.malloc(node_t::new, node_t[]::new, this.numnodes);
        mapnode_t[] data = (mapnode_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numnodes, mapnode_t::new, mapnode_t[]::new);
        for (int i = 0; i < this.numnodes; ++i) {
            mapnode_t mn = data[i];
            node_t no = this.nodes[i];
            no.x = mn.x << 16;
            no.y = mn.y << 16;
            no.dx = mn.dx << 16;
            no.dy = mn.dy << 16;
            for (int j = 0; j < 2; ++j) {
                no.children[j] = mn.children[j];
                if (no.children[j] == 65535) {
                    no.children[j] = -1;
                } else if (C2JUtils.flags(no.children[j], 32768)) {
                    int n = j;
                    no.children[n] = no.children[n] & 0xFFFF7FFF;
                    if (no.children[j] >= this.numsubsectors) {
                        System.err.printf("P_LoadNodes: BSP tree references invalid subsector %d.\n", no.children[j]);
                        no.children[j] = 0;
                    }
                    int n2 = j;
                    no.children[n2] = no.children[n2] | Integer.MIN_VALUE;
                }
                for (int k = 0; k < 4; ++k) {
                    no.bbox[j].set(k, mn.bbox[j][k] << 16);
                }
            }
        }
    }

    public void LoadThings(int lump) throws IOException {
        int numthings = this.DOOM.wadLoader.LumpLength(lump) / mapthing_t.sizeOf();
        mapthing_t[] data = (mapthing_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, numthings, mapthing_t::new, mapthing_t[]::new);
        for (int i = 0; i < numthings; ++i) {
            mapthing_t mt = data[i];
            boolean spawn = true;
            if (!this.DOOM.isCommercial()) {
                switch (mt.type) {
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 71: 
                    case 84: 
                    case 88: 
                    case 89: {
                        spawn = false;
                    }
                }
            }
            if (!spawn) break;
            this.DOOM.actions.SpawnMapThing(mt);
        }
    }

    public void LoadLineDefs(int lump) throws IOException {
        this.numlines = this.DOOM.wadLoader.LumpLength(lump) / maplinedef_t.sizeOf();
        this.lines = (line_t[])GenericCopy.malloc(line_t::new, line_t[]::new, this.numlines);
        this.used_lines = new boolean[this.numlines];
        maplinedef_t[] data = (maplinedef_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numlines, maplinedef_t::new, maplinedef_t[]::new);
        for (int i = 0; i < this.numlines; ++i) {
            maplinedef_t mld = data[i];
            line_t ld = this.lines[i];
            ld.flags = mld.flags;
            ld.special = mld.special;
            ld.tag = mld.tag;
            vertex_t v1 = ld.v1 = this.vertexes[mld.v1];
            vertex_t v2 = ld.v2 = this.vertexes[mld.v2];
            ld.dx = v2.x - v1.x;
            ld.dy = v2.y - v1.y;
            ld.assignVertexValues();
            ld.slopetype = ld.dx == 0 ? slopetype_t.ST_VERTICAL : (ld.dy == 0 ? slopetype_t.ST_HORIZONTAL : (fixed_t.FixedDiv(ld.dy, ld.dx) > 0 ? slopetype_t.ST_POSITIVE : slopetype_t.ST_NEGATIVE));
            if (v1.x < v2.x) {
                ld.bbox[2] = v1.x;
                ld.bbox[3] = v2.x;
            } else {
                ld.bbox[2] = v2.x;
                ld.bbox[3] = v1.x;
            }
            if (v1.y < v2.y) {
                ld.bbox[1] = v1.y;
                ld.bbox[0] = v2.y;
            } else {
                ld.bbox[1] = v2.y;
                ld.bbox[0] = v1.y;
            }
            ld.sidenum[0] = mld.sidenum[0];
            ld.sidenum[1] = mld.sidenum[1];
            if (C2JUtils.flags(ld.flags, 4) && (ld.sidenum[0] == '\uffff' || ld.sidenum[1] == '\uffff')) {
                ld.flags = (short)(ld.flags ^ 4);
            }
            if (ld.sidenum[0] != '\uffff') {
                ld.frontsector = this.sides[ld.sidenum[0]].sector;
                if (ld.frontsector == null) {
                    ld.frontsector = this.dummy_sector;
                }
            } else {
                ld.frontsector = null;
            }
            if (ld.sidenum[1] != '\uffff') {
                ld.backsector = this.sides[ld.sidenum[1]].sector;
                if (ld.backsector == null) {
                    ld.backsector = this.dummy_sector;
                }
            } else {
                ld.backsector = null;
            }
            if (ld.frontsector == null && ld.backsector == null) continue;
            this.used_lines[i] = true;
        }
    }

    public void LoadSideDefs(int lump) throws IOException {
        this.numsides = this.DOOM.wadLoader.LumpLength(lump) / mapsidedef_t.sizeOf();
        this.sides = (side_t[])GenericCopy.malloc(side_t::new, side_t[]::new, this.numsides);
        mapsidedef_t[] data = (mapsidedef_t[])this.DOOM.wadLoader.CacheLumpNumIntoArray(lump, this.numsides, mapsidedef_t::new, mapsidedef_t[]::new);
        for (int i = 0; i < this.numsides; ++i) {
            mapsidedef_t msd = data[i];
            side_t sd = this.sides[i];
            sd.textureoffset = msd.textureoffset << 16;
            sd.rowoffset = msd.rowoffset << 16;
            sd.toptexture = (short)this.DOOM.textureManager.TextureNumForName(msd.toptexture);
            sd.bottomtexture = (short)this.DOOM.textureManager.TextureNumForName(msd.bottomtexture);
            sd.midtexture = (short)this.DOOM.textureManager.TextureNumForName(msd.midtexture);
            sd.sector = msd.sector < 0 ? this.dummy_sector : this.sectors[msd.sector];
        }
    }

    public void LoadBlockMap(int lump) throws IOException {
        int i;
        int count = 0;
        if (this.DOOM.cVarManager.bool(CommandVariable.BLOCKMAP) || this.DOOM.wadLoader.LumpLength(lump) < 8 || (count = this.DOOM.wadLoader.LumpLength(lump) / 2) >= 65536) {
            this.CreateBlockMap();
        } else {
            DoomBuffer data = this.DOOM.wadLoader.CacheLumpNum(lump, 50, DoomBuffer.class);
            count = this.DOOM.wadLoader.LumpLength(lump) / 2;
            this.blockmaplump = new int[count];
            data.setOrder(ByteOrder.LITTLE_ENDIAN);
            data.rewind();
            data.readCharArray(this.blockmaplump, count);
            this.bmaporgx = this.blockmaplump[0] << 16;
            this.bmaporgy = this.blockmaplump[1] << 16;
            this.bmapwidth = this.blockmaplump[2];
            this.bmapheight = this.blockmaplump[3];
            for (int i2 = 4; i2 < count; ++i2) {
                short t = (short)this.blockmaplump[i2];
                this.blockmaplump[i2] = (int)(t == -1 ? -1L : (long)(t & 0xFFFF));
            }
            if (!this.VerifyBlockMap(count)) {
                System.err.printf("P_LoadBlockMap: erroneous BLOCKMAP lump may cause crashes.\n", new Object[0]);
                System.err.printf("P_LoadBlockMap: use \"-blockmap\" command line switch for rebuilding\n", new Object[0]);
            }
        }
        count = this.bmapwidth * this.bmapheight;
        this.blockmap = new int[this.blockmaplump.length - 4];
        for (i = 0; i < this.blockmaplump.length - 4; ++i) {
            short t;
            this.blockmaplump[i] = i < count ? this.blockmaplump[i + 4] - 4 : (int)((t = (short)this.blockmaplump[i + 4]) == -1 ? -1L : (long)(t & 0xFFFF));
        }
        if (this.blocklinks != null && this.blocklinks.length == count) {
            for (i = 0; i < count; ++i) {
                this.blocklinks[i] = null;
            }
        } else {
            this.blocklinks = new mobj_t[count];
        }
        this.blockmap = this.blockmaplump;
    }

    public void GroupLines() {
        line_t li;
        int i;
        int[] bbox = new int[4];
        for (i = 0; i < this.numsubsectors; ++i) {
            subsector_t ss = this.subsectors[i];
            seg_t seg = this.segs[ss.firstline];
            ss.sector = seg.sidedef.sector;
        }
        int total = 0;
        for (i = 0; i < this.numlines; ++i) {
            li = this.lines[i];
            ++total;
            ++li.frontsector.linecount;
            if (li.backsector == null || li.backsector == li.frontsector) continue;
            ++li.backsector.linecount;
            ++total;
        }
        for (i = 0; i < this.numsectors; ++i) {
            sector_t sector = this.sectors[i];
            BBox.ClearBox(bbox);
            int countlines = 0;
            for (int j = 0; j < this.numlines; ++j) {
                li = this.lines[j];
                if (li.frontsector != sector && li.backsector != sector) continue;
                ++countlines;
                BBox.AddToBox(bbox, li.v1.x, li.v1.y);
                BBox.AddToBox(bbox, li.v2.x, li.v2.y);
            }
            sector.lines = new line_t[countlines];
            int addedlines = 0;
            int pointline = 0;
            for (int j = 0; j < this.numlines; ++j) {
                li = this.lines[j];
                if (li.frontsector != sector && li.backsector != sector) continue;
                this.sectors[i].lines[pointline++] = this.lines[j];
                ++addedlines;
            }
            if (addedlines != sector.linecount) {
                this.DOOM.doomSystem.Error("P_GroupLines: miscounted");
            }
            sector.soundorg = new degenmobj_t((bbox[3] + bbox[2]) / 2, (bbox[0] + bbox[1]) / 2, (sector.ceilingheight - sector.floorheight) / 2);
            int block = bbox[0] - this.bmaporgy + 0x200000 >> 23;
            sector.blockbox[0] = block = block >= this.bmapheight ? this.bmapheight - 1 : block;
            block = bbox[1] - this.bmaporgy - 0x200000 >> 23;
            sector.blockbox[1] = block = block < 0 ? 0 : block;
            block = bbox[3] - this.bmaporgx + 0x200000 >> 23;
            sector.blockbox[3] = block = block >= this.bmapwidth ? this.bmapwidth - 1 : block;
            block = bbox[2] - this.bmaporgx - 0x200000 >> 23;
            sector.blockbox[2] = block = block < 0 ? 0 : block;
        }
    }

    @Override
    public void SetupLevel(int episode, int map, int playermask, skill_t skill) {
        try {
            int i;
            this.DOOM.wminfo.maxfrags = 0;
            this.DOOM.totalsecret = 0;
            this.DOOM.totalitems = 0;
            this.DOOM.totalkills = 0;
            this.DOOM.wminfo.partime = 180;
            for (i = 0; i < 4; ++i) {
                this.DOOM.players[i].itemcount = 0;
                this.DOOM.players[i].secretcount = 0;
                this.DOOM.players[i].killcount = 0;
            }
            this.DOOM.players[this.DOOM.consoleplayer].viewz = 1;
            this.DOOM.doomSound.Start();
            this.DOOM.actions.InitThinkers();
            this.DOOM.wadLoader.Reload();
            String lumpname = this.DOOM.isCommercial() ? (map < 10 ? "MAP0" + map : "MAP" + map) : "E" + (char)(48 + episode) + "M" + (char)(48 + map);
            int lumpnum = this.DOOM.wadLoader.GetNumForName(lumpname);
            this.DOOM.leveltime = 0;
            if (!this.DOOM.wadLoader.verifyLumpName(lumpnum + 10, LABELS[10])) {
                System.err.println("Blockmap missing!");
            }
            this.LoadVertexes(lumpnum + 4);
            this.LoadSectors(lumpnum + 8);
            this.LoadSideDefs(lumpnum + 3);
            this.LoadLineDefs(lumpnum + 2);
            this.LoadSubsectors(lumpnum + 6);
            this.LoadNodes(lumpnum + 7);
            this.LoadSegs(lumpnum + 5);
            this.LoadBlockMap(lumpnum + 10);
            this.LoadReject(lumpnum + 9);
            this.GroupLines();
            this.DOOM.bodyqueslot = 0;
            this.DOOM.deathmatch_p = 0;
            this.LoadThings(lumpnum + 1);
            if (this.DOOM.deathmatch) {
                for (i = 0; i < 4; ++i) {
                    if (!this.DOOM.playeringame[i]) continue;
                    this.DOOM.players[i].mo = null;
                    this.DOOM.DeathMatchSpawnPlayer(i);
                }
            }
            this.DOOM.actions.ClearRespawnQueue();
            this.DOOM.actions.SpawnSpecials();
            if (this.DOOM.precache) {
                this.DOOM.textureManager.PrecacheLevel();
                this.DOOM.sceneRenderer.PreCacheThinkers();
            }
        }
        catch (Exception e) {
            System.err.println("Error while loading level");
            e.printStackTrace();
        }
    }
}

