/*
 * Decompiled with CFR 0.152.
 */
package p;

import data.info;
import data.mapthing_t;
import data.mobjinfo_t;
import data.mobjtype_t;
import data.sounds;
import data.spritenum_t;
import data.state_t;
import defines.statenum_t;
import doom.DoomMain;
import doom.player_t;
import doom.thinker_t;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import p.ActionFunctions;
import p.ActiveStates;
import p.Interceptable;
import p.MapUtils;
import rr.subsector_t;
import s.ISoundOrigin;
import utils.C2JUtils;
import w.IPackableDoomObject;
import w.IReadableDoomObject;
import w.IWritableDoomObject;

public class mobj_t
extends thinker_t
implements ISoundOrigin,
Interceptable,
IWritableDoomObject,
IPackableDoomObject,
IReadableDoomObject {
    public final ActionFunctions A;
    public int x;
    public int y;
    public int z;
    public thinker_t snext;
    public thinker_t sprev;
    public long angle;
    public spritenum_t mobj_sprite;
    public int mobj_frame;
    public thinker_t bnext;
    public thinker_t bprev;
    public subsector_t subsector;
    public int floorz;
    public int ceilingz;
    public int radius;
    public int height;
    public int momx;
    public int momy;
    public int momz;
    public int validcount;
    public mobjtype_t type;
    public mobjinfo_t info;
    public long mobj_tics;
    public state_t mobj_state;
    public long flags;
    public int health;
    public int movedir;
    public int movecount;
    public mobj_t target;
    public int p_target;
    public int reactiontime;
    public int threshold;
    public player_t player;
    public int lastlook;
    public mapthing_t spawnpoint = new mapthing_t();
    public mobj_t tracer;
    public static final int MF_SPECIAL = 1;
    public static final int MF_SOLID = 2;
    public static final int MF_SHOOTABLE = 4;
    public static final int MF_NOSECTOR = 8;
    public static final int MF_NOBLOCKMAP = 16;
    public static final int MF_AMBUSH = 32;
    public static final int MF_JUSTHIT = 64;
    public static final int MF_JUSTATTACKED = 128;
    public static final int MF_SPAWNCEILING = 256;
    public static final int MF_NOGRAVITY = 512;
    public static final int MF_DROPOFF = 1024;
    public static final int MF_PICKUP = 2048;
    public static final int MF_NOCLIP = 4096;
    public static final int MF_SLIDE = 8192;
    public static final int MF_FLOAT = 16384;
    public static final int MF_TELEPORT = 32768;
    public static final int MF_MISSILE = 65536;
    public static final int MF_DROPPED = 131072;
    public static final int MF_SHADOW = 262144;
    public static final int MF_NOBLOOD = 524288;
    public static final int MF_CORPSE = 0x100000;
    public static final int MF_INFLOAT = 0x200000;
    public static final int MF_COUNTKILL = 0x400000;
    public static final int MF_COUNTITEM = 0x800000;
    public static final int MF_SKULLFLY = 0x1000000;
    public static final int MF_NOTDMATCH = 0x2000000;
    public static final int MF_TRANSLATION = 0xC000000;
    public static final int MF_TRANSSHIFT = 26;
    public int eflags;
    public int stateid;
    public int playerid;
    public int p_tracer;
    public int thingnum;
    private static ByteBuffer buffer = ByteBuffer.allocate(154);
    private static ByteBuffer fastclear = ByteBuffer.allocate(154);
    protected static int count = 0;

    public static mobj_t createOn(DoomMain<?, ?> context) {
        if (C2JUtils.eval(context.actions)) {
            return new mobj_t(context.actions);
        }
        return new mobj_t();
    }

    private mobj_t() {
        this.A = null;
    }

    private mobj_t(ActionFunctions A) {
        this.A = A;
    }

    public boolean SetMobjState(statenum_t state) {
        do {
            state_t st;
            if (state == statenum_t.S_NULL) {
                this.mobj_state = null;
                this.A.RemoveMobj(this);
                return false;
            }
            this.mobj_state = st = data.info.states[state.ordinal()];
            this.mobj_tics = st.tics;
            this.mobj_sprite = st.sprite;
            this.mobj_frame = st.frame;
            if (st.action.isParamType(ActiveStates.MobjConsumer.class)) {
                st.action.fun(ActiveStates.MobjConsumer.class).accept(this.A, this);
            }
            state = st.nextstate;
        } while (!C2JUtils.eval(this.mobj_tics));
        return true;
    }

    public void ZMovement() {
        if (this.player != null && this.z < this.floorz) {
            this.player.viewheight -= this.floorz - this.z;
            this.player.deltaviewheight = 0x290000 - this.player.viewheight >> 3;
        }
        this.z += this.momz;
        if ((this.flags & 0x4000L) != 0L && this.target != null && (this.flags & 0x1000000L) == 0L && (this.flags & 0x200000L) == 0L) {
            int dist = MapUtils.AproxDistance(this.x - this.target.x, this.y - this.target.y);
            int delta = this.target.z + (this.height >> 1) - this.z;
            if (delta < 0 && dist < -(delta * 3)) {
                this.z -= 262144;
            } else if (delta > 0 && dist < delta * 3) {
                this.z += 262144;
            }
        }
        if (this.z <= this.floorz) {
            if ((this.flags & 0x1000000L) != 0L) {
                this.momz = -this.momz;
            }
            if (this.momz < 0) {
                if (this.player != null && this.momz < -524288) {
                    this.player.deltaviewheight = this.momz >> 3;
                    this.A.DOOM.doomSound.StartSound((ISoundOrigin)this, sounds.sfxenum_t.sfx_oof);
                }
                this.momz = 0;
            }
            this.z = this.floorz;
            if ((this.flags & 0x10000L) != 0L && (this.flags & 0x1000L) == 0L) {
                this.A.ExplodeMissile(this);
                return;
            }
        } else if ((this.flags & 0x200L) == 0L) {
            this.momz = this.momz == 0 ? -131072 : (this.momz -= 65536);
        }
        if (this.z + this.height > this.ceilingz) {
            if (this.momz > 0) {
                this.momz = 0;
            }
            this.z = this.ceilingz - this.height;
            if ((this.flags & 0x1000000L) != 0L) {
                this.momz = -this.momz;
            }
            if ((this.flags & 0x10000L) != 0L && (this.flags & 0x1000L) == 0L) {
                this.A.ExplodeMissile(this);
            }
        }
    }

    public void clear() {
        fastclear.rewind();
        try {
            this.unpack(fastclear);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        buffer.position(0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        f.read(buffer.array());
        this.unpack(buffer);
    }

    @Override
    public void write(DataOutputStream f) throws IOException {
        buffer.position(0);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.pack(buffer);
        f.write(buffer.array());
    }

    @Override
    public void pack(ByteBuffer b) throws IOException {
        b.order(ByteOrder.LITTLE_ENDIAN);
        super.pack(b);
        b.putInt(this.x);
        b.putInt(this.y);
        b.putInt(this.z);
        b.putInt(C2JUtils.pointer(this.snext));
        b.putInt(C2JUtils.pointer(this.sprev));
        b.putInt((int)(this.angle & 0xFFFFFFFFL));
        b.putInt(this.mobj_sprite.ordinal());
        b.putInt(this.mobj_frame);
        b.putInt(C2JUtils.pointer(this.bnext));
        b.putInt(C2JUtils.pointer(this.bprev));
        b.putInt(C2JUtils.pointer(this.subsector));
        b.putInt(this.floorz);
        b.putInt(this.ceilingz);
        b.putInt(this.radius);
        b.putInt(this.height);
        b.putInt(this.momx);
        b.putInt(this.momy);
        b.putInt(this.momz);
        b.putInt(this.validcount);
        b.putInt(this.type.ordinal());
        b.putInt(C2JUtils.pointer(this.info));
        b.putInt((int)(this.mobj_tics & 0xFFFFFFFFL));
        b.putInt(this.mobj_state.id);
        b.putInt((int)this.flags);
        b.putInt(this.health);
        b.putInt(this.movedir);
        b.putInt(this.movecount);
        b.putInt(C2JUtils.pointer(this.target));
        b.putInt(this.reactiontime);
        b.putInt(this.threshold);
        if (this.player != null) {
            b.putInt(1 + this.player.identify());
        } else {
            b.putInt(0);
        }
        b.putInt(this.lastlook);
        this.spawnpoint.pack(b);
        b.putInt(C2JUtils.pointer(this.tracer));
    }

    @Override
    public void unpack(ByteBuffer b) throws IOException {
        b.order(ByteOrder.LITTLE_ENDIAN);
        super.unpack(b);
        this.x = b.getInt();
        this.y = b.getInt();
        this.z = b.getInt();
        b.getLong();
        this.angle = 0xFFFFFFFFL & (long)b.getInt();
        this.mobj_sprite = spritenum_t.values()[b.getInt()];
        this.mobj_frame = b.getInt();
        b.getLong();
        b.getInt();
        this.floorz = b.getInt();
        this.ceilingz = b.getInt();
        this.radius = b.getInt();
        this.height = b.getInt();
        this.momx = b.getInt();
        this.momy = b.getInt();
        this.momz = b.getInt();
        this.validcount = b.getInt();
        this.type = mobjtype_t.values()[b.getInt()];
        b.getInt();
        this.mobj_tics = 0xFFFFFFFFL & (long)b.getInt();
        this.stateid = b.getInt();
        this.flags = (long)b.getInt() & 0xFFFFFFFFL;
        this.health = b.getInt();
        this.movedir = b.getInt();
        this.movecount = b.getInt();
        this.p_target = b.getInt();
        this.reactiontime = b.getInt();
        this.threshold = b.getInt();
        this.playerid = b.getInt();
        this.lastlook = b.getInt();
        this.spawnpoint.unpack(b);
        this.p_tracer = b.getInt();
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getZ() {
        return this.z;
    }

    public String toString() {
        return String.format("%s %d", new Object[]{this.type, this.thingnum});
    }
}

