/*
 * Decompiled with CFR 0.152.
 */
package pooling;

import java.util.Enumeration;
import java.util.Hashtable;
import p.mobj_t;

public abstract class ObjectPool<K> {
    private static final boolean D = false;
    private long expirationTime;
    protected Hashtable<K, Long> locked;
    private Hashtable<K, Long> unlocked;

    public ObjectPool(long expirationTime) {
        this.expirationTime = expirationTime;
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
    }

    protected abstract K create();

    public abstract boolean validate(K var1);

    public abstract void expire(K var1);

    public synchronized K checkOut() {
        K t;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<K> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    if (t instanceof mobj_t) {
                        // empty if block
                    }
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void checkIn(K t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }
}

