/*
 * Decompiled with CFR 0.152.
 */
package pooling;

import java.util.Arrays;

public class RoguePatchMap2 {
    private static final int DEFAULT_CAPACITY = 16;
    private int[] lumps = new int[16];
    private int numEntries;
    private byte[][][] patches = new byte[16][][];

    boolean containsKey(int lump) {
        return this.indexOf(lump) >= 0;
    }

    public byte[][] get(int lump) {
        int index = this.indexOf(lump);
        if (index >= 0) {
            return this.patches[index];
        }
        return null;
    }

    public void put(int lump, byte[][] patch) {
        int index = this.indexOf(lump);
        if (index >= 0) {
            this.patches[index] = patch;
        } else {
            this.ensureCapacity(this.numEntries + 1);
            int newIndex = ~index;
            int moveCount = this.numEntries - newIndex;
            if (moveCount > 0) {
                System.arraycopy(this.lumps, newIndex, this.lumps, newIndex + 1, moveCount);
                System.arraycopy(this.patches, newIndex, this.patches, newIndex + 1, moveCount);
            }
            this.lumps[newIndex] = lump;
            this.patches[newIndex] = patch;
            ++this.numEntries;
        }
    }

    private void ensureCapacity(int cap) {
        while (this.lumps.length <= cap) {
            this.lumps = Arrays.copyOf(this.lumps, Math.max(this.lumps.length * 2, 16));
        }
        while (this.patches.length <= cap) {
            this.patches = (byte[][][])Arrays.copyOf(this.patches, Math.max(this.patches.length * 2, 16));
        }
    }

    private int indexOf(int lump) {
        return Arrays.binarySearch(this.lumps, 0, this.numEntries, lump);
    }
}

