/*
 * Decompiled with CFR 0.152.
 */
package rr;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import rr.column_t;
import rr.patch_t;

public class MultiPatchSynthesizer {
    public static patch_t synthesizePatchFromFlat(String name, byte[] flat, int width, int height) {
        byte[] expected = new byte[width * height];
        byte[][] pixels = new byte[width][height];
        boolean[][] solid = new boolean[width][height];
        System.arraycopy(flat, 0, expected, 0, Math.min(flat.length, expected.length));
        for (int i = 0; i < width; ++i) {
            Arrays.fill(solid[i], true);
            for (int j = 0; j < height; ++j) {
                pixels[i][j] = expected[i + j * width];
            }
        }
        patch_t result = new patch_t(name, width, height, 0, 0);
        column_t[] columns = new column_t[width];
        for (int x = 0; x < width; ++x) {
            columns[x] = MultiPatchSynthesizer.getColumnStream(pixels[x], solid[x], height);
        }
        result.columns = columns;
        return result;
    }

    public static patch_t synthesize(String name, byte[][] pixels, boolean[][] solid, int width, int height) {
        patch_t result = new patch_t(name, width, height, 0, 0);
        column_t[] columns = new column_t[width];
        for (int x = 0; x < width; ++x) {
            columns[x] = MultiPatchSynthesizer.getColumnStream(pixels[x], solid[x], height);
        }
        result.columns = columns;
        return result;
    }

    public static column_t getColumnStream(byte[] pixels, boolean[] solid, int height) {
        column_t result = new column_t();
        int start = -1;
        int end = -1;
        ArrayList<PixelRange> ranges = new ArrayList<PixelRange>();
        for (int i = 0; i < height; ++i) {
            if (solid[i] && start == -1) {
                start = i;
            }
            if (solid[i] && i == height - 1 && start != -1) {
                end = i;
                ranges.add(new PixelRange(start, end));
                end = -1;
                start = -1;
            }
            if (!solid[i] && start != -1 && end == -1) {
                end = i - 1;
            }
            if (start == -1 || end == -1) continue;
            ranges.add(new PixelRange(start, end));
            end = -1;
            start = -1;
        }
        if (ranges.size() == 0) {
            ranges.add(new PixelRange(0, -1));
        }
        ByteArrayOutputStream file = new ByteArrayOutputStream();
        int topdelta = 0;
        int n = ranges.size();
        short[] topdeltas = new short[n];
        int[] postofs = new int[n];
        short[] postlens = new short[n];
        for (int i = 0; i < n; ++i) {
            PixelRange pr = (PixelRange)ranges.get(i);
            topdelta = pr.start;
            postofs[i] = (short)file.size() + 3;
            topdeltas[i] = (short)topdelta;
            postlens[i] = (short)pr.getLength();
            file.write(topdeltas[i]);
            file.write(postlens[i]);
            file.write(0);
            file.write(pixels, pr.start, pr.getLength());
            file.write(0);
        }
        file.write(255);
        result.data = file.toByteArray();
        result.postdeltas = topdeltas;
        result.postlen = postlens;
        result.postofs = postofs;
        result.posts = ranges.size();
        return result;
    }

    static class PixelRange {
        public int start;
        public int end;

        public PixelRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getLength() {
            return this.end - this.start + 1;
        }
    }
}

