/*
 * Decompiled with CFR 0.152.
 */
package rr;

import data.Tables;
import doom.CommandVariable;
import doom.DoomMain;
import doom.player_t;
import doom.thinker_t;
import i.IDoomSystem;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import m.IDoomMenu;
import m.MenuMisc;
import m.Settings;
import m.fixed_t;
import mochadoom.Engine;
import p.ActiveStates;
import p.mobj_t;
import rr.BSPVars;
import rr.IDetailAware;
import rr.ILimitResettable;
import rr.IMaskedDrawer;
import rr.ISpriteManager;
import rr.IVisSpriteManagement;
import rr.PlaneDrawer;
import rr.SceneRenderer;
import rr.SegVars;
import rr.SimpleTextureManager;
import rr.SimpleThings;
import rr.TextureManager;
import rr.ViewVars;
import rr.VisSprites;
import rr.Visplanes;
import rr.cliprange_t;
import rr.column_t;
import rr.drawfuns.ColFuncs;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.DoomSpanFunction;
import rr.drawfuns.SpanVars;
import rr.drawseg_t;
import rr.flat_t;
import rr.node_t;
import rr.patch_t;
import rr.seg_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import rr.subsector_t;
import rr.visplane_t;
import utils.C2JUtils;
import utils.GenericCopy;
import v.renderers.DoomScreen;
import v.tables.BlurryTable;
import v.tables.LightsAndColors;
import w.IWadLoader;

public abstract class RendererState<T, V>
implements SceneRenderer<T, V>,
ILimitResettable {
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG2 = false;
    protected DoomMain<T, V> DOOM;
    protected ISegDrawer MySegs;
    protected IDoomMenu Menu;
    protected BSP MyBSP;
    protected PlaneDrawer<T, V> MyPlanes;
    protected IMaskedDrawer<T, V> MyThings;
    public IVisSpriteManagement<V> VIS;
    protected TextureManager<T> TexMan;
    public ViewVars view;
    public LightsAndColors<V> colormaps;
    public SegVars seg_vars;
    public Visplanes vp_vars;
    protected List<IDetailAware> detailaware;
    protected int validcount = 1;
    protected boolean setsizeneeded;
    protected int setblocks;
    protected int setdetail;
    protected V screen;
    protected static final boolean RANGECHECK = false;
    protected int[] ylookup = new int[1200];
    protected int[] columnofs = new int[1600];
    protected ColVars<T, V> dcvars;
    protected SpanVars<T, V> dsvars;
    protected ColVars<T, V> skydcvars;
    protected ColVars<T, V> maskedcvars;
    protected int framecount;
    protected int sscount;
    protected int linecount;
    protected int loopcount;
    protected long clipangle;
    protected long CLIPANGLE2;
    protected final int[] viewangletox = new int[4096];
    protected ColFuncs<T, V> colfunc;
    protected ColFuncs<T, V> colfunchi;
    protected ColFuncs<T, V> colfunclow;
    protected DoomColumnFunction<T, V> DrawTranslatedColumn;
    protected DoomColumnFunction<T, V> DrawTranslatedColumnLow;
    protected DoomColumnFunction<T, V> DrawColumnPlayer;
    protected DoomColumnFunction<T, V> DrawColumnSkies;
    protected DoomColumnFunction<T, V> DrawColumnSkiesLow;
    protected DoomColumnFunction<T, V> DrawFuzzColumn;
    protected DoomColumnFunction<T, V> DrawFuzzColumnLow;
    protected DoomColumnFunction<T, V> DrawColumn;
    protected DoomColumnFunction<T, V> DrawColumnLow;
    protected DoomColumnFunction<T, V> DrawColumnMasked;
    protected DoomColumnFunction<T, V> DrawColumnMaskedLow;
    protected DoomColumnFunction<T, V> DrawTLColumn;
    protected DoomSpanFunction<T, V> DrawSpan;
    protected DoomSpanFunction<T, V> DrawSpanLow;
    private final Rectangle backScreenRect = new Rectangle();
    private final Rectangle tilePatchRect = new Rectangle();
    protected static final int DISTMAP = 2;
    protected static final int TSC = 12;
    byte[] main_tranmap;
    protected BlurryTable BLURRY_MAP;
    protected int spritememory;
    protected float viewfocratio;
    protected int projectiony;

    @Override
    public boolean isFullHeight() {
        return this.view.height == this.DOOM.vs.getScreenHeight();
    }

    public boolean isFullWidth() {
        return this.view.scaledwidth == this.DOOM.vs.getScreenWidth();
    }

    @Override
    public boolean isFullScreen() {
        return this.isFullWidth() && this.isFullHeight();
    }

    @Override
    public void SetViewSize(int blocks, int detail) {
        this.setsizeneeded = true;
        this.setblocks = blocks;
        this.setdetail = detail;
        this.detailaware.forEach(d -> d.setDetail(this.setdetail));
    }

    public void SetupFrame(player_t player) {
        int bumplight;
        this.view.player = player;
        this.view.x = player.mo.x;
        this.view.y = player.mo.y;
        this.view.angle = player.mo.angle & 0xFFFFFFFFL;
        this.colormaps.extralight = player.extralight << (bumplight += (bumplight = Math.max(this.colormaps.lightBits() - 5, 0)) > 0 ? 1 : 0);
        this.view.z = player.viewz;
        this.view.lookdir = player.lookdir;
        int tempCentery = this.setblocks == 11 ? this.view.height / 2 + (int)((float)this.view.lookdir * this.DOOM.vs.getScreenMul() * (float)this.setblocks) / 11 : this.view.height / 2 + (int)((float)this.view.lookdir * this.DOOM.vs.getScreenMul() * (float)this.setblocks) / 10;
        if (this.view.centery != tempCentery) {
            this.view.centery = tempCentery;
            this.view.centeryfrac = this.view.centery << 16;
            int[] yslope = this.vp_vars.yslope;
            for (int i = 0; i < this.view.height; ++i) {
                yslope[i] = fixed_t.FixedDiv((this.view.width << this.view.detailshift) / 2 * 65536, Math.abs((i - this.view.centery << 16) + 32768));
            }
            this.maskedcvars.centery = this.dcvars.centery = this.view.centery;
            this.skydcvars.centery = this.dcvars.centery;
        }
        this.view.sin = Tables.finesine(this.view.angle);
        this.view.cos = Tables.finecosine(this.view.angle);
        this.sscount = 0;
        if (player.fixedcolormap != 0) {
            this.colormaps.fixedcolormap = this.colormaps.getFixedColormap(player);
            this.colormaps.walllights = this.colormaps.scalelightfixed;
            for (int i = 0; i < this.colormaps.maxLightScale(); ++i) {
                this.colormaps.scalelightfixed[i] = this.colormaps.fixedcolormap;
            }
        } else {
            this.colormaps.fixedcolormap = null;
        }
        ++this.framecount;
        ++this.validcount;
    }

    public void SetupFrame(mobj_t actor) {
        this.view.x = actor.x;
        this.view.y = actor.y;
        this.view.angle = actor.angle & 0xFFFFFFFFL;
        this.view.z = actor.z + actor.height;
        this.view.sin = Tables.finesine(this.view.angle);
        this.view.cos = Tables.finecosine(this.view.angle);
        this.sscount = 0;
        ++this.framecount;
        ++this.validcount;
    }

    public RendererState(DoomMain<T, V> DOOM) {
        SimpleTextureManager tm;
        this.DOOM = DOOM;
        this.MyBSP = new BSP();
        this.view = new ViewVars(DOOM.vs);
        this.seg_vars = new SegVars();
        this.dcvars = new ColVars();
        this.dsvars = new SpanVars();
        this.maskedcvars = new ColVars();
        this.skydcvars = new ColVars();
        this.colfunclow = new ColFuncs();
        this.colfunchi = new ColFuncs();
        this.detailaware = new ArrayList<IDetailAware>();
        this.colormaps = new LightsAndColors<V>(DOOM);
        this.TexMan = tm = new SimpleTextureManager(DOOM);
        this.vp_vars = new Visplanes(DOOM.vs, this.view, this.TexMan);
        this.MyPlanes = new Planes(DOOM, this);
        this.VIS = new VisSprites(this);
        this.MyThings = new SimpleThings(DOOM.vs, this);
    }

    @Override
    public final long PointToAngle2(int x1, int y1, int x2, int y2) {
        this.view.x = x1;
        this.view.y = y1;
        return this.view.PointToAngle(x2, y2);
    }

    public static long PointToAngle(int viewx, int viewy, int x, int y) {
        if ((x -= viewx) == 0 && (y -= viewy) == 0) {
            return 0L;
        }
        if (x >= 0) {
            if (y >= 0) {
                if (x > y) {
                    return Tables.tantoangle[Tables.SlopeDiv(y, x)];
                }
                return 0x3FFFFFFFL - (long)Tables.tantoangle[Tables.SlopeDiv(x, y)];
            }
            if (x > (y = -y)) {
                return -Tables.tantoangle[Tables.SlopeDiv(y, x)];
            }
            return 0xC0000000L + (long)Tables.tantoangle[Tables.SlopeDiv(x, y)];
        }
        x = -x;
        if (y >= 0) {
            if (x > y) {
                return Integer.MAX_VALUE - (long)Tables.tantoangle[Tables.SlopeDiv(y, x)];
            }
            return 0x40000000L + (long)Tables.tantoangle[Tables.SlopeDiv(x, y)];
        }
        if (x > (y = -y)) {
            return 0x80000000L + (long)Tables.tantoangle[Tables.SlopeDiv(y, x)];
        }
        return 0xBFFFFFFFL - (long)Tables.tantoangle[Tables.SlopeDiv(x, y)];
    }

    protected void InitTables() {
    }

    protected int PointToDist(int x, int y) {
        int dx = Math.abs(x - this.view.x);
        int dy = Math.abs(y - this.view.y);
        if (dy > dx) {
            int temp = dx;
            dx = dy;
            dy = temp;
        }
        if (dx == 0) {
            return 0;
        }
        int angle = (fixed_t.FixedDiv(dy, dx) & 0x1FFFF) >> 5;
        angle = (int)((long)Tables.tantoangle[angle] + 0x40000000L >> 19);
        int dist = fixed_t.FixedDiv(dx, Tables.finesine[angle]);
        return dist;
    }

    protected void setHiColFuns() {
        this.colfunchi.base = this.DrawColumn;
        this.colfunchi.main = this.colfunchi.base;
        this.colfunchi.masked = this.DrawColumnMasked;
        this.colfunchi.fuzz = this.DrawFuzzColumn;
        this.colfunchi.trans = this.DrawTranslatedColumn;
        this.colfunchi.glass = this.DrawTLColumn;
        this.colfunchi.player = this.DrawColumnPlayer;
        this.colfunchi.sky = this.DrawColumnSkies;
    }

    protected void setLowColFuns() {
        this.colfunclow.base = this.DrawColumnLow;
        this.colfunclow.main = this.colfunclow.base;
        this.colfunclow.masked = this.DrawColumnMaskedLow;
        this.colfunclow.fuzz = this.DrawFuzzColumnLow;
        this.colfunclow.trans = this.DrawTranslatedColumnLow;
        this.colfunclow.glass = this.DrawTLColumn;
        this.colfunclow.player = this.DrawColumnMaskedLow;
        this.colfunclow.sky = this.DrawColumnSkiesLow;
    }

    @Override
    public ColFuncs<T, V> getColFuncsHi() {
        return this.colfunchi;
    }

    @Override
    public ColFuncs<T, V> getColFuncsLow() {
        return this.colfunclow;
    }

    @Override
    public ColVars<T, V> getMaskedDCVars() {
        return this.maskedcvars;
    }

    @Override
    public void DrawViewBorder() {
        if (this.view.scaledwidth == this.DOOM.vs.getScreenWidth()) {
            return;
        }
        int top = (this.DOOM.vs.getScreenHeight() - this.DOOM.statusBar.getHeight() - this.view.height) / 2;
        int side = (this.DOOM.vs.getScreenWidth() - this.view.scaledwidth) / 2;
        Rectangle rect = new Rectangle(0, 0, this.DOOM.vs.getScreenWidth(), top);
        this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
        rect.setBounds(0, top, side, this.view.height);
        this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
        rect.x = side + this.view.scaledwidth;
        this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
        rect.setBounds(0, top + this.view.height, this.DOOM.vs.getScreenWidth(), top);
        this.DOOM.graphicSystem.CopyRect(DoomScreen.BG, rect, DoomScreen.FG);
    }

    @Override
    public void ExecuteSetViewSize() {
        int i;
        this.setsizeneeded = false;
        if (this.setblocks == 11) {
            this.view.scaledwidth = this.DOOM.vs.getScreenWidth();
            this.view.height = this.DOOM.vs.getScreenHeight();
        } else if (this.DOOM.CM.equals(Settings.scale_screen_tiles, Boolean.TRUE)) {
            this.view.scaledwidth = this.setblocks * 32 * this.DOOM.vs.getScalingX();
            this.view.height = (this.setblocks * 168 / 10 & 0xFFFFFFF8) * this.DOOM.vs.getScalingY();
        } else {
            this.view.scaledwidth = this.setblocks * (this.DOOM.vs.getScreenWidth() / 10);
            this.view.height = (short)(this.setblocks * (this.DOOM.vs.getScreenHeight() - this.DOOM.statusBar.getHeight()) / 10 & 0xFFFFFFF8);
        }
        this.maskedcvars.viewheight = this.dcvars.viewheight = this.view.height;
        this.skydcvars.viewheight = this.dcvars.viewheight;
        this.view.detailshift = this.setdetail;
        this.view.width = this.view.scaledwidth >> this.view.detailshift;
        this.view.centery = this.view.height / 2;
        this.view.centerx = this.view.width / 2;
        this.view.centerxfrac = this.view.centerx << 16;
        this.view.centeryfrac = this.view.centery << 16;
        this.view.projection = this.view.centerxfrac;
        this.maskedcvars.centery = this.dcvars.centery = this.view.centery;
        this.skydcvars.centery = this.dcvars.centery;
        if (this.view.detailshift == 0) {
            this.colfunc = this.colfunchi;
            this.dsvars.spanfunc = this.DrawSpan;
        } else {
            this.colfunc = this.colfunclow;
            this.dsvars.spanfunc = this.DrawSpanLow;
        }
        this.InitBuffer(this.view.scaledwidth, this.view.height);
        this.InitTextureMapping();
        this.MyThings.setPspriteScale((int)(65536.0f * (this.DOOM.vs.getScreenMul() * (float)this.view.width) / (float)this.DOOM.vs.getScreenWidth()));
        this.MyThings.setPspriteIscale((int)(65536.0f * ((float)this.DOOM.vs.getScreenWidth() / ((float)this.view.width * this.DOOM.vs.getScreenMul()))));
        this.vp_vars.setSkyScale((int)(65536.0f * ((float)this.DOOM.vs.getScreenWidth() / ((float)this.view.width * this.DOOM.vs.getScreenMul()))));
        this.view.BOBADJUST = this.DOOM.vs.getSafeScaling() << 15;
        this.view.WEAPONADJUST = (int)((float)this.DOOM.vs.getScreenWidth() / (2.0f * this.DOOM.vs.getScreenMul()) * 65536.0f);
        for (i = 0; i < this.view.width; ++i) {
            this.view.screenheightarray[i] = (short)this.view.height;
        }
        for (i = 0; i < this.view.height; ++i) {
            int dy = (i - this.view.height / 2 << 16) + 32768;
            dy = Math.abs(dy);
            this.vp_vars.yslope[i] = fixed_t.FixedDiv((this.view.width << this.view.detailshift) / 2 * 65536, dy);
        }
        for (i = 0; i < this.view.width; ++i) {
            int cosadj = Math.abs(Tables.finecosine(this.view.xtoviewangle[i]));
            this.MyPlanes.getDistScale()[i] = fixed_t.FixedDiv(65536, cosadj);
        }
        for (i = 0; i < this.colormaps.lightLevels(); ++i) {
            int startmap = (this.colormaps.lightLevels() - this.colormaps.lightBright() - i) * 2 * this.colormaps.numColorMaps() / this.colormaps.lightLevels();
            for (int j = 0; j < this.colormaps.maxLightScale(); ++j) {
                int level = startmap - j / 2;
                if (level < 0) {
                    level = 0;
                }
                if (level >= this.colormaps.numColorMaps()) {
                    level = this.colormaps.numColorMaps() - 1;
                }
                this.colormaps.scalelight[i][j] = this.colormaps.colormaps[level];
            }
        }
        this.MySegs.ExecuteSetViewSize(this.view.width);
    }

    @Override
    public void FillBackScreen() {
        int y;
        int x;
        boolean scaleSetting = Engine.getConfig().equals(Settings.scale_screen_tiles, Boolean.TRUE);
        String name1 = "FLOOR7_2";
        String name2 = "GRNROCK";
        if (this.view.scaledwidth == this.DOOM.vs.getScreenWidth()) {
            return;
        }
        String name = this.DOOM.isCommercial() ? name2 : name1;
        flat_t src = this.DOOM.wadLoader.CacheLumpName(name, 101, flat_t.class);
        DoomScreen dest = DoomScreen.BG;
        this.backScreenRect.setBounds(0, 0, this.DOOM.vs.getScreenWidth(), this.DOOM.vs.getScreenHeight() - this.DOOM.statusBar.getHeight());
        this.tilePatchRect.setBounds(0, 0, 64, 64);
        Object block = this.DOOM.graphicSystem.convertPalettedBlock(src.data);
        if (scaleSetting) {
            block = this.DOOM.graphicSystem.ScaleBlock(block, this.DOOM.vs, this.tilePatchRect.width, this.tilePatchRect.height);
            this.tilePatchRect.width *= this.DOOM.graphicSystem.getScalingX();
            this.tilePatchRect.height *= this.DOOM.graphicSystem.getScalingY();
        }
        this.DOOM.graphicSystem.TileScreenArea(dest, this.backScreenRect, block, this.tilePatchRect);
        int scaleFlags = 0x10000 | (scaleSetting ? 0 : 0x2080000);
        int stepX = scaleSetting ? this.DOOM.graphicSystem.getScalingX() << 3 : 8;
        int stepY = scaleSetting ? this.DOOM.graphicSystem.getScalingY() << 3 : 8;
        patch_t patch = this.DOOM.wadLoader.CachePatchName("BRDR_T", 101);
        for (x = 0; x < this.view.scaledwidth; x += stepX) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx + x, this.view.windowy - stepY, scaleFlags);
        }
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_B", 101);
        for (x = 0; x < this.view.scaledwidth; x += stepX) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx + x, this.view.windowy + this.view.height, scaleFlags);
        }
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_L", 101);
        for (y = 0; y < this.view.height; y += stepY) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx - stepX, this.view.windowy + y, scaleFlags);
        }
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_R", 101);
        for (y = 0; y < this.view.height; y += stepY) {
            this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx + this.view.scaledwidth, this.view.windowy + y, scaleFlags);
        }
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_TL", 101);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx - stepX, this.view.windowy - stepY, scaleFlags);
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_TR", 101);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx + this.view.scaledwidth, this.view.windowy - stepY, scaleFlags);
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_BL", 101);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx - stepX, this.view.windowy + this.view.height, scaleFlags);
        patch = this.DOOM.wadLoader.CachePatchName("BRDR_BR", 101);
        this.DOOM.graphicSystem.DrawPatchScaled(DoomScreen.BG, patch, this.DOOM.vs, this.view.windowx + this.view.width, this.view.windowy + this.view.height, scaleFlags);
    }

    @Override
    public void Init() {
        this.screen = this.DOOM.graphicSystem.getScreen(DoomScreen.FG);
        System.out.print("\nR_InitData");
        this.InitData();
        System.out.print("\nR_InitPointToAngle");
        System.out.print("\nR_InitTables");
        this.InitTables();
        this.SetViewSize(this.DOOM.menu.getScreenBlocks(), this.DOOM.menu.getDetailLevel());
        System.out.print("\nR_InitPlanes");
        this.MyPlanes.InitPlanes();
        System.out.print("\nR_InitLightTables");
        this.InitLightTables();
        System.out.print("\nR_InitSkyMap: " + this.TexMan.InitSkyMap());
        System.out.print("\nR_InitTranslationsTables");
        this.InitTranslationTables();
        System.out.print("\nR_InitTranMap: ");
        this.R_InitTranMap(0);
        System.out.print("\nR_InitDrawingFunctions: ");
        this.R_InitDrawingFunctions();
        this.framecount = 0;
    }

    protected void InitBuffer(int width, int height) {
        int i;
        this.view.windowx = this.DOOM.vs.getScreenWidth() - width >> 1;
        for (i = 0; i < width; ++i) {
            this.columnofs[i] = this.view.windowx + i;
        }
        this.view.windowy = width == this.DOOM.vs.getScreenWidth() ? 0 : this.DOOM.vs.getScreenHeight() - this.DOOM.statusBar.getHeight() - height >> 1;
        for (i = 0; i < height; ++i) {
            this.ylookup[i] = (i + this.view.windowy) * this.DOOM.vs.getScreenWidth();
        }
    }

    protected void InitTextureMapping() {
        int t;
        int i;
        int fov = 2048;
        int focallength = fixed_t.FixedDiv(this.view.centerxfrac, Tables.finetangent[3072]);
        for (i = 0; i < 4096; ++i) {
            if (Tables.finetangent[i] > 131072) {
                t = -1;
            } else if (Tables.finetangent[i] < -131072) {
                t = this.view.width + 1;
            } else {
                t = fixed_t.FixedMul(Tables.finetangent[i], focallength);
                if ((t = this.view.centerxfrac - t + 65536 - 1 >> 16) < -1) {
                    t = -1;
                } else if (t > this.view.width + 1) {
                    t = this.view.width + 1;
                }
            }
            this.viewangletox[i] = t;
        }
        for (int x = 0; x <= this.view.width; ++x) {
            i = 0;
            while (this.viewangletox[i] > x) {
                ++i;
            }
            this.view.xtoviewangle[x] = Tables.addAngles(i << 19, -1073741824L);
        }
        for (i = 0; i < 4096; ++i) {
            t = fixed_t.FixedMul(Tables.finetangent[i], focallength);
            t = this.view.centerx - t;
            if (this.viewangletox[i] == -1) {
                this.viewangletox[i] = 0;
                continue;
            }
            if (this.viewangletox[i] != this.view.width + 1) continue;
            this.viewangletox[i] = this.view.width;
        }
        this.clipangle = this.view.xtoviewangle[0];
        this.CLIPANGLE2 = 2L * this.clipangle & 0xFFFFFFFFL;
    }

    protected void InitLightTables() {
        for (int i = 0; i < this.colormaps.lightLevels(); ++i) {
            int startmap = (this.colormaps.lightLevels() - this.colormaps.lightBright() - i) * 2 * this.colormaps.numColorMaps() / this.colormaps.lightLevels();
            for (int j = 0; j < this.colormaps.maxLightZ(); ++j) {
                int scale = fixed_t.FixedDiv(0xA00000, j + 1 << this.colormaps.lightZShift());
                int level = startmap - (scale >>= this.colormaps.lightScaleShift()) / 2;
                if (level < 0) {
                    level = 0;
                }
                if (level >= this.colormaps.numColorMaps()) {
                    level = this.colormaps.numColorMaps() - 1;
                }
                this.colormaps.zlight[i][j] = this.colormaps.colormaps[level];
            }
        }
    }

    protected void R_InitTranMap(int progress) {
        int i;
        int lump = this.DOOM.wadLoader.CheckNumForName("TRANMAP");
        long ta = System.nanoTime();
        this.DOOM.cVarManager.with(CommandVariable.TRANMAP, 0, tranmap -> {
            if (C2JUtils.testReadAccess(tranmap)) {
                System.out.printf("Translucency map file %s specified in -tranmap arg. Attempting to use...\n", tranmap);
                this.main_tranmap = new byte[65536];
                int result = MenuMisc.ReadFile(tranmap, this.main_tranmap);
                if (result > 0) {
                    return;
                }
                System.out.print("...failure.\n");
            }
        });
        if (lump != -1) {
            System.out.print("Translucency map found in lump. Attempting to use...");
            this.main_tranmap = this.DOOM.wadLoader.CacheLumpNumAsRawBytes(lump, 1);
            if (this.main_tranmap.length >= 65536) {
                return;
            }
            System.out.print("...failure.\n");
        }
        if (C2JUtils.testReadAccess("tranmap.dat")) {
            System.out.print("Translucency map found in default tranmap.dat file. Attempting to use...");
            this.main_tranmap = new byte[65536];
            int result = MenuMisc.ReadFile("tranmap.dat", this.main_tranmap);
            if (result > 0) {
                return;
            }
        }
        System.out.print("Computing translucency map from scratch...that's gonna be SLOW...");
        byte[] playpal = this.DOOM.wadLoader.CacheLumpNameAsRawBytes("PLAYPAL", 1);
        this.main_tranmap = new byte[65536];
        int[] basepal = new int[768];
        int[] mixedpal = new int[196608];
        this.main_tranmap = new byte[65536];
        for (i = 0; i < 256; ++i) {
            basepal[3 * i] = 0xFF & playpal[i * 3];
            basepal[1 + 3 * i] = 0xFF & playpal[1 + i * 3];
            basepal[2 + 3 * i] = 0xFF & playpal[2 + i * 3];
        }
        for (i = 0; i < 768; i += 3) {
            for (int j = 0; j < 768; j += 3) {
                this.mixColors(basepal, basepal, mixedpal, i, j, j * 256 + i);
            }
        }
        float[] tmpdist = new float[256];
        for (int a = 0; a < 256; ++a) {
            for (int b = a; b < 256; ++b) {
                for (int k = 0; k < 256; ++k) {
                    tmpdist[k] = this.colorDistance(mixedpal, basepal, 3 * (a + b * 256), k * 3);
                }
                this.main_tranmap[a << 8 | b] = (byte)this.findMin(tmpdist);
                this.main_tranmap[b << 8 | a] = this.main_tranmap[a << 8 | b];
            }
        }
        System.out.print("...done\n");
        if (MenuMisc.WriteFile("tranmap.dat", this.main_tranmap, this.main_tranmap.length)) {
            System.out.print("TRANMAP.DAT saved to disk for your convenience! Next time will be faster.\n");
        }
        long b = System.nanoTime();
        System.out.printf("Tranmap %d\n", (b - ta) / 1000000L);
    }

    protected void mixColors(int[] a, int[] b, int[] c, int pa, int pb, int pc) {
        c[pc] = (a[pa] + b[pb]) / 2;
        c[pc + 1] = (a[pa + 1] + b[pb + 1]) / 2;
        c[pc + 2] = (a[pa + 2] + b[pb + 2]) / 2;
    }

    protected float colorDistance(int[] a, int[] b, int pa, int pb) {
        return (float)Math.sqrt((a[pa] - b[pb]) * (a[pa] - b[pb]) + (a[pa + 1] - b[pb + 1]) * (a[pa + 1] - b[pb + 1]) + (a[pa + 2] - b[pb + 2]) * (a[pa + 2] - b[pb + 2]));
    }

    protected void completeInit() {
        this.detailaware.add(this.MyThings);
    }

    protected int findMin(float[] a) {
        int minindex = 0;
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            minindex = i;
        }
        return minindex;
    }

    protected abstract void InitColormaps() throws IOException;

    public void InitData() {
        try {
            System.out.print("\nInit Texture and Flat Manager");
            this.TexMan = this.DOOM.textureManager;
            System.out.print("\nInitTextures");
            this.TexMan.InitTextures();
            System.out.print("\nInitFlats");
            this.TexMan.InitFlats();
            System.out.print("\nInitSprites");
            this.DOOM.spriteManager.InitSpriteLumps();
            this.MyThings.cacheSpriteManager(this.DOOM.spriteManager);
            this.VIS.cacheSpriteManager(this.DOOM.spriteManager);
            System.out.print("\nInitColormaps\t\t");
            this.InitColormaps();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void PreCacheThinkers() {
        spritedef_t[] sprites = this.DOOM.spriteManager.getSprites();
        int numsprites = this.DOOM.spriteManager.getNumSprites();
        boolean[] spritepresent = new boolean[numsprites];
        thinker_t th = this.DOOM.actions.getThinkerCap().next;
        while (th != this.DOOM.actions.getThinkerCap()) {
            if (th.thinkerFunction == ActiveStates.P_MobjThinker) {
                spritepresent[((mobj_t)th).mobj_sprite.ordinal()] = true;
            }
            th = th.next;
        }
        this.spritememory = 0;
        for (int i = 0; i < numsprites; ++i) {
            if (!spritepresent[i]) continue;
            for (int j = 0; j < sprites[i].numframes; ++j) {
                spriteframe_t sf = sprites[i].spriteframes[j];
                for (int k = 0; k < 8; ++k) {
                    int lump = this.DOOM.spriteManager.getFirstSpriteLump() + sf.lump[k];
                    this.spritememory = (int)((long)this.spritememory + this.DOOM.wadLoader.GetLumpInfo((int)lump).size);
                    this.DOOM.wadLoader.CacheLumpNum(lump, 101, patch_t.class);
                }
            }
        }
    }

    protected void InitTranslationTables() {
        int TR_COLORS = 28;
        this.colormaps.translationtables = new byte[28][256];
        byte[][] translationtables = this.colormaps.translationtables;
        for (int i = 0; i < 256; ++i) {
            translationtables[0][i] = (byte)i;
            if (i >= 112 && i <= 127) {
                translationtables[1][i] = (byte)(96 + (i & 0xF));
                translationtables[2][i] = (byte)(64 + (i & 0xF));
                translationtables[3][i] = (byte)(32 + (i & 0xF));
                translationtables[4][i] = (byte)(16 + (i & 0xF));
                translationtables[5][i] = (byte)(48 + (i & 0xF));
                translationtables[6][i] = (byte)(80 + (i & 0xF));
                translationtables[7][i] = (byte)(128 + (i & 0xF));
                translationtables[8][i] = (byte)(176 + (i & 0xF));
                translationtables[9][i] = (byte)(192 + (i & 0xF));
                translationtables[10][i] = (byte)(208 + (i & 0xF));
                translationtables[11][i] = (byte)(144 + (i & 0xF) / 2);
                translationtables[12][i] = (byte)(152 + (i & 0xF) / 2);
                translationtables[13][i] = (byte)(160 + (i & 0xF) / 2);
                translationtables[14][i] = (byte)(168 + (i & 0xF) / 2);
                translationtables[15][i] = (byte)(224 + (i & 0xF) / 2);
                translationtables[16][i] = (byte)(232 + (i & 0xF) / 2);
                translationtables[17][i] = (byte)(240 + (i & 0xF) / 2);
                translationtables[18][i] = (byte)(248 + (i & 0xF) / 2);
                translationtables[19][i] = (byte)(5 + (i & 0xF) / 2);
                translationtables[20][i] = (byte)(144 + (i & 0xF));
                translationtables[21][i] = (byte)(160 + (i & 0xF));
                translationtables[22][i] = (byte)(224 + (i & 0xF));
                translationtables[23][i] = (byte)(240 + (i & 0xF));
                translationtables[24][i] = (byte)(112 + (15 - i & 0xF));
                translationtables[25][i] = (byte)(240 + (15 - i & 0xF));
                translationtables[26][i] = (byte)(224 + (15 - i & 0xF));
                translationtables[27][i] = (byte)(160 + (i & 0xF));
                continue;
            }
            for (int j = 1; j < 28; ++j) {
                translationtables[j][i] = (byte)i;
            }
        }
    }

    public IMaskedDrawer<T, V> getThings() {
        return this.MyThings;
    }

    @Override
    public int getValidCount() {
        return this.validcount;
    }

    @Override
    public void increaseValidCount(int amount) {
        this.validcount += amount;
    }

    @Override
    public boolean getSetSizeNeeded() {
        return this.setsizeneeded;
    }

    @Override
    public TextureManager<T> getTextureManager() {
        return this.TexMan;
    }

    @Override
    public PlaneDrawer<T, V> getPlaneDrawer() {
        return this.MyPlanes;
    }

    @Override
    public ViewVars getView() {
        return this.view;
    }

    @Override
    public SpanVars<T, V> getDSVars() {
        return this.dsvars;
    }

    @Override
    public LightsAndColors<V> getColorMap() {
        return this.colormaps;
    }

    @Override
    public IDoomSystem getDoomSystem() {
        return this.DOOM.doomSystem;
    }

    @Override
    public Visplanes getVPVars() {
        return this.vp_vars;
    }

    @Override
    public SegVars getSegVars() {
        return this.seg_vars;
    }

    @Override
    public IWadLoader getWadLoader() {
        return this.DOOM.wadLoader;
    }

    @Override
    public ISpriteManager getSpriteManager() {
        return this.DOOM.spriteManager;
    }

    @Override
    public BSPVars getBSPVars() {
        return this.MyBSP;
    }

    @Override
    public IVisSpriteManagement<V> getVisSpriteManager() {
        return this.VIS;
    }

    protected void R_InitDrawingFunctions() {
        this.setHiColFuns();
        this.setLowColFuns();
    }

    @Override
    public void resetLimits() {
        this.VIS.resetLimits();
        this.MySegs.resetLimits();
    }

    @Override
    public void RenderPlayerView(player_t player) {
        this.SetupFrame(player);
        this.MyBSP.ClearClipSegs();
        this.seg_vars.ClearDrawSegs();
        this.vp_vars.ClearPlanes();
        this.MySegs.ClearClips();
        this.VIS.ClearSprites();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyBSP.RenderBSPNode(this.DOOM.levelLoader.numnodes - 1);
        this.DOOM.gameNetworking.NetUpdate();
        this.MyPlanes.DrawPlanes();
        this.DOOM.gameNetworking.NetUpdate();
        this.MyThings.DrawMasked();
        this.colfunc.main = this.colfunc.base;
        this.DOOM.gameNetworking.NetUpdate();
    }

    protected class Planes
    extends PlaneDrawer<T, V> {
        Planes(DoomMain<T, V> DOOM, RendererState<T, V> R) {
            super(DOOM, R);
        }

        @Override
        public void DrawPlanes() {
            for (int pl = 0; pl < RendererState.this.vp_vars.lastvisplane; ++pl) {
                int x;
                visplane_t pln = RendererState.this.vp_vars.visplanes[pl];
                if (pln.minx > pln.maxx) continue;
                if (pln.picnum == this.TexMan.getSkyFlatNum()) {
                    int skytexture = this.TexMan.getSkyTexture();
                    RendererState.this.skydcvars.dc_texheight = this.TexMan.getTextureheight(skytexture) >> 16;
                    RendererState.this.skydcvars.dc_iscale = this.vpvars.getSkyScale() >> this.view.detailshift;
                    RendererState.this.skydcvars.dc_colormap = RendererState.this.DOOM.CM.equals(Settings.fix_sky_palette, Boolean.TRUE) && this.colormap.fixedcolormap != null ? this.colormap.fixedcolormap : this.colormap.colormaps[0];
                    RendererState.this.skydcvars.dc_texturemid = this.TexMan.getSkyTextureMid();
                    for (x = pln.minx; x <= pln.maxx; ++x) {
                        RendererState.this.skydcvars.dc_yl = pln.getTop(x);
                        RendererState.this.skydcvars.dc_yh = pln.getBottom(x);
                        if (RendererState.this.skydcvars.dc_yl > RendererState.this.skydcvars.dc_yh) continue;
                        int angle = (int)(Tables.addAngles(this.view.angle, this.view.xtoviewangle[x]) >>> 22);
                        RendererState.this.skydcvars.dc_x = x;
                        RendererState.this.skydcvars.dc_source = this.TexMan.GetCachedColumn(skytexture, angle);
                        RendererState.this.colfunc.sky.invoke();
                    }
                    continue;
                }
                this.dsvars.ds_source = this.TexMan.getSafeFlat(pln.picnum);
                this.planeheight = Math.abs(pln.height - this.view.z);
                int light = (pln.lightlevel >> this.colormap.lightSegShift()) + this.colormap.extralight;
                if (light >= this.colormap.lightLevels()) {
                    light = this.colormap.lightLevels() - 1;
                }
                if (light < 0) {
                    light = 0;
                }
                this.planezlight = this.colormap.zlight[light];
                pln.setTop(pln.maxx + 1, '\u8000');
                pln.setTop(pln.minx - 1, '\u8000');
                int stop = pln.maxx + 1;
                for (x = pln.minx; x <= stop; ++x) {
                    this.MakeSpans(x, pln.getTop(x - 1), pln.getBottom(x - 1), pln.getTop(x), pln.getBottom(x));
                }
            }
        }
    }

    protected static interface ISegDrawer
    extends ILimitResettable {
        public void ClearClips();

        public short[] getBLANKCEILINGCLIP();

        public short[] getBLANKFLOORCLIP();

        public short[] getFloorClip();

        public short[] getCeilingClip();

        public void ExecuteSetViewSize(int var1);

        public void setGlobalAngle(long var1);

        public void StoreWallRange(int var1, int var2);

        public void CompleteRendering();

        public void sync();
    }

    protected static interface IPlaneDrawer {
        public void InitPlanes();

        public void MapPlane(int var1, int var2, int var3);

        public void DrawPlanes();

        public int[] getDistScale();

        public void sync();
    }

    protected abstract class SegDrawer
    implements ISegDrawer {
        protected static final int HEIGHTBITS = 12;
        protected static final int HEIGHTUNIT = 4096;
        protected final Visplanes vp_vars;
        protected final SegVars seg_vars;
        protected short[] BLANKFLOORCLIP;
        protected short[] BLANKCEILINGCLIP;
        protected int pixhigh;
        protected int pixlow;
        protected int pixhighstep;
        protected int pixlowstep;
        protected int topfrac;
        protected int topstep;
        protected int bottomfrac;
        protected int bottomstep;
        protected int worldtop;
        protected int worldbottom;
        protected int worldhigh;
        protected int worldlow;
        protected boolean segtextured;
        protected short[] floorclip;
        protected short[] ceilingclip;
        protected boolean markfloor;
        protected boolean markceiling;
        protected boolean maskedtexture;
        protected int toptexture;
        protected int bottomtexture;
        protected int midtexture;
        protected long rw_normalangle;
        protected long rw_angle1;
        protected int rw_x;
        protected int rw_stopx;
        protected long rw_centerangle;
        protected int rw_offset;
        protected int rw_distance;
        protected int rw_scale;
        protected int rw_scalestep;
        protected int rw_midtexturemid;
        protected int rw_toptexturemid;
        protected int rw_bottomtexturemid;
        protected column_t col;

        @Override
        public short[] getBLANKFLOORCLIP() {
            return this.BLANKFLOORCLIP;
        }

        @Override
        public short[] getBLANKCEILINGCLIP() {
            return this.BLANKCEILINGCLIP;
        }

        @Override
        public final short[] getFloorClip() {
            return this.floorclip;
        }

        @Override
        public short[] getCeilingClip() {
            return this.ceilingclip;
        }

        @Override
        public void resetLimits() {
            drawseg_t[] tmp = new drawseg_t[this.seg_vars.MAXDRAWSEGS];
            System.arraycopy(this.seg_vars.drawsegs, 0, tmp, 0, this.seg_vars.MAXDRAWSEGS);
            this.seg_vars.drawsegs = tmp;
        }

        @Override
        public void sync() {
        }

        @Override
        public void StoreWallRange(int start, int stop) {
            if (this.seg_vars.ds_p == this.seg_vars.drawsegs.length) {
                this.seg_vars.ResizeDrawsegs();
            }
            drawseg_t seg = this.seg_vars.drawsegs[this.seg_vars.ds_p];
            RendererState.this.MyBSP.sidedef = RendererState.this.MyBSP.curline.sidedef;
            RendererState.this.MyBSP.linedef = RendererState.this.MyBSP.curline.linedef;
            RendererState.this.MyBSP.linedef.flags = (short)(RendererState.this.MyBSP.linedef.flags | 0x100);
            this.rw_normalangle = Tables.addAngles(RendererState.this.MyBSP.curline.angle, 0x40000000L);
            long offsetangle = Math.abs((int)this.rw_normalangle - (int)this.rw_angle1);
            if (offsetangle > 0x40000000L) {
                offsetangle = 0x40000000L;
            }
            int distangle = (int)(0x40000000L - offsetangle);
            int hyp = RendererState.this.PointToDist(RendererState.this.MyBSP.curline.v1x, RendererState.this.MyBSP.curline.v1y);
            int sineval = Tables.finesine(distangle);
            this.rw_distance = fixed_t.FixedMul(hyp, sineval);
            seg.x1 = this.rw_x = start;
            seg.x2 = stop;
            seg.curline = RendererState.this.MyBSP.curline;
            this.rw_stopx = stop + 1;
            seg.scale1 = this.rw_scale = this.ScaleFromGlobalAngle(RendererState.this.view.angle + RendererState.this.view.xtoviewangle[start]);
            if (stop > start) {
                seg.scale2 = this.ScaleFromGlobalAngle(RendererState.this.view.angle + RendererState.this.view.xtoviewangle[stop]);
                seg.scalestep = this.rw_scalestep = (seg.scale2 - this.rw_scale) / (stop - start);
            } else {
                seg.scale2 = seg.scale1;
            }
            this.worldtop = RendererState.this.MyBSP.frontsector.ceilingheight - RendererState.this.view.z;
            this.worldbottom = RendererState.this.MyBSP.frontsector.floorheight - RendererState.this.view.z;
            this.bottomtexture = 0;
            this.toptexture = 0;
            this.midtexture = 0;
            this.maskedtexture = false;
            seg.setMaskedTextureCol(null, 0);
            if (RendererState.this.MyBSP.backsector == null) {
                this.midtexture = RendererState.this.TexMan.getTextureTranslation(RendererState.this.MyBSP.sidedef.midtexture);
                this.markceiling = true;
                this.markfloor = true;
                if ((RendererState.this.MyBSP.linedef.flags & 0x10) != 0) {
                    int vtop = RendererState.this.MyBSP.frontsector.floorheight + RendererState.this.TexMan.getTextureheight(RendererState.this.MyBSP.sidedef.midtexture);
                    this.rw_midtexturemid = vtop - RendererState.this.view.z;
                } else {
                    this.rw_midtexturemid = this.worldtop;
                }
                this.rw_midtexturemid += RendererState.this.MyBSP.sidedef.rowoffset;
                seg.silhouette = 3;
                seg.setSprTopClip(RendererState.this.view.screenheightarray, 0);
                seg.setSprBottomClip(RendererState.this.view.negonearray, 0);
                seg.bsilheight = Integer.MAX_VALUE;
                seg.tsilheight = Integer.MIN_VALUE;
            } else {
                seg.setSprTopClip(null, 0);
                seg.setSprBottomClip(null, 0);
                seg.silhouette = 0;
                if (RendererState.this.MyBSP.frontsector.floorheight > RendererState.this.MyBSP.backsector.floorheight) {
                    seg.silhouette = 1;
                    seg.bsilheight = RendererState.this.MyBSP.frontsector.floorheight;
                } else if (RendererState.this.MyBSP.backsector.floorheight > RendererState.this.view.z) {
                    seg.silhouette = 1;
                    seg.bsilheight = Integer.MAX_VALUE;
                }
                if (RendererState.this.MyBSP.frontsector.ceilingheight < RendererState.this.MyBSP.backsector.ceilingheight) {
                    seg.silhouette |= 2;
                    seg.tsilheight = RendererState.this.MyBSP.frontsector.ceilingheight;
                } else if (RendererState.this.MyBSP.backsector.ceilingheight < RendererState.this.view.z) {
                    seg.silhouette |= 2;
                    seg.tsilheight = Integer.MIN_VALUE;
                }
                if (RendererState.this.MyBSP.backsector.ceilingheight <= RendererState.this.MyBSP.frontsector.floorheight) {
                    seg.setSprBottomClip(RendererState.this.view.negonearray, 0);
                    seg.bsilheight = Integer.MAX_VALUE;
                    seg.silhouette |= 1;
                }
                if (RendererState.this.MyBSP.backsector.floorheight >= RendererState.this.MyBSP.frontsector.ceilingheight) {
                    seg.setSprTopClip(RendererState.this.view.screenheightarray, 0);
                    seg.tsilheight = Integer.MIN_VALUE;
                    seg.silhouette |= 2;
                }
                this.worldhigh = RendererState.this.MyBSP.backsector.ceilingheight - RendererState.this.view.z;
                this.worldlow = RendererState.this.MyBSP.backsector.floorheight - RendererState.this.view.z;
                if (RendererState.this.MyBSP.frontsector.ceilingpic == RendererState.this.TexMan.getSkyFlatNum() && RendererState.this.MyBSP.backsector.ceilingpic == RendererState.this.TexMan.getSkyFlatNum()) {
                    this.worldtop = this.worldhigh;
                }
                this.markfloor = this.worldlow != this.worldbottom || RendererState.this.MyBSP.backsector.floorpic != RendererState.this.MyBSP.frontsector.floorpic || RendererState.this.MyBSP.backsector.lightlevel != RendererState.this.MyBSP.frontsector.lightlevel;
                boolean bl = this.markceiling = this.worldhigh != this.worldtop || RendererState.this.MyBSP.backsector.ceilingpic != RendererState.this.MyBSP.frontsector.ceilingpic || RendererState.this.MyBSP.backsector.lightlevel != RendererState.this.MyBSP.frontsector.lightlevel;
                if (RendererState.this.MyBSP.backsector.ceilingheight <= RendererState.this.MyBSP.frontsector.floorheight || RendererState.this.MyBSP.backsector.floorheight >= RendererState.this.MyBSP.frontsector.ceilingheight) {
                    this.markfloor = true;
                    this.markceiling = true;
                }
                if (this.worldhigh < this.worldtop) {
                    this.toptexture = RendererState.this.TexMan.getTextureTranslation(RendererState.this.MyBSP.sidedef.toptexture);
                    if ((RendererState.this.MyBSP.linedef.flags & 8) != 0) {
                        this.rw_toptexturemid = this.worldtop;
                    } else {
                        int vtop = RendererState.this.MyBSP.backsector.ceilingheight + RendererState.this.TexMan.getTextureheight(RendererState.this.MyBSP.sidedef.toptexture);
                        this.rw_toptexturemid = vtop - RendererState.this.view.z;
                    }
                }
                if (this.worldlow > this.worldbottom) {
                    this.bottomtexture = RendererState.this.TexMan.getTextureTranslation(RendererState.this.MyBSP.sidedef.bottomtexture);
                    this.rw_bottomtexturemid = (RendererState.this.MyBSP.linedef.flags & 0x10) != 0 ? this.worldtop : this.worldlow;
                }
                this.rw_toptexturemid += RendererState.this.MyBSP.sidedef.rowoffset;
                this.rw_bottomtexturemid += RendererState.this.MyBSP.sidedef.rowoffset;
                if (RendererState.this.MyBSP.sidedef.midtexture != 0) {
                    this.maskedtexture = true;
                    this.seg_vars.maskedtexturecol = this.vp_vars.openings;
                    this.seg_vars.pmaskedtexturecol = this.vp_vars.lastopening - this.rw_x;
                    seg.setMaskedTextureCol(this.seg_vars.maskedtexturecol, this.seg_vars.pmaskedtexturecol);
                    this.vp_vars.lastopening += this.rw_stopx - this.rw_x;
                }
            }
            this.segtextured = (this.midtexture | this.toptexture | this.bottomtexture) != 0 | this.maskedtexture;
            if (this.segtextured) {
                offsetangle = Tables.addAngles(this.rw_normalangle, -this.rw_angle1);
                if (offsetangle > 0x80000000L) {
                    offsetangle = (long)(-((int)offsetangle)) & 0xFFFFFFFFL;
                }
                if (offsetangle > 0x40000000L) {
                    offsetangle = 0x40000000L;
                }
                sineval = Tables.finesine(offsetangle);
                this.rw_offset = fixed_t.FixedMul(hyp, sineval);
                if ((this.rw_normalangle - this.rw_angle1 & 0xFFFFFFFFL) < 0x80000000L) {
                    this.rw_offset = -this.rw_offset;
                }
                this.rw_offset += RendererState.this.MyBSP.sidedef.textureoffset + RendererState.this.MyBSP.curline.offset;
                this.rw_centerangle = 0x40000000L + RendererState.this.view.angle - this.rw_normalangle & 0xFFFFFFFFL;
                if (RendererState.this.colormaps.fixedcolormap == null) {
                    int lightnum = (RendererState.this.MyBSP.frontsector.lightlevel >> RendererState.this.colormaps.lightSegShift()) + RendererState.this.colormaps.extralight;
                    if (RendererState.this.MyBSP.curline.v1y == RendererState.this.MyBSP.curline.v2y) {
                        --lightnum;
                    } else if (RendererState.this.MyBSP.curline.v1x == RendererState.this.MyBSP.curline.v2x) {
                        ++lightnum;
                    }
                    RendererState.this.colormaps.walllights = lightnum < 0 ? RendererState.this.colormaps.scalelight[0] : (lightnum >= RendererState.this.colormaps.lightLevels() ? RendererState.this.colormaps.scalelight[RendererState.this.colormaps.lightLevels() - 1] : RendererState.this.colormaps.scalelight[lightnum]);
                }
            }
            if (RendererState.this.MyBSP.frontsector.floorheight >= RendererState.this.view.z) {
                this.markfloor = false;
            }
            if (RendererState.this.MyBSP.frontsector.ceilingheight <= RendererState.this.view.z && RendererState.this.MyBSP.frontsector.ceilingpic != RendererState.this.TexMan.getSkyFlatNum()) {
                this.markceiling = false;
            }
            this.worldtop >>= 4;
            this.worldbottom >>= 4;
            this.topstep = -fixed_t.FixedMul(this.rw_scalestep, this.worldtop);
            this.topfrac = (RendererState.this.view.centeryfrac >> 4) - fixed_t.FixedMul(this.worldtop, this.rw_scale);
            this.bottomstep = -fixed_t.FixedMul(this.rw_scalestep, this.worldbottom);
            this.bottomfrac = (RendererState.this.view.centeryfrac >> 4) - fixed_t.FixedMul(this.worldbottom, this.rw_scale);
            if (RendererState.this.MyBSP.backsector != null) {
                this.worldhigh >>= 4;
                this.worldlow >>= 4;
                if (this.worldhigh < this.worldtop) {
                    this.pixhigh = (RendererState.this.view.centeryfrac >> 4) - fixed_t.FixedMul(this.worldhigh, this.rw_scale);
                    this.pixhighstep = -fixed_t.FixedMul(this.rw_scalestep, this.worldhigh);
                }
                if (this.worldlow > this.worldbottom) {
                    this.pixlow = (RendererState.this.view.centeryfrac >> 4) - fixed_t.FixedMul(this.worldlow, this.rw_scale);
                    this.pixlowstep = -fixed_t.FixedMul(this.rw_scalestep, this.worldlow);
                }
            }
            if (this.markceiling) {
                this.vp_vars.ceilingplane = this.vp_vars.CheckPlane(this.vp_vars.ceilingplane, this.rw_x, this.rw_stopx - 1);
            }
            if (this.markfloor) {
                this.vp_vars.floorplane = this.vp_vars.CheckPlane(this.vp_vars.floorplane, this.rw_x, this.rw_stopx - 1);
            }
            this.RenderSegLoop();
            if ((C2JUtils.flags(seg.silhouette, 2) || this.maskedtexture) && seg.nullSprTopClip()) {
                System.arraycopy(this.ceilingclip, start, this.vp_vars.openings, this.vp_vars.lastopening, this.rw_stopx - start);
                seg.setSprTopClip(this.vp_vars.openings, this.vp_vars.lastopening - start);
                this.vp_vars.lastopening += this.rw_stopx - start;
            }
            if ((C2JUtils.flags(seg.silhouette, 1) || this.maskedtexture) && seg.nullSprBottomClip()) {
                System.arraycopy(this.floorclip, start, this.vp_vars.openings, this.vp_vars.lastopening, this.rw_stopx - start);
                seg.setSprBottomClip(this.vp_vars.openings, this.vp_vars.lastopening - start);
                this.vp_vars.lastopening += this.rw_stopx - start;
            }
            if (this.maskedtexture && C2JUtils.flags(seg.silhouette, 2)) {
                seg.silhouette |= 2;
                seg.tsilheight = Integer.MIN_VALUE;
            }
            if (this.maskedtexture && (seg.silhouette & 1) == 0) {
                seg.silhouette |= 1;
                seg.bsilheight = Integer.MAX_VALUE;
            }
            ++this.seg_vars.ds_p;
        }

        protected void RenderSegLoop() {
            int texturecolumn = 0;
            while (this.rw_x < this.rw_stopx) {
                int yh;
                int bottom;
                int top;
                int yl = this.topfrac + 4096 - 1 >> 12;
                if (yl < this.ceilingclip[this.rw_x] + 1) {
                    yl = this.ceilingclip[this.rw_x] + 1;
                }
                if (this.markceiling) {
                    top = this.ceilingclip[this.rw_x] + 1;
                    bottom = yl - 1;
                    if (bottom >= this.floorclip[this.rw_x]) {
                        bottom = this.floorclip[this.rw_x] - 1;
                    }
                    if (top <= bottom) {
                        this.vp_vars.visplanes[this.vp_vars.ceilingplane].setTop(this.rw_x, (char)top);
                        this.vp_vars.visplanes[this.vp_vars.ceilingplane].setBottom(this.rw_x, (char)bottom);
                    }
                }
                if ((yh = this.bottomfrac >> 12) >= this.floorclip[this.rw_x]) {
                    yh = this.floorclip[this.rw_x] - 1;
                }
                if (this.markfloor) {
                    top = yh + 1;
                    bottom = this.floorclip[this.rw_x] - 1;
                    if (top <= this.ceilingclip[this.rw_x]) {
                        top = this.ceilingclip[this.rw_x] + 1;
                    }
                    if (top <= bottom) {
                        this.vp_vars.visplanes[this.vp_vars.floorplane].setTop(this.rw_x, (char)top);
                        this.vp_vars.visplanes[this.vp_vars.floorplane].setBottom(this.rw_x, (char)bottom);
                    }
                }
                if (this.segtextured) {
                    int angle = Tables.toBAMIndex(this.rw_centerangle + (long)((int)RendererState.this.view.xtoviewangle[this.rw_x]));
                    texturecolumn = this.rw_offset - fixed_t.FixedMul(Tables.finetangent[angle], this.rw_distance);
                    texturecolumn >>= 16;
                    int index = this.rw_scale >> RendererState.this.colormaps.lightScaleShift();
                    if (index >= RendererState.this.colormaps.maxLightScale()) {
                        index = RendererState.this.colormaps.maxLightScale() - 1;
                    }
                    RendererState.this.dcvars.dc_colormap = RendererState.this.colormaps.walllights[index];
                    RendererState.this.dcvars.dc_x = this.rw_x;
                    RendererState.this.dcvars.dc_iscale = (int)(0xFFFFFFFFL / (long)this.rw_scale);
                }
                if (this.midtexture != 0) {
                    RendererState.this.dcvars.dc_yl = yl;
                    RendererState.this.dcvars.dc_yh = yh;
                    RendererState.this.dcvars.dc_texheight = RendererState.this.TexMan.getTextureheight(this.midtexture) >> 16;
                    RendererState.this.dcvars.dc_texturemid = this.rw_midtexturemid;
                    RendererState.this.dcvars.dc_source_ofs = 0;
                    RendererState.this.dcvars.dc_source = RendererState.this.TexMan.GetCachedColumn(this.midtexture, texturecolumn);
                    this.CompleteColumn();
                    this.ceilingclip[this.rw_x] = (short)RendererState.this.view.height;
                    this.floorclip[this.rw_x] = -1;
                } else {
                    int mid;
                    if (this.toptexture != 0) {
                        mid = this.pixhigh >> 12;
                        this.pixhigh += this.pixhighstep;
                        if (mid >= this.floorclip[this.rw_x]) {
                            mid = this.floorclip[this.rw_x] - 1;
                        }
                        if (mid >= yl) {
                            RendererState.this.dcvars.dc_yl = yl;
                            RendererState.this.dcvars.dc_yh = mid;
                            RendererState.this.dcvars.dc_texturemid = this.rw_toptexturemid;
                            RendererState.this.dcvars.dc_texheight = RendererState.this.TexMan.getTextureheight(this.toptexture) >> 16;
                            RendererState.this.dcvars.dc_source = RendererState.this.TexMan.GetCachedColumn(this.toptexture, texturecolumn);
                            RendererState.this.dcvars.dc_source_ofs = 0;
                            if (RendererState.this.dcvars.dc_colormap == null) {
                                System.out.println("Two-sided");
                            }
                            this.CompleteColumn();
                            this.ceilingclip[this.rw_x] = (short)mid;
                        } else {
                            this.ceilingclip[this.rw_x] = (short)(yl - 1);
                        }
                    } else if (this.markceiling) {
                        this.ceilingclip[this.rw_x] = (short)(yl - 1);
                    }
                    if (this.bottomtexture != 0) {
                        mid = this.pixlow + 4096 - 1 >> 12;
                        this.pixlow += this.pixlowstep;
                        if (mid <= this.ceilingclip[this.rw_x]) {
                            mid = this.ceilingclip[this.rw_x] + 1;
                        }
                        if (mid <= yh) {
                            RendererState.this.dcvars.dc_yl = mid;
                            RendererState.this.dcvars.dc_yh = yh;
                            RendererState.this.dcvars.dc_texturemid = this.rw_bottomtexturemid;
                            RendererState.this.dcvars.dc_texheight = RendererState.this.TexMan.getTextureheight(this.bottomtexture) >> 16;
                            RendererState.this.dcvars.dc_source = RendererState.this.TexMan.GetCachedColumn(this.bottomtexture, texturecolumn);
                            RendererState.this.dcvars.dc_source_ofs = 0;
                            this.CompleteColumn();
                            this.floorclip[this.rw_x] = (short)mid;
                        } else {
                            this.floorclip[this.rw_x] = (short)(yh + 1);
                        }
                    } else if (this.markfloor) {
                        this.floorclip[this.rw_x] = (short)(yh + 1);
                    }
                    if (this.maskedtexture) {
                        this.seg_vars.maskedtexturecol[this.seg_vars.pmaskedtexturecol + this.rw_x] = (short)texturecolumn;
                    }
                }
                this.rw_scale += this.rw_scalestep;
                this.topfrac += this.topstep;
                this.bottomfrac += this.bottomstep;
                ++this.rw_x;
            }
        }

        @Override
        public void ClearClips() {
            System.arraycopy(this.BLANKFLOORCLIP, 0, this.floorclip, 0, RendererState.this.view.width);
            System.arraycopy(this.BLANKCEILINGCLIP, 0, this.ceilingclip, 0, RendererState.this.view.width);
        }

        protected abstract void CompleteColumn();

        @Override
        public void ExecuteSetViewSize(int viewwidth) {
            for (int i = 0; i < viewwidth; ++i) {
                this.BLANKFLOORCLIP[i] = (short)RendererState.this.view.height;
                this.BLANKCEILINGCLIP[i] = -1;
            }
        }

        @Override
        public void CompleteRendering() {
        }

        public SegDrawer(SceneRenderer<?, ?> R) {
            this.vp_vars = R.getVPVars();
            this.seg_vars = R.getSegVars();
            this.col = new column_t();
            this.seg_vars.drawsegs = (drawseg_t[])GenericCopy.malloc(drawseg_t::new, drawseg_t[]::new, this.seg_vars.MAXDRAWSEGS);
            this.floorclip = new short[RendererState.this.DOOM.vs.getScreenWidth()];
            this.ceilingclip = new short[RendererState.this.DOOM.vs.getScreenWidth()];
            this.BLANKFLOORCLIP = new short[RendererState.this.DOOM.vs.getScreenWidth()];
            this.BLANKCEILINGCLIP = new short[RendererState.this.DOOM.vs.getScreenWidth()];
        }

        protected int ScaleFromGlobalAngle(long visangle) {
            int scale;
            long anglea = 0x40000000L + visangle - RendererState.this.view.angle & 0xFFFFFFFFL;
            long angleb = 0x40000000L + visangle - this.rw_normalangle & 0xFFFFFFFFL;
            int sinea = Tables.finesine(anglea);
            int sineb = Tables.finesine(angleb);
            int num = fixed_t.FixedMul(RendererState.this.view.projection, sineb) << RendererState.this.view.detailshift;
            int den = fixed_t.FixedMul(this.rw_distance, sinea);
            if (den > num >> 16) {
                scale = fixed_t.FixedDiv(num, den);
                if (scale > 0x400000) {
                    scale = 0x400000;
                } else if (scale < 256) {
                    scale = 256;
                }
            } else {
                scale = 0x400000;
            }
            return scale;
        }

        @Override
        public void setGlobalAngle(long angle) {
            this.rw_angle1 = angle;
        }
    }

    protected final class BSP
    extends BSPVars {
        int newend;
        cliprange_t[] solidsegs;
        private final int[][] checkcoord = new int[][]{{3, 0, 2, 1}, {3, 0, 2, 0}, {3, 1, 2, 0}, {0}, {2, 0, 2, 1}, {0, 0, 0, 0}, {3, 1, 3, 0}, {0}, {2, 0, 3, 1}, {2, 1, 3, 1}, {2, 1, 3, 0}};

        BSP() {
            this.solidsegs = (cliprange_t[])GenericCopy.malloc(cliprange_t::new, cliprange_t[]::new, 33);
        }

        private void ClipSolidWallSegment(int first, int last) {
            int start = 0;
            while (this.solidsegs[start].last < first - 1) {
                ++start;
            }
            if (first < this.solidsegs[start].first) {
                if (last < this.solidsegs[start].first - 1) {
                    RendererState.this.MySegs.StoreWallRange(first, last);
                    int next = this.newend++;
                    if (next >= this.solidsegs.length) {
                        this.ResizeSolidSegs();
                    }
                    while (next != start) {
                        this.solidsegs[next].copy(this.solidsegs[next - 1]);
                        --next;
                    }
                    this.solidsegs[next].first = first;
                    this.solidsegs[next].last = last;
                    return;
                }
                RendererState.this.MySegs.StoreWallRange(first, this.solidsegs[start].first - 1);
                this.solidsegs[start].first = first;
            }
            if (last <= this.solidsegs[start].last) {
                return;
            }
            int next = start;
            while (last >= this.solidsegs[next + 1].first - 1) {
                RendererState.this.MySegs.StoreWallRange(this.solidsegs[next].last + 1, this.solidsegs[next + 1].first - 1);
                if (last > this.solidsegs[++next].last) continue;
                this.solidsegs[start].last = this.solidsegs[next].last;
                if (next == start) {
                    return;
                }
                while (next++ != this.newend) {
                    if (next >= this.solidsegs.length) {
                        this.ResizeSolidSegs();
                    }
                    this.solidsegs[++start].copy(this.solidsegs[next]);
                }
                this.newend = start + 1;
                return;
            }
            RendererState.this.MySegs.StoreWallRange(this.solidsegs[next].last + 1, last);
            this.solidsegs[start].last = last;
            if (next == start) {
                return;
            }
            while (next++ != this.newend) {
                if (next >= this.solidsegs.length) {
                    this.ResizeSolidSegs();
                }
                this.solidsegs[++start].copy(this.solidsegs[next]);
            }
            this.newend = start + 1;
        }

        void ResizeSolidSegs() {
            this.solidsegs = C2JUtils.resize(this.solidsegs, this.solidsegs.length * 2);
        }

        private void ClipPassWallSegment(int first, int last) {
            int start = 0;
            while (this.solidsegs[start].last < first - 1) {
                ++start;
            }
            if (first < this.solidsegs[start].first) {
                if (last < this.solidsegs[start].first - 1) {
                    RendererState.this.MySegs.StoreWallRange(first, last);
                    return;
                }
                RendererState.this.MySegs.StoreWallRange(first, this.solidsegs[start].first - 1);
            }
            if (last <= this.solidsegs[start].last) {
                return;
            }
            while (last >= this.solidsegs[start + 1].first - 1) {
                RendererState.this.MySegs.StoreWallRange(this.solidsegs[start].last + 1, this.solidsegs[start + 1].first - 1);
                if (last > this.solidsegs[++start].last) continue;
                return;
            }
            RendererState.this.MySegs.StoreWallRange(this.solidsegs[start].last + 1, last);
        }

        public void ClearClipSegs() {
            this.solidsegs[0].first = -2147483647;
            this.solidsegs[0].last = -1;
            this.solidsegs[1].first = RendererState.this.view.width;
            this.solidsegs[1].last = Integer.MAX_VALUE;
            this.newend = 2;
        }

        private void AddLine(seg_t line) {
            int x2;
            int x1;
            long angle2;
            this.curline = line;
            long angle1 = RendererState.this.view.PointToAngle(line.v1x, line.v1y);
            long span = Tables.addAngles(angle1, -(angle2 = RendererState.this.view.PointToAngle(line.v2x, line.v2y)));
            if (span >= 0x80000000L) {
                return;
            }
            RendererState.this.MySegs.setGlobalAngle(angle1);
            angle1 -= RendererState.this.view.angle;
            angle2 -= RendererState.this.view.angle;
            angle2 &= 0xFFFFFFFFL;
            long tspan = Tables.addAngles(angle1 &= 0xFFFFFFFFL, RendererState.this.clipangle);
            if (tspan > RendererState.this.CLIPANGLE2) {
                tspan -= RendererState.this.CLIPANGLE2;
                if ((tspan &= 0xFFFFFFFFL) >= span) {
                    return;
                }
                angle1 = RendererState.this.clipangle;
            }
            if ((tspan = Tables.addAngles(RendererState.this.clipangle, -angle2)) > RendererState.this.CLIPANGLE2) {
                tspan -= RendererState.this.CLIPANGLE2;
                if ((tspan &= 0xFFFFFFFFL) >= span) {
                    return;
                }
                angle2 = -RendererState.this.clipangle;
                angle2 &= 0xFFFFFFFFL;
            }
            if ((x1 = RendererState.this.viewangletox[(int)(angle1 = (angle1 + 0x40000000L & 0xFFFFFFFFL) >>> 19)]) == (x2 = RendererState.this.viewangletox[(int)(angle2 = (angle2 + 0x40000000L & 0xFFFFFFFFL) >>> 19)])) {
                return;
            }
            this.backsector = line.backsector;
            if (this.backsector == null) {
                this.ClipSolidWallSegment(x1, x2 - 1);
                return;
            }
            if (this.backsector.ceilingheight <= this.frontsector.floorheight || this.backsector.floorheight >= this.frontsector.ceilingheight) {
                this.ClipSolidWallSegment(x1, x2 - 1);
                return;
            }
            if (this.backsector.ceilingheight != this.frontsector.ceilingheight || this.backsector.floorheight != this.frontsector.floorheight) {
                this.ClipPassWallSegment(x1, x2 - 1);
                return;
            }
            if (this.backsector.ceilingpic == this.frontsector.ceilingpic && this.backsector.floorpic == this.frontsector.floorpic && this.backsector.lightlevel == this.frontsector.lightlevel && this.curline.sidedef.midtexture == 0) {
                return;
            }
            this.ClipPassWallSegment(x1, x2 - 1);
        }

        public boolean CheckBBox(int[] bspcoord) {
            int sx2;
            int sx1;
            int boxx;
            int boxy = RendererState.this.view.y >= bspcoord[0] ? 0 : (RendererState.this.view.y > bspcoord[1] ? 1 : 2);
            int boxpos = (boxy << 2) + (boxx = RendererState.this.view.x <= bspcoord[2] ? 0 : (RendererState.this.view.x < bspcoord[3] ? 1 : 2));
            if (boxpos == 5) {
                return true;
            }
            int x1 = bspcoord[this.checkcoord[boxpos][0]];
            int y1 = bspcoord[this.checkcoord[boxpos][1]];
            int x2 = bspcoord[this.checkcoord[boxpos][2]];
            int y2 = bspcoord[this.checkcoord[boxpos][3]];
            long angle1 = RendererState.this.view.PointToAngle(x1, y1) - RendererState.this.view.angle;
            long angle2 = RendererState.this.view.PointToAngle(x2, y2) - RendererState.this.view.angle;
            long span = (angle1 &= 0xFFFFFFFFL) - (angle2 &= 0xFFFFFFFFL);
            if ((span &= 0xFFFFFFFFL) >= 0x80000000L) {
                return true;
            }
            long tspan = angle1 + RendererState.this.clipangle;
            if ((tspan &= 0xFFFFFFFFL) > RendererState.this.CLIPANGLE2) {
                tspan -= RendererState.this.CLIPANGLE2;
                if ((tspan &= 0xFFFFFFFFL) >= span) {
                    return false;
                }
                angle1 = RendererState.this.clipangle;
            }
            if ((tspan = RendererState.this.clipangle - angle2 & 0xFFFFFFFFL) > RendererState.this.CLIPANGLE2) {
                tspan -= RendererState.this.CLIPANGLE2;
                if ((tspan &= 0xFFFFFFFFL) >= span) {
                    return false;
                }
                angle2 = -RendererState.this.clipangle;
                angle2 &= 0xFFFFFFFFL;
            }
            if ((sx1 = RendererState.this.viewangletox[(int)(angle1 = (angle1 + 0x40000000L & 0xFFFFFFFFL) >>> 19)]) == (sx2 = RendererState.this.viewangletox[(int)(angle2 = (angle2 + 0x40000000L & 0xFFFFFFFFL) >>> 19)])) {
                return false;
            }
            --sx2;
            int pstart = 0;
            cliprange_t start = this.solidsegs[pstart];
            while (start.last < sx2 && pstart < 32) {
                start = this.solidsegs[pstart++];
            }
            return sx1 < start.first || sx2 > start.last;
        }

        private void Subsector(int num) {
            ++RendererState.this.sscount;
            subsector_t sub = RendererState.this.DOOM.levelLoader.subsectors[num];
            this.frontsector = sub.sector;
            int count = sub.numlines;
            int line = sub.firstline;
            RendererState.this.vp_vars.floorplane = this.frontsector.floorheight < RendererState.this.view.z ? RendererState.this.vp_vars.FindPlane(this.frontsector.floorheight, this.frontsector.floorpic, this.frontsector.lightlevel) : -1;
            RendererState.this.vp_vars.ceilingplane = this.frontsector.ceilingheight > RendererState.this.view.z || this.frontsector.ceilingpic == RendererState.this.TexMan.getSkyFlatNum() ? RendererState.this.vp_vars.FindPlane(this.frontsector.ceilingheight, this.frontsector.ceilingpic, this.frontsector.lightlevel) : -1;
            RendererState.this.VIS.AddSprites(this.frontsector);
            while (count-- > 0) {
                this.AddLine(RendererState.this.DOOM.levelLoader.segs[line]);
                ++line;
            }
        }

        public void RenderBSPNode(int bspnum) {
            if (C2JUtils.flags(bspnum, Integer.MIN_VALUE)) {
                if (bspnum == -1) {
                    this.Subsector(0);
                } else {
                    this.Subsector(bspnum & Integer.MAX_VALUE);
                }
                return;
            }
            node_t bsp = RendererState.this.DOOM.levelLoader.nodes[bspnum];
            int side = bsp.PointOnSide(RendererState.this.view.x, RendererState.this.view.y);
            this.RenderBSPNode(bsp.children[side]);
            if (this.CheckBBox(bsp.bbox[side ^ 1].bbox)) {
                this.RenderBSPNode(bsp.children[side ^ 1]);
            }
        }
    }
}

