/*
 * Decompiled with CFR 0.152.
 */
package rr;

import doom.DoomMain;
import i.IDoomSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import p.AbstractLevelLoader;
import rr.MultiPatchSynthesizer;
import rr.TextureManager;
import rr.column_t;
import rr.flat_t;
import rr.mappatch_t;
import rr.maptexture_t;
import rr.patch_t;
import rr.texpatch_t;
import rr.texture_t;
import w.DoomBuffer;
import w.IWadLoader;
import w.li_namespace;
import w.lumpinfo_t;

public class SimpleTextureManager
implements TextureManager<byte[]> {
    IWadLoader W;
    IDoomSystem I;
    AbstractLevelLoader LL;
    DoomMain<?, ?> DM;
    protected int firstflat;
    protected int lastflat;
    protected int numflats;
    protected flat_t[] flats;
    protected int numpatches;
    protected int numtextures;
    protected texture_t[] textures;
    protected int[] texturewidthmask;
    protected int[] textureheight;
    protected int[] texturecompositesize;
    protected short[][] texturecolumnlump;
    protected char[][] texturecolumnofs;
    protected char texturecoloffset;
    protected byte[][][] texturecomposite;
    protected patch_t[] patchcomposite;
    protected int[] flattranslation;
    protected int[] flatstorage;
    protected int[] texturetranslation;
    protected int skytexture;
    protected int skytexturemid;
    protected int skyflatnum;
    Hashtable<Integer, Integer> FlatCache;
    Hashtable<Integer, patch_t> FlatPatchCache;
    Hashtable<String, Integer> TextureCache;
    private static final String LUMPSTART = "F_START";
    private static final String LUMPEND = "F_END";
    private static final String DEUTEX_END = "FF_END";
    private static final String DEUTEX_START = "FF_START";
    int flatmemory;
    int texturememory;
    int lastrogue = -1;
    byte[][] rogue;
    HashMap<Integer, byte[][]> roguePatches = new HashMap();
    private final byte[] safepatch = new byte[4096];
    protected boolean[] smp_composite;
    protected int[] smp_lasttex;
    protected int[] smp_lastlump;
    protected patch_t[] smp_lastpatch;
    private boolean composite = false;
    private int lasttex = -1;
    private int lastlump = -1;
    private patch_t lastpatch = null;

    public SimpleTextureManager(DoomMain<?, ?> DC) {
        this.DM = DC;
        this.W = this.DM.wadLoader;
        this.I = this.DM.doomSystem;
        this.LL = this.DM.levelLoader;
        this.FlatPatchCache = new Hashtable();
    }

    @Override
    public int CheckTextureNumForName(String name) {
        if (name.charAt(0) == '-') {
            return 0;
        }
        Integer i = this.TextureCache.get(name);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public int TextureNumForName(String name) {
        int i = this.CheckTextureNumForName(name);
        if (i == -1) {
            this.I.Error("R_TextureNumForName: %s not found", name);
        }
        return i;
    }

    @Override
    public void InitTextures() throws IOException {
        int i;
        maptexture_t mtexture = new maptexture_t();
        ByteBuffer[] maptex = new ByteBuffer[texturelumps.length];
        int[] maxoff = new int[texturelumps.length];
        int[] _numtextures = new int[texturelumps.length];
        int directory = 1;
        int texset = 0;
        int[] patchlookup = this.loadPatchNames("PNAMES");
        for (i = 0; i < texturelumps.length; ++i) {
            String TEXTUREx = texturelumps[i];
            if (this.W.CheckNumForName(TEXTUREx) == -1) continue;
            maptex[i] = this.W.CacheLumpName(TEXTUREx, 1).getBuffer();
            maptex[i].rewind();
            maptex[i].order(ByteOrder.LITTLE_ENDIAN);
            _numtextures[i] = maptex[i].getInt();
            maxoff[i] = this.W.LumpLength(this.W.GetNumForName(TEXTUREx));
        }
        this.numtextures = _numtextures[0] + _numtextures[1];
        this.textures = new texture_t[this.numtextures];
        this.TextureCache = new Hashtable(this.numtextures);
        this.texturecolumnlump = new short[this.numtextures][];
        this.texturecolumnofs = new char[this.numtextures][];
        this.patchcomposite = new patch_t[this.numtextures];
        this.texturecomposite = new byte[this.numtextures][][];
        this.texturecompositesize = new int[this.numtextures];
        this.texturewidthmask = new int[this.numtextures];
        this.textureheight = new int[this.numtextures];
        int totalwidth = 0;
        System.out.print("[");
        i = 0;
        while (i < this.numtextures) {
            int j;
            int offset;
            if ((i & 0x3F) == 0) {
                System.out.print('.');
            }
            if (i == _numtextures[0]) {
                texset = 1;
                directory = 1;
            }
            if ((offset = maptex[texset].getInt(directory << 2)) > maxoff[texset]) {
                this.I.Error("R_InitTextures: bad texture directory");
            }
            maptex[texset].position(offset);
            mtexture.unpack(maptex[texset]);
            this.TextureCache.put(mtexture.name.toUpperCase(), new Integer(i));
            this.textures[i] = new texture_t();
            this.textures[i].copyFromMapTexture(mtexture);
            texture_t texture = this.textures[i];
            mappatch_t[] mpatch = mtexture.patches;
            texpatch_t[] patch = texture.patches;
            for (j = 0; j < texture.patchcount; ++j) {
                patch[j].patch = patchlookup[mpatch[j].patch];
                if (patch[j].patch != -1) continue;
                this.I.Error("R_InitTextures: Missing patch in texture %s", texture.name);
            }
            this.texturecolumnlump[i] = new short[texture.width];
            this.texturecolumnofs[i] = new char[texture.width];
            j = 1;
            while (j * 2 <= texture.width) {
                j <<= 1;
            }
            this.texturewidthmask[i] = j - 1;
            this.textureheight[i] = texture.height << 16;
            totalwidth += texture.width;
            ++i;
            ++directory;
        }
        for (i = 0; i < this.numtextures; ++i) {
            this.GenerateLookup(i);
        }
        this.texturetranslation = new int[this.numtextures];
        for (i = 0; i < this.numtextures; ++i) {
            this.texturetranslation[i] = i;
        }
    }

    private int[] loadPatchNames(String pnames) throws IOException {
        ByteBuffer names = this.W.CacheLumpName(pnames, 1).getBuffer();
        names.order(ByteOrder.LITTLE_ENDIAN);
        names.rewind();
        int nummappatches = names.getInt();
        int[] patchlookup = new int[nummappatches];
        block0: for (int i = 0; i < nummappatches; ++i) {
            String name = DoomBuffer.getNullTerminatedString(names, 8).toUpperCase();
            int[] stuff = this.W.CheckNumsForName(name);
            for (int k = 0; k < stuff.length; ++k) {
                if (this.W.GetLumpInfo((int)stuff[k]).namespace != li_namespace.ns_flats) {
                    patchlookup[i] = stuff[k];
                    continue block0;
                }
                patchlookup[i] = stuff[k];
            }
        }
        return patchlookup;
    }

    private patch_t retrievePatchSafe(int lump) {
        patch_t realpatch;
        if (this.FlatPatchCache.containsKey(lump)) {
            return this.FlatPatchCache.get(lump);
        }
        lumpinfo_t info2 = this.W.GetLumpInfo(lump);
        if (info2.namespace == li_namespace.ns_flats) {
            byte[] flat = this.W.CacheLumpNumAsRawBytes(lump, 101);
            realpatch = MultiPatchSynthesizer.synthesizePatchFromFlat(info2.name, flat, 64, 64);
            this.FlatPatchCache.put(lump, realpatch);
            this.W.UnlockLumpNum(lump);
        } else {
            realpatch = this.W.CacheLumpNum(lump, 101, patch_t.class);
        }
        return realpatch;
    }

    @Override
    public void GenerateLookup(int texnum) throws IOException {
        int x;
        patch_t realpatch = null;
        texture_t texture = this.textures[texnum];
        this.texturecomposite[texnum] = null;
        this.texturecompositesize[texnum] = 0;
        short[] collump = this.texturecolumnlump[texnum];
        char[] colofs = this.texturecolumnofs[texnum];
        short[] patchcount = new short[texture.width];
        texpatch_t[] patch = texture.patches;
        for (int i = 0; i < texture.patchcount; ++i) {
            realpatch = this.retrievePatchSafe(patch[i].patch);
            int x1 = patch[i].originx;
            int x2 = x1 + realpatch.width;
            x = x1 < 0 ? 0 : x1;
            if (x2 > texture.width) {
                x2 = texture.width;
            }
            while (x < x2) {
                int n = x;
                patchcount[n] = (short)(patchcount[n] + 1);
                collump[x] = (short)patch[i].patch;
                colofs[x] = (char)(x - x1);
                ++x;
            }
        }
        for (x = 0; x < texture.width; ++x) {
            if (patchcount[x] == 0) {
                System.err.print(realpatch.width);
                System.err.print("R_GenerateLookup: column without a patch (" + texture.name + ")\n");
            }
            if (patchcount[x] <= 1) continue;
            collump[x] = -1;
            colofs[x] = (char)this.texturecompositesize[texnum];
            int n = texnum;
            this.texturecompositesize[n] = this.texturecompositesize[n] + texture.height;
        }
    }

    @Override
    public void GenerateComposite(int texnum) {
        patch_t realpatch = null;
        texture_t texture = this.textures[texnum];
        this.texturecomposite[texnum] = new byte[texture.width][texture.height];
        byte[][] block = this.texturecomposite[texnum];
        short[] collump = this.texturecolumnlump[texnum];
        char[] colofs = this.texturecolumnofs[texnum];
        texpatch_t[] patch = texture.patches;
        for (int i = 0; i < texture.patchcount; ++i) {
            realpatch = this.retrievePatchSafe(patch[i].patch);
            int x1 = patch[i].originx;
            int x2 = x1 + realpatch.width;
            int x = x1 < 0 ? 0 : x1;
            if (x2 > texture.width) {
                x2 = texture.width;
            }
            while (x < x2) {
                if (collump[x] < 0) {
                    column_t patchcol = realpatch.columns[x - x1];
                    this.DrawColumnInCache(patchcol, block[x], colofs[x], patch[i].originy, texture.height);
                }
                ++x;
            }
        }
    }

    @Override
    public void GenerateMaskedComposite(int texnum) {
        patch_t realpatch = null;
        texture_t texture = this.textures[texnum];
        byte[][] block = new byte[texture.width][texture.height];
        boolean[][] pixmap = new boolean[texture.width][texture.height];
        short[] collump = this.texturecolumnlump[texnum];
        char[] colofs = this.texturecolumnofs[texnum];
        texpatch_t[] patch = texture.patches;
        for (int i = 0; i < texture.patchcount; ++i) {
            realpatch = this.W.CachePatchNum(patch[i].patch);
            int x1 = patch[i].originx;
            int x2 = x1 + realpatch.width;
            int x = x1 < 0 ? 0 : x1;
            if (x2 > texture.width) {
                x2 = texture.width;
            }
            while (x < x2) {
                if (collump[x] < 0) {
                    column_t patchcol = realpatch.columns[x - x1];
                    this.DrawColumnInCache(patchcol, block[x], pixmap[x], colofs[x], patch[i].originy, texture.height);
                }
                ++x;
            }
        }
        this.patchcomposite[texnum] = MultiPatchSynthesizer.synthesize(this.CheckTextureNameForNum(texnum), block, pixmap, texture.width, texture.height);
    }

    public void DrawColumnInCache(column_t patch, byte[] cache, int offset, int originy, int cacheheight) {
        int source = 0;
        for (int i = 0; i < patch.posts; ++i) {
            source = patch.postofs[i];
            int count = patch.postlen[i];
            int position = originy + patch.postdeltas[i];
            if (position < 0) {
                count += position;
                position = 0;
            }
            if (position + count > cacheheight) {
                count = cacheheight - position;
            }
            if (count <= 0) continue;
            System.arraycopy(patch.data, source, cache, position, count);
        }
    }

    public void DrawColumnInCache(column_t patch, byte[] cache, boolean[] pixmap, int offset, int originy, int cacheheight) {
        int source = 0;
        for (int i = 0; i < patch.posts; ++i) {
            source = patch.postofs[i];
            int count = patch.postlen[i];
            int position = originy + patch.postdeltas[i];
            if (position < 0) {
                count += position;
                position = 0;
            }
            if (position + count > cacheheight) {
                count = cacheheight - position;
            }
            if (count <= 0) continue;
            System.arraycopy(patch.data, source, cache, position, count);
            Arrays.fill(pixmap, position, position + count, true);
        }
    }

    @Override
    public final void InitFlats() {
        String name;
        this.numflats = 0;
        int extendedflatstart = -1;
        this.firstflat = this.W.GetNumForName(LUMPSTART);
        if (this.FlatCache == null) {
            this.FlatCache = new Hashtable();
        } else {
            this.FlatCache.clear();
        }
        Hashtable<String, Integer> FlatNames = new Hashtable<String, Integer>();
        int lump = this.firstflat;
        int seq = 0;
        while (!(name = this.W.GetNameForNum(lump)).equalsIgnoreCase(LUMPEND)) {
            if (!this.W.isLumpMarker(lump)) {
                this.FlatCache.put(lump, seq);
                FlatNames.put(name, lump);
                ++seq;
                ++this.numflats;
            }
            ++lump;
        }
        extendedflatstart = this.W.CheckNumForName(DEUTEX_START);
        if (extendedflatstart > -1) {
            lump = extendedflatstart;
            name = this.W.GetNameForNum(lump);
            while (name != null && !name.equalsIgnoreCase(LUMPEND) && !name.equalsIgnoreCase(DEUTEX_END)) {
                if (!this.W.isLumpMarker(lump)) {
                    if (FlatNames.containsKey(name)) {
                        int removed = (Integer)FlatNames.remove(name);
                        FlatNames.put(name, lump);
                        int oldseq = this.FlatCache.remove(removed);
                        this.FlatCache.put(lump, oldseq);
                    } else {
                        this.FlatCache.put(lump, seq);
                        FlatNames.put(name, lump);
                        ++seq;
                        ++this.numflats;
                    }
                }
                name = this.W.GetNameForNum(++lump);
            }
        }
        this.flattranslation = new int[this.numflats];
        this.flatstorage = new int[this.numflats];
        Enumeration<Integer> stuff = this.FlatCache.keys();
        while (stuff.hasMoreElements()) {
            int nextlump;
            this.flatstorage[this.FlatCache.get((Object)Integer.valueOf((int)nextlump)).intValue()] = nextlump = stuff.nextElement().intValue();
        }
        for (int i = 0; i < this.numflats; ++i) {
            this.flattranslation[i] = i;
        }
    }

    @Override
    public void PrecacheLevel() throws IOException {
        this.preCacheFlats();
        this.preCacheTextures();
    }

    protected final void preCacheFlats() {
        int i;
        if (this.DM.demoplayback) {
            return;
        }
        boolean[] flatpresent = new boolean[this.numflats];
        this.flats = new flat_t[this.numflats];
        for (i = 0; i < this.LL.numsectors; ++i) {
            flatpresent[this.LL.sectors[i].floorpic] = true;
            flatpresent[this.LL.sectors[i].ceilingpic] = true;
        }
        this.flatmemory = 0;
        for (i = 0; i < this.numflats; ++i) {
            if (!flatpresent[i]) continue;
            int lump = this.firstflat + i;
            this.flatmemory = (int)((long)this.flatmemory + this.W.GetLumpInfo((int)lump).size);
            this.flats[i] = this.W.CacheLumpNum(lump, 101, flat_t.class);
        }
    }

    protected final void preCacheTextures() {
        int i;
        boolean[] texturepresent = new boolean[this.numtextures];
        for (i = 0; i < this.LL.numsides; ++i) {
            texturepresent[this.LL.sides[i].toptexture] = true;
            texturepresent[this.LL.sides[i].midtexture] = true;
            texturepresent[this.LL.sides[i].bottomtexture] = true;
        }
        texturepresent[this.skytexture] = true;
        this.texturememory = 0;
        for (i = 0; i < this.numtextures; ++i) {
            if (!texturepresent[i]) continue;
            texture_t texture = this.textures[i];
            for (int j = 0; j < texture.patchcount; ++j) {
                int lump = texture.patches[j].patch;
                this.texturememory = (int)((long)this.texturememory + this.W.GetLumpInfo((int)lump).size);
                this.W.CacheLumpNum(lump, 101, patch_t.class);
            }
        }
    }

    @Override
    public final int FlatNumForName(String name) {
        int i = this.W.CheckNumForName(name);
        if (i == -1) {
            this.I.Error("R_FlatNumForName: %s not found", name);
        }
        return this.FlatCache.get(i);
    }

    @Override
    public final int getTextureColumnLump(int tex, int col) {
        return this.texturecolumnlump[tex][col];
    }

    @Override
    public final char getTextureColumnOfs(int tex, int col) {
        return this.texturecolumnofs[tex][col];
    }

    @Override
    public final int getTexturewidthmask(int tex) {
        return this.texturewidthmask[tex];
    }

    public final byte[][] getTextureComposite(int tex) {
        return this.texturecomposite[tex];
    }

    @Override
    public final byte[] getTextureComposite(int tex, int col) {
        return this.texturecomposite[tex][col];
    }

    @Override
    public final patch_t getMaskedComposite(int tex) {
        return this.patchcomposite[tex];
    }

    @Override
    public final int getTextureheight(int texnum) {
        return this.textureheight[texnum];
    }

    @Override
    public final int getTextureTranslation(int texnum) {
        return this.texturetranslation[texnum];
    }

    @Override
    public int getFlatTranslation(int flatnum) {
        return this.flatstorage[this.flattranslation[flatnum]];
    }

    @Override
    public final void setTextureTranslation(int texnum, int amount) {
        this.texturetranslation[texnum] = amount;
    }

    @Override
    public final void setFlatTranslation(int flatnum, int amount) {
        this.flattranslation[flatnum] = amount;
    }

    @Override
    public int InitSkyMap() {
        this.skyflatnum = this.FlatNumForName("F_SKY1");
        this.skytexturemid = 0x640000;
        return this.skyflatnum;
    }

    @Override
    public int getSkyFlatNum() {
        return this.skyflatnum;
    }

    @Override
    public void setSkyFlatNum(int skyflatnum) {
        this.skyflatnum = skyflatnum;
    }

    @Override
    public int getSkyTexture() {
        return this.skytexture;
    }

    @Override
    public void setSkyTexture(int skytexture) {
        this.skytexture = skytexture;
    }

    @Override
    public int getSkyTextureMid() {
        return this.skytexturemid;
    }

    @Override
    public String CheckTextureNameForNum(int texnum) {
        return this.textures[texnum].name;
    }

    @Override
    public int getFlatLumpNum(int flatnum) {
        return 0;
    }

    @Override
    public synchronized byte[] getRogueColumn(int lump, int column) {
        if (!this.roguePatches.containsKey(lump)) {
            this.roguePatches.put(lump, this.generateRoguePatch(lump));
        }
        this.lastrogue = lump;
        this.rogue = this.roguePatches.get(lump);
        return this.rogue[column];
    }

    private byte[][] generateRoguePatch(int lump) {
        patch_t p = this.retrievePatchSafe(lump);
        byte[][] block = new byte[p.width][p.height];
        for (int i = 0; i < p.width; ++i) {
            this.DrawColumnInCache(p.columns[i], block[i], i, 0, p.height);
        }
        this.W.UnlockLumpNum(lump);
        return block;
    }

    @Override
    public byte[] getSafeFlat(int flatnum) {
        byte[] flat = this.W.CacheLumpNum((int)this.getFlatTranslation((int)flatnum), (int)1, flat_t.class).data;
        if (flat.length < 4096) {
            System.arraycopy(flat, 0, this.safepatch, 0, flat.length);
            return this.safepatch;
        }
        return flat;
    }

    @Override
    public column_t GetSmpColumn(int tex, int col, int id) {
        int lump = this.getTextureColumnLump(tex, col &= this.getTexturewidthmask(tex));
        char ofs = this.getTextureColumnOfs(tex, col);
        if (tex == this.smp_lasttex[id] && lump == this.smp_lastlump[id]) {
            if (this.composite) {
                return this.smp_lastpatch[id].columns[col];
            }
            return this.smp_lastpatch[id].columns[ofs];
        }
        if (lump > 0) {
            this.smp_lastpatch[id] = this.W.CachePatchNum(lump);
            this.smp_lasttex[id] = tex;
            this.smp_lastlump[id] = lump;
            this.smp_composite[id] = false;
            return this.smp_lastpatch[id].columns[ofs];
        }
        if (this.getMaskedComposite(tex) == null) {
            System.err.printf("Forced generation of composite %s\n", this.CheckTextureNameForNum(tex), this.smp_composite[id], col, (int)ofs);
            this.GenerateMaskedComposite(tex);
            System.err.printf("Composite patch %s %d\n", this.getMaskedComposite((int)tex).name, this.getMaskedComposite((int)tex).columns.length);
        }
        this.smp_lastpatch[id] = this.getMaskedComposite(tex);
        this.smp_lasttex[id] = tex;
        this.smp_composite[id] = true;
        this.smp_lastlump[id] = 0;
        return this.lastpatch.columns[col];
    }

    @Override
    public byte[] GetColumn(int tex, int col) {
        int lump = this.getTextureColumnLump(tex, col &= this.getTexturewidthmask(tex));
        char ofs = this.getTextureColumnOfs(tex, col);
        if (tex == this.lasttex && lump == this.lastlump) {
            if (this.composite) {
                return this.lastpatch.columns[col].data;
            }
            return this.lastpatch.columns[ofs].data;
        }
        if (lump > 0) {
            this.lastpatch = this.W.CachePatchNum(lump);
            this.lasttex = tex;
            this.lastlump = lump;
            this.composite = false;
            return this.lastpatch.columns[ofs].data;
        }
        if (this.getMaskedComposite(tex) == null) {
            System.err.printf("Forced generation of composite %s\n", this.CheckTextureNameForNum(tex), this.composite, col, (int)ofs);
            this.GenerateMaskedComposite(tex);
            System.err.printf("Composite patch %s %d\n", this.getMaskedComposite((int)tex).name, this.getMaskedComposite((int)tex).columns.length);
        }
        this.lastpatch = this.getMaskedComposite(tex);
        this.lasttex = tex;
        this.composite = true;
        this.lastlump = 0;
        return this.lastpatch.columns[col].data;
    }

    @Override
    public column_t GetColumnStruct(int tex, int col) {
        int lump = this.getTextureColumnLump(tex, col &= this.getTexturewidthmask(tex));
        char ofs = this.getTextureColumnOfs(tex, col);
        if (tex == this.lasttex && lump == this.lastlump) {
            if (this.composite) {
                return this.lastpatch.columns[col];
            }
            return this.lastpatch.columns[ofs];
        }
        if (lump > 0) {
            this.lastpatch = this.W.CachePatchNum(lump);
            this.lasttex = tex;
            this.lastlump = lump;
            this.composite = false;
            return this.lastpatch.columns[ofs];
        }
        if (this.getMaskedComposite(tex) == null) {
            System.err.printf("Forced generation of composite %s\n", this.CheckTextureNameForNum(tex), this.composite, col, (int)ofs);
            this.GenerateMaskedComposite(tex);
            System.err.printf("Composite patch %s %d\n", this.getMaskedComposite((int)tex).name, this.getMaskedComposite((int)tex).columns.length);
        }
        this.lastpatch = this.getMaskedComposite(tex);
        this.lasttex = tex;
        this.composite = true;
        this.lastlump = 0;
        return this.lastpatch.columns[col];
    }

    @Override
    public final byte[] GetCachedColumn(int tex, int col) {
        int lump = this.getTextureColumnLump(tex, col &= this.getTexturewidthmask(tex));
        char ofs = this.getTextureColumnOfs(tex, col);
        if (lump > 0) {
            return this.getRogueColumn(lump, ofs);
        }
        if (this.getTextureComposite(tex) == null) {
            this.GenerateComposite(tex);
        }
        return this.getTextureComposite(tex, col);
    }

    @Override
    public void setSMPVars(int num_threads) {
        this.smp_composite = new boolean[num_threads];
        this.smp_lasttex = new int[num_threads];
        this.smp_lastlump = new int[num_threads];
        this.smp_lastpatch = new patch_t[num_threads];
    }

    class TextureDirectoryEntry
    implements Comparable<TextureDirectoryEntry> {
        int offset;
        int entry;
        int length;

        TextureDirectoryEntry() {
        }

        @Override
        public int compareTo(TextureDirectoryEntry o) {
            if (this.offset < o.offset) {
                return -1;
            }
            if (this.offset == o.offset) {
                return 0;
            }
            return 1;
        }
    }
}

