/*
 * Decompiled with CFR 0.152.
 */
package rr;

import java.util.Arrays;
import m.fixed_t;
import p.mobj_t;
import rr.ISpriteManager;
import rr.IVisSpriteManagement;
import rr.RendererState;
import rr.sector_t;
import rr.spritedef_t;
import rr.spriteframe_t;
import rr.vissprite_t;
import utils.C2JUtils;

public final class VisSprites<V>
implements IVisSpriteManagement<V> {
    private static final boolean DEBUG = false;
    private static final boolean RANGECHECK = false;
    protected final RendererState<?, V> rendererState;
    protected vissprite_t<V>[] vissprites;
    protected int vissprite_p;
    protected int newvissprite;
    protected int[] spritewidth;
    protected int[] spriteoffset;
    protected int[] spritetopoffset;

    public VisSprites(RendererState<?, V> rendererState) {
        vissprite_t tmp = new vissprite_t();
        this.vissprites = C2JUtils.createArrayOfObjects(tmp, 128);
        this.rendererState = rendererState;
    }

    @Override
    public void AddSprites(sector_t sec) {
        if (sec.validcount == this.rendererState.getValidCount()) {
            return;
        }
        sec.validcount = this.rendererState.getValidCount();
        int lightnum = (sec.lightlevel >> this.rendererState.colormaps.lightSegShift()) + this.rendererState.colormaps.extralight;
        this.rendererState.colormaps.spritelights = lightnum < 0 ? this.rendererState.colormaps.scalelight[0] : (lightnum >= this.rendererState.colormaps.lightLevels() ? this.rendererState.colormaps.scalelight[this.rendererState.colormaps.lightLevels() - 1] : this.rendererState.colormaps.scalelight[lightnum]);
        mobj_t thing = sec.thinglist;
        while (thing != null) {
            this.ProjectSprite(thing);
            thing = (mobj_t)thing.snext;
        }
    }

    protected final void ProjectSprite(mobj_t thing) {
        boolean flip;
        int lump;
        int gyt;
        int tr_x = thing.x - this.rendererState.view.x;
        int tr_y = thing.y - this.rendererState.view.y;
        int gxt = fixed_t.FixedMul(tr_x, this.rendererState.view.cos);
        int tz = gxt - (gyt = -fixed_t.FixedMul(tr_y, this.rendererState.view.sin));
        if (tz < 262144) {
            return;
        }
        int xscale = fixed_t.FixedDiv(this.rendererState.view.projection, tz);
        gxt = -fixed_t.FixedMul(tr_x, this.rendererState.view.sin);
        gyt = fixed_t.FixedMul(tr_y, this.rendererState.view.cos);
        int tx = -(gyt + gxt);
        if (Math.abs(tx) > tz << 2) {
            return;
        }
        spritedef_t sprdef = this.rendererState.DOOM.spriteManager.getSprite(thing.mobj_sprite.ordinal());
        spriteframe_t sprframe = sprdef.spriteframes[thing.mobj_frame & Short.MAX_VALUE];
        if (sprframe.rotate != 0) {
            long ang = this.rendererState.view.PointToAngle(thing.x, thing.y);
            int rot = (int)(ang - thing.angle + 0x90000000L & 0xFFFFFFFFL) >>> 29;
            lump = sprframe.lump[rot];
            flip = sprframe.flip[rot] != 0;
        } else {
            lump = sprframe.lump[0];
            flip = sprframe.flip[0] != 0;
        }
        int x1 = this.rendererState.view.centerxfrac + fixed_t.FixedMul(tx -= this.spriteoffset[lump], xscale) >> 16;
        if (x1 > this.rendererState.view.width) {
            return;
        }
        int x2 = (this.rendererState.view.centerxfrac + fixed_t.FixedMul(tx += this.spritewidth[lump], xscale) >> 16) - 1;
        if (x2 < 0) {
            return;
        }
        vissprite_t<V> vis = this.NewVisSprite();
        vis.mobjflags = thing.flags;
        vis.scale = xscale << this.rendererState.view.detailshift;
        vis.gx = thing.x;
        vis.gy = thing.y;
        vis.gz = thing.z;
        vis.gzt = thing.z + this.spritetopoffset[lump];
        vis.texturemid = vis.gzt - this.rendererState.view.z;
        vis.x1 = x1 < 0 ? 0 : x1;
        vis.x2 = x2 >= this.rendererState.view.width ? this.rendererState.view.width - 1 : x2;
        int iscale = fixed_t.FixedDiv(65536, xscale);
        if (flip) {
            vis.startfrac = this.spritewidth[lump] - 1;
            vis.xiscale = -iscale;
        } else {
            vis.startfrac = 0;
            vis.xiscale = iscale;
        }
        if (vis.x1 > x1) {
            vis.startfrac += vis.xiscale * (vis.x1 - x1);
        }
        vis.patch = lump;
        if ((thing.flags & 0x40000L) != 0L) {
            vis.colormap = null;
        } else if (this.rendererState.colormaps.fixedcolormap != null) {
            vis.colormap = this.rendererState.colormaps.fixedcolormap;
        } else if ((thing.mobj_frame & 0x8000) != 0) {
            vis.colormap = this.rendererState.colormaps.colormaps[0];
        } else {
            int index = xscale >> this.rendererState.colormaps.lightScaleShift() - this.rendererState.view.detailshift;
            if (index >= this.rendererState.colormaps.maxLightScale()) {
                index = this.rendererState.colormaps.maxLightScale() - 1;
            }
            vis.colormap = this.rendererState.colormaps.spritelights[index];
        }
    }

    protected final vissprite_t<V> NewVisSprite() {
        if (this.vissprite_p == this.vissprites.length - 1) {
            this.ResizeSprites();
        }
        ++this.vissprite_p;
        return this.vissprites[this.vissprite_p - 1];
    }

    @Override
    public void cacheSpriteManager(ISpriteManager SM) {
        this.spritewidth = SM.getSpriteWidth();
        this.spriteoffset = SM.getSpriteOffset();
        this.spritetopoffset = SM.getSpriteTopOffset();
    }

    @Override
    public void ClearSprites() {
        this.vissprite_p = 0;
    }

    protected final void ResizeSprites() {
        this.vissprites = C2JUtils.resize(this.vissprites[0], this.vissprites, this.vissprites.length * 2);
    }

    @Override
    public final void SortVisSprites() {
        Arrays.sort(this.vissprites, 0, this.vissprite_p);
    }

    @Override
    public int getNumVisSprites() {
        return this.vissprite_p;
    }

    @Override
    public vissprite_t<V>[] getVisSprites() {
        return this.vissprites;
    }

    @Override
    public void resetLimits() {
        vissprite_t<V>[] tmp = C2JUtils.createArrayOfObjects(this.vissprites[0], 128);
        System.arraycopy(this.vissprites, 0, tmp, 0, 128);
        this.vissprites = tmp;
    }
}

