/*
 * Decompiled with CFR 0.152.
 */
package rr.drawfuns;

import i.IDoomSystem;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;

public abstract class R_DrawColumnBoom<T, V>
extends DoomColumnFunction<T, V> {
    public R_DrawColumnBoom(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<T, V> dcvars, V screen, IDoomSystem I) {
        super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
    }

    public static final class TrueColor
    extends R_DrawColumnBoom<byte[], int[]> {
        public TrueColor(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], int[]> dcvars, int[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int frac;
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl + 1;
            if (count <= 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            byte[] source = (byte[])this.dcvars.dc_source;
            int[] colormap = (int[])this.dcvars.dc_colormap;
            int heightmask = this.dcvars.dc_texheight - 1;
            if ((this.dcvars.dc_texheight & heightmask) != 0) {
                ++heightmask;
                heightmask <<= 16;
                if (frac < 0) {
                    while ((frac += heightmask) < 0) {
                    }
                } else {
                    for (frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep; frac >= heightmask; frac -= heightmask) {
                    }
                }
                do {
                    ((int[])this.screen)[dest] = colormap[0xFF & source[frac >> 16]];
                    dest += this.SCREENWIDTH;
                    if ((frac += fracstep) < heightmask) continue;
                    frac -= heightmask;
                } while (--count > 0);
            } else {
                while (count >= 4) {
                    ((int[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((int[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    count -= 4;
                }
                while (count > 0) {
                    try {
                        ((int[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    }
                    catch (Exception e) {
                        System.err.printf("%s %s %x %x %x\n", colormap, source, dc_source_ofs, frac, heightmask);
                    }
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    --count;
                }
            }
        }
    }

    public static final class Indexed
    extends R_DrawColumnBoom<byte[], byte[]> {
        public Indexed(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], byte[]> dcvars, byte[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int frac;
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl + 1;
            if (count <= 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            byte[] source = (byte[])this.dcvars.dc_source;
            byte[] colormap = (byte[])this.dcvars.dc_colormap;
            int heightmask = this.dcvars.dc_texheight - 1;
            if ((this.dcvars.dc_texheight & heightmask) != 0) {
                ++heightmask;
                heightmask <<= 16;
                if (frac < 0) {
                    while ((frac += heightmask) < 0) {
                    }
                } else {
                    for (frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep; frac >= heightmask; frac -= heightmask) {
                    }
                }
                do {
                    ((byte[])this.screen)[dest] = colormap[0xFF & source[frac >> 16]];
                    dest += this.SCREENWIDTH;
                    if ((frac += fracstep) < heightmask) continue;
                    frac -= heightmask;
                } while (--count > 0);
            } else {
                while (count >= 4) {
                    ((byte[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((byte[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    count -= 4;
                }
                while (count > 0) {
                    try {
                        ((byte[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    }
                    catch (Exception e) {
                        System.err.printf("%s %s %x %x %x\n", colormap, source, dc_source_ofs, frac, heightmask);
                    }
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    --count;
                }
            }
        }
    }

    public static final class HiColor
    extends R_DrawColumnBoom<byte[], short[]> {
        public HiColor(int SCREENWIDTH, int SCREENHEIGHT, int[] ylookup, int[] columnofs, ColVars<byte[], short[]> dcvars, short[] screen, IDoomSystem I) {
            super(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, dcvars, screen, I);
        }

        @Override
        public void invoke() {
            int frac;
            int dc_source_ofs = this.dcvars.dc_source_ofs;
            int count = this.dcvars.dc_yh - this.dcvars.dc_yl + 1;
            if (count <= 0) {
                return;
            }
            int dest = this.computeScreenDest();
            int fracstep = this.dcvars.dc_iscale;
            byte[] source = (byte[])this.dcvars.dc_source;
            short[] colormap = (short[])this.dcvars.dc_colormap;
            int heightmask = this.dcvars.dc_texheight - 1;
            if ((this.dcvars.dc_texheight & heightmask) != 0) {
                ++heightmask;
                heightmask <<= 16;
                if (frac < 0) {
                    while ((frac += heightmask) < 0) {
                    }
                } else {
                    for (frac = this.dcvars.dc_texturemid + (this.dcvars.dc_yl - this.dcvars.centery) * fracstep; frac >= heightmask; frac -= heightmask) {
                    }
                }
                do {
                    ((short[])this.screen)[dest] = colormap[0xFF & source[frac >> 16]];
                    dest += this.SCREENWIDTH;
                    if ((frac += fracstep) < heightmask) continue;
                    frac -= heightmask;
                } while (--count > 0);
            } else {
                while (count >= 4) {
                    ((short[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    ((short[])this.screen)[dest += this.SCREENWIDTH] = colormap[0xFF & source[dc_source_ofs + ((frac += fracstep) >> 16 & heightmask)]];
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    count -= 4;
                }
                while (count > 0) {
                    try {
                        ((short[])this.screen)[dest] = colormap[0xFF & source[dc_source_ofs + (frac >> 16 & heightmask)]];
                    }
                    catch (Exception e) {
                        System.err.printf("%s %s %x %x %x\n", colormap, source, dc_source_ofs, frac, heightmask);
                    }
                    dest += this.SCREENWIDTH;
                    frac += fracstep;
                    --count;
                }
            }
        }
    }
}

