/*
 * Decompiled with CFR 0.152.
 */
package rr;

import defines.slopetype_t;
import doom.thinker_t;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import m.fixed_t;
import p.Interceptable;
import p.Resettable;
import rr.sector_t;
import rr.vertex_t;
import s.degenmobj_t;
import utils.C2JUtils;
import w.DoomIO;
import w.IPackableDoomObject;
import w.IReadableDoomObject;

public class line_t
implements Interceptable,
IReadableDoomObject,
IPackableDoomObject,
Resettable {
    public static final char NO_INDEX = '\uffff';
    public vertex_t v1;
    public vertex_t v2;
    public int v1x;
    public int v1y;
    public int v2x;
    public int v2y;
    public int dx;
    public int dy;
    public short flags;
    public short special;
    public short tag;
    public char[] sidenum = new char[2];
    public int[] bbox = new int[4];
    public slopetype_t slopetype = slopetype_t.ST_HORIZONTAL;
    public sector_t frontsector;
    public sector_t backsector;
    public int frontsectorid;
    public int backsectorid;
    public int validcount;
    public thinker_t specialdata;
    public int specialdataid;
    public degenmobj_t soundorg;
    public int tranlump;
    public int id;
    public int firsttag;
    public int nexttag;
    public static final int ML_BLOCKING = 1;
    public static final int ML_BLOCKMONSTERS = 2;
    public static final int ML_TWOSIDED = 4;
    public static final int ML_DONTPEGTOP = 8;
    public static final int ML_DONTPEGBOTTOM = 16;
    public static final int ML_SECRET = 32;
    public static final int ML_SOUNDBLOCK = 64;
    public static final int ML_DONTDRAW = 128;
    public static final int ML_MAPPED = 256;

    public int getSpecialSidenum() {
        return this.sidenum[0] << 16 & (0xFFFF & this.sidenum[1]);
    }

    public void assignVertexValues() {
        this.v1x = this.v1.x;
        this.v1y = this.v1.y;
        this.v2x = this.v2.x;
        this.v2y = this.v2.y;
    }

    public boolean PointOnLineSide(int x, int y) {
        return this.dx == 0 ? (x <= this.v1x ? this.dy > 0 : this.dy < 0) : (this.dy == 0 ? (y <= this.v1y ? this.dx < 0 : this.dx > 0) : fixed_t.FixedMul(y - this.v1y, this.dx >> 16) >= fixed_t.FixedMul(this.dy >> 16, x - this.v1x));
    }

    public int BoxOnLineSide(int[] tmbox) {
        boolean p1 = false;
        boolean p2 = false;
        switch (this.slopetype) {
            case ST_HORIZONTAL: {
                p1 = tmbox[0] > this.v1y;
                boolean bl = p2 = tmbox[1] > this.v1y;
                if (this.dx >= 0) break;
                p1 ^= true;
                p2 ^= true;
                break;
            }
            case ST_VERTICAL: {
                p1 = tmbox[3] < this.v1x;
                boolean bl = p2 = tmbox[2] < this.v1x;
                if (this.dy >= 0) break;
                p1 ^= true;
                p2 ^= true;
                break;
            }
            case ST_POSITIVE: {
                p1 = this.PointOnLineSide(tmbox[2], tmbox[0]);
                p2 = this.PointOnLineSide(tmbox[3], tmbox[1]);
                break;
            }
            case ST_NEGATIVE: {
                p1 = this.PointOnLineSide(tmbox[3], tmbox[0]);
                p2 = this.PointOnLineSide(tmbox[2], tmbox[1]);
            }
        }
        if (p1 == p2) {
            return p1 ? 1 : 0;
        }
        return -1;
    }

    public int BoxOnLineSideInclusive(int[] tmbox) {
        boolean p1 = false;
        boolean p2 = false;
        switch (this.slopetype) {
            case ST_HORIZONTAL: {
                p1 = tmbox[0] >= this.v1y;
                boolean bl = p2 = tmbox[1] >= this.v1y;
                if (this.dx >= 0) break;
                p1 ^= true;
                p2 ^= true;
                break;
            }
            case ST_VERTICAL: {
                p1 = tmbox[3] <= this.v1x;
                boolean bl = p2 = tmbox[2] <= this.v1x;
                if (this.dy >= 0) break;
                p1 ^= true;
                p2 ^= true;
                break;
            }
            case ST_POSITIVE: {
                p1 = this.PointOnLineSide(tmbox[2], tmbox[0]);
                p2 = this.PointOnLineSide(tmbox[3], tmbox[1]);
                break;
            }
            case ST_NEGATIVE: {
                p1 = this.PointOnLineSide(tmbox[3], tmbox[0]);
                p2 = this.PointOnLineSide(tmbox[2], tmbox[1]);
            }
        }
        if (p1 == p2) {
            return p1 ? 1 : 0;
        }
        return -1;
    }

    public sector_t getNextSector(sector_t sec) {
        if (!C2JUtils.eval(this.flags & 4)) {
            return null;
        }
        if (this.frontsector == sec) {
            return this.backsector;
        }
        return this.frontsector;
    }

    public String toString() {
        return String.format("Line %d Flags: %x Special %d Tag: %d ", this.id, this.flags, this.special, this.tag);
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        this.flags = DoomIO.readLEShort(f);
        this.special = DoomIO.readLEShort(f);
        this.tag = DoomIO.readLEShort(f);
    }

    @Override
    public void pack(ByteBuffer buffer) {
        buffer.putShort(this.flags);
        buffer.putShort(this.special);
        buffer.putShort(this.tag);
    }

    @Override
    public void reset() {
        this.v2 = null;
        this.v1 = null;
        this.v2y = 0;
        this.v2x = 0;
        this.v1y = 0;
        this.v1x = 0;
        this.dy = 0;
        this.dx = 0;
        this.tag = 0;
        this.special = 0;
        this.flags = 0;
        C2JUtils.memset(this.sidenum, '\u0000', this.sidenum.length);
        Arrays.fill(this.bbox, 0);
        this.slopetype = slopetype_t.ST_HORIZONTAL;
        this.backsector = null;
        this.frontsector = null;
        this.backsectorid = 0;
        this.frontsectorid = 0;
        this.validcount = 0;
        this.specialdata = null;
        this.specialdataid = 0;
        this.soundorg = null;
        this.tranlump = 0;
    }
}

